/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.specify.ui.DBObjSearchPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TaxonLabelFormatting
extends UIPluginBase {
    private static final Logger log = Logger.getLogger(TaxonLabelFormatting.class);
    protected Taxon taxon = null;
    protected ValComboBox formatCBX;
    protected JList authorsList;
    protected DBObjSearchPanel searchPanel;
    protected JLabel refWorkLabel;
    protected SpecialLabel specialLabel;
    protected JButton mapToBtn;
    protected JButton unmapBtn;
    protected JButton upBtn;
    protected JButton downBtn;
    protected JButton newAgentBtn;
    protected ResourceBundle resourceBundle;
    protected Vector<TextDrawInfo> drawList = new Vector();

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        String plName = "TaxonLabelFormatter";
        PickListDBAdapterIFace adapter = PickListDBAdapterFactory.getInstance().create(plName, false);
        if (adapter == null || adapter.getPickList() == null) {
            throw new RuntimeException("PickList Adapter [" + plName + "] cannot be null!");
        }
        this.formatCBX = new ValComboBox(adapter);
        this.formatCBX.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxonLabelFormatting.this.doFormatting();
            }
        });
        this.formatCBX.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TaxonLabelFormatting.this.doFormatting();
            }
        });
        this.newAgentBtn = UIHelper.createButton("");
        this.searchPanel = new DBObjSearchPanel("Search", "AgentNameSearch", "AgentNameSearch", "edu.ku.brc.specify.datamodel.Agent", "agentId", 3);
        this.searchPanel.getScrollPane().setMinimumSize(new Dimension(100, 200));
        this.searchPanel.getScrollPane().setPreferredSize(new Dimension(100, 150));
        ((FormViewObj)this.searchPanel.getForm()).getPanel().setBorder(null);
        try {
            UIRegistry.loadAndPushResourceBundle("specify_plugins");
            this.newAgentBtn.setText(UIRegistry.getResourceString("NewAgent"));
            this.authorsList = new JList(new DefaultListModel());
            this.authorsList.setVisibleRowCount(10);
            this.authorsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        Object selObj = TaxonLabelFormatting.this.authorsList.getSelectedValue();
                        TaxonLabelFormatting.this.updateEnabledState();
                    }
                }
            });
            JScrollPane scrollPane = new JScrollPane(this.authorsList, 20, 30);
            this.mapToBtn = UIHelper.createIconBtn("Map", "ADD_AUTHOR_NAME_TT", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Object agent = TaxonLabelFormatting.this.searchPanel.getSelectedObject();
                    ((DefaultListModel)TaxonLabelFormatting.this.authorsList.getModel()).addElement(agent);
                    TaxonLabelFormatting.this.doFormatting();
                }
            });
            this.unmapBtn = UIHelper.createIconBtn("Unmap", "REMOVE_AUTHOR_NAME_TT", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int index = TaxonLabelFormatting.this.authorsList.getSelectedIndex();
                    if (index > -1) {
                        DefaultListModel model = (DefaultListModel)TaxonLabelFormatting.this.authorsList.getModel();
                        model.remove(index);
                        TaxonLabelFormatting.this.updateEnabledState();
                        TaxonLabelFormatting.this.doFormatting();
                    }
                }
            });
            this.upBtn = UIHelper.createIconBtn("ReorderUp", "MOVE_AUTHOR_NAME_UP", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DefaultListModel model = (DefaultListModel)TaxonLabelFormatting.this.authorsList.getModel();
                    int index = TaxonLabelFormatting.this.authorsList.getSelectedIndex();
                    Object item = TaxonLabelFormatting.this.authorsList.getSelectedValue();
                    model.remove(index);
                    model.insertElementAt(item, index - 1);
                    TaxonLabelFormatting.this.authorsList.setSelectedIndex(index - 1);
                    TaxonLabelFormatting.this.updateEnabledState();
                }
            });
            this.downBtn = UIHelper.createIconBtn("ReorderDown", "MOVE_AUTHOR_NAME_DOWN", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DefaultListModel model = (DefaultListModel)TaxonLabelFormatting.this.authorsList.getModel();
                    int index = TaxonLabelFormatting.this.authorsList.getSelectedIndex();
                    Object item = TaxonLabelFormatting.this.authorsList.getSelectedValue();
                    model.remove(index);
                    model.insertElementAt(item, index + 1);
                    TaxonLabelFormatting.this.authorsList.setSelectedIndex(index + 1);
                    TaxonLabelFormatting.this.updateEnabledState();
                }
            });
            PanelBuilder bldr = new PanelBuilder(new FormLayout("p, 5px, p, 5px, f:p:g, 2px, p", "p, 4px, p, 2px, f:p:g, 4px, p, 4px, p, 2px, p, 2px, p, 2px, p"), (JPanel)this);
            CellConstraints cc = new CellConstraints();
            PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "p, 2px, p, f:p:g"));
            upDownPanel.add((Component)this.upBtn, cc.xy(1, 1));
            upDownPanel.add((Component)this.downBtn, cc.xy(1, 3));
            PanelBuilder middlePanel = new PanelBuilder(new FormLayout("c:p:g", "f:p:g, p, 2px, p, f:p:g"));
            middlePanel.add((Component)this.mapToBtn, cc.xy(1, 2));
            middlePanel.add((Component)this.unmapBtn, cc.xy(1, 4));
            PanelBuilder rwPanel = new PanelBuilder(new FormLayout("p, 2px, f:p:g", "p"));
            this.refWorkLabel = UIHelper.createLabel(UIRegistry.getResourceString("NONE"));
            rwPanel.add((Component)UIHelper.createI18NFormLabel("REFERENCEWORK"), cc.xy(1, 1));
            rwPanel.add((Component)this.refWorkLabel, cc.xy(3, 1));
            int y = 1;
            bldr.add((Component)rwPanel.getPanel(), cc.xywh(1, y, 7, 1));
            bldr.add((Component)this.searchPanel, cc.xywh(1, y += 2, 1, 3));
            bldr.addSeparator(UIRegistry.getResourceString("Authors"), cc.xy(5, y));
            bldr.add((Component)middlePanel.getPanel(), cc.xy(3, y += 2));
            bldr.add((Component)scrollPane, cc.xywh(5, y, 1, 3));
            bldr.add((Component)upDownPanel.getPanel(), cc.xy(7, y));
            PanelBuilder newAgentPanel = new PanelBuilder(new FormLayout("f:p:g,p", "p"));
            newAgentPanel.add((Component)this.newAgentBtn, cc.xy(2, 1));
            bldr.add((Component)newAgentPanel.getPanel(), cc.xy(1, y += 2));
            JLabel fmtLabel = UIHelper.createLabel(UIRegistry.getResourceString("LABELFORMAT"));
            bldr.add((Component)fmtLabel, cc.xy(1, y += 2));
            bldr.add((Component)this.formatCBX, cc.xywh(1, y += 2, 7, 1));
            Font plain = fmtLabel.getFont();
            this.specialLabel = new SpecialLabel(plain, new Font(plain.getName(), 2, plain.getSize()));
            this.specialLabel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            bldr.add((Component)UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("SAMPLEOUTPUT")) + ":"), cc.xywh(1, y += 2, 7, 1));
            bldr.add((Component)this.specialLabel, cc.xywh(1, y += 2, 7, 1));
            this.searchPanel.setOKBtn(this.mapToBtn);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaxonLabelFormatting.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
        }
        UIRegistry.popResourceBundle();
    }

    protected void updateEnabledState() {
        int size = this.authorsList.getModel().getSize();
        int selInx = this.authorsList.getSelectedIndex();
        this.unmapBtn.setEnabled(selInx != -1);
        this.upBtn.setEnabled(selInx > 0);
        this.downBtn.setEnabled(selInx < size - 1);
    }

    @Override
    public boolean isNotEmpty() {
        throw new NotImplementedException("isNotEmpty not implement!");
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        super.setValue(value, defaultValue);
        if (value instanceof Taxon) {
            this.taxon = (Taxon)value;
            Taxon parent = this.taxon.getParent();
            while (parent != null) {
                parent = parent.getParent();
            }
        }
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"name"};
    }

    protected Taxon getByRank(Taxon tx, int rankId) {
        Taxon txn = tx;
        while (txn != null && txn.getRankId() != rankId) {
            txn = txn.getParent();
        }
        return txn;
    }

    protected void doFormatting() {
        this.drawList.clear();
        Object fmtObj = this.formatCBX.getValue();
        if (fmtObj == null) {
            return;
        }
        String format = fmtObj.toString();
        if (StringUtils.isNotEmpty((String)format) && format.length() > 0) {
            DefaultListModel model = (DefaultListModel)this.authorsList.getModel();
            StringBuilder chars = new StringBuilder();
            StringBuilder exp = new StringBuilder();
            int len = format.length();
            StringBuilder pat = new StringBuilder();
            int i = 0;
            while (i < len) {
                char ch = format.charAt(i);
                if (ch == '%') {
                    if (chars.length() > 0) {
                        this.drawList.add(new TextDrawInfo(FormatType.Plain, chars.toString()));
                        chars.setLength(0);
                    }
                    ch = format.charAt(++i);
                    pat.setLength(0);
                    pat.append('%');
                    do {
                        if (!Character.isLetter(ch) && !Character.isDigit(ch)) {
                            --i;
                            break;
                        }
                        pat.append(ch);
                        if (++i >= len) continue;
                        ch = format.charAt(i);
                    } while (i < len);
                    FormatType ft = FormatType.Plain;
                    String val = "";
                    String token = pat.toString();
                    if (token.equals("%S")) {
                        val = this.getByRank(this.taxon, 220).getName();
                        ft = FormatType.Italic;
                    } else if (token.equals("%G")) {
                        val = this.getByRank(this.taxon, 180).getName();
                        ft = FormatType.Italic;
                    } else if (token.charAt(1) == 'A') {
                        int authNum = Integer.parseInt(token.substring(2)) - 1;
                        val = authNum < model.getSize() ? ((Agent)model.get(authNum)).getLastName() : token;
                    }
                    exp.append(val);
                    this.drawList.add(new TextDrawInfo(ft, val));
                } else {
                    exp.append(ch);
                    chars.append(ch);
                }
                ++i;
            }
            if (chars.length() > 0) {
                this.drawList.add(new TextDrawInfo(FormatType.Plain, chars.toString()));
                chars.setLength(0);
            }
            this.specialLabel.repaint();
        }
    }

    public static enum FormatType {
        Plain,
        Italic;

    }

    class SpecialLabel
    extends JLabel {
        protected Font plainFont;
        protected Font italicFont;

        public SpecialLabel(Font plainFont, Font italicFont) {
            super(" ");
            this.plainFont = plainFont;
            this.italicFont = italicFont;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.BLACK);
            Dimension size = this.getSize();
            Insets insets = this.getBorder().getBorderInsets(this);
            int x = 5;
            int y = 0;
            for (TextDrawInfo tdi : TaxonLabelFormatting.this.drawList) {
                Font f = tdi.getType() == FormatType.Plain ? this.plainFont : this.italicFont;
                g.setFont(f);
                FontMetrics fm = g.getFontMetrics();
                y = size.height - fm.getDescent() - insets.bottom - fm.getLeading() - 1;
                g.drawString(tdi.getText(), x, y);
                x += fm.stringWidth(tdi.getText());
            }
        }
    }

    class TextDrawInfo {
        protected FormatType type;
        protected String text;

        public TextDrawInfo(FormatType type, String text) {
            this.type = type;
            this.text = text;
        }

        public FormatType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }
    }
}

