/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.forms.CarryForwardInfo;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldIFace;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public class SeriesProcCatNumPlugin
extends UIPluginBase
implements ValFormattedTextFieldIFace {
    private ValFormattedTextFieldIFace textFieldStart;
    private ValFormattedTextFieldIFace textFieldEnd;
    private JButton expandBtn;
    private boolean isAutoNumOn = true;
    private boolean isExpanded = false;
    private PanelBuilder pb;
    private CellConstraints cc = new CellConstraints();
    private JPanel panel;

    public SeriesProcCatNumPlugin(ValFormattedTextFieldIFace textFieldStart, ValFormattedTextFieldIFace textFieldEnd) {
        this.textFieldStart = textFieldStart;
        this.textFieldEnd = textFieldEnd;
        this.expandBtn = UIHelper.createIconBtn("move_right", "", null);
        this.pb = new PanelBuilder(new FormLayout("p,f:p:g", "c:p"), (JPanel)this);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(textFieldStart.getValidatableUIComp());
        this.panel.add(textFieldEnd.getValidatableUIComp());
        this.panel.add(this.expandBtn);
        this.expandBtn.setEnabled(true);
        this.pb.add((Component)this.panel, this.cc.xy(1, 1));
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeriesProcCatNumPlugin.this.doToggleContract();
            }
        });
        textFieldEnd.setAutoNumberEnabled(false);
        textFieldEnd.getValidatableUIComp().setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SeriesProcCatNumPlugin.this.isExpanded = true;
                SeriesProcCatNumPlugin.this.expandBtn.doClick();
                SeriesProcCatNumPlugin.this.expandBtn.setVisible(false);
            }
        });
    }

    public Pair<String, String> getStartAndEndCatNumbers() {
        String end;
        String start;
        String string = start = this.textFieldStart.getValue() != null ? this.textFieldStart.getValue().toString() : null;
        String string2 = !this.isExpanded() ? null : (end = this.textFieldEnd.getValue() != null ? this.textFieldEnd.getValue().toString() : null);
        if (end == null && start != null) {
            end = start;
        }
        return new Pair<String, String>(start, end);
    }

    @Override
    public void setNewObj(boolean isNewObj) {
        super.setNewObj(isNewObj);
        this.carryForwardStateChange();
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void clearEndTextField() {
        this.textFieldEnd.setValue("", "");
    }

    private void checkToggleContract() {
        boolean isCarryForwardOK = false;
        CarryForwardInfo cfInfo = this.fvo.getCarryFwdInfo();
        if (cfInfo != null) {
            isCarryForwardOK = cfInfo.getFieldList().size() > 0;
        }
        boolean isManualCatNumOK = !this.isAutoNumOn;
        boolean isOKToExpand = isManualCatNumOK && isCarryForwardOK;
        this.textFieldStart.setAutoNumberEnabled(!isManualCatNumOK);
        this.textFieldEnd.setAutoNumberEnabled(!isManualCatNumOK);
        this.expandBtn.setVisible(isOKToExpand);
        if (!isOKToExpand) {
            this.isExpanded = true;
            this.doToggleContract();
        }
    }

    private void doToggleContract() {
        boolean bl = this.isExpanded = !this.isExpanded;
        if (this.isExpanded) {
            this.panel.removeAll();
            this.panel.add(this.textFieldStart.getValidatableUIComp());
            this.panel.add(this.textFieldEnd.getValidatableUIComp());
            this.panel.add(this.expandBtn);
        } else {
            this.panel.removeAll();
            this.panel.add(this.textFieldStart.getValidatableUIComp());
            this.panel.add(this.expandBtn);
        }
        this.expandBtn.setIcon(IconManager.getIcon(!this.isExpanded ? "move_right" : "move_left"));
        this.invalidate();
        this.revalidate();
        this.doLayout();
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
        this.repaint();
    }

    @Override
    public boolean isNotEmpty() {
        return this.textFieldStart.isNotEmpty() && (!this.isExpanded || this.textFieldEnd.isNotEmpty());
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"catalogNumber"};
    }

    @Override
    public boolean isFormatterAutoNumber() {
        return this.textFieldStart.isFormatterAutoNumber();
    }

    @Override
    public void setAutoNumberEnabled(boolean turnOn) {
        this.isAutoNumOn = turnOn;
        this.carryForwardStateChange();
    }

    @Override
    public void carryForwardStateChange() {
        this.checkToggleContract();
        this.repaint();
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.getParent().doLayout();
        this.repaint();
    }

    @Override
    public void updateAutoNumbers() {
        if (!this.isExpanded) {
            this.textFieldStart.updateAutoNumbers();
        }
    }

    @Override
    public boolean canCarryForward() {
        return false;
    }

    @Override
    public String[] getCarryForwardFields() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.textFieldStart.getValue();
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.textFieldStart.setValue(value, defaultValue);
    }

    @Override
    public void cleanUp() {
        this.textFieldStart.cleanUp();
        this.textFieldEnd.cleanUp();
    }

    @Override
    public String getReason() {
        if (this.isExpanded) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.textFieldStart.getReason())) {
                sb.append(this.textFieldStart.getReason());
            }
            if (StringUtils.isNotEmpty((String)this.textFieldEnd.getReason())) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(this.textFieldEnd.getReason());
            }
            return sb.toString();
        }
        return this.textFieldStart.getReason();
    }

    @Override
    public UIValidatable.ErrorType getState() {
        if (this.isExpanded) {
            UIValidatable.ErrorType state1 = this.textFieldStart.validateState();
            UIValidatable.ErrorType state2 = this.textFieldEnd.validateState();
            return state1.ordinal() > state2.ordinal() ? state1 : state2;
        }
        return this.textFieldStart.validateState();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public boolean isChanged() {
        return this.textFieldStart.isChanged() && (!this.isExpanded || this.textFieldEnd.isChanged());
    }

    @Override
    public boolean isInError() {
        return this.textFieldStart.isInError() && (!this.isExpanded || this.textFieldEnd.isInError());
    }

    @Override
    public boolean isRequired() {
        return this.textFieldStart.isRequired();
    }

    @Override
    public void reset() {
        this.textFieldStart.reset();
        this.textFieldEnd.reset();
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.textFieldStart.setAsNew(isNew);
        this.textFieldEnd.setAsNew(isNew);
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.textFieldStart.setChanged(isChanged);
        this.textFieldEnd.setChanged(isChanged);
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.textFieldStart.setRequired(isRequired);
        this.textFieldEnd.setRequired(isRequired);
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.textFieldStart.setState(state);
        this.textFieldEnd.setState(state);
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        if (this.isExpanded) {
            UIValidatable.ErrorType state1 = this.textFieldStart.validateState();
            UIValidatable.ErrorType state2 = this.textFieldEnd.validateState();
            return state1.ordinal() > state2.ordinal() ? state1 : state2;
        }
        return this.textFieldStart.validateState();
    }
}

