/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectGettableFactory;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.af.ui.forms.DataObjectSettableFactory;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextField;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldSingle;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PartialDateUI
extends JPanel
implements GetSetValueIFace,
UIPluginable,
UIValidatable,
ChangeListener {
    private static final Logger log = Logger.getLogger(PartialDateUI.class);
    protected DateWrapper scrDateFormat = null;
    protected DataObjectGettable getter;
    protected DataObjectSettable setter;
    protected FormViewObj parent;
    protected JComboBox formatSelector;
    protected String cellName = null;
    protected boolean isDisplayOnly = true;
    protected ChangeListener changeListener = null;
    protected String title;
    protected Object dataObj = null;
    protected String dateFieldName = null;
    protected String dateTypeName = null;
    protected UIFieldFormatterIFace.PartialDateEnum dateType = UIFieldFormatterIFace.PartialDateEnum.Full;
    protected UIFieldFormatterIFace.PartialDateEnum origDateType = UIFieldFormatterIFace.PartialDateEnum.Full;
    protected boolean dateTypeIsStr = false;
    protected UIValidatable[] uivs = new UIValidatable[3];
    protected JTextField[] textFields = new JTextField[3];
    protected JPanel[] panels = new JPanel[3];
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel cardPanel;
    protected UIValidatable currentUIV = null;
    protected ActionListener comboBoxAL = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected boolean ignoreDocChanges = false;
    protected boolean isDateChanged = false;

    public PartialDateUI() {
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        this.title = UIRegistry.getResourceString("PartialDateUI");
        UIRegistry.popResourceBundle();
    }

    private void setupPopupMenu(ValFormattedTextField tf) {
        JComponent[] jComponentArray = tf.getTextComps();
        int n = jComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent comp = jComponentArray[n2];
            if (comp instanceof JTextField) {
                ViewFactory.addTextFieldPopup(this, (JTextField)comp, true);
            }
            ++n2;
        }
    }

    protected void createUI() {
        DocumentAdaptor docListener = null;
        if (!this.isDisplayOnly) {
            docListener = new DocumentAdaptor(){

                @Override
                protected void changed(DocumentEvent e) {
                    super.changed(e);
                    if (!PartialDateUI.this.ignoreDocChanges) {
                        PartialDateUI.this.isChanged = true;
                        PartialDateUI.this.isDateChanged = true;
                        if (PartialDateUI.this.changeListener != null) {
                            PartialDateUI.this.changeListener.stateChanged(new ChangeEvent(PartialDateUI.this));
                        }
                    }
                }
            };
        }
        List<UIFieldFormatterIFace> partialDateList = UIFieldFormatterMgr.getInstance().getDateFormatterList(true);
        for (UIFieldFormatterIFace uiff : partialDateList) {
            Object tf;
            if (uiff.getName().equals("PartialDateMonth")) {
                tf = new ValFormattedTextField(uiff, this.isDisplayOnly, !this.isDisplayOnly);
                ((ValFormattedTextField)tf).setRequired(this.isRequired);
                if (docListener != null) {
                    ((ValFormattedTextField)tf).addDocumentListener(docListener);
                }
                this.uivs[1] = tf;
                this.textFields[1] = ((ValFormattedTextField)tf).getTextField();
                if (this.isDisplayOnly) {
                    ViewFactory.changeTextFieldUIForDisplay(this.textFields[1], false);
                    continue;
                }
                this.setupPopupMenu((ValFormattedTextField)tf);
                continue;
            }
            if (!uiff.getName().equals("PartialDateYear")) continue;
            tf = new ValFormattedTextField(uiff, this.isDisplayOnly, !this.isDisplayOnly);
            ((ValFormattedTextField)tf).setRequired(this.isRequired);
            if (docListener != null) {
                ((ValFormattedTextField)tf).addDocumentListener(docListener);
            }
            this.uivs[2] = tf;
            this.textFields[2] = ((ValFormattedTextField)tf).getTextField();
            if (this.isDisplayOnly) {
                ViewFactory.changeTextFieldUIForDisplay(this.textFields[2], false);
                continue;
            }
            this.setupPopupMenu((ValFormattedTextField)tf);
        }
        List<UIFieldFormatterIFace> dateList = UIFieldFormatterMgr.getInstance().getDateFormatterList(false);
        for (UIFieldFormatterIFace uiff : dateList) {
            if (!uiff.getName().equals("Date")) continue;
            ValFormattedTextFieldSingle tf = new ValFormattedTextFieldSingle(uiff, this.isDisplayOnly, false);
            tf.setRequired(this.isRequired);
            if (docListener != null) {
                tf.addDocumentListener(docListener);
            }
            this.uivs[0] = tf;
            this.textFields[0] = tf;
            if (this.isDisplayOnly) {
                ViewFactory.changeTextFieldUIForDisplay(this.textFields[0], false);
                continue;
            }
            ViewFactory.addTextFieldPopup(this, tf, true);
        }
        this.cardPanel = new JPanel(this.cardLayout);
        String[] formatKeys = new String[]{"PARTIAL_DATE_FULL", "PARTIAL_DATE_MONTH", "PARTIAL_DATE_YEAR"};
        Object[] labels = new String[formatKeys.length];
        int i = 0;
        while (i < formatKeys.length) {
            labels[i] = UIRegistry.getResourceString(formatKeys[i]);
            this.cardPanel.add((String)labels[i], (JComponent)((Object)this.uivs[i]));
            ++i;
        }
        this.formatSelector = UIHelper.createComboBox(labels);
        this.formatSelector.setSelectedIndex(0);
        JComboBox typDisplayComp = null;
        if (!this.isDisplayOnly) {
            this.comboBoxAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JComboBox cbx = (JComboBox)ae.getSource();
                    Object dataValue = ((GetSetValueIFace)((Object)PartialDateUI.this.currentUIV)).getValue();
                    PartialDateUI.this.currentUIV = PartialDateUI.this.uivs[cbx.getSelectedIndex()];
                    PartialDateUI.this.ignoreDocChanges = true;
                    ((GetSetValueIFace)((Object)PartialDateUI.this.currentUIV)).setValue(dataValue, null);
                    PartialDateUI.this.ignoreDocChanges = false;
                    PartialDateUI.this.cardLayout.show(PartialDateUI.this.cardPanel, PartialDateUI.this.formatSelector.getSelectedItem().toString());
                    PartialDateUI.this.isChanged = true;
                    if (PartialDateUI.this.changeListener != null) {
                        PartialDateUI.this.changeListener.stateChanged(new ChangeEvent(PartialDateUI.this));
                    }
                }
            };
            typDisplayComp = this.formatSelector;
            this.formatSelector.addActionListener(this.comboBoxAL);
        }
        PanelBuilder builder = new PanelBuilder(new FormLayout(typDisplayComp != null ? "p, 2px, f:p:g" : "f:p:g", "p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        if (typDisplayComp != null) {
            builder.add((Component)typDisplayComp, cc.xy(1, 1));
            builder.add((Component)this.cardPanel, cc.xy(3, 1));
        } else {
            builder.add((Component)this.cardPanel, cc.xy(1, 1));
        }
    }

    @Override
    public boolean canCarryForward() {
        return true;
    }

    @Override
    public String[] getCarryForwardFields() {
        return new String[]{this.dateFieldName, this.dateTypeName};
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isNotEmpty() {
        if (this.currentUIV != null) {
            return ((GetSetValueIFace)((Object)this.currentUIV)).getValue() != null;
        }
        return false;
    }

    @Override
    public Object getValue() {
        Object fieldVal = null;
        if (this.currentUIV != null) {
            fieldVal = ((GetSetValueIFace)((Object)this.currentUIV)).getValue();
        }
        if (!this.isDisplayOnly && this.dataObj != null && StringUtils.isNotEmpty((String)this.dateFieldName) && StringUtils.isNotEmpty((String)this.dateTypeName) && this.isChanged) {
            this.verifyGetterSetters(this.dataObj);
            this.setter.setFieldValue(this.dataObj, this.dateFieldName, fieldVal != null && StringUtils.isNotEmpty((String)fieldVal.toString()) ? fieldVal : null);
            this.setter.setFieldValue(this.dataObj, this.dateTypeName, this.formatSelector.getSelectedIndex() + 1);
        }
        return this.dataObj;
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{this.dateFieldName, this.dateTypeName};
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        UIValidatable[] uIValidatableArray = this.uivs;
        int n = this.uivs.length;
        int n2 = 0;
        while (n2 < n) {
            UIValidatable uiv = uIValidatableArray[n2];
            ((JComponent)((Object)uiv)).setEnabled(enabled);
            ++n2;
        }
        this.formatSelector.setEnabled(enabled);
    }

    private void verifyGetterSetters(Object dObj) {
        if (dObj != null) {
            if (this.getter == null) {
                this.getter = DataObjectGettableFactory.get(dObj.getClass().getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj");
            }
            if (this.setter == null) {
                this.setter = DataObjectSettableFactory.get(dObj.getClass().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
            }
        }
    }

    private SimpleDateFormat getDateFormatter() {
        if (this.scrDateFormat == null) {
            this.scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
        }
        if (this.scrDateFormat != null) {
            return this.scrDateFormat.getSimpleDateFormat();
        }
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value != null) {
            if (!(value instanceof String)) {
                this.verifyGetterSetters(this.dataObj == null ? value : this.dataObj);
            }
        } else {
            this.dataObj = null;
            UIValidatable[] uIValidatableArray = this.uivs;
            int n = this.uivs.length;
            int n2 = 0;
            while (n2 < n) {
                UIValidatable uiv = uIValidatableArray[n2];
                ((GetSetValueIFace)((Object)uiv)).setValue(null, "");
                ++n2;
            }
            this.currentUIV = this.uivs[0];
            return;
        }
        int inx = 0;
        boolean skipProcessing = false;
        Calendar calDate = null;
        if (value instanceof String && StringUtils.isEmpty((String)defaultValue)) {
            try {
                Date date = this.getDateFormatter().parse(value.toString());
                calDate = Calendar.getInstance();
                calDate.setTime(date);
                skipProcessing = true;
            }
            catch (ParseException date) {
                // empty catch block
            }
        }
        if (!skipProcessing) {
            Object dateTypeObj;
            this.dataObj = value;
            Object dateObj = this.getter.getFieldValue(value, this.dateFieldName);
            if (dateObj == null && StringUtils.isNotEmpty((String)defaultValue)) {
                calDate = Calendar.getInstance();
            }
            if (dateObj instanceof Calendar) {
                calDate = (Calendar)dateObj;
            }
            if ((dateTypeObj = this.getter.getFieldValue(value, this.dateTypeName)) instanceof String) {
                inx = Integer.parseInt((String)dateTypeObj);
                this.dateTypeIsStr = true;
            } else if (dateTypeObj instanceof Short) {
                inx = ((Short)dateTypeObj).intValue();
                this.dateTypeIsStr = false;
            } else if (dateTypeObj instanceof Byte) {
                inx = ((Byte)dateTypeObj).intValue();
                this.dateTypeIsStr = false;
            } else {
                inx = 1;
            }
            if (inx > 0) {
                --inx;
            } else {
                log.error((Object)(String.valueOf(this.dateTypeName) + " was zero and shouldn't have been!"));
            }
        }
        this.currentUIV = this.uivs[inx];
        if (this.currentUIV != null) {
            this.ignoreDocChanges = true;
            ((GetSetValueIFace)((Object)this.currentUIV)).setValue(calDate, "");
            this.isChanged = true;
            this.ignoreDocChanges = false;
        }
        this.dateType = UIFieldFormatterIFace.PartialDateEnum.values()[inx + 1];
        if (!skipProcessing) {
            this.formatSelector.removeActionListener(this.comboBoxAL);
        }
        this.formatSelector.setSelectedIndex(inx);
        if (!skipProcessing) {
            this.formatSelector.addActionListener(this.comboBoxAL);
        }
        this.cardLayout.show(this.cardPanel, this.formatSelector.getModel().getElementAt(inx).toString());
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public void initialize(Properties properties, boolean isViewMode) {
        this.isDisplayOnly = isViewMode;
        this.dateFieldName = properties.getProperty("df");
        this.dateTypeName = properties.getProperty("tp");
        this.createUI();
    }

    @Override
    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    @Override
    public void setParent(FormViewObj parent) {
        DBTableInfo tblInfo;
        this.parent = parent;
        JLabel lbl = parent.getLabelFor(this);
        if (lbl != null && StringUtils.isNotEmpty((String)this.dateFieldName) && (tblInfo = DBTableIdMgr.getInstance().getByClassName(parent.getView().getClassName())) != null) {
            final DBFieldInfo fi = tblInfo.getFieldByName(this.dateFieldName);
            if (fi != null) {
                this.title = fi.getTitle();
                this.isRequired = fi.isRequired();
                if (this.uivs[0] instanceof ValFormattedTextFieldSingle) {
                    ((ValFormattedTextFieldSingle)this.uivs[0]).setRequired(this.isRequired);
                } else {
                    UIValidatable[] uIValidatableArray = this.uivs;
                    int n = this.uivs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UIValidatable uiv = uIValidatableArray[n2];
                        ((ValFormattedTextField)uiv).setRequired(this.isRequired);
                        ++n2;
                    }
                }
                if (StringUtils.isNotEmpty((String)fi.getTitle())) {
                    lbl.setText(String.valueOf(fi.getTitle()) + ":");
                    if (this.isRequired) {
                        lbl.setFont(lbl.getFont().deriveFont(1));
                    }
                }
                if (lbl != null) {
                    lbl.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            super.mouseClicked(e);
                            if (e.getClickCount() == 2) {
                                JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), "<html>" + fi.getDescription(), UIRegistry.getResourceString("FormViewObj.UNOTES"), 1);
                            }
                        }
                    });
                }
            } else {
                log.error((Object)("PartialDateUI - Couldn't find date field [" + this.dateFieldName + "] in data obj View: " + parent.getView().getName()));
            }
        }
    }

    @Override
    public void shutdown() {
        this.changeListener = null;
        this.dataObj = null;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.validateState();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged || this.currentUIV != null && this.currentUIV.isChanged();
    }

    @Override
    public boolean isInError() {
        return this.currentUIV != null ? this.currentUIV.isInError() : true;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void reset() {
        Object[] objectArray = this.uivs;
        int n = this.uivs.length;
        int n2 = 0;
        while (n2 < n) {
            UIValidatable uiv = objectArray[n2];
            uiv.reset();
            ++n2;
        }
        this.isChanged = false;
        this.isDateChanged = false;
        this.dataObj = null;
        this.formatSelector.setSelectedIndex(0);
        objectArray = this.textFields;
        n = this.textFields.length;
        n2 = 0;
        while (n2 < n) {
            Object tf = objectArray[n2];
            if (tf != null) {
                ((JTextComponent)tf).setText("");
            }
            ++n2;
        }
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
        if (!isChanged) {
            this.isDateChanged = false;
        }
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        UIValidatable[] uIValidatableArray = this.uivs;
        int n = this.uivs.length;
        int n2 = 0;
        while (n2 < n) {
            UIValidatable uiv = uIValidatableArray[n2];
            uiv.setState(state);
            ++n2;
        }
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        UIValidatable.ErrorType errType = UIValidatable.ErrorType.Valid;
        if (this.currentUIV != null) {
            errType = this.currentUIV.validateState();
            if (errType == UIValidatable.ErrorType.Incomplete && !this.isRequired) {
                errType = UIValidatable.ErrorType.Valid;
            }
        } else {
            errType = UIValidatable.ErrorType.Error;
        }
        return errType;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(e);
        }
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public void carryForwardStateChange() {
    }

    @Override
    public void setNewObj(boolean isNewObj) {
    }
}

