/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.services.mapping.LatLonPoint;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.plugins.LocalityGoogleEarthPlugin;
import edu.ku.brc.specify.ui.WorldWindPanel;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.LatLonConverter;
import edu.ku.brc.util.Pair;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class LocalityWorldWindPlugin
extends LocalityGoogleEarthPlugin
implements SelectListener {
    protected Position lastClickPos = null;
    protected WorldWindPanel wwPanel = new WorldWindPanel();
    protected LatLonPoint latLonPnt = null;
    protected CustomDialog worldWindDlg = null;

    @Override
    protected void doButtonAction() {
        LatLonConverter.FORMAT defaultFormat;
        ImageIcon img;
        Vector<LatLonPlacemarkIFace> items = new Vector<LatLonPlacemarkIFace>();
        Pair<BigDecimal, BigDecimal> llPair = this.latLonPlugin.getLatLon();
        if (this.latLonPlugin != null && llPair != null && llPair.first != null && llPair.second != null) {
            Locality geLoc = new Locality();
            geLoc.initialize();
            geLoc.setLatitude1((BigDecimal)llPair.first);
            geLoc.setLongitude1((BigDecimal)llPair.second);
            if (this.locality != null) {
                geLoc.setGeography(this.locality.getGeography());
            }
            img = this.imageIcon != null ? this.imageIcon : IconManager.getIcon("locality", IconManager.IconSize.Std32);
            items.add((LocalityGoogleEarthPlugin)this.new LocalityGoogleEarthPlugin.CEPlacemark(geLoc, img));
        } else if (this.ce != null) {
            ImageIcon img2 = this.imageIcon != null ? this.imageIcon : IconManager.getIcon("locality", IconManager.IconSize.Std32);
            items.add((LocalityGoogleEarthPlugin)this.new LocalityGoogleEarthPlugin.CEPlacemark(this.ce, img2));
        } else if (this.locality != null) {
            List<CollectingEvent> collectingEvents = this.locality.getCollectingEvents(false);
            if (collectingEvents != null && collectingEvents.size() > 0) {
                img = this.imageIcon != null ? this.imageIcon : IconManager.getIcon("collectingevent", IconManager.IconSize.Std32);
                for (CollectingEvent colEv : collectingEvents) {
                    items.add((LocalityGoogleEarthPlugin)this.new LocalityGoogleEarthPlugin.CEPlacemark(colEv, img));
                }
            } else if (this.locality != null) {
                ImageIcon img3;
                Locality geLoc = new Locality();
                geLoc.initialize();
                if (this.localityNameComp != null && this.localityNameComp instanceof JTextField) {
                    geLoc.setLocalityName(((JTextField)this.localityNameComp).getText());
                }
                ImageIcon imageIcon = img3 = this.imageIcon != null ? this.imageIcon : IconManager.getIcon("locality", IconManager.IconSize.Std32);
                if (geLoc != null && this.isLatLonOK && this.latLon != null) {
                    geLoc.setLatitude1((BigDecimal)this.latLon.first);
                    geLoc.setLongitude1((BigDecimal)this.latLon.second);
                    geLoc.setGeography(this.locality.getGeography());
                } else if (this.locality.getLatitude1() != null && this.locality.getLongitude1() != null) {
                    geLoc.setLatitude1(this.locality.getLatitude1());
                    geLoc.setLongitude1(this.locality.getLongitude1());
                    geLoc.setGeography(this.locality.getGeography());
                }
                items.add((LocalityGoogleEarthPlugin)this.new LocalityGoogleEarthPlugin.CEPlacemark(geLoc, img3));
            }
        }
        this.lastClickPos = null;
        this.wwPanel.getWorld().getInputHandler().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (!LocalityWorldWindPlugin.this.isViewMode) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Position pos = (this).LocalityWorldWindPlugin.this.wwPanel.getWorld().getCurrentPosition();
                            if (!pos.equals((Object)(this).LocalityWorldWindPlugin.this.lastClickPos)) {
                                if ((this).LocalityWorldWindPlugin.this.latLonPnt == null) {
                                    LocalityWorldWindPlugin.this.addUserDefinedMarker();
                                } else {
                                    LocalityWorldWindPlugin.this.repositionUserDefMarker();
                                }
                            }
                        }
                    });
                }
            }
        });
        if (items.size() > 0) {
            this.wwPanel.placeMarkers(items, 0);
        }
        if (this.worldWindDlg == null) {
            int btns = this.isViewMode ? 2 : 3;
            this.worldWindDlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), "World Wind", true, btns, (Component)this.wwPanel);
            this.worldWindDlg.setCancelLabel(UIRegistry.getResourceString(this.isViewMode ? "CLOSE" : "CANCEL"));
            this.worldWindDlg.createUI();
            this.worldWindDlg.pack();
            this.worldWindDlg.setSize(900, 700);
        }
        this.worldWindDlg.setVisible(true);
        if (!this.worldWindDlg.isCancelled() && this.locality != null && this.latLonPlugin != null && this.latLonPnt != null && (defaultFormat = LatLonConverter.convertIntToFORMAT(this.locality.getOriginalLatLongUnit())) != null) {
            String latStr = LatLonConverter.ensureFormattedString(new BigDecimal(this.latLonPnt.getLatitude()), this.locality.getLat2text(), defaultFormat, LatLonConverter.LATLON.Latitude);
            String lonStr = LatLonConverter.ensureFormattedString(new BigDecimal(this.latLonPnt.getLongitude()), this.locality.getLong2text(), defaultFormat, LatLonConverter.LATLON.Longitude);
            this.latLonPlugin.setLatLon(latStr, lonStr, null, null);
            this.latLon = new Pair<BigDecimal, BigDecimal>(new BigDecimal(this.latLonPnt.getLatitude()), new BigDecimal(this.latLonPnt.getLongitude()));
        }
    }

    private void addUserDefinedMarker() {
        Position pos = this.wwPanel.getWorld().getCurrentPosition();
        this.latLonPnt = new LatLonPoint(pos.getLatitude().getDegrees(), pos.getLongitude().getDegrees());
        ArrayList<LatLonPlacemarkIFace> items = new ArrayList<LatLonPlacemarkIFace>(1);
        this.wwPanel.placeMarkers(items, null);
    }

    public LatLonPlacemarkIFace getLatLonPnt() {
        return this.latLonPnt;
    }

    private void repositionUserDefMarker() {
        Position pos = this.wwPanel.getWorld().getCurrentPosition();
        this.latLonPnt.setLatitude(pos.getLatitude().getDegrees());
        this.latLonPnt.setLongitude(pos.getLongitude().getDegrees());
        ArrayList<LatLonPlacemarkIFace> items = new ArrayList<LatLonPlacemarkIFace>(1);
        items.add(this.latLonPnt);
        this.wwPanel.placeMarkers(items, null);
        this.wwPanel.getWorld().repaint();
    }

    @Override
    public String getTitle() {
        return "WorldWind";
    }

    @Override
    public void initialize(Properties properties, boolean isViewMode) {
        this.isViewMode = isViewMode;
        this.setIcon(IconManager.getIcon("WorldWind", IconManager.IconSize.Std16));
        this.setText(UIRegistry.getResourceString("WW_DSP_IN_WW"));
        this.watchId = properties.getProperty("watch");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.hasPoints = true;
        this.isLatLonOK = true;
        this.setEnabled(true);
    }

    public void selected(SelectEvent event) {
        if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") && event.hasObjects() && event.getTopPickedObject().hasPosition()) {
            this.lastClickPos = this.wwPanel.getWorld().getCurrentPosition();
        }
    }
}

