/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.plugins.latlon.LatLonUI;
import edu.ku.brc.specify.rstools.GoogleEarthExporter;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class LocalityGoogleEarthPlugin
extends JButton
implements GetSetValueIFace,
UIPluginable,
PropertyChangeListener {
    protected CollectionObject colObj = null;
    protected CollectingEvent ce;
    protected Locality locality = null;
    protected Object origData = null;
    protected boolean hasPoints = false;
    protected ImageIcon imageIcon = null;
    protected Component localityNameComp = null;
    protected String watchId = null;
    protected LatLonUI latLonPlugin = null;
    protected Vector<ChangeListener> listeners = null;
    protected Pair<BigDecimal, BigDecimal> latLon = null;
    protected boolean isLatLonOK = false;
    protected boolean isViewMode = true;

    public LocalityGoogleEarthPlugin() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LocalityGoogleEarthPlugin.this.doButtonAction();
            }
        });
    }

    protected void doButtonAction() {
        Vector<CEPlacemark> items = new Vector<CEPlacemark>();
        if (this.ce != null) {
            ImageIcon img = this.imageIcon != null ? this.imageIcon : IconManager.getIcon("locality", IconManager.IconSize.Std32);
            items.add(new CEPlacemark(this.ce, img));
        } else if (this.locality != null) {
            List<CollectingEvent> collectingEvents = this.locality.getCollectingEvents(false);
            if (collectingEvents != null && collectingEvents.size() > 0) {
                ImageIcon img = this.imageIcon != null ? this.imageIcon : IconManager.getIcon("collectingevent", IconManager.IconSize.Std32);
                for (CollectingEvent colEv : collectingEvents) {
                    items.add(new CEPlacemark(colEv, img));
                }
            } else if (this.locality != null) {
                ImageIcon img;
                Locality geLoc = new Locality();
                geLoc.initialize();
                if (this.localityNameComp != null && this.localityNameComp instanceof JTextField) {
                    geLoc.setLocalityName(((JTextField)this.localityNameComp).getText());
                }
                ImageIcon imageIcon = img = this.imageIcon != null ? this.imageIcon : IconManager.getIcon("locality", IconManager.IconSize.Std32);
                if (geLoc != null && this.isLatLonOK) {
                    geLoc.setLatitude1((BigDecimal)this.latLon.first);
                    geLoc.setLongitude1((BigDecimal)this.latLon.second);
                    geLoc.setGeography(this.locality.getGeography());
                } else if (this.locality.getLatitude1() != null && this.locality.getLongitude1() != null) {
                    geLoc.setLatitude1(this.locality.getLatitude1());
                    geLoc.setLongitude1(this.locality.getLongitude1());
                    geLoc.setGeography(this.locality.getGeography());
                }
                items.add(new CEPlacemark(geLoc, img));
            }
        }
        JStatusBar statusBar = UIRegistry.getStatusBar();
        if (items.size() > 0) {
            CommandAction command = new CommandAction("Plugins", "ExportList");
            command.setData(items);
            command.setProperty("tool", GoogleEarthExporter.class);
            statusBar.setText(UIRegistry.getResourceString("WB_OPENING_GOOGLE_EARTH"));
            CommandDispatcher.dispatch(command);
        } else {
            statusBar.setErrorMessage(UIRegistry.getResourceString("GE_NO_POINTS"));
        }
    }

    @Override
    public Object getValue() {
        return this.origData;
    }

    protected ImageIcon getDisciplineIcon() {
        Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        return IconManager.getIcon(discipline.getType(), IconManager.IconSize.Std32);
    }

    @Override
    public boolean canCarryForward() {
        return false;
    }

    @Override
    public String[] getCarryForwardFields() {
        return null;
    }

    @Override
    public String getTitle() {
        return "GoogleEarth";
    }

    @Override
    public boolean isNotEmpty() {
        throw new NotImplementedException("isNotEmpty not implement!");
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"localityName", "latitude1", "longitude1", "geography"};
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.origData = value;
        if (value != null) {
            if (value instanceof CollectionObject) {
                this.colObj = (CollectionObject)value;
                this.ce = this.colObj.getCollectingEvent();
                if (this.ce != null) {
                    this.locality = this.ce.getLocality();
                }
                this.imageIcon = this.getDisciplineIcon();
            } else if (value instanceof CollectingEvent) {
                this.ce = (CollectingEvent)value;
                this.locality = this.ce.getLocality();
                if (this.ce.getCollectionObjects().size() == 1) {
                    this.colObj = this.ce.getCollectionObjects().iterator().next();
                    this.imageIcon = this.getDisciplineIcon();
                }
            } else if (value instanceof Locality) {
                this.locality = (Locality)value;
                String select = "SELECT COUNT(*)";
                String from = " FROM collectingevent WHERE LocalityID = " + this.locality.getId();
                int ceCount = BasicSQLUtils.getCountAsInt(String.valueOf(select) + from);
                if (ceCount == 1) {
                    int ceID = BasicSQLUtils.getCountAsInt("SELECT CollectingEventID" + from);
                    List<CollectingEvent> collectingEvents = this.locality.getCollectingEvents(false);
                    this.ce = collectingEvents.get(0);
                    from = " FROM collectionobject WHERE CollectingEventID = " + ceID;
                    int coCount = BasicSQLUtils.getCountAsInt(String.valueOf(select) + from);
                    if (coCount == 1) {
                        collectingEvents = this.locality.getCollectingEvents();
                        this.ce = collectingEvents.get(0);
                        this.colObj = this.ce.getCollectionObjects().iterator().next();
                        this.imageIcon = this.getDisciplineIcon();
                    }
                }
            }
            this.hasPoints = this.locality != null && this.locality.getLat1() != null && this.locality.getLong1() != null;
        } else {
            this.hasPoints = false;
        }
        if (this.latLon != null && this.isLatLonOK) {
            this.hasPoints = this.isLatLonOK;
        }
        this.setEnabled(this.hasPoints);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled && (this.hasPoints || this.isLatLonOK));
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public void initialize(Properties properties, boolean isViewMode) {
        this.isViewMode = isViewMode;
        this.setIcon(IconManager.getIcon("GoogleEarth16"));
        this.setText(UIRegistry.getResourceString("GE_DSP_IN_GE"));
        this.watchId = properties.getProperty("watch");
    }

    @Override
    public void setCellName(String cellName) {
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    @Override
    public void setParent(FormViewObj parent) {
        if (parent != null && StringUtils.isNotEmpty((String)this.watchId)) {
            this.localityNameComp = parent.getControlByName("localityName");
            Component comp = (Component)parent.getCompById(this.watchId);
            if (comp instanceof LatLonUI) {
                this.latLonPlugin = (LatLonUI)comp;
                this.latLonPlugin.addPropertyChangeListener(this);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.latLonPlugin != null) {
            this.latLonPlugin.removePropertyChangeListener(this);
            this.latLonPlugin = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        this.locality = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object obj;
        if (evt.getPropertyName().equals("latlon") && (obj = evt.getNewValue()) instanceof Pair) {
            this.latLon = this.latLonPlugin.getLatLon();
            this.isLatLonOK = this.latLon != null && this.latLon.first != null && this.latLon.second != null && this.latLonPlugin.getState() == UIValidatable.ErrorType.Valid;
            this.setEnabled(this.isLatLonOK);
        }
    }

    @Override
    public void carryForwardStateChange() {
    }

    @Override
    public void setNewObj(boolean isNewObj) {
    }

    class CEPlacemark
    implements LatLonPlacemarkIFace {
        protected CollectingEvent colEv;
        protected Locality localityCEP;
        protected String title;
        protected ImageIcon iconURL = null;

        public CEPlacemark(CollectingEvent ce, ImageIcon iconURL) {
            this.colEv = ce;
            this.localityCEP = ce.getLocality();
            this.iconURL = iconURL;
            DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
            this.title = ce.getStartDate() != null ? scrDateFormat.format(ce.getStartDate()) : UIRegistry.getResourceString("GE_NO_START_DATE");
        }

        public CEPlacemark(Locality locality, ImageIcon iconURL) {
            this.colEv = null;
            this.localityCEP = locality;
            this.iconURL = iconURL;
            this.title = locality.getLocalityName();
        }

        @Override
        public ImageIcon getImageIcon() {
            return this.iconURL;
        }

        @Override
        public void cleanup() {
            this.colEv = null;
            this.localityCEP = null;
        }

        @Override
        public String getHtmlContent(String textColorArg) {
            String textColor = UIHelper.fixColorForHTML(textColorArg);
            DBTableInfo localityTI = DBTableIdMgr.getInstance().getInfoById(Locality.getClassTableId());
            StringBuilder sb = new StringBuilder("<table>");
            sb.append("<tr><td align=\"right\" nowrap=\"true\"><font color=\"");
            sb.append(textColor);
            sb.append("\">");
            sb.append(localityTI.getFieldByColumnName("localityName").getTitle());
            sb.append(":</font></td><td align=\"left\"><font color=\"");
            sb.append(textColor);
            sb.append("\">");
            sb.append(this.localityCEP.getLocalityName() == null ? "" : this.localityCEP.getLocalityName());
            sb.append("</font></td></tr>\n");
            sb.append("<tr><td align=\"right\"><font color=\"");
            sb.append(textColor);
            sb.append("\">");
            sb.append(localityTI.getFieldByColumnName("latitude1").getTitle());
            sb.append(":</td><td align=\"left\"><font color=\"");
            sb.append(textColor);
            sb.append("\">");
            sb.append(this.localityCEP.getLat1());
            sb.append("</font></td></tr>\n");
            sb.append("<tr><td align=\"right\"><font color=\"");
            sb.append(textColor);
            sb.append("\">");
            sb.append(localityTI.getFieldByColumnName("longitude1").getTitle());
            sb.append(":</font></td><td align=\"left\"><font color=\"");
            sb.append(textColor);
            sb.append("\">");
            sb.append(this.localityCEP.getLong1());
            sb.append("</font></td></tr>\n");
            sb.append("</table>\n");
            return sb.toString();
        }

        @Override
        public Pair<Double, Double> getLatLon() {
            return this.localityCEP != null ? new Pair<Double, Double>(this.localityCEP.getLat1(), this.localityCEP.getLong1()) : null;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public Double getAltitude() {
            return null;
        }
    }
}

