/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.services.biogeomancer.GeoCoordDataIFace;
import edu.ku.brc.services.biogeomancer.GeoCoordProviderListenerIFace;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.plugins.latlon.LatLonUI;
import edu.ku.brc.specify.rstools.BGMRecordSetProcessor;
import edu.ku.brc.specify.rstools.GeoCoordData;
import edu.ku.brc.specify.rstools.GeoLocateRecordSetProcessor;
import edu.ku.brc.specify.rstools.GeoRefRecordSetProcessorBase;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.LatLonConverter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class LocalityGeoRefPlugin
extends JButton
implements GetSetValueIFace,
UIPluginable,
GeoCoordProviderListenerIFace,
CommandListener {
    protected final String PREFERENCES = "Preferences";
    protected NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.getDefault());
    protected Locality locality = null;
    protected FormViewObj fvo = null;
    protected Object dataObj = null;
    protected boolean isViewMode = false;
    protected boolean doGeoLocate = false;
    protected String title = null;
    protected String llId = null;
    protected String geoId = null;
    protected String locId = null;
    protected FormViewObj parent = null;
    protected Vector<ChangeListener> listeners = null;

    public LocalityGeoRefPlugin() {
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        this.title = UIRegistry.getResourceString("LocalityGeoRefPlugin");
        UIRegistry.popResourceBundle();
        this.locality = null;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalityGeoRefPlugin.this.sendToGeoRefTool();
            }
        });
        AppPreferences remotePrefs = AppPreferences.getRemote();
        String tool = remotePrefs.get("georef_tool", "geolocate");
        this.doGeoLocate = tool.equalsIgnoreCase("geolocate");
        CommandDispatcher.register("Preferences", this);
    }

    @Override
    public boolean canCarryForward() {
        return false;
    }

    @Override
    public String[] getCarryForwardFields() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected void sendToGeoRefTool() {
        if (this.locality != null) {
            Geography geo = this.locality.getGeography();
            if (geo == null) {
                if (this.geoId != null) {
                    ValComboBoxFromQuery cbx = (ValComboBoxFromQuery)this.parent.getCompById(this.geoId);
                    if (cbx != null) {
                        geo = (Geography)cbx.getValue();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "The LatLonUI is missing the 'geoid' parameter", "Error", 0);
                    return;
                }
            }
            if (geo != null) {
                String country = GeoRefRecordSetProcessorBase.getNameForRank(geo, 200);
                String state = GeoRefRecordSetProcessorBase.getNameForRank(geo, 300);
                String county = GeoRefRecordSetProcessorBase.getNameForRank(geo, 400);
                int id = this.locality.getLocalityId() != null ? this.locality.getLocalityId() : 1;
                String locName = this.locality.getLocalityName();
                if (StringUtils.isEmpty((String)locName)) {
                    if (this.locId != null) {
                        ValTextField txt = (ValTextField)this.parent.getCompById(this.locId);
                        if (txt != null) {
                            locName = (String)txt.getValue();
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "The LatLonUI is missing the 'locid' parameter", "Error", 0);
                    }
                }
                GeoCoordData geoCoordData = new GeoCoordData(id, country, state, county == null ? "" : county, locName, this.locality.getErrorPolygon(), this.locality.getErrorEstimate());
                Vector<GeoCoordData> items = new Vector<GeoCoordData>();
                items.add(geoCoordData);
                CommandAction command = new CommandAction("Plugins", "ExportList");
                command.setData(items);
                command.setProperty("tool", this.doGeoLocate ? GeoLocateRecordSetProcessor.class : BGMRecordSetProcessor.class);
                command.setProperty("listener", this);
                JStatusBar statusBar = UIRegistry.getStatusBar();
                statusBar.setText(UIRegistry.getResourceString(this.doGeoLocate ? "GEOLOC_PROCESSING" : "BGM_PROCESSING"));
                CommandDispatcher.dispatch(command);
            } else {
                UIRegistry.displayErrorDlgLocalized(this.doGeoLocate ? "GEOLOC_REQUIRED" : "BGM_GEO_REQUIRED", new Object[0]);
            }
        }
    }

    @Override
    public boolean isNotEmpty() {
        throw new NotImplementedException("isNotEmpty not implement!");
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"localityName", "geography"};
    }

    protected void adjustUIForTool() {
        if (this.doGeoLocate) {
            this.setIcon(IconManager.getIcon("GEOLocate16"));
            this.setText("GEOLocate");
        } else {
            this.setIcon(IconManager.getIcon("BioGeoMancer32", IconManager.IconSize.Std16));
            this.setText("BioGeomancer");
        }
    }

    @Override
    public Object getValue() {
        if (this.dataObj != null && this.dataObj instanceof Locality) {
            return this.locality;
        }
        return null;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.dataObj = value;
        boolean enable = false;
        if (value != null && value instanceof Locality) {
            this.locality = (Locality)value;
        } else {
            this.locality = null;
            this.dataObj = null;
        }
        if (this.locality != null) {
            enable = true;
        }
        this.setEnabled(enable);
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public void initialize(Properties properties, boolean isViewModeArg) {
        this.isViewMode = isViewModeArg;
        this.setEnabled(!this.isViewMode);
        this.geoId = properties.getProperty("geoid");
        this.locId = properties.getProperty("locid");
        this.llId = properties.getProperty("llid");
        this.adjustUIForTool();
    }

    @Override
    public void setCellName(String cellName) {
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    @Override
    public void setParent(FormViewObj parent) {
        this.parent = parent;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable && this.locality != null && !this.isViewMode);
    }

    @Override
    public void aboutToDisplayResults() {
    }

    @Override
    public void complete(List<GeoCoordDataIFace> items, int itemsUpdated) {
        if (this.parent != null && itemsUpdated > 0 && items.size() > 0) {
            GeoCoordDataIFace gcData = items.get(0);
            BigDecimal lat1 = UIHelper.parseDoubleToBigDecimal(gcData.getLatitude());
            BigDecimal lon1 = UIHelper.parseDoubleToBigDecimal(gcData.getLongitude());
            if (this.llId == null) {
                JOptionPane.showMessageDialog(null, "The LatLonUI is missing the 'llid' parameter", "Error", 0);
                return;
            }
            LatLonUI latLonUI = (LatLonUI)this.parent.getCompById(this.llId);
            if (latLonUI != null) {
                latLonUI.resetUI();
                String latStr = LatLonConverter.ensureFormattedString(lat1, null, LatLonConverter.FORMAT.DDDDDD, LatLonConverter.LATLON.Latitude);
                String lonStr = LatLonConverter.ensureFormattedString(lon1, null, LatLonConverter.FORMAT.DDDDDD, LatLonConverter.LATLON.Longitude);
                latLonUI.setLatLon(latStr, lonStr, null, null);
                latLonUI.setErrorInfo(gcData.getErrorPolygon(), gcData.getErrorEstimate());
            }
        }
    }

    @Override
    public void shutdown() {
        this.parent = null;
        CommandDispatcher.unregister("Preferences", this);
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        this.locality = null;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType("Preferences") && cmdAction.isAction("Updated")) {
            String geoRefTool = cmdAction.getPropertyAsString("georef_tool");
            if (geoRefTool != null) {
                this.doGeoLocate = geoRefTool.equalsIgnoreCase("geolocate");
            }
            this.adjustUIForTool();
        }
    }

    @Override
    public void carryForwardStateChange() {
    }

    @Override
    public void setNewObj(boolean isNewObj) {
    }
}

