/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigCache;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchQueryBuilderIFace;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectingEventAttribute;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.CollectionRelationship;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.busrules.TableSearchResults;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class HostTaxonPlugin
extends UIPluginBase {
    protected boolean isLeftSide = false;
    protected CollectionRelType colRelType = null;
    protected Collection leftSideCol = null;
    protected Collection rightSideCol = null;
    protected CollectionRelationship collectionRel = null;
    protected CollectionObject otherSide = null;
    protected ValComboBoxFromQuery cbx = null;
    protected JTextField text = null;
    protected String relName = null;
    protected Integer hostCollId = null;
    protected Discipline rightsideDiscipline = null;
    protected TaxonTreeDef taxonTreeDef = null;
    protected Taxon taxon = null;

    public static List<CollectionRelationship> getCollectionRelationships() {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<CollectionRelationship> list = session.getDataList("FROM CollectionRelationship");
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return new ArrayList<CollectionRelationship>();
    }

    @Override
    public boolean isNotEmpty() {
        throw new NotImplementedException("isNotEmpty not implement!");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.cbx != null) {
            this.cbx.setEnabled(enabled);
        }
    }

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        CellConstraints cc = new CellConstraints();
        String errMsg = null;
        this.relName = propertiesArg.getProperty("relname", null);
        if (StringUtils.isNotEmpty((String)this.relName)) {
            block21: {
                Collection curCollection = AppContextMgr.getInstance().getClassObject(Collection.class);
                String sql = String.format("SELECT RightSideCollectionID FROM collectionreltype WHERE Name = \"%s\" AND LeftSideCollectionID = %d", this.relName, curCollection.getId());
                System.err.println(sql);
                this.hostCollId = BasicSQLUtils.getCount(sql);
                System.err.println("hostCollId: " + this.hostCollId + "   curColId: " + curCollection.getId());
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        this.colRelType = session.getData(CollectionRelType.class, "name", this.relName, DataProviderSessionIFace.CompareType.Equals);
                        if (this.colRelType != null) {
                            this.leftSideCol = this.colRelType.getLeftSideCollection();
                            this.rightSideCol = this.colRelType.getRightSideCollection();
                        }
                        if (this.rightSideCol != null) {
                            this.hostCollId = this.rightSideCol.getId();
                            System.err.println("2hostCollId: " + this.hostCollId + "   curColId: " + curCollection.getId());
                            if (this.hostCollId != null) {
                                this.rightsideDiscipline = this.rightSideCol.getDiscipline();
                                if (this.rightsideDiscipline != null) {
                                    this.taxonTreeDef = this.rightsideDiscipline.getTaxonTreeDef();
                                } else {
                                    errMsg = UIRegistry.getLocalizedMessage("HostTaxonPlugin.ERR_MSG_RSD", this.relName);
                                }
                            } else {
                                errMsg = UIRegistry.getLocalizedMessage("HostTaxonPlugin.ERR_BAD_NM", this.relName, curCollection.getCollectionName());
                            }
                        } else {
                            errMsg = UIRegistry.getLocalizedMessage("HostTaxonPlugin.ERR_MSG_RSC", this.relName);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        errMsg = UIRegistry.getLocalizedMessage("HostTaxonPlugin.ERR", new Object[0]);
                        if (session != null) {
                            session.close();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
            if (this.hostCollId != null && this.rightsideDiscipline != null) {
                if (this.isViewMode) {
                    PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p"), (JPanel)this);
                    this.text = UIHelper.createTextField("");
                    ViewFactory.changeTextFieldUIForDisplay(this.text, false);
                    pb.add((Component)this.text, cc.xy(1, 1));
                } else {
                    PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"), (JPanel)this);
                    int btnOpts = 4;
                    this.cbx = new ValComboBoxFromQuery(DBTableIdMgr.getInstance().getInfoById(Taxon.getClassTableId()), "fullName", "fullName", "fullName", "%s", null, null, "", null, btnOpts);
                    pb.add((Component)this.cbx, cc.xy(1, 1));
                    this.cbx.registerQueryBuilder(this.createSearchQueryBuilder());
                    this.cbx.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            HostTaxonPlugin.this.itemSelected();
                        }
                    });
                }
            }
        } else {
            errMsg = UIRegistry.getLocalizedMessage("HostTaxonPlugin.ERR_MSG_REL_EMPTY", new Object[0]);
        }
        if (errMsg != null) {
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p"), (JPanel)this);
            JButton btn = UIHelper.createI18NButton("HostTaxonPlugin.ERR_CLICK");
            pb.add((Component)btn, cc.xy(1, 1));
            final String dlgErrMsg = errMsg;
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UIRegistry.showError(dlgErrMsg);
                }
            });
        }
    }

    protected ViewBasedSearchQueryBuilderIFace createSearchQueryBuilder() {
        return new ViewBasedSearchQueryBuilderIFace(){

            @Override
            public String buildSQL(String searchText, boolean isForCount) {
                String cols = isForCount ? "COUNT(*)" : "tx.fullName, tx.id";
                String sql = String.format("SELECT %s FROM Taxon tx INNER JOIN tx.definition ttd WHERE ttd.id = %d AND LOWER(tx.fullName) LIKE '%c%s%c' ORDER BY tx.fullName", cols, HostTaxonPlugin.this.taxonTreeDef.getId(), Character.valueOf('%'), searchText, Character.valueOf('%'));
                return sql;
            }

            @Override
            public String buildSQL(Map<String, Object> dataMap, List<String> fieldNames) {
                String common;
                String orderBy = "";
                String fullName = (String)dataMap.get("taxon.FullName");
                if (StringUtils.isNotEmpty((String)fullName)) {
                    fullName = StringUtils.remove((String)fullName, (char)'#');
                    if (StringUtils.isNotEmpty((String)(fullName = StringUtils.remove((String)fullName, (char)'*')))) {
                        orderBy = "FullName";
                        fullName = String.format("LOWER(FullName) LIKE '%c%s%c'", Character.valueOf('%'), fullName.toLowerCase(), Character.valueOf('%'));
                    }
                }
                if (StringUtils.isNotEmpty((String)(common = (String)dataMap.get("taxon.CommonName")))) {
                    common = StringUtils.remove((String)common, (char)'#');
                    if (StringUtils.isNotEmpty((String)(common = StringUtils.remove((String)common, (char)'*')))) {
                        common = String.valueOf(StringUtils.isNotEmpty((String)fullName) ? " OR " : "") + String.format("LOWER(CommonName) LIKE '%c%s%c'", Character.valueOf('%'), common.toLowerCase(), Character.valueOf('%'));
                        if (StringUtils.isEmpty((String)fullName)) {
                            orderBy = "CommonName";
                        }
                    }
                }
                String sql = String.format("SELECT TaxonID, FullName, CommonName FROM taxon tx INNER JOIN taxontreedef ttd ON tx.TaxonTreeDefID = ttd.TaxonTreeDefID WHERE ttd.TaxonTreeDefID = %d AND %s %s ORDER BY %s", HostTaxonPlugin.this.taxonTreeDef.getId(), fullName == null ? "" : fullName, common == null ? "" : common, orderBy);
                return sql;
            }

            @Override
            public QueryForIdResultsIFace createQueryForIdResults() {
                ExpressResultsTableInfo esTblInfo = ExpressSearchConfigCache.getTableInfoByName("TaxonSearch");
                return new TableSearchResults(DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId()), esTblInfo.getCaptionInfo());
            }
        };
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"hostTaxon"};
    }

    protected void itemSelected() {
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        CollectingEventAttribute cea;
        super.setValue(value, defaultValue);
        boolean clear = true;
        if (value instanceof CollectingEventAttribute && (cea = (CollectingEventAttribute)value).getHostTaxon() != null) {
            clear = false;
            if (this.text != null) {
                this.text.setText(cea.getHostTaxon().getFullName() != null ? cea.getHostTaxon().getFullName() : cea.getHostTaxon().getName());
            } else if (this.cbx != null) {
                this.cbx.setValue(cea.getHostTaxon(), null);
                this.cbx.getTextWithQuery().setSelectedId(cea.getHostTaxon().getId());
            }
        }
        if (clear) {
            if (this.text != null) {
                this.text.setText("");
            } else if (this.cbx != null) {
                this.cbx.setValue(null, null);
            } else {
                System.err.println("cbx and text field were null");
            }
        }
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                CollectingEvent ce = session.get(CollectingEvent.class, 9);
                if (ce != null && ce.getCollectingEventAttribute() != null) {
                    System.err.print("[" + ce.getCollectingEventAttribute().getId() + "]  ");
                    System.err.println("[" + ce.getCollectingEventAttribute().getHostTaxon() + "]");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ValComboBoxFromQuery.class, ex);
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    public Object getValue() {
        Object data;
        if (this.fvo != null && (data = this.fvo.getCurrentDataObj()) instanceof CollectingEventAttribute) {
            CollectingEventAttribute cea = (CollectingEventAttribute)data;
            cea.setHostTaxon((Taxon)this.cbx.getValue());
        }
        return null;
    }
}

