/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.ViewBasedDialogFactoryIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayActionAdapter;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.extras.FishBaseInfoGetter;
import edu.ku.brc.specify.extras.FishBaseInfoGetterListener;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.NotImplementedException;
import org.dom4j.Element;

public class FishBase
extends JPanel
implements GetSetValueIFace,
UIPluginable,
FishBaseInfoGetterListener {
    protected JTextField textField;
    protected Taxon taxon;
    protected JButton infoBtn = null;
    protected JProgressBar progress = null;
    protected ViewBasedDisplayIFace frame = null;
    protected MultiView multiView = null;
    protected FishBaseInfoGetter getter;

    protected void createInfoFrame() {
        String species = this.taxon.getName();
        String genus = this.taxon.getParent().getName();
        this.frame = UIRegistry.getViewbasedFactory().createDisplay(UIHelper.getWindow(this), "FishBase", "Fish Base Information", UIRegistry.getResourceString("CLOSE"), false, 0, null, ViewBasedDialogFactoryIFace.FRAME_TYPE.FRAME);
        this.frame.setData(null);
        this.frame.showDisplay(true);
        this.frame.setCloseListener(new ViewBasedDisplayActionAdapter(){

            @Override
            public boolean okPressed(ViewBasedDisplayIFace vbd) {
                if (FishBase.this.multiView != null) {
                    FishBase.this.multiView.unregisterDisplayFrame(FishBase.this.frame);
                }
                FishBase.this.frame.dispose();
                FishBase.this.frame = null;
                return true;
            }
        });
        this.multiView = this.frame.getMultiView();
        if (this.multiView != null) {
            this.multiView.registerDisplayFrame(this.frame);
            this.progress = (JProgressBar)this.multiView.getCurrentView().getCompById("progress");
            this.progress.setIndeterminate(true);
            this.progress.setValue(50);
        }
        if (this.frame instanceof JFrame) {
            ((JFrame)((Object)this.frame)).setIconImage(IconManager.getIcon("FishBase", IconManager.IconSize.Std16).getImage());
        }
        if (this.getter == null) {
            this.getter = new FishBaseInfoGetter(this, FishBaseInfoGetter.InfoType.Summary, genus, species);
        }
        this.getter.start();
    }

    @Override
    public boolean canCarryForward() {
        return false;
    }

    @Override
    public String[] getCarryForwardFields() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Fish Base";
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    protected void setDataIntoframe(Element dom) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FishBase.this.progress.setIndeterminate(false);
                FishBase.this.progress.setVisible(false);
                FishBase.this.frame.setData(FishBase.this.getter.getDom());
            }
        });
    }

    @Override
    public boolean isNotEmpty() {
        throw new NotImplementedException("isNotEmpty not implement!");
    }

    @Override
    public void infoArrived(FishBaseInfoGetter getterArg) {
        this.setDataIntoframe(getterArg.getDom());
    }

    @Override
    public void infoGetWasInError(FishBaseInfoGetter getterArg) {
        this.setDataIntoframe(null);
    }

    @Override
    public void initialize(Properties properties, boolean isViewMode) {
        this.textField = new JTextField();
        Insets insets = this.textField.getBorder().getBorderInsets(this.textField);
        this.textField.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.bottom));
        this.textField.setForeground(Color.BLACK);
        this.textField.setEditable(false);
        ColorWrapper viewFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "viewfieldcolor");
        if (viewFieldColor != null) {
            this.textField.setBackground(viewFieldColor.getColor());
        }
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g,1px,p", "c:p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.textField, cc.xy(1, 1));
        this.infoBtn = new JButton(IconManager.getIcon("FishBase", IconManager.IconSize.Std16));
        this.infoBtn.setFocusable(false);
        this.infoBtn.setMargin(new Insets(1, 1, 1, 1));
        this.infoBtn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        builder.add((Component)this.infoBtn, cc.xy(3, 1));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FishBase.this.createInfoFrame();
                    }
                });
            }
        });
    }

    @Override
    public void setCellName(String cellName) {
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"taxon"};
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value != null && value instanceof Taxon) {
            this.taxon = (Taxon)value;
            this.infoBtn.setEnabled(this.taxon.getRankId() == 220);
            this.textField.setText(this.taxon.getFullName());
        } else {
            this.textField.setText("");
        }
    }

    @Override
    public Object getValue() {
        return this.taxon;
    }

    @Override
    public void shutdown() {
        this.multiView = null;
        this.getter = null;
        this.frame = null;
    }

    @Override
    public void setParent(FormViewObj parent) {
    }

    @Override
    public void carryForwardStateChange() {
    }

    @Override
    public void setNewObj(boolean isNewObj) {
    }
}

