/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.TextFieldWithInfo;
import edu.ku.brc.af.ui.forms.SessionListenerIFace;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.Properties;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ContainersColObjPlugin
extends UIPluginBase
implements SessionListenerIFace,
UIValidatable {
    private static final String CATNUM_NAME = "catalogNumber";
    private static final String CATNUM_NAMECAP = "CatalogNumber";
    private static final String COLOBJ_NAME = "CollectionObject";
    private ValComboBoxFromQuery qcbx = null;
    private TextFieldWithInfo textWithInfo = null;
    private Set<CollectionObject> coSet = null;
    private Container container = null;
    private UIFieldFormatterIFace colObjFmt = null;
    private String errorMsg = null;
    private boolean isRequired = false;

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        this.errorMsg = UIRegistry.getResourceString("CNTR_CO_INUSE");
        UIRegistry.popResourceBundle();
        DBTableInfo coTI = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId());
        DBFieldInfo catNumFld = coTI.getFieldByColumnName(CATNUM_NAMECAP);
        this.colObjFmt = catNumFld.getFormatter();
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("MAX(p;100px)", "p"), (JPanel)this);
        if (isViewModeArg) {
            this.textWithInfo = new TextFieldWithInfo(coTI.getClassName(), CATNUM_NAME, CATNUM_NAME, null, CATNUM_NAMECAP, COLOBJ_NAME, COLOBJ_NAME, "");
            pb.add((Component)this.textWithInfo, cc.xy(1, 1));
            ViewFactory.changeTextFieldUIForDisplay(this.textWithInfo.getTextField(), false);
        } else {
            int btnOpts = 20;
            this.qcbx = new ValComboBoxFromQuery(coTI, CATNUM_NAME, CATNUM_NAME, CATNUM_NAME, null, CATNUM_NAMECAP, null, "", null, btnOpts);
            pb.add((Component)this.qcbx, cc.xy(1, 1));
            this.qcbx.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ContainersColObjPlugin.this.itemSelected();
                }
            });
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value != null && value instanceof Container) {
            this.container = (Container)value;
            this.coSet = this.container.getCollectionObjects();
            this.coSet.size();
            CollectionObject colObj = null;
            if (!this.coSet.isEmpty()) {
                colObj = this.coSet.iterator().next();
            }
            if (this.qcbx != null) {
                this.qcbx.setValue(colObj, null);
            } else if (this.textWithInfo != null) {
                this.textWithInfo.setValue(colObj, null);
            }
        }
    }

    @Override
    public Object getValue() {
        Object qcbxValue;
        CollectionObject colObj = null;
        if (this.coSet != null && !this.coSet.isEmpty()) {
            colObj = this.coSet.iterator().next();
        }
        if (this.qcbx != null && (qcbxValue = this.qcbx.getValue()) != null) {
            CollectionObject newColObj = (CollectionObject)qcbxValue;
            if (colObj == null || !newColObj.getId().equals(colObj.getId())) {
                this.coSet.clear();
                this.coSet.add(newColObj);
                newColObj.setContainer(this.container);
            }
        }
        return this.container;
    }

    protected void itemSelected() {
        Integer selectedId = this.qcbx.getTextWithQuery().getSelectedId();
        if (selectedId != null) {
            StringBuilder clauseSB = new StringBuilder(String.format(" FROM collectionobject WHERE CollectionObjectId = %d AND ContainerID IS NOT NULL", selectedId));
            if (this.container.getId() != null) {
                clauseSB.append(String.format(" AND ContainerID <> %d", this.container.getId()));
            }
            final String clause = clauseSB.toString();
            String sql = "SELECT COUNT(*)" + clause;
            System.err.println(sql);
            if (BasicSQLUtils.getCountAsInt(sql) > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContainersColObjPlugin.this.qcbx.setValue(null, null);
                        String catNumStr = (String)BasicSQLUtils.querySingleObj("SELECT CatalogNumber" + clause);
                        catNumStr = ContainersColObjPlugin.this.colObjFmt != null ? (String)ContainersColObjPlugin.this.colObjFmt.formatToUI(catNumStr) : catNumStr;
                        UIRegistry.showError(String.format(ContainersColObjPlugin.this.errorMsg, catNumStr));
                    }
                });
            }
        } else {
            CollectionObject colObj = this.container.getCollectionObject();
            if (colObj != null) {
                this.fvo.getMVParent().getTopLevel().addToBeSavedItem(colObj);
                colObj.setContainer(null);
                this.coSet.clear();
            }
        }
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    @Override
    public boolean isNotEmpty() {
        return false;
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{CATNUM_NAME};
    }

    @Override
    public void setSession(DataProviderSessionIFace session) {
        if (this.qcbx != null) {
            this.qcbx.setSession(session);
        }
    }

    @Override
    public void cleanUp() {
        if (this.qcbx != null) {
            this.qcbx.cleanUp();
        }
    }

    @Override
    public String getReason() {
        return this.qcbx != null ? this.qcbx.getReason() : null;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.qcbx != null ? this.qcbx.getState() : UIValidatable.ErrorType.Valid;
    }

    @Override
    public Component getValidatableUIComp() {
        return this.qcbx;
    }

    @Override
    public boolean isChanged() {
        return this.qcbx != null ? this.qcbx.isChanged() : false;
    }

    @Override
    public boolean isInError() {
        return this.qcbx != null ? this.qcbx.isInError() : false;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void reset() {
        this.qcbx.reset();
    }

    @Override
    public void setAsNew(boolean isNew) {
        if (this.qcbx != null) {
            this.qcbx.setAsNew(isNew);
        }
    }

    @Override
    public void setChanged(boolean isChanged) {
        if (this.qcbx != null) {
            this.qcbx.setChanged(isChanged);
        }
    }

    @Override
    public void setRequired(boolean isRequired) {
        if (this.qcbx != null) {
            this.qcbx.setRequired(isRequired);
        }
        this.isRequired = isRequired;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        if (this.qcbx != null) {
            this.qcbx.setState(state);
        }
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        return this.qcbx != null ? this.qcbx.validateState() : UIValidatable.ErrorType.Valid;
    }
}

