/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.TextFieldWithInfo;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ContainerPlugin
extends UIPluginBase
implements UIValidatable {
    private Container associatedContainer = null;
    private Container parentContainer = null;
    private CollectionObject collectionObject = null;
    private UIFieldFormatterIFace catalogNumberFormatter = null;
    protected ValComboBoxFromQuery parentContainerCBX = null;
    protected ValComboBoxFromQuery associatedContainerCBX = null;
    protected TextFieldWithInfo parentContainerTXTInfo = null;
    protected TextFieldWithInfo associatedContainerTXTInfo = null;
    protected JLabel labelParentCon = null;
    protected JLabel labelAssocCon = null;
    protected String strParentCon = null;
    protected String strAssocCon = null;
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel cardPanel;
    protected Boolean doingParent = null;
    protected boolean isRequired = false;
    protected ButtonGroup group = new ButtonGroup();
    protected JRadioButton isParentContainerRB = null;
    protected JRadioButton isAssociatedRB = null;
    protected String errorMsg = null;

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        DBTableInfo conTI = DBTableIdMgr.getInstance().getInfoById(Container.getClassTableId());
        CellConstraints cc = new CellConstraints();
        this.cardPanel = new JPanel(this.cardLayout);
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        this.strParentCon = UIRegistry.getResourceString("PARENT_CONTAINER");
        this.strAssocCon = UIRegistry.getResourceString("CONTAINER");
        this.errorMsg = UIRegistry.getResourceString("ASSOC_CONTR_INUSE");
        UIRegistry.popResourceBundle();
        if (isViewModeArg) {
            this.labelParentCon = UIHelper.createLabel(this.strParentCon);
            this.labelAssocCon = UIHelper.createLabel(this.strAssocCon);
            PanelBuilder pbParent = new PanelBuilder(new FormLayout("f:p:g", "p,2px,p"));
            pbParent.add((Component)this.labelParentCon, cc.xy(1, 1));
            PanelBuilder pbAssoc = new PanelBuilder(new FormLayout("f:p:g", "p,2px,p"));
            pbAssoc.add((Component)this.labelAssocCon, cc.xy(1, 1));
            this.parentContainerTXTInfo = new TextFieldWithInfo(conTI.getClassName(), "name", "name", null, null, null, "ContainerDisplay", "");
            this.associatedContainerTXTInfo = new TextFieldWithInfo(conTI.getClassName(), "name", "name", null, null, null, "ContainerDisplay", "");
            ViewFactory.changeTextFieldUIForDisplay(this.parentContainerTXTInfo.getTextField(), false);
            ViewFactory.changeTextFieldUIForDisplay(this.associatedContainerTXTInfo.getTextField(), false);
            pbParent.add((Component)this.parentContainerTXTInfo, cc.xy(1, 3));
            pbAssoc.add((Component)this.associatedContainerTXTInfo, cc.xy(1, 3));
            this.cardPanel.add(Integer.toString(this.parentContainerTXTInfo.hashCode()), pbParent.getPanel());
            this.cardPanel.add(Integer.toString(this.associatedContainerTXTInfo.hashCode()), pbAssoc.getPanel());
            this.setLayout(new BorderLayout());
            this.add((Component)this.cardPanel, "Center");
        } else {
            this.isParentContainerRB = new JRadioButton(this.strParentCon);
            this.isAssociatedRB = new JRadioButton(this.strAssocCon);
            this.group.add(this.isParentContainerRB);
            this.group.add(this.isAssociatedRB);
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,4px,p"));
            pb.add((Component)this.isParentContainerRB, cc.xy(1, 1));
            pb.add((Component)this.isAssociatedRB, cc.xy(1, 3));
            this.catalogNumberFormatter = DBTableIdMgr.getFieldFormatterFor(CollectionObject.class, "CatalogNumber");
            int btnOpts = 7;
            this.parentContainerCBX = new ValComboBoxFromQuery(conTI, "name", "name", "name", null, "name", null, "", null, btnOpts);
            this.associatedContainerCBX = new ValComboBoxFromQuery(conTI, "name", "name", "name", null, "name", null, "", null, btnOpts);
            PanelBuilder pbParent = new PanelBuilder(new FormLayout("f:p:g", "p"));
            pbParent.add((Component)this.parentContainerCBX, cc.xy(1, 1));
            PanelBuilder pbAssoc = new PanelBuilder(new FormLayout("f:p:g", "p"));
            pbAssoc.add((Component)this.associatedContainerCBX, cc.xy(1, 1));
            this.setOpaque(false);
            this.cardPanel.setOpaque(false);
            pbParent.getPanel().setOpaque(false);
            pbAssoc.getPanel().setOpaque(false);
            this.isParentContainerRB.setOpaque(false);
            this.isAssociatedRB.setOpaque(false);
            pb.getPanel().setOpaque(false);
            this.cardPanel.add(Integer.toString(this.isParentContainerRB.hashCode()), pbParent.getPanel());
            this.cardPanel.add(Integer.toString(this.isAssociatedRB.hashCode()), pbAssoc.getPanel());
            PanelBuilder parent = new PanelBuilder(new FormLayout("f:p:g", "p,4px,p"), (JPanel)this);
            parent.add((Component)pb.getPanel(), cc.xy(1, 1));
            parent.add((Component)this.cardPanel, cc.xy(1, 3));
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            ListSelectionListener lsl = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e == null || !e.getValueIsAdjusting()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ContainerPlugin.this.itemSelected();
                            }
                        });
                    }
                }
            };
            this.associatedContainerCBX.addListSelectionListener(lsl);
            this.parentContainerCBX.addListSelectionListener(lsl);
            ActionListener rbAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRadioButton rb = (JRadioButton)e.getSource();
                    if (rb.isSelected()) {
                        boolean oldDoingParent = ContainerPlugin.this.doingParent;
                        ContainerPlugin.this.cardLayout.show(ContainerPlugin.this.cardPanel, Integer.toString(rb.hashCode()));
                        ContainerPlugin.this.doingParent = rb.hashCode() == ContainerPlugin.this.isParentContainerRB.hashCode();
                        if (ContainerPlugin.this.doingParent != oldDoingParent) {
                            ContainerPlugin.this.parentContainer = null;
                            ContainerPlugin.this.associatedContainer = null;
                            ContainerPlugin.this.parentContainerCBX.setValue(null, null);
                            ContainerPlugin.this.associatedContainerCBX.setValue(null, null);
                        }
                    }
                    ContainerPlugin.this.notifyChangeListeners(new ChangeEvent(rb));
                }
            };
            this.isParentContainerRB.addActionListener(rbAction);
            this.isAssociatedRB.addActionListener(rbAction);
            this.isParentContainerRB.setSelected(true);
        }
    }

    private void ensureCBXs() {
        if (this.collectionObject != null) {
            this.parentContainer = this.collectionObject.getContainerOwner();
            this.associatedContainer = this.collectionObject.getContainer();
            this.doingParent = this.associatedContainer == null;
        } else {
            this.parentContainer = null;
            this.associatedContainer = null;
            this.doingParent = true;
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value != null && value instanceof CollectionObject) {
            this.collectionObject = (CollectionObject)value;
            this.ensureCBXs();
            if (this.isViewMode) {
                this.parentContainerTXTInfo.setValue(this.parentContainer, null);
                this.associatedContainerTXTInfo.setValue(this.associatedContainer, null);
                if (this.doingParent != null) {
                    TextFieldWithInfo comp = this.doingParent != false ? this.parentContainerTXTInfo : this.associatedContainerTXTInfo;
                    this.cardLayout.show(this.cardPanel, Integer.toString(comp.hashCode()));
                }
            } else {
                if (this.doingParent.booleanValue()) {
                    if (this.parentContainerCBX != null) {
                        this.parentContainerCBX.setValue(this.parentContainer, null);
                    }
                } else if (this.associatedContainerCBX != null) {
                    this.associatedContainerCBX.setValue(this.associatedContainer, null);
                }
                if (this.doingParent != null) {
                    JRadioButton rb = this.doingParent != false ? this.isParentContainerRB : this.isAssociatedRB;
                    rb.setSelected(true);
                    this.cardLayout.show(this.cardPanel, Integer.toString(rb.hashCode()));
                }
            }
        }
        if (this.isViewMode) {
            if (this.parentContainer == null && this.associatedContainer == null) {
                this.cardLayout.show(this.cardPanel, Integer.toString(this.parentContainerTXTInfo.hashCode()));
                this.labelParentCon.setText("       ");
            } else {
                this.labelParentCon.setText(this.strParentCon);
            }
        }
    }

    @Override
    public Object getValue() {
        if (this.doingParent != null) {
            if (this.doingParent.booleanValue()) {
                this.collectionObject.setContainerOwner((Container)this.parentContainerCBX.getValue());
                this.collectionObject.setContainer(null);
            } else {
                this.collectionObject.setContainer((Container)this.associatedContainerCBX.getValue());
                this.collectionObject.setContainerOwner(null);
            }
        }
        return this.collectionObject;
    }

    private ValComboBoxFromQuery getCBX() {
        return this.doingParent == null ? null : (this.doingParent != false ? this.parentContainerCBX : this.associatedContainerCBX);
    }

    protected void itemSelected() {
        String sql;
        Vector<Object[]> data;
        final ValComboBoxFromQuery qcbx = this.getCBX();
        Integer selectedId = qcbx.getTextWithQuery().getSelectedId();
        if (!this.doingParent.booleanValue() && selectedId != null && (data = BasicSQLUtils.query(sql = String.format("SELECT cn.Name, co.CatalogNumber FROM container AS cn Inner Join collectionobject AS co ON cn.ContainerID = co.ContainerID WHERE co.ContainerID = %d", selectedId))).size() > 0) {
            final Object[] row = data.get(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    qcbx.setValue(null, null);
                    String conName = (String)row[0];
                    String catNumber = (String)ContainerPlugin.this.catalogNumberFormatter.formatToUI(row[1]);
                    UIRegistry.showError(String.format(ContainerPlugin.this.errorMsg, conName, catNumber));
                }
            });
        }
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    @Override
    public boolean isNotEmpty() {
        ValComboBoxFromQuery qcbx;
        ValComboBoxFromQuery valComboBoxFromQuery = qcbx = this.doingParent != false ? this.parentContainerCBX : this.associatedContainerCBX;
        return qcbx.getValue() != null;
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"container", "containerOwner"};
    }

    @Override
    public void cleanUp() {
        if (this.parentContainerCBX != null) {
            this.parentContainerCBX.cleanUp();
            this.associatedContainerCBX.cleanUp();
        }
    }

    @Override
    public String getReason() {
        return this.getCBX() != null ? this.getCBX().getReason() : null;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.getCBX() != null ? this.getCBX().getState() : UIValidatable.ErrorType.Valid;
    }

    @Override
    public Component getValidatableUIComp() {
        return this.getCBX();
    }

    @Override
    public boolean isChanged() {
        return this.getCBX() != null ? this.getCBX().isChanged() : false;
    }

    @Override
    public boolean isInError() {
        return this.getCBX() != null ? this.getCBX().isInError() : false;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void reset() {
        if (this.parentContainerCBX != null) {
            this.parentContainerCBX.reset();
            this.associatedContainerCBX.reset();
        }
    }

    @Override
    public void setAsNew(boolean isNew) {
        if (this.parentContainerCBX != null) {
            this.parentContainerCBX.setAsNew(isNew);
            this.associatedContainerCBX.setAsNew(isNew);
        }
    }

    @Override
    public void setChanged(boolean isChanged) {
        if (this.getCBX() != null) {
            this.getCBX().setChanged(isChanged);
        }
    }

    @Override
    public void setRequired(boolean isRequired) {
        if (this.parentContainerCBX != null) {
            this.parentContainerCBX.setRequired(isRequired);
        }
        if (this.associatedContainerCBX != null) {
            this.associatedContainerCBX.setRequired(isRequired);
        }
        this.isRequired = isRequired;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        if (this.getCBX() != null) {
            this.getCBX().setState(state);
        }
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        return this.getCBX() != null ? this.getCBX().validateState() : UIValidatable.ErrorType.Valid;
    }
}

