/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.specify.ui.containers.ContainerTreePanel;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ContainerListPlugin
extends UIPluginBase
implements ChangeListener {
    private static final Logger log = Logger.getLogger(ContainerListPlugin.class);
    protected ContainerTreePanel treePanel;

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        this.treePanel = new ContainerTreePanel(this, false, null, null);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"), (JPanel)this);
        pb.add((Component)this.treePanel, cc.xy(1, 1));
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        Container container;
        super.setValue(value, defaultValue);
        if (value instanceof Container && (container = (Container)value).getId() == null) {
            final Thread waitThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Here1");
                    try {
                        Thread.sleep(500L);
                        System.out.println("Here2");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("Here3");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ContainerListPlugin.this.chooseContainer();
                        }
                    });
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    waitThread.start();
                }
            });
        }
    }

    private void chooseContainer() {
        ViewBasedSearchDialogIFace srchDlg = UIRegistry.getViewbasedFactory().createSearchDialog(null, "ContainerSearch");
        if (srchDlg != null) {
            Container container;
            srchDlg.setTitle(this.title);
            srchDlg.getDialog().setVisible(true);
            if (!srchDlg.isCancelled() && (container = (Container)srchDlg.getSelectedObject()) != null) {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        session.attach(container);
                        this.treePanel.set(container, null);
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
                        log.error((Object)ex);
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
        }
    }

    @Override
    public boolean isNotEmpty() {
        return false;
    }

    @Override
    public void setParent(FormViewObj parent) {
        super.setParent(parent);
        if (parent != null) {
            this.fvo.getRsController().getPanel().setVisible(false);
            this.fvo.getMVParent().getSeparator().setVisible(false);
            if (parent.getSaveComponent() != null) {
                parent.getSaveComponent().setVisible(false);
            }
        }
        this.treePanel.setFVO(parent);
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"collectionObject"};
    }

    @Override
    public void shutdown() {
        this.treePanel.cleanUp();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ChangeEvent ce = e;
        if (ce == null) {
            ce = new ChangeEvent(this);
        }
        this.notifyChangeListeners(e);
    }
}

