/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigCache;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.db.TextFieldWithInfo;
import edu.ku.brc.af.ui.db.ViewBasedSearchQueryBuilderIFace;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.CollectionRelationship;
import edu.ku.brc.specify.datamodel.busrules.TableSearchResults;
import edu.ku.brc.specify.plugins.CollectionRelOneToManyPlugin;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;

public class CollectionRelPlugin
extends UIPluginBase
implements UIValidatable {
    private static final String CATNUM_NAME = "catalogNumber";
    private static final String CATNUM_NAMECAP = "CatalogNumber";
    private static final String COLOBJ_NAME = "CollectionObject";
    private boolean isLeftSide = true;
    private boolean isRightOverride = false;
    private CollectionRelType colRelType = null;
    private Collection leftSideCol = null;
    private Collection rightSideCol = null;
    private CollectionObject currentColObj = null;
    private CollectionRelationship collectionRel = null;
    private CollectionObject otherSideColObj = null;
    private ValComboBoxFromQuery cbx = null;
    private TextFieldWithInfo textWithInfo = null;
    private boolean isRequired = false;
    private UIFieldFormatterIFace catNumFormatter = null;

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        String relName = propertiesArg.getProperty("relname");
        String rightSide = propertiesArg.getProperty("rightside");
        boolean bl = this.isRightOverride = StringUtils.isNotEmpty((String)rightSide) && rightSide.equalsIgnoreCase("true");
        if (StringUtils.isNotEmpty((String)relName)) {
            block14: {
                DataProviderSessionIFace tmpSession = null;
                try {
                    try {
                        tmpSession = DataProviderFactory.getInstance().createSession();
                        this.colRelType = tmpSession.getData(CollectionRelType.class, "name", relName, DataProviderSessionIFace.CompareType.Equals);
                        if (this.colRelType != null) {
                            this.leftSideCol = this.colRelType.getLeftSideCollection();
                            this.rightSideCol = this.colRelType.getRightSideCollection();
                            this.rightSideCol.getCollectionId();
                            this.leftSideCol.getCollectionId();
                            Collection currCollection = AppContextMgr.getInstance().getClassObject(Collection.class);
                            this.isLeftSide = currCollection.getId().equals(this.leftSideCol.getId());
                            if (this.isLeftSide && this.isRightOverride) {
                                this.isLeftSide = false;
                            }
                            this.catNumFormatter = CollectionRelOneToManyPlugin.getCatNumFormatter(this.leftSideCol, this.rightSideCol);
                        } else {
                            DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(CollectionRelationship.getClassTableId());
                            UIRegistry.showError(String.format("The %s name '%s' doesn't exist (defined in the form for the plugin).", ti.getTitle(), relName));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (tmpSession != null) {
                            tmpSession.close();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (tmpSession != null) {
                        tmpSession.close();
                    }
                    throw throwable;
                }
                if (tmpSession != null) {
                    tmpSession.close();
                }
            }
            DBTableInfo coTI = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId());
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("MAX(p;40px)", "p"), (JPanel)this);
            if (isViewModeArg || !this.isLeftSide) {
                this.textWithInfo = new TextFieldWithInfo(coTI.getClassName(), CATNUM_NAME, CATNUM_NAME, null, CATNUM_NAMECAP, COLOBJ_NAME, COLOBJ_NAME, "");
                pb.add((Component)this.textWithInfo, cc.xy(1, 1));
                ViewFactory.changeTextFieldUIForDisplay(this.textWithInfo.getTextField(), false);
            } else {
                int btnOpts = 20;
                this.cbx = new ValComboBoxFromQuery(coTI, CATNUM_NAME, CATNUM_NAME, CATNUM_NAME, null, CATNUM_NAMECAP, COLOBJ_NAME, "", null, btnOpts);
                pb.add((Component)this.cbx, cc.xy(1, 1));
                this.cbx.setEnabled(this.colRelType != null);
                this.adjustSQLTemplate();
                this.cbx.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        CollectionRelPlugin.this.itemSelected();
                        CollectionRelPlugin.this.notifyChangeListeners(new ChangeEvent(CollectionRelPlugin.this));
                    }
                });
                this.cbx.registerQueryBuilder(CollectionRelPlugin.createSearchQueryBuilder(this.isLeftSide, this.leftSideCol, this.rightSideCol));
            }
        }
    }

    protected static ViewBasedSearchQueryBuilderIFace createSearchQueryBuilder(final boolean isLeftSide, final Collection leftSideCol, final Collection rightSideCol) {
        return new ViewBasedSearchQueryBuilderIFace(){

            @Override
            public String buildSQL(String searchText, boolean isForCount) {
                Collection collection = !isLeftSide ? leftSideCol : rightSideCol;
                String cols = isForCount ? "COUNT(*)" : "catalogNumber, collectionObjectId";
                String sql = String.format("SELECT %s FROM CollectionObject WHERE collectionMemberId = %d AND %s LIKE '%c%s%c' ORDER BY catalogNumber", cols, collection.getId(), CollectionRelPlugin.CATNUM_NAME, Character.valueOf('%'), searchText, Character.valueOf('%'));
                return sql;
            }

            @Override
            public String buildSQL(Map<String, Object> dataMap, List<String> fieldNames) {
                Collection collection = !isLeftSide ? leftSideCol : rightSideCol;
                String catNum = (String)dataMap.get(CollectionRelPlugin.CATNUM_NAMECAP);
                catNum = StringUtils.remove((String)catNum, (char)'#');
                String sql = String.format("SELECT CollectionObjectId, CatalogNumber FROM collectionobject WHERE CollectionMemberID = %d AND CatalogNumber LIKE '%c%s%c' ORDER BY catalogNumber", collection.getId(), Character.valueOf('%'), catNum, Character.valueOf('%'));
                return sql;
            }

            @Override
            public QueryForIdResultsIFace createQueryForIdResults() {
                ExpressResultsTableInfo esTblInfo = ExpressSearchConfigCache.getTableInfoByName("CollectionObjectSearch");
                return new TableSearchResults(DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId()), esTblInfo.getCaptionInfo());
            }
        };
    }

    public static List<CollectionRelationship> getCollectionRelationships() {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<CollectionRelationship> list = session.getDataList("FROM CollectionRelationship");
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return new ArrayList<CollectionRelationship>();
    }

    @Override
    public boolean isNotEmpty() {
        return this.cbx.isNotEmpty();
    }

    public static void removeFromCollectionRel(Set<CollectionRelationship> collectionRels, CollectionRelationship colRelToBeRemoved) {
        for (CollectionRelationship colRel : collectionRels) {
            if (colRel != colRelToBeRemoved && !colRel.getId().equals(colRelToBeRemoved.getId())) continue;
            collectionRels.remove(colRel);
            break;
        }
    }

    private void itemSelected() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollectionRelPlugin.this.itemSelectedInternal();
            }
        });
    }

    public static String isColObjAlreadyUsedInDB(int colRelId, String dstCatNum) {
        String sql = "SELECT src.CatalogNumber FROM collectionobject AS src Left Join collectionrelationship AS cr ON src.CollectionObjectID = cr.LeftSideCollectionID Left Join collectionobject AS dst ON cr.RightSideCollectionID = dst.CollectionObjectID WHERE cr.CollectionRelTypeID = %d AND dst.CatalogNumber = '%s'";
        sql = String.format(sql, colRelId, dstCatNum);
        System.out.println("[" + BasicSQLUtils.querySingleObj(sql) + "] " + sql);
        return (String)BasicSQLUtils.querySingleObj(sql);
    }

    public static boolean isColObjAlreadyUsed(int colRelId, final int dstId, final String dstCatNum, final UIFieldFormatterIFace catNumFormatter) {
        final String catNum = CollectionRelPlugin.isColObjAlreadyUsedInDB(colRelId, dstCatNum);
        if (catNum != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String otherCatNum = dstCatNum;
                    if (StringUtils.isNotEmpty((String)otherCatNum)) {
                        UIFieldFormatterIFace fmt = CollectionRelOneToManyPlugin.getCatNumFormatter(dstId);
                        otherCatNum = fmt != null ? (String)fmt.formatToUI(otherCatNum) : otherCatNum;
                    }
                    UIRegistry.showLocalizedError("COLREL_USED_CO", otherCatNum, catNumFormatter.formatToUI(catNum));
                }
            });
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void itemSelectedInternal() {
        CollectionObject newOtherSide = (CollectionObject)this.cbx.getValue();
        if (newOtherSide != null) {
            if (CollectionRelPlugin.isColObjAlreadyUsed(this.colRelType.getId(), this.rightSideCol.getId(), newOtherSide.getCatalogNumber(), this.catNumFormatter)) {
                this.cbx.setValue(null, null);
                return;
            }
            DataProviderSessionIFace tmpSession = null;
            try {
                try {
                    tmpSession = DataProviderFactory.getInstance().createSession();
                    tmpSession.attach(newOtherSide);
                    if (this.collectionRel == null && this.colRelType != null) {
                        this.collectionRel = new CollectionRelationship();
                        this.collectionRel.initialize();
                        this.collectionRel.setCollectionRelType(this.colRelType);
                    }
                    if (this.otherSideColObj != null && !newOtherSide.getId().equals(this.otherSideColObj.getId())) {
                        if (this.isLeftSide) {
                            this.collectionRel.setRightSide(null);
                        } else {
                            this.collectionRel.setLeftSide(null);
                        }
                    }
                    this.otherSideColObj = newOtherSide;
                    if (this.isLeftSide) {
                        this.collectionRel.setLeftSide(this.currentColObj);
                        this.collectionRel.setRightSide(this.otherSideColObj);
                        if (this.currentColObj.getLeftSideRels().contains(this.collectionRel)) return;
                        this.currentColObj.getLeftSideRels().add(this.collectionRel);
                        this.otherSideColObj.getRightSideRels().add(this.collectionRel);
                        return;
                    }
                    this.collectionRel.setLeftSide(this.otherSideColObj);
                    this.collectionRel.setRightSide(this.currentColObj);
                    if (this.currentColObj.getLeftSideRels().contains(this.collectionRel)) return;
                    this.otherSideColObj.getLeftSideRels().add(this.collectionRel);
                    this.currentColObj.getRightSideRels().add(this.collectionRel);
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (tmpSession == null) return;
                    tmpSession.close();
                }
                return;
            }
            finally {
                if (tmpSession != null) {
                    tmpSession.close();
                }
            }
        }
        if (this.dataObj == null || this.otherSideColObj == null) return;
        DataProviderSessionIFace tmpSession = null;
        try {
            try {
                tmpSession = DataProviderFactory.getInstance().createSession();
                this.otherSideColObj = tmpSession.merge(this.otherSideColObj);
                if (this.isLeftSide) {
                    CollectionRelPlugin.removeFromCollectionRel(this.currentColObj.getLeftSideRels(), this.collectionRel);
                    CollectionRelPlugin.removeFromCollectionRel(this.otherSideColObj.getRightSideRels(), this.collectionRel);
                } else {
                    CollectionRelPlugin.removeFromCollectionRel(this.currentColObj.getRightSideRels(), this.collectionRel);
                    CollectionRelPlugin.removeFromCollectionRel(this.otherSideColObj.getLeftSideRels(), this.collectionRel);
                }
                this.collectionRel.setRightSide(null);
                this.collectionRel.setLeftSide(null);
                if (this.collectionRel.getId() == null || this.fvo == null) return;
                this.fvo.getMVParent().getTopLevel().addDeletedItem(this.collectionRel);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (tmpSession == null) return;
                tmpSession.close();
            }
            return;
        }
        finally {
            if (tmpSession != null) {
                tmpSession.close();
            }
        }
    }

    private void adjustSQLTemplate() {
        if (this.colRelType != null && (!this.isLeftSide && this.rightSideCol != null || this.isLeftSide && this.leftSideCol != null)) {
            StringBuilder sql = new StringBuilder("SELECT %s1 FROM CollectionObject co ");
            sql.append("WHERE co.collectionMemberId = ");
            sql.append(this.isLeftSide ? this.rightSideCol.getCollectionId() : this.leftSideCol.getCollectionId());
            sql.append(" AND %s2");
            this.cbx.setSqlTemplate(sql.toString());
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        super.setValue(value, defaultValue);
        if (value instanceof CollectionObject && this.colRelType != null) {
            this.currentColObj = (CollectionObject)value;
            if (this.currentColObj.getId() != null) {
                System.out.println("Left: " + this.currentColObj.getLeftSideRels().size());
                System.out.println("Left: " + this.currentColObj.getRightSideRels().size());
            }
            this.otherSideColObj = null;
            boolean leftSide = this.currentColObj.getCollection().getId().equals(this.leftSideCol.getId());
            if (leftSide && this.isRightOverride) {
                leftSide = false;
            }
            Set<CollectionRelationship> collectionRels = leftSide ? this.currentColObj.getLeftSideRels() : this.currentColObj.getRightSideRels();
            for (CollectionRelationship colRel : collectionRels) {
                if (!colRel.getCollectionRelType().getId().equals(this.colRelType.getId())) continue;
                this.collectionRel = colRel;
                this.otherSideColObj = leftSide ? colRel.getRightSide() : colRel.getLeftSide();
                this.otherSideColObj.getLeftSideRels().size();
                this.otherSideColObj.getRightSideRels().size();
                break;
            }
            if (this.cbx != null) {
                this.cbx.setValue(this.otherSideColObj, null);
            } else {
                this.textWithInfo.setValue(this.otherSideColObj, null);
            }
        } else {
            this.currentColObj = null;
        }
    }

    @Override
    public Object getValue() {
        return this.cbx != null ? this.cbx.getValue() : super.getValue();
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{CATNUM_NAME, "rightSide", "leftSide"};
    }

    @Override
    public void cleanUp() {
        if (this.cbx != null) {
            this.cbx.cleanUp();
        }
    }

    @Override
    public String getReason() {
        return this.cbx != null ? this.cbx.getReason() : null;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.cbx != null ? this.cbx.getState() : UIValidatable.ErrorType.Valid;
    }

    @Override
    public Component getValidatableUIComp() {
        return this.cbx;
    }

    @Override
    public boolean isChanged() {
        return this.cbx != null ? this.cbx.isChanged() : false;
    }

    @Override
    public boolean isInError() {
        return this.cbx != null ? this.cbx.isInError() : false;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void reset() {
        if (this.cbx != null) {
            this.cbx.reset();
        }
    }

    @Override
    public void setAsNew(boolean isNew) {
        if (this.cbx != null) {
            this.cbx.setAsNew(isNew);
        }
    }

    @Override
    public void setChanged(boolean isChanged) {
        if (this.cbx != null) {
            this.cbx.setChanged(isChanged);
        }
    }

    @Override
    public void setRequired(boolean isRequired) {
        if (this.cbx != null) {
            this.cbx.setRequired(isRequired);
        }
        this.isRequired = isRequired;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        if (this.cbx != null) {
            this.cbx.setState(state);
        }
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        return this.cbx != null ? this.cbx.validateState() : UIValidatable.ErrorType.Valid;
    }
}

