/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.ViewBasedDialogFactoryIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.CollectionRelationship;
import edu.ku.brc.specify.plugins.CollectionRelPlugin;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CollectionRelOneToManyPlugin
extends UIPluginBase
implements UIValidatable {
    protected static final Logger log = Logger.getLogger(CollectionRelOneToManyPlugin.class);
    private static final HashMap<Integer, UIFieldFormatterIFace> catNumFmtHash = new HashMap();
    private String[] headers;
    private boolean isLeftSide = true;
    private CollectionRelType colRelType = null;
    private Collection leftSideCol = null;
    private Collection rightSideCol = null;
    private UIFieldFormatterIFace catNumFormatter = null;
    private CollectionObject currentColObj = null;
    private boolean isRequired = false;
    private boolean isChanged = false;
    private JTable table;
    private ColObjDataModel model;
    private Vector<CollectionRelationship> colObjs = new Vector();
    private JButton searchAddBtn;
    private JButton removeBtn;
    private JButton infoBtn;

    public CollectionRelOneToManyPlugin() {
        DBTableInfo coTI = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId());
        DBTableInfo collTI = DBTableIdMgr.getInstance().getInfoById(Collection.getClassTableId());
        this.headers = new String[]{coTI.getTitle(), collTI.getTitle()};
    }

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        String relName = propertiesArg.getProperty("relname");
        if (StringUtils.isNotEmpty((String)relName)) {
            block13: {
                DataProviderSessionIFace tmpSession = null;
                try {
                    try {
                        tmpSession = DataProviderFactory.getInstance().createSession();
                        this.colRelType = tmpSession.getData(CollectionRelType.class, "name", relName, DataProviderSessionIFace.CompareType.Equals);
                        if (this.colRelType != null) {
                            this.leftSideCol = this.colRelType.getLeftSideCollection();
                            this.rightSideCol = this.colRelType.getRightSideCollection();
                            this.rightSideCol.getCollectionId();
                            this.leftSideCol.getCollectionId();
                            this.catNumFormatter = CollectionRelOneToManyPlugin.getCatNumFormatter(this.leftSideCol, this.rightSideCol);
                            Collection currCollection = AppContextMgr.getInstance().getClassObject(Collection.class);
                            this.isLeftSide = currCollection.getId().equals(this.leftSideCol.getId());
                        } else {
                            DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(CollectionRelationship.getClassTableId());
                            UIRegistry.showError(String.format("The %s name '%s' doesn't exist (defined in the form for the plugin).", ti.getTitle(), relName));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (tmpSession != null) {
                            tmpSession.close();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (tmpSession != null) {
                        tmpSession.close();
                    }
                    throw throwable;
                }
                if (tmpSession != null) {
                    tmpSession.close();
                }
            }
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,2px,p", "f:p:g"), (JPanel)this);
            this.model = new ColObjDataModel();
            this.table = new JTable(this.model);
            JScrollPane sp = UIHelper.createScrollPane(this.table, false);
            pb.add((Component)sp, cc.xy(1, 1));
            this.searchAddBtn = UIHelper.createIconBtn("SearchAdd", IconManager.IconSize.Std20, "", true, this.createSearchAL());
            this.removeBtn = UIHelper.createIconBtn("Eraser", IconManager.IconSize.NonStd, "", true, this.createRemoveAL());
            this.infoBtn = UIHelper.createIconBtn("InfoIcon", IconManager.IconSize.Std20, "", true, this.createInfoAL());
            PanelBuilder rpb = new PanelBuilder(new FormLayout("f:p:g", "p,4px,p,4px,p, f:p:g"));
            int y = 1;
            rpb.add((Component)this.infoBtn, cc.xy(1, y));
            y += 2;
            if (!this.isViewMode) {
                rpb.add((Component)this.searchAddBtn, cc.xy(1, y));
                rpb.add((Component)this.removeBtn, cc.xy(1, y += 2));
                y += 2;
            }
            pb.add((Component)rpb.getPanel(), cc.xy(3, 1));
            UIHelper.makeTableHeadersCentered(this.table, true);
            UIHelper.setVisibleRowCount(this.table, 5);
            this.table.setSelectionMode(0);
            this.table.setCellSelectionEnabled(false);
            this.table.setColumnSelectionAllowed(false);
            this.table.setRowSelectionAllowed(true);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CollectionRelOneToManyPlugin.this.updateBtns();
                }
            });
            this.updateBtns();
        } else {
            System.err.println(propertiesArg);
            log.error((Object)"CollectionRelOneToManyPlugin - initialize attribute for 'relname' is null and can't be!");
        }
    }

    private void updateBtns() {
        int rowInx = this.table.getSelectedRow();
        boolean selected = rowInx > -1;
        this.infoBtn.setEnabled(selected);
        this.removeBtn.setEnabled(selected);
        this.searchAddBtn.setEnabled(true);
    }

    private ActionListener createInfoAL() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionRelOneToManyPlugin.this.showCollectionObject();
            }
        };
    }

    private ActionListener createRemoveAL() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionRelOneToManyPlugin.this.removeCollectionObject();
            }
        };
    }

    private ActionListener createSearchAL() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionRelOneToManyPlugin.this.showSearch();
            }
        };
    }

    private void showSearch() {
        ViewBasedSearchDialogIFace srchDlg = UIRegistry.getViewbasedFactory().createSearchDialog(null, "CollectionObjectSearch");
        if (srchDlg != null) {
            CollectionObject colObj;
            srchDlg.registerQueryBuilder(CollectionRelPlugin.createSearchQueryBuilder(this.isLeftSide, this.leftSideCol, this.rightSideCol));
            srchDlg.setTitle(DBTableIdMgr.getInstance().getTitleForId(CollectionObject.getClassTableId()));
            srchDlg.getDialog().setVisible(true);
            if (!srchDlg.isCancelled() && (colObj = (CollectionObject)srchDlg.getSelectedObject()) != null) {
                if (CollectionRelPlugin.isColObjAlreadyUsed(this.colRelType.getId(), this.rightSideCol.getId(), colObj.getCatalogNumber(), this.catNumFormatter)) {
                    return;
                }
                if (!this.existsInCollectionRel(this.currentColObj.getLeftSideRels(), colObj)) {
                    block12: {
                        CollectionRelationship collectionRel = new CollectionRelationship();
                        collectionRel.initialize();
                        collectionRel.setCollectionRelType(this.colRelType);
                        collectionRel.setLeftSide(this.currentColObj);
                        collectionRel.setRightSide(colObj);
                        this.currentColObj.getLeftSideRels().add(collectionRel);
                        this.colObjs.add(collectionRel);
                        DataProviderSessionIFace tmpSession = null;
                        try {
                            try {
                                tmpSession = DataProviderFactory.getInstance().createSession();
                                tmpSession.attach(colObj);
                                colObj.getCollection().getId();
                                colObj.getRightSideRels().add(collectionRel);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                if (tmpSession != null) {
                                    tmpSession.close();
                                }
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            if (tmpSession != null) {
                                tmpSession.close();
                            }
                            throw throwable;
                        }
                        if (tmpSession != null) {
                            tmpSession.close();
                        }
                    }
                    this.model.fireTableDataChanged();
                    this.notifyChangeListeners(new ChangeEvent(this));
                }
            }
        }
    }

    private void removeCollectionObject() {
        CollectionRelationship colRel;
        int rowInx = this.table.getSelectedRow();
        if (rowInx > -1 && (colRel = this.colObjs.get(rowInx)) != null) {
            CollectionRelPlugin.removeFromCollectionRel(this.currentColObj.getLeftSideRels(), colRel);
            if (colRel.getId() != null) {
                colRel.setLeftSide(null);
                colRel.setRightSide(null);
                this.fvo.getMVParent().getTopLevel().addDeletedItem(colRel);
            }
            this.colObjs.remove(rowInx);
            this.model.fireTableDataChanged();
            this.notifyChangeListeners(new ChangeEvent(this));
        }
    }

    private boolean existsInCollectionRel(Set<CollectionRelationship> collectionRels, CollectionObject colObj) {
        for (CollectionRelationship colRel : collectionRels) {
            if (!colRel.getRightSide().getId().equals(colObj.getId())) continue;
            return true;
        }
        return false;
    }

    private void showCollectionObject() {
        int rowInx = this.table.getSelectedRow();
        if (rowInx > -1) {
            int options = 1024;
            ViewBasedDisplayIFace dlg = UIRegistry.getViewbasedFactory().createDisplay(UIRegistry.getTopWindow(), "CollectionObject", DBTableIdMgr.getInstance().getTitleForId(CollectionObject.getClassTableId()), UIRegistry.getResourceString("CLOSE"), false, options, null, ViewBasedDialogFactoryIFace.FRAME_TYPE.DIALOG);
            CollectionRelationship colRel = this.colObjs.get(rowInx);
            boolean leftSide = this.currentColObj.getCollection().getId().equals(this.leftSideCol.getId());
            CollectionObject colObj = leftSide ? colRel.getRightSide() : colRel.getLeftSide();
            dlg.setData(colObj);
            dlg.showDisplay(true);
        }
    }

    public static UIFieldFormatterIFace getCatNumFormatter(Integer id) {
        if (id != null) {
            return catNumFmtHash.get(id);
        }
        return null;
    }

    public static UIFieldFormatterIFace getCatNumFormatter(Collection leftSideCol, Collection rightSideCol) {
        UIFieldFormatterIFace catNumFormatter;
        if (catNumFmtHash.get(leftSideCol.getId()) == null) {
            catNumFmtHash.put(leftSideCol.getId(), UIFieldFormatterMgr.getInstance().getFormatter(leftSideCol.getCatalogNumFormatName()));
        }
        if ((catNumFormatter = catNumFmtHash.get(rightSideCol.getId())) == null) {
            catNumFmtHash.put(rightSideCol.getId(), UIFieldFormatterMgr.getInstance().getFormatter(leftSideCol.getCatalogNumFormatName()));
        }
        return catNumFormatter;
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        super.setValue(value, defaultValue);
        if (this.leftSideCol != null) {
            if (value != null) {
                this.currentColObj = (CollectionObject)value;
                boolean leftSide = this.currentColObj.getCollection().getId().equals(this.leftSideCol.getId());
                this.model.setLeft(leftSide);
                Set<CollectionRelationship> collectionRels = leftSide ? this.currentColObj.getLeftSideRels() : this.currentColObj.getRightSideRels();
                for (CollectionRelationship cr : collectionRels) {
                    cr.getLeftSide().getCollection().getCollectionName();
                    cr.getRightSide().getCollection().getCollectionName();
                }
                this.currentColObj.getLeftSideRels().size();
                this.currentColObj.getRightSideRels().size();
                this.colObjs.clear();
                this.colObjs.addAll(collectionRels);
                this.model.fireTableDataChanged();
            }
        } else {
            log.error((Object)"CollectionRelOneToManyPlugin - leftSide collection is null and it can't be!");
        }
    }

    @Override
    public boolean isNotEmpty() {
        return this.colObjs.size() > 0;
    }

    @Override
    public void cleanUp() {
        this.colObjs.clear();
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return UIValidatable.ErrorType.Valid;
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public boolean isInError() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void reset() {
        this.isChanged = false;
    }

    @Override
    public void setAsNew(boolean isNew) {
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        return UIValidatable.ErrorType.Valid;
    }

    @Override
    public String[] getFieldNames() {
        return new String[]{"rightSideColRels"};
    }

    class ColObjDataModel
    extends DefaultTableModel {
        boolean isLeft = true;

        @Override
        public Object getValueAt(int row, int column) {
            String valueStr = "N/A";
            CollectionRelationship colRel = (CollectionRelationship)CollectionRelOneToManyPlugin.this.colObjs.get(row);
            if (colRel != null) {
                CollectionObject colObj;
                CollectionObject collectionObject = colObj = this.isLeft ? colRel.getRightSide() : colRel.getLeftSide();
                if (colObj != null) {
                    if (column == 0) {
                        valueStr = colObj.getCatalogNumber();
                        if (CollectionRelOneToManyPlugin.this.catNumFormatter != null) {
                            valueStr = (String)CollectionRelOneToManyPlugin.this.catNumFormatter.formatToUI(valueStr);
                        }
                    } else if (column == 1) {
                        valueStr = colObj.getCollection().getCollectionName();
                    }
                }
            }
            return valueStr;
        }

        @Override
        public int getColumnCount() {
            return CollectionRelOneToManyPlugin.this.headers.length;
        }

        @Override
        public String getColumnName(int column) {
            return CollectionRelOneToManyPlugin.this.headers[column];
        }

        @Override
        public int getRowCount() {
            return CollectionRelOneToManyPlugin.this.colObjs.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean isLeft() {
            return this.isLeft;
        }

        public void setLeft(boolean isLeft) {
            this.isLeft = isLeft;
        }
    }
}

