/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.extras;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.SearchBox;
import edu.ku.brc.af.ui.db.JAutoCompTextField;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellPanelIFace;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.FormRow;
import edu.ku.brc.af.ui.forms.persist.FormRowIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.ui.BiColorBooleanTableCellRenderer;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.lang.StringUtils;

public class ViewToSchemaReview {
    protected Vector<Object[]> modelList = new Vector();
    protected Hashtable<String, String> tblTitle2Name = new Hashtable();
    protected TableRowSorter<TableModel> sorter = null;
    protected JAutoCompTextField searchTF = null;
    protected ViewModel viewModel;
    protected JComboBox filterCBX = null;
    protected boolean blockCBXUpdate = false;

    public static void checkViews() {
        SpecifyAppContextMgr sacm = (SpecifyAppContextMgr)AppContextMgr.getInstance();
        for (ViewIFace view : sacm.getEntirelyAllViews()) {
            System.err.println(String.valueOf(view.getName()) + " ----------------------");
            for (AltViewIFace av : view.getAltViews()) {
                DBTableInfo ti;
                ViewDefIFace vd = av.getViewDef();
                if (vd.getType() != ViewDefIFace.ViewType.form || (ti = DBTableIdMgr.getInstance().getByClassName(vd.getClassName())) == null) continue;
                FormViewDef fvd = (FormViewDef)vd;
                for (FormRowIFace row : fvd.getRows()) {
                    for (FormCellIFace cell : row.getCells()) {
                        DBRelationshipInfo ri;
                        DBFieldInfo fi;
                        if (cell.getType() != FormCellIFace.CellType.field && cell.getType() != FormCellIFace.CellType.subview) continue;
                        String fieldName = cell.getName();
                        if (cell.isIgnoreSetGet() || fieldName.equals("this") || (fi = ti.getFieldByName(fieldName)) != null || (ri = ti.getRelationshipByName(fieldName)) != null) continue;
                        System.err.println("Form Field[" + fieldName + "] not in table.");
                    }
                }
            }
        }
    }

    private Object[] createRow(String tblName, String fldName, String fldTitle, Boolean isOnForm, Boolean isHidden, Integer index) {
        Object[] row = new Object[]{new TableInfo(tblName, this.modelList.size()), fldName, new Pair<String, Integer>(fldTitle, this.modelList.size()), isOnForm, isHidden, isHidden, index};
        return row;
    }

    protected void checkPluginForNames(FormCellFieldIFace cellField, String pluginName, HashSet<String> fieldsHash) {
        Class<?> pluginClass = TaskMgr.getUIPluginClassForName(pluginName);
        if (pluginClass != null && UIPluginable.class.isAssignableFrom(pluginClass)) {
            try {
                UIPluginable uiPlugin = pluginClass.asSubclass(UIPluginable.class).newInstance();
                if (uiPlugin != null) {
                    String[] stringArray = uiPlugin.getFieldNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fieldName = stringArray[n2];
                        fieldsHash.add(fieldName);
                        ++n2;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                FormDevHelper.appendFormDevError(ex);
            }
        }
    }

    public void checkSchemaAndViews() {
        Hashtable<String, HashSet<String>> viewFieldHash = new Hashtable<String, HashSet<String>>();
        SpecifyAppContextMgr sacm = (SpecifyAppContextMgr)AppContextMgr.getInstance();
        for (ViewIFace view : sacm.getEntirelyAllViews()) {
            for (AltViewIFace av : view.getAltViews()) {
                Iterator<DBRelationshipInfo> ti;
                ViewDefIFace vd = av.getViewDef();
                if (vd.getType() != ViewDefIFace.ViewType.form || (ti = DBTableIdMgr.getInstance().getByClassName(vd.getClassName())) == null) continue;
                HashSet<String> tiHash = (HashSet<String>)viewFieldHash.get(((DBInfoBase)((Object)ti)).getName());
                if (tiHash == null) {
                    tiHash = new HashSet<String>();
                    viewFieldHash.put(((DBInfoBase)((Object)ti)).getName(), tiHash);
                }
                FormViewDef fvd = (FormViewDef)vd;
                for (FormRowIFace row : fvd.getRows()) {
                    for (FormCellIFace cell : row.getCells()) {
                        String pluginName;
                        FormCellFieldIFace fcf;
                        if (cell.getType() == FormCellIFace.CellType.panel) {
                            FormCellPanelIFace panelCell = (FormCellPanelIFace)cell;
                            String[] stringArray = panelCell.getFieldNames();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String fieldName = stringArray[n2];
                                tiHash.add(fieldName);
                                ++n2;
                            }
                            continue;
                        }
                        if (cell.getType() != FormCellIFace.CellType.field && cell.getType() != FormCellIFace.CellType.subview) continue;
                        String fieldName = cell.getName();
                        if (!cell.isIgnoreSetGet() && !fieldName.equals("this")) {
                            DBFieldInfo fi = ((DBTableInfo)((Object)ti)).getFieldByName(fieldName);
                            if (fi != null) {
                                tiHash.add(fieldName);
                                continue;
                            }
                            DBRelationshipInfo ri = ((DBTableInfo)((Object)ti)).getRelationshipByName(fieldName);
                            if (ri == null) continue;
                            tiHash.add(fieldName);
                            continue;
                        }
                        if (!(cell instanceof FormCellFieldIFace) || (fcf = (FormCellFieldIFace)cell).getUiType() != FormCellFieldIFace.FieldType.plugin || !StringUtils.isNotEmpty((String)(pluginName = fcf.getProperty("name")))) continue;
                        this.checkPluginForNames(fcf, pluginName, tiHash);
                    }
                }
            }
        }
        for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
            Boolean isInForm;
            int cnt = 0;
            HashSet tiHash = (HashSet)viewFieldHash.get(ti.getName());
            if (tiHash == null) continue;
            this.tblTitle2Name.put(ti.getTitle(), ti.getName());
            for (DBFieldInfo fi : ti.getFields()) {
                isInForm = tiHash.contains(fi.getName());
                this.modelList.add(this.createRow(ti.getTitle(), fi.getName(), fi.getTitle(), isInForm, fi.isHidden(), cnt++));
            }
            for (DBRelationshipInfo ri : ti.getRelationships()) {
                isInForm = tiHash.contains(ri.getName());
                this.modelList.add(this.createRow(ti.getTitle(), ri.getName(), ri.getTitle(), isInForm, ri.isHidden(), cnt++));
            }
        }
        this.viewModel = new ViewModel();
        JTable table = new JTable(this.viewModel);
        this.sorter = new TableRowSorter<ViewModel>(this.viewModel);
        this.searchTF = new JAutoCompTextField(20);
        table.setRowSorter(this.sorter);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,4px,f:p:g,2px,p:g"));
        SearchBox searchBox = new SearchBox(this.searchTF, null);
        this.filterCBX = UIHelper.createComboBox(new String[]{"None", "Not On Form, Not Hidden", "On Form, Hidden"});
        PanelBuilder searchPB = new PanelBuilder(new FormLayout("p,2px,p, f:p:g, p,2px,p", "p"));
        searchPB.add((Component)UIHelper.createI18NFormLabel("SEARCH"), cc.xy(1, 1));
        searchPB.add((Component)searchBox, cc.xy(3, 1));
        searchPB.add((Component)UIHelper.createI18NFormLabel("Filter"), cc.xy(5, 1));
        searchPB.add((Component)this.filterCBX, cc.xy(7, 1));
        JLabel legend = UIHelper.createLabel("<HTML><li><font color=\"red\">Red</font> - Not on form and not hidden</li><li><font color=\"magenta\">Magenta</font> - On the form , but is hidden</li><li>Black - Correct</li>");
        legend.setBorder(BorderFactory.createEtchedBorder(1));
        PanelBuilder legPB = new PanelBuilder(new FormLayout("p,f:p:g", "p"));
        legPB.add((Component)legend, cc.xy(1, 1));
        pb.add((Component)searchPB.getPanel(), cc.xy(1, 1));
        pb.add((Component)UIHelper.createScrollPane(table), cc.xy(1, 3));
        pb.add((Component)legPB.getPanel(), cc.xy(1, 5));
        pb.setDefaultDialogBorder();
        this.sorter.setRowFilter(null);
        this.searchTF.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ViewToSchemaReview.this.filterCBX.getSelectedIndex() > 0) {
                            (this).ViewToSchemaReview.this.blockCBXUpdate = true;
                            (this).ViewToSchemaReview.this.filterCBX.setSelectedIndex(-1);
                            (this).ViewToSchemaReview.this.blockCBXUpdate = false;
                        }
                        String text = (this).ViewToSchemaReview.this.searchTF.getText();
                        (this).ViewToSchemaReview.this.sorter.setRowFilter(text.isEmpty() ? null : RowFilter.regexFilter("^(?i)" + text, 0, 1));
                    }
                });
            }
        });
        this.filterCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).ViewToSchemaReview.this.blockCBXUpdate) {
                            RowFilter filter = null;
                            int inx = (this).ViewToSchemaReview.this.filterCBX.getSelectedIndex();
                            if (inx > 0) {
                                filter = (this).ViewToSchemaReview.this.filterCBX.getSelectedIndex() == 1 ? new NotOnFormNotHiddenRowFilter() : new OnFormIsHiddenRowFilter();
                            }
                            (this).ViewToSchemaReview.this.sorter.setRowFilter(filter);
                        }
                    }
                });
            }
        });
        table.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
        table.setDefaultRenderer(Boolean.class, new BiColorBooleanTableCellRenderer());
        table.getColumnModel().getColumn(0).setCellRenderer(new TitleCellFadeRenderer());
        table.getColumnModel().getColumn(3).setCellRenderer(new BiColorTableCellRenderer(true));
        table.getColumnModel().getColumn(2).setCellRenderer(new BiColorTableCellRenderer(false){

            @Override
            public Component getTableCellRendererComponent(JTable tableArg, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(tableArg, value, isSelected, hasFocus, row, column);
                if (value instanceof TableInfo) {
                    TableInfo pair = (TableInfo)value;
                    Object[] rowData = ViewToSchemaReview.this.modelList.get((Integer)pair.getSecond());
                    lbl.setText(rowData[0].toString());
                } else if (value instanceof Pair) {
                    boolean isHidden;
                    Pair pair = (Pair)value;
                    Object[] rowData = ViewToSchemaReview.this.modelList.get((Integer)pair.getSecond());
                    boolean isOnForm = rowData[3] instanceof Boolean ? ((Boolean)rowData[3]).booleanValue() : ((String)rowData[3]).equals("Yes");
                    boolean bl = isHidden = rowData[4] instanceof Boolean ? ((Boolean)rowData[4]).booleanValue() : ((String)rowData[4]).equals("true");
                    if (!isOnForm && !isHidden) {
                        lbl.setForeground(Color.RED);
                    } else if (isOnForm && isHidden) {
                        lbl.setForeground(Color.MAGENTA);
                    } else {
                        lbl.setForeground(Color.BLACK);
                    }
                    lbl.setText((String)pair.getFirst());
                } else {
                    lbl.setText(value.toString());
                }
                return lbl;
            }
        });
        UIHelper.calcColumnWidths(table, null);
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), "", true, 11, pb.getPanel()){

            @Override
            protected void applyButtonPressed() {
                ViewToSchemaReview.this.fix(this);
            }
        };
        dlg.setApplyLabel("Fix All");
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            this.updateSchema();
        }
    }

    protected void fix(final CustomDialog parentDlg) {
        final Vector<String> fixedNames = new Vector<String>();
        int fixCnt = 0;
        for (Object[] rowData : this.modelList) {
            boolean wasFixed = false;
            boolean isOnForm = (Boolean)rowData[3];
            boolean isHidden = (Boolean)rowData[4];
            if (!isOnForm && !isHidden) {
                rowData[4] = true;
                wasFixed = true;
            } else if (isOnForm && isHidden) {
                rowData[4] = false;
                wasFixed = true;
            }
            if (!wasFixed) continue;
            ++fixCnt;
            fixedNames.add(String.format("%s / %s", rowData[0], rowData[1]));
        }
        this.viewModel.fireTableRowsUpdated(0, this.modelList.size() - 1);
        final int fixCount = fixCnt;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,4px,f:p:g"));
                CellConstraints cc = new CellConstraints();
                JList list = new JList(fixedNames);
                pb.add((Component)UIHelper.createLabel(String.format("%d items fixed.", fixCount)), cc.xy(1, 1));
                pb.add((Component)UIHelper.createScrollPane(list), cc.xy(1, 3));
                pb.setDefaultDialogBorder();
                CustomDialog dlg = new CustomDialog(parentDlg, "Fixed Items", true, 1, (Component)pb.getPanel());
                UIHelper.centerAndShow(dlg);
            }
        });
    }

    public static void dumpFormFieldList(boolean doShowInBrowser) {
        block13: {
            List<ViewIFace> viewList = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getEntirelyAllViews();
            Hashtable<String, ViewIFace> hash = new Hashtable<String, ViewIFace>();
            for (ViewIFace view : viewList) {
                hash.put(view.getName(), view);
            }
            Vector names = new Vector(hash.keySet());
            Collections.sort(names);
            try {
                File file = new File("FormFields.html");
                PrintWriter pw = new PrintWriter(file);
                pw.println("<HTML><HEAD><TITLE>Form Fields</TITLE><link rel=\"stylesheet\" href=\"http://specify6.specifysoftware.org/schema/specify6.css\" type=\"text/css\"/></HEAD><BODY>");
                pw.println("<center>");
                pw.println("<H2>Forms and Fields</H2>");
                pw.println("<center><table class=\"brdr\" border=\"0\" cellspacing=\"0\">");
                int formCnt = 0;
                int fieldCnt = 0;
                for (String name : names) {
                    ViewIFace view = (ViewIFace)hash.get(name);
                    boolean hasEdit = false;
                    for (AltViewIFace altView : view.getAltViews()) {
                        if (altView.getMode() == AltViewIFace.CreationMode.EDIT) continue;
                        hasEdit = true;
                        break;
                    }
                    for (AltViewIFace altView : view.getAltViews()) {
                        ViewDefIFace vd;
                        if (!hasEdit || altView.getMode() != AltViewIFace.CreationMode.VIEW || !((vd = altView.getViewDef()) instanceof FormViewDef)) continue;
                        ++formCnt;
                        FormViewDef fvd = (FormViewDef)vd;
                        pw.println("<tr><td class=\"brdrodd\">");
                        pw.println(fvd.getName());
                        pw.println("</td></tr>");
                        int r = 1;
                        for (FormRowIFace fri : fvd.getRows()) {
                            FormRow fr = (FormRow)fri;
                            for (FormCellIFace cell : fr.getCells()) {
                                if (!StringUtils.isNotEmpty((String)cell.getName())) continue;
                                if (cell.getType() == FormCellIFace.CellType.panel) {
                                    FormCellPanelIFace panelCell = (FormCellPanelIFace)cell;
                                    String[] stringArray = panelCell.getFieldNames();
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String fieldName = stringArray[n2];
                                        pw.print("<tr><td ");
                                        pw.print("class=\"");
                                        pw.print(r % 2 == 0 ? "brdrodd" : "brdreven");
                                        pw.print("\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + fieldName);
                                        pw.println("</td></tr>");
                                        ++fieldCnt;
                                        ++n2;
                                    }
                                    continue;
                                }
                                if (cell.getType() != FormCellIFace.CellType.field && cell.getType() != FormCellIFace.CellType.subview) continue;
                                pw.print("<tr><td ");
                                pw.print("class=\"");
                                pw.print(r % 2 == 0 ? "brdrodd" : "brdreven");
                                pw.print("\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + cell.getName());
                                pw.println("</td></tr>");
                                ++fieldCnt;
                            }
                        }
                    }
                }
                pw.println("</table></center><br>");
                pw.println("Number of Forms: " + formCnt + "<br>");
                pw.println("Number of Fields: " + fieldCnt + "<br>");
                pw.println("</body></html>");
                pw.close();
                try {
                    if (doShowInBrowser) {
                        AttachmentUtils.openURI(file.toURI());
                        break block13;
                    }
                    JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString("FormDisplayer.OUTPUT"), file.getCanonicalFile()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void updateSchema() {
        Connection conn = DBConnection.getInstance().getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            for (Object[] row : this.modelList) {
                Boolean isChanged = !row[4].equals(row[5]);
                if (!isChanged.booleanValue()) continue;
                String fieldName = row[1].toString();
                Boolean isHidden = (Boolean)row[4];
                String title = row[0].toString();
                DBTableInfo ti = DBTableIdMgr.getInstance().getInfoByTableName(this.tblTitle2Name.get(title));
                DBFieldInfo fi = ti.getFieldByName(fieldName);
                if (fi != null) {
                    fi.setHidden(isHidden);
                } else {
                    DBRelationshipInfo ri = ti.getRelationshipByName(fieldName);
                    if (ri == null) continue;
                    ri.setHidden(isHidden);
                }
                Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
                String srchSQL = String.format("SELECT SpLocaleContainerID FROM splocalecontainer WHERE Name = '%s' AND DisciplineID = %d AND SchemaType = %d", ti.getName(), discipline.getId(), SpLocaleContainer.CORE_SCHEMA);
                Integer id = BasicSQLUtils.getCount(conn, srchSQL);
                if (id == null) continue;
                String sql = "UPDATE splocalecontaineritem SET IsHidden=" + isHidden.toString().toUpperCase() + " WHERE Name = '" + fieldName + "' AND SpLocaleContainerID = " + id;
                stmt.executeUpdate(sql);
            }
            stmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class NotOnFormNotHiddenRowFilter
    extends RowFilter<TableModel, Integer> {
        NotOnFormNotHiddenRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            Integer id = entry.getIdentifier();
            Object[] rowData = ViewToSchemaReview.this.modelList.get(id);
            boolean isOnForm = (Boolean)rowData[3];
            boolean isHidden = (Boolean)rowData[4];
            return !isOnForm && !isHidden;
        }
    }

    class OnFormIsHiddenRowFilter
    extends RowFilter<TableModel, Integer> {
        OnFormIsHiddenRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            Integer id = entry.getIdentifier();
            Object[] rowData = ViewToSchemaReview.this.modelList.get(id);
            boolean isOnForm = (Boolean)rowData[3];
            boolean isHidden = (Boolean)rowData[4];
            return isOnForm && isHidden;
        }
    }

    class TableInfo
    extends Pair<String, Integer> {
        public TableInfo() {
        }

        public TableInfo(String first, Integer second) {
            super(first, second);
        }

        @Override
        public String toString() {
            return (String)this.first;
        }
    }

    class TitleCellFadeRenderer
    extends BiColorTableCellRenderer {
        TitleCellFadeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof TableInfo) {
                TableInfo pair = (TableInfo)value;
                Integer inx = (Integer)pair.getSecond();
                Object[] rowData = ViewToSchemaReview.this.modelList.get(inx);
                String tableName = (String)((TableInfo)rowData[0]).first;
                if (inx > 0 && ViewToSchemaReview.this.sorter.getRowFilter() == null) {
                    String prevTableName = (String)((TableInfo)ViewToSchemaReview.this.modelList.get((int)(inx.intValue() - 1))[0]).first;
                    lbl.setForeground(prevTableName.equals(tableName) ? Color.LIGHT_GRAY : Color.BLACK);
                } else {
                    lbl.setForeground(Color.BLACK);
                }
                lbl.setText(tableName);
            } else {
                Object[] rowData = ViewToSchemaReview.this.modelList.get(row);
                if (row > 0) {
                    Object[] prevRowData = ViewToSchemaReview.this.modelList.get(row - 1);
                    lbl.setForeground(prevRowData[0].equals(rowData[0]) ? Color.LIGHT_GRAY : Color.BLACK);
                } else {
                    lbl.setForeground(Color.BLACK);
                }
                lbl.setText(rowData[0].toString());
            }
            return lbl;
        }
    }

    class ViewModel
    extends AbstractTableModel {
        protected String[] header = new String[]{"Table", "Field Name", "Field Title", "Is On Form", "Is Hidden"};

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 4 ? Boolean.class : String.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.header[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public int getRowCount() {
            return ViewToSchemaReview.this.modelList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object[] row = ViewToSchemaReview.this.modelList.get(rowIndex);
            if (columnIndex == 2) {
                return row[2];
            }
            if (columnIndex == 3) {
                return (Boolean)row[3] != false ? "Yes" : "";
            }
            return row[columnIndex];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            super.setValueAt(value, rowIndex, columnIndex);
            Boolean isChecked = (Boolean)value;
            Object[] row = ViewToSchemaReview.this.modelList.get(rowIndex);
            if (columnIndex == 4) {
                row[4] = isChecked;
                this.fireTableCellUpdated(rowIndex, 4);
            }
            this.fireTableCellUpdated(rowIndex, 2);
        }
    }
}

