/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.extras;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.HTTPGetter;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.extras.FishBaseInfoGetterListener;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class FishBaseInfoGetter
extends HTTPGetter {
    private static final Logger log = Logger.getLogger(FishBaseInfoGetter.class);
    protected FishBaseInfoGetterListener consumer;
    protected InfoType type;
    protected String genus;
    protected String species;
    protected Image image = null;
    protected String imageURL = null;
    protected String tmpDir = null;
    protected Element dom = null;
    protected String data = null;

    public FishBaseInfoGetter(FishBaseInfoGetterListener consumer, InfoType type, String genus, String species) {
        this.consumer = consumer;
        this.type = type;
        this.genus = genus;
        this.species = species;
        File path = UIRegistry.getAppDataSubDir("cache", true);
        if (!path.exists()) {
            String msg = "unable to create directory [" + path.getAbsolutePath() + "]";
            log.warn((Object)msg);
            throw new RuntimeException(msg);
        }
        this.tmpDir = path.getAbsolutePath();
    }

    public Element getDom() {
        return this.dom;
    }

    public Image getImage() {
        return this.image;
    }

    public void setConsumer(FishBaseInfoGetterListener consumer) {
        this.consumer = consumer;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public Image getImage(String fileName, String url) {
        this.imageURL = url;
        String fullPath = String.valueOf(this.tmpDir) + File.separator + fileName;
        File file = new File(fullPath);
        if (file.exists()) {
            try {
                return new ImageIcon(fullPath).getImage();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FishBaseInfoGetter.class, ex);
                ex.printStackTrace();
                this.status = HTTPGetter.ErrorCode.Error;
            }
        } else {
            byte[] bytes = super.doHTTPRequest(url);
            try {
                FileImageOutputStream fos = new FileImageOutputStream(file);
                fos.write(bytes);
                fos.flush();
                fos.close();
                return new ImageIcon(bytes).getImage();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FishBaseInfoGetter.class, ex);
                ex.printStackTrace();
                this.status = HTTPGetter.ErrorCode.Error;
            }
        }
        return null;
    }

    public void getDOMDoc(String url, InfoType infoType) {
        this.dom = null;
        String fileName = String.valueOf(this.tmpDir) + File.separator + this.genus + "_" + this.species + "_" + infoType.toString() + ".xml";
        File file = new File(fileName);
        if (file.exists()) {
            try {
                this.dom = XMLHelper.readFileToDOM4J(file);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FishBaseInfoGetter.class, ex);
                ex.printStackTrace();
                this.status = HTTPGetter.ErrorCode.Error;
            }
        } else {
            byte[] bytes = super.doHTTPRequest(url);
            this.data = new String(bytes);
            int inx = this.data.indexOf("<?");
            if (inx > -1) {
                this.data = this.data.substring(inx, this.data.length());
                try {
                    BufferedWriter output = new BufferedWriter(new FileWriter(file));
                    output.write(this.data);
                    ((Writer)output).flush();
                    ((Writer)output).close();
                    this.dom = XMLHelper.readFileToDOM4J(file);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(FishBaseInfoGetter.class, ex);
                    ex.printStackTrace();
                    this.status = HTTPGetter.ErrorCode.Error;
                }
            } else {
                this.status = HTTPGetter.ErrorCode.Error;
                this.data = null;
            }
        }
    }

    @Override
    public void run() {
        if (this.type == InfoType.Summary) {
            this.urlStr = "http://www.fishbase.org.ph/webservice/Species/SpeciesSummary.asp?Genus=" + this.genus + "&Species=" + this.species;
            this.getDOMDoc(this.urlStr, this.type);
        } else if (this.type == InfoType.Thumbnail || this.type == InfoType.Image) {
            int numPictures;
            Element speciesElement;
            this.urlStr = "http://www.fishbase.org/webservice/Photos/FishPicsList.php?Genus=" + this.genus + "&Species=" + this.species;
            this.getDOMDoc(this.urlStr, InfoType.PictureList);
            if (this.status == HTTPGetter.ErrorCode.NoError && (speciesElement = (Element)this.dom.selectSingleNode("/fishbase/species")) != null && (numPictures = XMLHelper.getAttr(speciesElement, "total_adult", 0)) > 0) {
                List adults = this.dom.selectNodes("/fishbase/pictures[@type='adult']");
                for (Element pictureElement : adults) {
                    String fileURL;
                    Element nameElement = (Element)pictureElement.selectSingleNode(this.type == InfoType.Thumbnail ? "thumbnail" : "actual");
                    if (nameElement == null || !StringUtils.isNotEmpty((String)(fileURL = nameElement.getTextTrim()))) continue;
                    String shortName = "";
                    int inx = fileURL.lastIndexOf("/");
                    if (inx > -1) {
                        shortName = fileURL.substring(inx + 1, fileURL.length());
                    }
                    this.image = this.getImage(shortName, fileURL);
                    if (this.image != null) break;
                }
            }
        }
        if (this.consumer != null) {
            if (this.status == HTTPGetter.ErrorCode.NoError) {
                this.consumer.infoArrived(this);
            } else {
                this.consumer.infoGetWasInError(this);
            }
        }
        this.stop();
    }

    public static enum InfoType {
        Summary,
        Image,
        Thumbnail,
        PictureList;

    }
}

