/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport.customqueries;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsDataObj;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Loan;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.NotImplementedException;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CustomStatQueries
implements CustomQueryIFace {
    protected Type type;
    protected List<QueryResultsDataObj> qrdoResults = null;
    protected boolean inError = false;
    protected List<?> resultsList = null;

    public CustomStatQueries(Type type) {
        this.type = type;
    }

    @Override
    public boolean execute() {
        boolean retVal = this.executeInternal();
        if (retVal) {
            if (this.qrdoResults == null) {
                this.qrdoResults = new Vector<QueryResultsDataObj>();
            }
            for (Object obj : this.resultsList) {
                this.qrdoResults.add(new QueryResultsDataObj(obj));
            }
        }
        return retVal;
    }

    protected boolean executeInternal() {
        switch (this.type) {
            case CatalogedLast7Days: {
                return this.catalogedLastXDays(7);
            }
            case CatalogedLast30Days: {
                return this.catalogedLastXDays(30);
            }
            case CatalogedLastYear: {
                return this.catalogedLastXDays(365);
            }
            case OverdueLoans: {
                return this.overdueLoans();
            }
        }
        return false;
    }

    @Override
    public List<Integer> getTableIds() {
        Vector<Integer> list = new Vector<Integer>();
        switch (this.type) {
            case CatalogedLast7Days: 
            case CatalogedLast30Days: 
            case CatalogedLastYear: {
                Collections.addAll(list, 1);
                break;
            }
            case OverdueLoans: {
                Collections.addAll(list, 52);
            }
        }
        return list;
    }

    @Override
    public void execute(final CustomQueryListener cql) {
        final CustomStatQueries thisItem = this;
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                CustomStatQueries.this.inError = CustomStatQueries.this.executeInternal();
                return null;
            }

            @Override
            public void finished() {
                if (CustomStatQueries.this.inError) {
                    cql.executionError(thisItem);
                } else {
                    cql.exectionDone(thisItem);
                }
            }
        };
        worker.start();
    }

    @Override
    public List<?> getDataObjects() {
        return this.resultsList;
    }

    protected boolean catalogedLastXDays(int numDays) {
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.clear(11);
        startDate.clear(12);
        startDate.clear(13);
        Calendar today = Calendar.getInstance();
        today.add(5, -numDays);
        startDate.clear();
        startDate.set(1, today.get(1));
        startDate.set(2, today.get(2));
        startDate.set(5, today.get(5));
        Session session = HibernateUtil.getNewSession();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate.getTime());
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate.getTime());
        Criteria criteria = session.createCriteria(CollectionObject.class);
        criteria.add((Criterion)Expression.ge((String)"catalogedDate", (Object)startCal));
        criteria.add((Criterion)Expression.le((String)"catalogedDate", (Object)endCal));
        criteria.add((Criterion)Expression.eq((String)"collectionMemberId", (Object)AppContextMgr.getInstance().getClassObject(Collection.class).getCollectionId()));
        criteria.setProjection(Projections.rowCount());
        this.resultsList = criteria.list();
        session.close();
        return true;
    }

    protected boolean overdueLoans() {
        Session session = HibernateUtil.getNewSession();
        Calendar today = Calendar.getInstance();
        Criteria criteria = session.createCriteria(Loan.class);
        criteria.add(Restrictions.isNotNull((String)"currentDueDate"));
        criteria.add((Criterion)Restrictions.lt((String)"currentDueDate", (Object)today));
        Criteria dsp = criteria.createCriteria("discipline");
        dsp.add((Criterion)Restrictions.eq((String)"disciplineId", (Object)AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId()));
        criteria.setProjection(Projections.rowCount());
        this.resultsList = criteria.list();
        session.close();
        return true;
    }

    @Override
    public List<QueryResultsContainerIFace> getQueryDefinition() {
        throw new NotImplementedException();
    }

    @Override
    public List<QueryResultsDataObj> getResults() {
        return this.qrdoResults;
    }

    @Override
    public String getName() {
        return this.type.toString();
    }

    @Override
    public boolean isInError() {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void cancel() {
    }

    @Override
    public int getMaxResults() {
        return 0;
    }

    @Override
    public void setMaxResults(int maxResults) {
    }

    public static enum Type {
        CatalogedLast7Days,
        CatalogedLast30Days,
        CatalogedLastYear,
        OverdueLoans;

    }
}

