/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport.cleanuptools;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.conversion.TimeLogger;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModelRowInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataObjTableModel
extends DefaultTableModel {
    protected static final Logger log = Logger.getLogger(DataObjTableModel.class);
    protected Connection conn;
    protected ArrayList<DBInfoBase> items;
    protected DBTableInfo tableInfo;
    protected Vector<Object[]> values = null;
    protected boolean isEditable = false;
    protected boolean isFirstColBool = true;
    protected int[] mapInx = null;
    protected String colName;
    protected Object searchValue;
    protected int numColumns = 0;
    protected ArrayList<DBInfoBase> colDefItems = new ArrayList();
    protected ArrayList<Class<?>> altClasses = null;
    protected int hasDataCols = 0;
    protected ArrayList<Boolean> sameValues = null;
    protected ArrayList<Boolean> hasDataList = null;
    protected ArrayList<DataObjTableModelRowInfo> rowInfoList = new ArrayList();
    protected HashMap<Integer, Integer> indexHash = new HashMap();

    public DataObjTableModel(Connection conn, int tableId, String colName, Object value, boolean isEditable) {
        this.conn = conn;
        this.isEditable = isEditable;
        this.colName = colName;
        this.searchValue = value;
        this.tableInfo = DBTableIdMgr.getInstance().getInfoById(tableId);
    }

    public DataObjTableModel(Connection conn, int tableId, Object value, boolean isEditable) {
        this(conn, tableId, null, value, isEditable);
        this.fillModels();
    }

    public DataObjTableModel(Connection conn, int tableId, ArrayList<DBInfoBase> items, ArrayList<Boolean> hasDataList, ArrayList<Boolean> sameValues, int[] mapInx, HashMap<Integer, Integer> indexHash) {
        this.conn = conn;
        this.items = items;
        this.hasDataList = hasDataList;
        this.sameValues = sameValues;
        this.mapInx = mapInx;
        this.indexHash = indexHash;
        this.isEditable = true;
        this.tableInfo = DBTableIdMgr.getInstance().getInfoById(tableId);
        this.values = new Vector();
        this.values.add(new Object[items != null ? items.size() : 1]);
    }

    public void setFirstColBool(boolean isFirstColBool) {
        this.isFirstColBool = isFirstColBool;
    }

    protected String buildSQL() {
        StringBuffer sql = new StringBuffer("SELECT ");
        for (DBFieldInfo fi : this.tableInfo.getFields()) {
            if (fi.getColumn().equals("Version")) continue;
            this.colDefItems.add(fi);
            if (this.colDefItems.size() > 1) {
                sql.append(',');
            }
            sql.append(fi.getColumn());
        }
        this.numColumns = this.colDefItems.size();
        sql.append(" FROM %s WHERE %s LIKE ?");
        String sqlStr = String.format(sql.toString(), this.tableInfo.getName(), this.colName, String.valueOf(this.searchValue.toString()) + '%');
        return sqlStr;
    }

    public void clear() {
        this.values.clear();
        this.fireTableDataChanged();
    }

    protected void processColumns(Object[] cmpRow) {
    }

    protected void fillModels() {
        String sqlStr = this.buildSQL();
        TimeLogger tml = new TimeLogger("Fetching Rows");
        this.values = new Vector();
        if (StringUtils.isNotEmpty((String)sqlStr)) {
            log.debug((Object)sqlStr);
            try {
                PreparedStatement pStmt = this.conn.prepareStatement(sqlStr);
                if (this.searchValue != null) {
                    pStmt.setObject(1, this.searchValue);
                }
                log.debug((Object)(String.valueOf(sqlStr) + " [" + this.searchValue + "]"));
                tml.restart("Query");
                ResultSet rs = pStmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                tml.restart("Loading");
                while (rs.next()) {
                    Object[] row = new Object[this.numColumns];
                    int i = 0;
                    while (i < rsmd.getColumnCount()) {
                        Object obj = rs.getObject(i + 1);
                        row[i] = obj instanceof String ? obj.toString().trim() : obj;
                        ++i;
                    }
                    this.rowInfoList.add(new DataObjTableModelRowInfo(rs.getInt(1), false, false));
                    this.values.add(row);
                    this.processColumns(row);
                }
                rs.close();
                pStmt.close();
                tml.end();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        tml.restart("Step 2 - Addl Rows");
        this.addAdditionalRows(this.colDefItems, this.rowInfoList);
        tml.restart("Step 3");
        this.sameValues = new ArrayList(this.numColumns);
        this.hasDataList = new ArrayList(this.numColumns);
        int i = 0;
        while (i < this.numColumns) {
            this.sameValues.add(true);
            this.hasDataList.add(false);
            ++i;
        }
        for (Object[] col : this.values) {
            int i2 = 0;
            while (i2 < this.numColumns) {
                boolean hasData;
                Object data = col[i2];
                boolean bl = hasData = data != null;
                if (hasData && !this.hasDataList.get(i2).booleanValue()) {
                    this.hasDataList.set(i2, true);
                    ++this.hasDataCols;
                }
                ++i2;
            }
        }
        tml.restart("Step  4 - adj cols");
        this.adjustHasDataColumns();
        tml.restart("Step  5 - Map");
        this.mapInx = new int[this.hasDataCols];
        int colInx = 0;
        int i3 = 0;
        while (i3 < this.numColumns) {
            if (this.hasDataList.get(i3).booleanValue()) {
                this.mapInx[colInx] = i3;
                this.indexHash.put(i3, colInx);
                ++colInx;
            }
            ++i3;
        }
        tml.restart("Step  6 - same data");
        i3 = 0;
        while (i3 < this.mapInx.length) {
            colInx = this.mapInx[i3];
            if (this.hasDataList.get(colInx).booleanValue()) {
                Object data = null;
                for (Object[] col : this.values) {
                    Object newData = col[colInx];
                    if (data == null) {
                        if (newData == null) continue;
                        data = newData;
                        continue;
                    }
                    if (newData == null || data.equals(newData)) continue;
                    this.sameValues.set(colInx, false);
                    break;
                }
            }
            ++i3;
        }
        tml.end();
        this.items = new ArrayList<DBInfoBase>(this.colDefItems);
        this.doneFillingModels(this.values);
    }

    protected void doneFillingModels(Vector<Object[]> values) {
    }

    protected void addAdditionalRows(ArrayList<DBInfoBase> colDefItems, ArrayList<DataObjTableModelRowInfo> rowInfoList) {
    }

    protected void adjustHasDataColumns() {
    }

    public ArrayList<DataObjTableModelRowInfo> getRowInfoList() {
        return this.rowInfoList;
    }

    public boolean isSame(int column) {
        return this.sameValues.get(this.mapInx[column]);
    }

    @Override
    public int getColumnCount() {
        return this.mapInx != null ? this.mapInx.length : 0;
    }

    @Override
    public String getColumnName(int column) {
        if (this.isFirstColBool && column == 0) {
            return !this.isEditable ? "Is Included" : "";
        }
        return this.mapInx != null ? this.items.get(this.mapInx[column]).getTitle() : "";
    }

    @Override
    public int getRowCount() {
        return this.values != null ? this.values.size() : 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object[] col;
        if (this.isFirstColBool && column == 0) {
            if (!this.isEditable) {
                return this.rowInfoList.size() > 0 ? this.rowInfoList.get(row).isIncluded() : false;
            }
            return "";
        }
        Object[] objectArray = col = this.values != null ? this.values.get(row) : null;
        if (col != null) {
            return col[this.mapInx[column]];
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (this.isFirstColBool && column == 0) {
            return !this.isEditable ? Boolean.class : String.class;
        }
        int mappedInx = this.mapInx[column];
        if (this.altClasses == null) {
            DBInfoBase base = this.items.get(mappedInx);
            if (base instanceof DBFieldInfo) {
                return ((DBFieldInfo)base).getDataClass();
            }
        } else {
            return this.altClasses.get(mappedInx);
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.isFirstColBool && column == 0) {
            return !this.isEditable;
        }
        return this.isEditable;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Object[] col;
        if (this.isFirstColBool && column == 0) {
            if (!this.isEditable && aValue instanceof Boolean) {
                this.rowInfoList.get(row).setIncluded((Boolean)aValue);
            }
            return;
        }
        Object[] objectArray = col = this.values != null ? this.values.get(row) : null;
        if (col != null) {
            col[this.mapInx[column]] = aValue;
            this.fireTableCellUpdated(row, column);
        }
    }

    public ArrayList<DBInfoBase> getItems() {
        return this.items;
    }

    public void setItems(ArrayList<DBInfoBase> items) {
        this.items = items;
    }

    public int[] getMapInx() {
        return this.mapInx;
    }

    public void setMapInx(int[] mapInx) {
        this.mapInx = mapInx;
    }

    public ArrayList<Boolean> getSameValues() {
        return this.sameValues;
    }

    public void setSameValues(ArrayList<Boolean> sameValues) {
        this.sameValues = sameValues;
    }

    public ArrayList<Boolean> getHasDataList() {
        return this.hasDataList;
    }

    public void setHasDataList(ArrayList<Boolean> hasDataList) {
        this.hasDataList = hasDataList;
    }

    public HashMap<Integer, Integer> getIndexHash() {
        return this.indexHash;
    }

    public void setIndexHash(HashMap<Integer, Integer> indexHash) {
        this.indexHash = indexHash;
    }

    public Vector<Object[]> getValues() {
        return this.values;
    }
}

