/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport.cleanuptools;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.dbsupport.cleanuptools.FindItemInfo;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BaseFindCleanupItems
extends CustomDialog {
    protected JList itemsList;
    protected JButton cleanupBtn;
    protected DBTableInfo tblInfo = null;
    protected String title = null;
    protected String topMsg = null;

    public BaseFindCleanupItems(DBTableInfo tblInfo) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("CLNUP.FNDTITLE", tblInfo.getTitle()), true, 1, null);
        this.tblInfo = tblInfo;
        this.title = tblInfo.getTitle();
    }

    public BaseFindCleanupItems(String title) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("CLNUP.FNDTITLE", title), true, 1, null);
        this.title = title;
    }

    public BaseFindCleanupItems(String title, String topMsg) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("CLNUP.FNDTITLE", title), true, 1, null);
        this.title = title;
        this.topMsg = topMsg;
    }

    @Override
    public void createUI() {
        this.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        super.createUI();
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,f:p:g", String.valueOf(this.topMsg != null ? "p,2px," : "") + "p,2px,p"));
        DefaultListModel<FindItemInfo> model = new DefaultListModel<FindItemInfo>();
        model.addElement(new FindItemInfo(0, UIRegistry.getResourceString("CLNUP.LOAD")));
        this.itemsList = new JList(model);
        this.itemsList.setEnabled(false);
        this.cleanupBtn = UIHelper.createButton(UIRegistry.getLocalizedMessage("CLNUP.CHOOSE", this.title));
        this.cleanupBtn.setEnabled(false);
        int y = 1;
        if (this.topMsg != null) {
            pb.add((Component)UIHelper.createLabel(this.topMsg), cc.xyw(1, y, 3));
            y += 2;
        }
        pb.add((Component)UIHelper.createScrollPane(this.itemsList), cc.xyw(1, y, 3));
        pb.add((Component)this.cleanupBtn, cc.xy(1, y += 2));
        y += 2;
        DefaultListCellRenderer lcr = this.getListCellRenderer();
        if (lcr != null) {
            this.itemsList.setCellRenderer(lcr);
        }
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.cleanupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseFindCleanupItems.this.doCleanupOfItem();
            }
        });
        this.itemsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && BaseFindCleanupItems.this.cleanupBtn != null) {
                    BaseFindCleanupItems.this.cleanupBtn.setEnabled(BaseFindCleanupItems.this.itemsList.getSelectedIndex() != -1);
                }
            }
        });
        this.itemsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    BaseFindCleanupItems.this.cleanupBtn.setEnabled(true);
                    BaseFindCleanupItems.this.cleanupBtn.doClick();
                }
            }
        });
    }

    protected void doCleanupOfItem() {
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                }
            });
            this.startProcessing();
        }
        super.setVisible(visible);
    }

    protected void fillModel(DefaultListModel model) {
        this.itemsList.setModel(model);
        this.pack();
        this.setSize(Math.max(this.getSize().width, 350), this.getSize().height);
        UIHelper.centerWindow(this);
    }

    protected Vector<FindItemInfo> doWork() {
        return new Vector<FindItemInfo>();
    }

    protected void startProcessing() {
        SwingWorker<DefaultListModel, Object> worker = new SwingWorker<DefaultListModel, Object>(){
            DefaultListModel wrkModel = null;

            @Override
            protected DefaultListModel doInBackground() throws Exception {
                this.wrkModel = new DefaultListModel();
                for (FindItemInfo ii : BaseFindCleanupItems.this.doWork()) {
                    this.wrkModel.addElement(ii);
                }
                return this.wrkModel;
            }

            @Override
            protected void done() {
                BaseFindCleanupItems.this.fillModel(this.wrkModel);
                BaseFindCleanupItems.this.itemsList.setEnabled(true);
                super.done();
            }
        };
        worker.execute();
    }

    protected DefaultListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                FindItemInfo itemInfo = (FindItemInfo)value;
                JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                lbl.setText(itemInfo.getValue().toString());
                return lbl;
            }
        };
    }

    protected static enum ItemStatusType {
        eOK,
        eProcessed,
        eRelated;

    }
}

