/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport.cleanuptools;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModel;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModelRowInfo;
import edu.ku.brc.specify.dbsupport.cleanuptools.FindItemInfo;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;

public abstract class BaseCleanupResults
extends CustomDialog {
    protected static final Logger log = Logger.getLogger(BaseCleanupResults.class);
    protected DataObjTableModel model;
    protected DataObjTableModel newModel;
    protected FindItemInfo itemInfo;
    protected JTable topTable;
    protected JTable botTable;
    protected JButton upBtn;
    protected JButton dwnBtn;
    protected JButton mvRecBtn;

    public BaseCleanupResults(String title, FindItemInfo itemInfo) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), title, true, (Component)null);
        this.itemInfo = itemInfo;
    }

    protected abstract void createAndFillModels();

    @Override
    public void createUI() {
        this.setOkLabel(UIRegistry.getResourceString("CLNUP.DOCLEANUP"));
        super.createUI();
        this.createAndFillModels();
        this.topTable = new JTable(this.model);
        this.botTable = new JTable(this.newModel);
        DefaultTableCellRenderer tcr = this.getTableCellRenderer(this.model.getRowInfoList());
        int i = 0;
        while (i < this.model.getColumnCount()) {
            if (this.model.getColumnClass(i) != Boolean.class) {
                this.topTable.setDefaultRenderer(this.model.getColumnClass(i), tcr);
            }
            ++i;
        }
        this.topTable.setCellSelectionEnabled(true);
        CellConstraints cc = new CellConstraints();
        this.dwnBtn = UIHelper.createButton("Move Field Value");
        this.dwnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseCleanupResults.this.moveValueDown();
            }
        });
        this.mvRecBtn = UIHelper.createButton("Choose Base Record");
        this.mvRecBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseCleanupResults.this.moveRecord();
            }
        });
        ListSelectionListener lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BaseCleanupResults.this.mvRecBtn.setEnabled(BaseCleanupResults.this.topTable.getSelectedRow() > -1);
                BaseCleanupResults.this.dwnBtn.setEnabled(BaseCleanupResults.this.topTable.getSelectedRow() > -1);
            }
        };
        this.topTable.getSelectionModel().addListSelectionListener(lsl);
        this.botTable.getSelectionModel().addListSelectionListener(lsl);
        PanelBuilder arrowPanel = new PanelBuilder(new FormLayout("p:g, p, 30px, p, f:p:g", "p"));
        arrowPanel.add((Component)this.mvRecBtn, cc.xy(2, 1));
        arrowPanel.add((Component)this.dwnBtn, cc.xy(4, 1));
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,10px,p,10px,p:g"));
        this.topTable.setAutoResizeMode(0);
        this.botTable.setAutoResizeMode(0);
        UIHelper.makeTableHeadersCentered(this.topTable, false);
        this.topTable.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
        UIHelper.makeTableHeadersCentered(this.botTable, false);
        pb.add((Component)UIHelper.createScrollPane(this.topTable, true), cc.xy(1, 1));
        pb.add((Component)arrowPanel.getPanel(), cc.xy(1, 3));
        pb.add((Component)UIHelper.createScrollPane(this.botTable, true), cc.xy(1, 5));
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BaseCleanupResults.this.doFixDuplicates();
                    }
                });
            }
        });
    }

    private void moveValueDown() {
        int row = this.topTable.getSelectedRow();
        int[] colsInxs = this.topTable.getSelectedColumns();
        if (colsInxs != null && colsInxs.length > 0) {
            int[] nArray = colsInxs;
            int n = colsInxs.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                Object data = this.topTable.getValueAt(row, c);
                this.newModel.setValueAt(data, 0, c);
                ++n2;
            }
        }
    }

    private void moveRecord() {
        int row = this.topTable.getSelectedRow();
        if (row != -1) {
            int i = 0;
            while (i < this.topTable.getColumnCount()) {
                Object data = this.topTable.getValueAt(row, i);
                this.newModel.setValueAt(data, 0, i);
                ++i;
            }
            i = 0;
            while (i < this.model.getRowCount()) {
                this.model.getRowInfoList().get(i).setMainRecord(row == i);
                ++i;
            }
        }
    }

    protected DefaultTableCellRenderer getTableCellRenderer(final List<DataObjTableModelRowInfo> rowInfoList) {
        final Color sameColor = new Color(0, 128, 0);
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DataObjTableModelRowInfo rowInfo = (DataObjTableModelRowInfo)rowInfoList.get(row);
                boolean doCenter = false;
                Object val = value;
                if (value instanceof Pair) {
                    Pair pair = (Pair)value;
                    val = pair.first;
                    doCenter = true;
                }
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
                if (rowInfo.isMainRecord()) {
                    lbl.setForeground(Color.WHITE);
                    lbl.setBackground(Color.BLUE.brighter().brighter());
                } else {
                    lbl.setForeground(BaseCleanupResults.this.model.isSame(column) ? sameColor : Color.BLACK);
                    lbl.setBackground(Color.WHITE);
                }
                lbl.setHorizontalTextPosition(doCenter ? 0 : 2);
                return lbl;
            }
        };
    }

    protected void doFixDuplicates() {
    }
}

