/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport.cleanuptools;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.config.Scriptlet;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.dbsupport.cleanuptools.AgentCleanupResults;
import edu.ku.brc.specify.dbsupport.cleanuptools.BaseFindCleanupItems;
import edu.ku.brc.specify.dbsupport.cleanuptools.FindItemInfo;
import edu.ku.brc.ui.UIHelper;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class AgentFindCleanupItems
extends BaseFindCleanupItems {
    public AgentFindCleanupItems(Frame frame) throws HeadlessException {
        super(DBTableIdMgr.getInstance().getInfoById(Agent.getClassTableId()));
    }

    @Override
    protected Vector<FindItemInfo> doWork() {
        Vector<FindItemInfo> items = super.doWork();
        HashSet<String> lastNameHash = new HashSet<String>();
        Scriptlet scriptlet = new Scriptlet();
        String sql = "SELECT LastName, cnt FROM (SELECT LastName, COUNT(LastName) as cnt FROM agent WHERE LastName IS NOT NULL GROUP BY LastName) T1";
        int i = 0;
        for (Object[] row : BasicSQLUtils.query(sql)) {
            if (i % 100 == 0) {
                System.out.println("Loaded: " + i);
            }
            ++i;
            String lastName = (String)row[0];
            if (lastNameHash.contains(lastName)) continue;
            long cnt = (Long)row[1];
            Connection conn = DBConnection.getInstance().getConnection();
            PreparedStatement pStmt = null;
            try {
                if (lastName.length() > 2 && cnt == 1L) {
                    String partialLastName = String.valueOf(lastName.substring(0, 1)) + "%";
                    pStmt = conn.prepareStatement("SELECT LastName FROM agent WHERE LastName = ? AND LastName IS NOT NULL ORDER BY TimestampCreated ASC");
                    pStmt.setString(1, partialLastName);
                    ResultSet rs = pStmt.executeQuery();
                    while (rs.next()) {
                        String lName = rs.getString(1);
                        if (StringUtils.getLevenshteinDistance((String)lastName, (String)lName) != 2) continue;
                        ++cnt;
                        break;
                    }
                    rs.close();
                    pStmt.close();
                }
                if (cnt <= 1L) continue;
                pStmt = conn.prepareStatement("SELECT AgentID, FirstName, MiddleInitial FROM agent WHERE LastName = ? ORDER BY TimestampCreated ASC");
                pStmt.setString(1, lastName);
                ResultSet rs = pStmt.executeQuery();
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String firstName = rs.getString(2);
                    String midInitial = rs.getString(3);
                    String fullName = scriptlet.buildNameString(firstName, lastName, midInitial);
                    FindItemInfo ii = new FindItemInfo(id, fullName);
                    items.add(ii);
                    lastNameHash.add(lastName);
                }
                rs.close();
                pStmt.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return items;
    }

    @Override
    protected void doCleanupOfItem() {
        FindItemInfo itemInfo = (FindItemInfo)this.itemsList.getSelectedValue();
        if (itemInfo != null) {
            AgentCleanupResults agentResults = new AgentCleanupResults(itemInfo);
            UIHelper.centerAndShow(agentResults);
        }
    }
}

