/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport.cleanuptools;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.dbsupport.cleanuptools.BaseCleanupResults;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModel;
import edu.ku.brc.specify.dbsupport.cleanuptools.DataObjTableModelRowInfo;
import edu.ku.brc.specify.dbsupport.cleanuptools.FindItemInfo;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class AgentCleanupResults
extends BaseCleanupResults {
    protected String selectColNames = null;

    public AgentCleanupResults(FindItemInfo itemInfo) {
        super("Agent Cleanup", itemInfo);
    }

    @Override
    protected void createAndFillModels() {
        Connection conn = DBConnection.getInstance().getConnection();
        this.model = new DataObjTableModel(conn, Agent.getClassTableId(), (Object)this.itemInfo.getValue().toString(), false){

            @Override
            protected String buildSQL() {
                DBTableInfo addrTableInfo = DBTableIdMgr.getInstance().getInfoById(Address.getClassTableId());
                String agentKey = this.tableInfo.getIdColumnName();
                String addrKey = addrTableInfo.getIdColumnName();
                String[] skipFields = new String[]{"Ordinal", "TimestampModified", "TimestampCreated", "Version", agentKey, addrKey};
                HashSet<String> skipHash = new HashSet<String>();
                String[] stringArray = skipFields;
                int n = skipFields.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    skipHash.add(s);
                    ++n2;
                }
                this.numColumns = 0;
                StringBuilder fsb = new StringBuilder("ag." + agentKey);
                this.colDefItems.add(new DBFieldInfo(this.tableInfo, agentKey, Integer.class));
                for (DBFieldInfo fi : this.tableInfo.getFields()) {
                    if (skipHash.contains(fi.getColumn())) continue;
                    if (fsb.length() > 0) {
                        fsb.append(',');
                    }
                    fsb.append("ag." + fi.getColumn());
                    this.colDefItems.add(fi);
                    ++this.numColumns;
                }
                fsb.append(",ad." + addrKey);
                this.colDefItems.add(new DBFieldInfo(addrTableInfo, addrKey, Integer.class));
                for (DBFieldInfo fi : addrTableInfo.getFields()) {
                    if (skipHash.contains(fi.getColumn())) continue;
                    if (fsb.length() > 0) {
                        fsb.append(',');
                    }
                    fsb.append("ad." + fi.getColumn());
                    this.colDefItems.add(fi);
                    ++this.numColumns;
                }
                AgentCleanupResults.this.selectColNames = fsb.toString();
                return String.format("SELECT %s FROM agent ag LEFT JOIN address ad on ag.AgentID = ad.AgentID WHERE LastName = ?", AgentCleanupResults.this.selectColNames);
            }

            @Override
            protected void addAdditionalRows(ArrayList<DBInfoBase> colDefItems, ArrayList<DataObjTableModelRowInfo> rowInfoList) {
                HashSet<Integer> existingIdsHash = new HashSet<Integer>();
                for (DataObjTableModelRowInfo ri : rowInfoList) {
                    existingIdsHash.add(ri.getId());
                }
                Connection conn = DBConnection.getInstance().getConnection();
                String sqlFmt = String.format("SELECT %s FROM agent ag LEFT JOIN address ad on ag.AgentID = ad.AgentID WHERE ag.LastName LIKE ? AND ag.LastName IS NOT NULL ORDER BY ag.LastName, ag.TimestampCreated ASC", AgentCleanupResults.this.selectColNames);
                PreparedStatement pStmt = null;
                try {
                    int len = 4;
                    String lastName = AgentCleanupResults.this.itemInfo.getValue().toString();
                    if (lastName.length() > len) {
                        String partialLastName = String.valueOf(lastName.substring(0, len - 1)) + "%";
                        pStmt = conn.prepareStatement(sqlFmt);
                        pStmt.setString(1, partialLastName);
                        System.out.println(String.valueOf(sqlFmt) + " [" + partialLastName + "]");
                        ResultSet rs = pStmt.executeQuery();
                        while (rs.next()) {
                            int id = rs.getInt(1);
                            if (existingIdsHash.contains(id)) continue;
                            Object[] row = new Object[this.numColumns];
                            int i = 0;
                            while (i < this.numColumns) {
                                row[i] = rs.getObject(i + 1);
                                ++i;
                            }
                            this.values.add(row);
                            rowInfoList.add(new DataObjTableModelRowInfo(rs.getInt(1), false, false));
                        }
                        rs.close();
                        pStmt.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                int agentTypeInx = -1;
                int i = 0;
                this.altClasses = new ArrayList();
                for (DBInfoBase bi : colDefItems) {
                    DBFieldInfo fi = (DBFieldInfo)bi;
                    if (fi.getColumn().equals("AgentType")) {
                        this.altClasses.add(String.class);
                        agentTypeInx = i;
                    } else {
                        this.altClasses.add(fi.getDataClass());
                    }
                    ++i;
                }
                if (agentTypeInx > -1) {
                    String[] types = new String[]{"ORG", "PERSON", "OTHER", "GROUP"};
                    int j = 0;
                    while (j < types.length) {
                        types[j] = UIRegistry.getResourceString("Agent_" + types[j]);
                        ++j;
                    }
                    int ii = 0;
                    while (ii < this.values.size()) {
                        Object[] cols = (Object[])this.values.get(ii);
                        Integer agentType = (Integer)cols[agentTypeInx];
                        DualValue p = new DualValue(types[agentType], agentType);
                        cols[agentTypeInx] = p;
                        ++ii;
                    }
                }
            }

            @Override
            protected void adjustHasDataColumns() {
                int inx = this.tableInfo.getFields().size() - 2;
                if (((Boolean)this.hasDataList.get(inx)).booleanValue()) {
                    this.hasDataList.set(inx, false);
                    --this.hasDataCols;
                }
            }
        };
        this.newModel = new DataObjTableModel(conn, Agent.getClassTableId(), this.model.getItems(), this.model.getHasDataList(), this.model.getSameValues(), this.model.getMapInx(), this.model.getIndexHash());
    }

    @Override
    protected void doFixDuplicates() {
        Vector<DBRelationshipInfo> rels;
        Integer mainId = null;
        HashSet<Integer> idsToChange = new HashSet<Integer>();
        for (DataObjTableModelRowInfo ri : this.model.getRowInfoList()) {
            if (ri.isMainRecord) {
                mainId = ri.getId();
                continue;
            }
            idsToChange.add(ri.getId());
        }
        for (Integer id : new HashSet(idsToChange)) {
            if (!id.equals(mainId)) continue;
            idsToChange.remove(id);
        }
        if (idsToChange.size() == 0) {
            return;
        }
        StringBuilder idsStrSB = new StringBuilder();
        for (Integer id : idsToChange) {
            if (idsStrSB.length() > 0) {
                idsStrSB.append(',');
            }
            idsStrSB.append(id);
        }
        String idsStr = String.valueOf('(') + idsStrSB.toString() + ')';
        System.out.println("Main: " + mainId + "  ids: " + idsStrSB.toString());
        if (!this.checkForValidDeletions(mainId, idsToChange)) {
            return;
        }
        HashMap<DBTableInfo, Vector<DBRelationshipInfo>> tablesToBeFixed = new HashMap<DBTableInfo, Vector<DBRelationshipInfo>>();
        int totalCnt = 0;
        ArrayList<Pair<String, Integer>> cntPairs = new ArrayList<Pair<String, Integer>>();
        for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
            rels = null;
            int totalForTable = 0;
            for (DBRelationshipInfo ri : ti.getRelationships()) {
                String sql;
                int cnt;
                if (ri.getDataClass() != Agent.class || (cnt = BasicSQLUtils.getCountAsInt(sql = String.format("SELECT COUNT(*) FROM %s WHERE %s IN %s", ti.getName(), ri.getColName(), idsStr))) <= 0) continue;
                System.out.println(String.format("Found %d in %s.%s", cnt, ti.getName(), ri.getColName()));
                totalForTable += cnt;
                totalCnt += cnt;
                if (rels == null) {
                    rels = new Vector<DBRelationshipInfo>();
                }
                rels.add(ri);
            }
            if (totalForTable <= 0) continue;
            cntPairs.add(new Pair<String, Integer>(ti.getTitle(), totalForTable));
            tablesToBeFixed.put(ti, rels);
        }
        if (totalCnt > 0) {
            this.displayTotals(cntPairs, totalCnt);
            for (DBTableInfo ti : tablesToBeFixed.keySet()) {
                rels = (Vector<DBRelationshipInfo>)tablesToBeFixed.get(ti);
                for (DBRelationshipInfo ri : rels) {
                    for (Integer id : idsToChange) {
                        String sql = String.format("UPDATE %s SET %s=%d WHERE %s = %d", ti.getName(), ri.getColName(), mainId, ri.getColName(), id);
                        System.out.println(sql);
                    }
                }
            }
        }
        for (Integer id : idsToChange) {
            String sql = String.format("DELETE FROM agent WHERE AgentID = %d", id);
            System.out.println(sql);
        }
    }

    private StringBuilder addErrMsg(StringBuilder errMsgs, String msg) {
        StringBuilder msgs = errMsgs;
        if (msgs == null) {
            msgs = new StringBuilder();
        }
        msgs.append(msg);
        msgs.append("<BR>");
        return msgs;
    }

    protected boolean checkForValidDeletions(Integer mainId, HashSet<Integer> idsToChange) {
        String str;
        String sql;
        HashSet<String> idsInErrorHash = new HashSet<String>();
        StringBuilder errMsgs = null;
        String sqlFmt = "SELECT id, cnt, num  FROM (SELECT l.LoanID as id, COUNT(l.LoanID) as cnt, l.LoanNumber as num FROM loanagent la INNER JOIN loan l ON la.LoanID = l.LoanID WHERE la.AgentID in (%d,%d) GROUP BY l.LoanID) T1 WHERE cnt > 1";
        for (Integer id : idsToChange) {
            sql = String.format(sqlFmt, mainId, id);
            for (Object[] row : BasicSQLUtils.query(sql)) {
                str = row[2].toString();
                if (idsInErrorHash.contains(str)) continue;
                errMsgs = this.addErrMsg(errMsgs, String.format("For Loan %s it is using both Agents.", str));
                idsInErrorHash.add(str);
            }
        }
        sqlFmt = "SELECT id, cnt, num  FROM (SELECT ce.CollectingEventID as id, COUNT(ce.CollectingEventID) as cnt, ce.StartDate as num FROM collector c INNER JOIN collectingevent ce ON c.CollectingEventID = ce.CollectingEventID WHERE c.AgentID in (%d,%d) GROUP BY ce.CollectingEventID) T1 WHERE cnt > 1";
        for (Integer id : idsToChange) {
            sql = String.format(sqlFmt, mainId, id);
            for (Object[] row : BasicSQLUtils.query(sql)) {
                str = row[2].toString();
                if (idsInErrorHash.contains(str)) continue;
                errMsgs = this.addErrMsg(errMsgs, String.format("For CollectingEvent %s it is using both Agents.", str));
                idsInErrorHash.add(str);
            }
        }
        sqlFmt = "SELECT id, cnt, num  FROM (SELECT a.AccessionID as id, COUNT(a.AccessionID) as cnt, a.AccessionNumber as num FROM accessionagent aa INNER JOIN accession a ON aa.AccessionID = a.AccessionID WHERE aa.AgentID in (%d,%d) GROUP BY a.AccessionID) T1 WHERE cnt > 1";
        for (Integer id : idsToChange) {
            sql = String.format(sqlFmt, mainId, id);
            for (Object[] row : BasicSQLUtils.query(sql)) {
                str = row[2].toString();
                if (idsInErrorHash.contains(str)) continue;
                errMsgs = this.addErrMsg(errMsgs, String.format("For Accession %s it is using both Agents.", str));
                idsInErrorHash.add(str);
            }
        }
        sqlFmt = "SELECT id, cnt, num  FROM (SELECT r.RepositoryAgreementID as id, COUNT(r.RepositoryAgreementID) as cnt, r.RepositoryAgreementNumber as num FROM accessionagent a INNER JOIN repositoryagreement r ON a.RepositoryAgreementID = r.RepositoryAgreementID WHERE a.AgentID in (%d,%d) GROUP BY r.RepositoryAgreementID) T1 WHERE cnt > 1";
        for (Integer id : idsToChange) {
            sql = String.format(sqlFmt, mainId, id);
            for (Object[] row : BasicSQLUtils.query(sql)) {
                str = row[2].toString();
                if (idsInErrorHash.contains(str)) continue;
                errMsgs = this.addErrMsg(errMsgs, String.format("For RepositoryAgreement %s it is using both Agents.", str));
                idsInErrorHash.add(str);
            }
        }
        if (errMsgs != null) {
            JEditorPane pane = new JEditorPane("text/html", UIRegistry.getResourceString("UNHDL_EXCP"));
            pane.setEditable(false);
            pane.setOpaque(false);
            pane.setText(errMsgs.toString());
            JScrollPane sp = new JScrollPane(pane, 22, 32);
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
            pb.add((Component)UIHelper.createScrollPane(sp), new CellConstraints().xy(1, 1));
            pb.setDefaultDialogBorder();
            CustomDialog dlg = UIRegistry.getMostRecentWindow() instanceof Frame ? new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), "Errors", true, 1, (Component)pb.getPanel()) : new CustomDialog((Dialog)UIRegistry.getMostRecentWindow(), "Errors", true, 1, (Component)pb.getPanel());
            dlg.createUI();
            dlg.pack();
            dlg.setSize(Math.max(dlg.getPreferredSize().width, 350), Math.max(dlg.getPreferredSize().height, 350));
            UIHelper.centerAndShow(dlg);
            return false;
        }
        return true;
    }

    protected void displayTotals(ArrayList<Pair<String, Integer>> cntPairs, int totalCnt) {
        Vector<String> colNames = new Vector<String>();
        colNames.add("Table");
        colNames.add("Count");
        Vector rows = new Vector();
        for (Pair<String, Integer> p : cntPairs) {
            Vector<Object> row = new Vector<Object>();
            row.add(p.first);
            row.add(p.second);
            rows.add(row);
        }
        Vector<Object> row = new Vector<Object>();
        row.add("Total");
        row.add(totalCnt);
        rows.add(row);
        DefaultTableModel mdl = new DefaultTableModel(rows, colNames);
        JTable tbl = new JTable(mdl);
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
        pb.add((Component)UIHelper.createScrollPane(tbl), new CellConstraints().xy(1, 1));
        pb.setDefaultDialogBorder();
        CustomDialog dlg = new CustomDialog((Dialog)UIRegistry.getMostRecentWindow(), "Summary", true, 1, (Component)pb.getPanel());
        dlg.setVisible(true);
    }

    class DualValue
    extends Pair<Object, Object> {
        public DualValue() {
        }

        public DualValue(Object first, Object second) {
            super(first, second);
        }

        @Override
        public String toString() {
            return this.first != null ? this.first.toString() : "";
        }
    }
}

