/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgrCallerIFace;
import edu.ku.brc.ui.UIRegistry;

public class TreeDefStatus {
    protected static String nodeNumbersInvalid = "BadNodes";
    protected static String numberingNodes = "UpdateNodes";
    protected final TreeDefIface<?, ?, ?> treeDef;
    protected boolean doNodeNumberUpdates;
    protected boolean uploadInProgress;

    public TreeDefStatus(TreeDefIface<?, ?, ?> treeDef) {
        this.treeDef = treeDef;
        this.doNodeNumberUpdates = true;
        this.uploadInProgress = false;
    }

    public synchronized boolean isNodeNumbersAreUpToDate() {
        return !TaskSemaphoreMgr.isLocked(this.getNodeNumberUptoDateLockTitle(), this.getNodeNumberUptoDateLockName(), TaskSemaphoreMgr.SCOPE.Discipline);
    }

    public synchronized boolean setNodeNumbersAreUpToDate(boolean nodeNumbersAreUpToDate) {
        boolean current = this.isNodeNumbersAreUpToDate();
        if (current != nodeNumbersAreUpToDate) {
            if (!nodeNumbersAreUpToDate) {
                return TaskSemaphoreMgr.lock(this.getNodeNumberUptoDateLockTitle(), this.getNodeNumberUptoDateLockName(), null, TaskSemaphoreMgr.SCOPE.Discipline, true) == TaskSemaphoreMgr.USER_ACTION.OK;
            }
            return TaskSemaphoreMgr.unlock(this.getNodeNumberUptoDateLockTitle(), this.getNodeNumberUptoDateLockName(), TaskSemaphoreMgr.SCOPE.Discipline);
        }
        return true;
    }

    public synchronized boolean isRenumberingNodes() {
        return TaskSemaphoreMgr.isLocked(this.getNodeNumberingLockTitle(), this.getNodeNumberingLockName(), TaskSemaphoreMgr.SCOPE.Discipline);
    }

    public synchronized boolean setRenumberingNodes(boolean isRenumberingNodes) {
        boolean current = this.isRenumberingNodes();
        if (current != isRenumberingNodes) {
            if (isRenumberingNodes) {
                return TaskSemaphoreMgr.lock(this.getNodeNumberingLockTitle(), this.getNodeNumberingLockName(), null, TaskSemaphoreMgr.SCOPE.Discipline, true) == TaskSemaphoreMgr.USER_ACTION.OK;
            }
            return TaskSemaphoreMgr.unlock(this.getNodeNumberingLockTitle(), this.getNodeNumberingLockName(), TaskSemaphoreMgr.SCOPE.Discipline);
        }
        return true;
    }

    public synchronized boolean isDoNodeNumberUpdates() {
        return this.doNodeNumberUpdates;
    }

    public synchronized void setDoNodeNumberUpdates(boolean doNodeNumberUpdates) {
        this.doNodeNumberUpdates = doNodeNumberUpdates;
    }

    public synchronized boolean isUploadInProgress() {
        return this.uploadInProgress;
    }

    public synchronized void setUploadInProgress(boolean uploadInProgress) {
        this.uploadInProgress = uploadInProgress;
    }

    protected String getTreeLockTitle() {
        return this.treeDef.getClass().getSimpleName();
    }

    protected String getNodeNumberingLockTitle() {
        return String.format(UIRegistry.getResourceString("BaseTreeDef.numberingNodes"), this.treeDef.getNodeClass().getSimpleName());
    }

    protected String getNodeNumberUptoDateLockTitle() {
        return String.format(UIRegistry.getResourceString("BaseTreeDef.nodeNumbersInvalid"), this.treeDef.getNodeClass().getSimpleName());
    }

    protected String getNodeNumberingLockName() {
        return String.valueOf(numberingNodes) + this.treeDef.getNodeClass().getSimpleName();
    }

    protected String getNodeNumberUptoDateLockName() {
        return String.valueOf(nodeNumbersInvalid) + this.treeDef.getNodeClass().getSimpleName();
    }

    protected String getTreeLockName() {
        return this.treeDef.getClass().getSimpleName();
    }

    public boolean lockTree(TaskSemaphoreMgrCallerIFace lockCallback) {
        TaskSemaphoreMgr.USER_ACTION action = TaskSemaphoreMgr.lock(this.getTreeLockTitle(), this.getTreeLockName(), null, TaskSemaphoreMgr.SCOPE.Discipline, false, lockCallback, true);
        if (action == TaskSemaphoreMgr.USER_ACTION.Override) {
            if (TaskSemaphoreMgr.unlock(this.getTreeLockTitle(), this.getTreeLockName(), TaskSemaphoreMgr.SCOPE.Discipline)) {
                action = TaskSemaphoreMgr.lock(this.getTreeLockTitle(), this.getTreeLockName(), null, TaskSemaphoreMgr.SCOPE.Discipline, false);
            } else {
                return false;
            }
        }
        return action == TaskSemaphoreMgr.USER_ACTION.OK;
    }

    public boolean unlockTree() {
        return TaskSemaphoreMgr.unlock(this.getTreeLockTitle(), this.getTreeLockName(), TaskSemaphoreMgr.SCOPE.Discipline);
    }
}

