/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import com.mysql.jdbc.exceptions.jdbc4.CommunicationsException;
import com.mysql.jdbc.exceptions.jdbc4.MySQLNonTransientConnectionException;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.StaleObjectException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpTaskSemaphore;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgrCallerIFace;
import edu.ku.brc.ui.UIRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TaskSemaphoreMgr {
    private static final Logger log = Logger.getLogger(TaskSemaphoreMgr.class);
    private static boolean previouslyLocked = false;
    private static String prevLockedBy = null;

    public static boolean isLocked(String title, String name, SCOPE scope) {
        Discipline discipline = scope == SCOPE.Discipline ? AppContextMgr.getInstance().getClassObject(Discipline.class) : null;
        Collection collection = scope == SCOPE.Collection ? AppContextMgr.getInstance().getClassObject(Collection.class) : null;
        Connection connection = DBConnection.getInstance().getConnection();
        if (connection != null) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                String sql = TaskSemaphoreMgr.buildSQL(name, scope, discipline, collection);
                stmt = connection.createStatement();
                rs = stmt.executeQuery(sql);
                if (rs != null && rs.next()) {
                    boolean bl = rs.getBoolean(1);
                    return bl;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean isLockedOrInUse(String title, String name, SCOPE scope) {
        Discipline discipline = scope == SCOPE.Discipline ? AppContextMgr.getInstance().getClassObject(Discipline.class) : null;
        Collection collection = scope == SCOPE.Collection ? AppContextMgr.getInstance().getClassObject(Collection.class) : null;
        Connection connection = DBConnection.getInstance().getConnection();
        if (connection != null) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                String sql = TaskSemaphoreMgr.buildSQL(name, scope, discipline, collection, "IsLocked, UsageCount");
                stmt = connection.createStatement();
                rs = stmt.executeQuery(sql);
                if (rs != null && rs.next()) {
                    Integer count = rs.getInt(2);
                    boolean bl = rs.getBoolean(1) || count != null && count > 0;
                    return bl;
                }
                return false;
            }
            catch (CommunicationsException ex) {
                UIRegistry.showLocalizedMsg("TIMEOUT_ERR");
            }
            catch (MySQLNonTransientConnectionException ex) {
                UIRegistry.showLocalizedMsg("TIMEOUT_ERR");
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
                log.error((Object)ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
                    log.error((Object)ex);
                }
            }
        }
        return false;
    }

    public static SpTaskSemaphore getLockInfo(String title, String name, SCOPE scope) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            Discipline discipline = scope == SCOPE.Discipline ? AppContextMgr.getInstance().getClassObject(Discipline.class) : null;
            Collection collection = scope == SCOPE.Collection ? AppContextMgr.getInstance().getClassObject(Collection.class) : null;
            SpTaskSemaphore semaphore = TaskSemaphoreMgr.getSemaphore(session, name, scope, discipline, collection);
            if (semaphore != null && semaphore.getOwner() != null && semaphore.getOwner().getAgents() != null) {
                semaphore.getOwner().getAgents().size();
            }
            SpTaskSemaphore spTaskSemaphore = semaphore;
            return spTaskSemaphore;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        throw new RuntimeException("Error getting lock info [" + title + "]");
    }

    public static boolean askUserToUnlock(String title, String name, SCOPE scope) {
        SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        Discipline discipline = scope == SCOPE.Discipline ? AppContextMgr.getInstance().getClassObject(Discipline.class) : null;
        Collection collection = scope == SCOPE.Collection ? AppContextMgr.getInstance().getClassObject(Collection.class) : null;
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            SpTaskSemaphore semaphore = null;
            try {
                semaphore = TaskSemaphoreMgr.getSemaphore(session, name, scope, discipline, collection);
            }
            catch (StaleObjectException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
                semaphore = null;
            }
            if (semaphore != null) {
                if (!(semaphore.getIsLocked().booleanValue() || semaphore.getUsageCount() != null && semaphore.getUsageCount() > 0)) {
                    return false;
                }
                String currMachineName = InetAddress.getLocalHost().toString();
                String dbMachineName = semaphore.getMachineName();
                if (StringUtils.isNotEmpty((String)dbMachineName) && StringUtils.isNotEmpty((String)currMachineName) && currMachineName.equals(dbMachineName) && semaphore.getOwner() != null && user != null && user.getId().equals(semaphore.getOwner().getId())) {
                    int options = 0;
                    Object[] optionLabels = new String[]{UIRegistry.getResourceString("SpTaskSemaphore.OVERRIDE"), UIRegistry.getResourceString("CANCEL")};
                    int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("SpTaskSemaphore.IN_USE_BY_YOU_UNLK", title, title), UIRegistry.getResourceString("SpTaskSemaphore.IN_USE_TITLE"), options, 3, null, optionLabels, 1);
                    boolean bl = userChoice == 0;
                    return bl;
                }
                String userStr = prevLockedBy != null ? prevLockedBy : semaphore.getOwner().getIdentityTitle();
                String msg = UIRegistry.getLocalizedMessage("SpTaskSemaphore.IN_USE_OV_UNLK", title, userStr, semaphore.getLockedTime() == null ? "?" : semaphore.getLockedTime().toString());
                int options = 0;
                Object[] optionLabels = new String[]{UIRegistry.getResourceString("SpTaskSemaphore.OVERRIDE"), UIRegistry.getResourceString("CANCEL")};
                int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), msg, UIRegistry.getResourceString("SpTaskSemaphore.IN_USE_TITLE"), options, 3, null, optionLabels, 1);
                boolean bl = userChoice == 0;
                return bl;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return false;
    }

    public static boolean unlock(String title, String name, SCOPE scope) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            int count = 0;
            boolean lockWasRemoved = false;
            do {
                try {
                    boolean bl = lockWasRemoved = TaskSemaphoreMgr.setLock(session, name, null, scope, false, false, false) != null;
                    if (!lockWasRemoved) continue;
                    break;
                }
                catch (StaleObjectException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
                    lockWasRemoved = false;
                }
            } while (++count < 3);
            return lockWasRemoved;
            {
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return false;
    }

    public static USER_ACTION lock(String title, String name, String context, SCOPE scope, boolean allViewMode) {
        return TaskSemaphoreMgr.lock(title, name, context, scope, allViewMode, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static USER_ACTION lock(String title, String name, String context, SCOPE scope, boolean allViewMode, TaskSemaphoreMgrCallerIFace caller, boolean checkUsage) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            int count = 0;
            while (true) {
                SpTaskSemaphore semaphore = null;
                try {
                    semaphore = TaskSemaphoreMgr.setLock(session, name, context, scope, true, false, checkUsage);
                }
                catch (StaleObjectException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
                    semaphore = null;
                }
                if (semaphore != null && !previouslyLocked) {
                    USER_ACTION uSER_ACTION = USER_ACTION.OK;
                    return uSER_ACTION;
                }
                if (caller != null) {
                    USER_ACTION uSER_ACTION = caller.resolveConflict(semaphore, previouslyLocked, prevLockedBy);
                    return uSER_ACTION;
                }
                if (semaphore == null) {
                    String msg = UIRegistry.getLocalizedMessage("SpTaskSemaphore.IN_USE", title);
                    Object[] options = new Object[]{UIRegistry.getResourceString("SpTaskSemaphore.TRYAGAIN"), UIRegistry.getResourceString("CANCEL")};
                    int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), msg, UIRegistry.getResourceString("SpTaskSemaphore.IN_USE_TITLE"), 0, 3, null, options, options[0]);
                    if (userChoice == 1) {
                        USER_ACTION uSER_ACTION = USER_ACTION.Cancel;
                        return uSER_ACTION;
                    }
                } else {
                    Object[] optionLabels;
                    int options;
                    int defBtn;
                    SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                    String currMachineName = InetAddress.getLocalHost().toString();
                    String dbMachineName = semaphore.getMachineName();
                    if (StringUtils.isNotEmpty((String)dbMachineName) && StringUtils.isNotEmpty((String)currMachineName) && currMachineName.equals(dbMachineName) && semaphore.getOwner() != null && user != null && user.getId().equals(semaphore.getOwner().getId())) {
                        Object[] optionLabels2;
                        if (!allViewMode) {
                            int options3 = 0;
                            optionLabels2 = new String[]{UIRegistry.getResourceString("OK")};
                            JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("SpTaskSemaphore.IN_USE_BY_YOU", title), UIRegistry.getResourceString("SpTaskSemaphore.IN_USE_TITLE"), options3, 3, null, optionLabels2, 0);
                            USER_ACTION uSER_ACTION = USER_ACTION.Cancel;
                            return uSER_ACTION;
                        }
                        int options2 = 0;
                        optionLabels2 = new String[]{UIRegistry.getResourceString("SpTaskSemaphore.VIEWMODE"), UIRegistry.getResourceString("CANCEL")};
                        int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("SpTaskSemaphore.IN_USE_BY_YOU", title), UIRegistry.getResourceString("SpTaskSemaphore.IN_USE_TITLE"), options2, 3, null, optionLabels2, 0);
                        USER_ACTION uSER_ACTION = userChoice == 1 ? USER_ACTION.Cancel : USER_ACTION.ViewMode;
                        return uSER_ACTION;
                    }
                    String userStr = prevLockedBy != null ? prevLockedBy : semaphore.getOwner().getIdentityTitle();
                    String msgKey = allViewMode ? "SpTaskSemaphore.IN_USE_OV" : "SpTaskSemaphore.IN_USE";
                    String msg = UIRegistry.getLocalizedMessage(msgKey, title, userStr, semaphore.getLockedTime() != null ? semaphore.getLockedTime().toString() : "");
                    if (allViewMode) {
                        defBtn = 2;
                        options = 1;
                        optionLabels = new String[]{UIRegistry.getResourceString("SpTaskSemaphore.VIEWMODE"), UIRegistry.getResourceString("SpTaskSemaphore.TRYAGAIN"), UIRegistry.getResourceString("CANCEL")};
                    } else {
                        defBtn = 0;
                        options = 0;
                        optionLabels = new String[]{UIRegistry.getResourceString("SpTaskSemaphore.TRYAGAIN"), UIRegistry.getResourceString("CANCEL")};
                    }
                    int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), msg, UIRegistry.getResourceString("SpTaskSemaphore.IN_USE_TITLE"), options, 3, null, optionLabels, defBtn);
                    if (userChoice == 0) {
                        if (options == 1) {
                            USER_ACTION uSER_ACTION = USER_ACTION.ViewMode;
                            return uSER_ACTION;
                        }
                    } else if (userChoice == 1) {
                        if (options == 0) {
                            USER_ACTION uSER_ACTION = USER_ACTION.Cancel;
                            return uSER_ACTION;
                        }
                    } else if (userChoice == 2) {
                        USER_ACTION uSER_ACTION = USER_ACTION.Cancel;
                        return uSER_ACTION;
                    }
                }
                ++count;
                continue;
                break;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
            ex.printStackTrace();
            return USER_ACTION.Error;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static boolean incrementUsageCount(String title, String name, SCOPE scope) {
        return TaskSemaphoreMgr.updateUsageCount(title, name, scope, 1);
    }

    public static boolean decrementUsageCount(String title, String name, SCOPE scope) {
        return TaskSemaphoreMgr.updateUsageCount(title, name, scope, -1);
    }

    public static boolean clearUsageCount(String title, String name, SCOPE scope) {
        return TaskSemaphoreMgr.updateUsageCount(title, name, scope, null);
    }

    private static boolean updateUsageCount(String title, String name, SCOPE scope, Integer increment) {
        if (TaskSemaphoreMgr.isLocked(title, name, scope)) {
            return false;
        }
        boolean result = false;
        boolean inTransaction = false;
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                Discipline discipline = scope == SCOPE.Discipline ? AppContextMgr.getInstance().getClassObject(Discipline.class) : null;
                Collection collection = scope == SCOPE.Collection ? AppContextMgr.getInstance().getClassObject(Collection.class) : null;
                user = user != null ? session.getData(SpecifyUser.class, "id", user.getId(), DataProviderSessionIFace.CompareType.Equals) : null;
                discipline = discipline != null ? session.getData(Discipline.class, "id", discipline.getId(), DataProviderSessionIFace.CompareType.Equals) : null;
                collection = collection != null ? session.getData(Collection.class, "id", collection.getId(), DataProviderSessionIFace.CompareType.Equals) : null;
                session.beginTransaction();
                inTransaction = true;
                SpTaskSemaphore semaphore = TaskSemaphoreMgr.getSemaphore(session, name, scope, discipline, collection);
                if (semaphore == null) {
                    semaphore = new SpTaskSemaphore();
                    semaphore = new SpTaskSemaphore();
                    semaphore.initialize();
                    semaphore.setTaskName(name);
                    semaphore.setTimestampCreated(now);
                    semaphore.setOwner(user);
                    semaphore.setScope((byte)scope.ordinal());
                    semaphore.setDiscipline(discipline);
                    semaphore.setCollection(collection);
                }
                Integer count = semaphore.getUsageCount() == null ? 0 : semaphore.getUsageCount();
                if (increment == null) {
                    semaphore.setUsageCount(null);
                } else {
                    Integer newCount = new Integer(count + increment);
                    if (newCount < 0) {
                        log.error((Object)("attempt to set usage count for " + name + "to " + newCount));
                        newCount = 0;
                    }
                    semaphore.setUsageCount(newCount);
                }
                session.saveOrUpdate(semaphore);
                session.commit();
                result = true;
            }
            catch (Exception ex) {
                if (inTransaction) {
                    session.rollback();
                }
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, ex);
                ex.printStackTrace();
                session.close();
            }
        }
        finally {
            session.close();
        }
        return result;
    }

    private static String buildHQL(String name, SCOPE scope, Discipline discipline, Collection collection) {
        StringBuilder joins = new StringBuilder();
        StringBuilder where = new StringBuilder();
        if (discipline != null) {
            where.append(" AND d.disciplineId = ");
            where.append(discipline.getId());
            joins.append("INNER JOIN ts.discipline d ");
        } else if (collection != null) {
            where.append(" AND ts.collectionId = ");
            where.append(collection.getId());
            joins.append("INNER JOIN ts.collection c ");
        }
        StringBuilder sb = new StringBuilder("FROM SpTaskSemaphore ts ");
        sb.append((CharSequence)joins);
        String wStr = String.format("WHERE taskName = '%s' AND scope = %d ", name, scope.ordinal());
        sb.append(wStr);
        sb.append((CharSequence)where);
        return sb.toString();
    }

    private static String buildSQL(String name, SCOPE scope, Discipline discipline, Collection collection) {
        return TaskSemaphoreMgr.buildSQL(name, scope, discipline, collection, "IsLocked");
    }

    private static String buildSQL(String name, SCOPE scope, Discipline discipline, Collection collection, String fldsToSelect) {
        StringBuilder joins = new StringBuilder();
        StringBuilder where = new StringBuilder();
        if (discipline != null) {
            where.append(" AND d.DisciplineID = ");
            where.append(discipline.getId());
            joins.append("INNER JOIN discipline d ON d.DisciplineID = ts.DisciplineID ");
        } else if (collection != null) {
            where.append(" AND ts.CollectionID = ");
            where.append(collection.getId());
            joins.append("INNER JOIN collection c ON c.CollectionID = ts.CollectionID ");
        }
        StringBuilder sb = new StringBuilder("SELECT " + fldsToSelect + " FROM sptasksemaphore ts ");
        sb.append((CharSequence)joins);
        String wStr = String.format("WHERE TaskName = '%s' AND Scope = %d ", name, scope.ordinal());
        sb.append(wStr);
        sb.append((CharSequence)where);
        return sb.toString();
    }

    private static SpTaskSemaphore getSemaphore(DataProviderSessionIFace session, String name, SCOPE scope, Discipline discipline, Collection collection) throws Exception {
        String sql = TaskSemaphoreMgr.buildHQL(name, scope, discipline, collection);
        Object data = session.getData(sql);
        if (data instanceof SpTaskSemaphore) {
            return (SpTaskSemaphore)data;
        }
        Object[] cols = (Object[])data;
        return cols != null && cols.length > 0 ? (SpTaskSemaphore)cols[0] : null;
    }

    public static boolean doesOwnSemaphore(String name, SCOPE scope) {
        SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        String sqlStr = String.format("SELECT count(*) FROM sptasksemaphore WHERE TaskName = '%s' AND Scope = %d AND OwnerID = %d AND IsLocked <> 0", name, scope.ordinal(), user.getId());
        return BasicSQLUtils.getCount(sqlStr) > 0;
    }

    private static SpTaskSemaphore setLock(DataProviderSessionIFace session, String name, String context, SCOPE scope, boolean doLock, boolean doOverride, boolean checkUsage) throws Exception {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        Discipline discipline = scope == SCOPE.Discipline ? AppContextMgr.getInstance().getClassObject(Discipline.class) : null;
        Collection collection = scope == SCOPE.Collection ? AppContextMgr.getInstance().getClassObject(Collection.class) : null;
        user = user != null ? session.getData(SpecifyUser.class, "id", user.getId(), DataProviderSessionIFace.CompareType.Equals) : null;
        SpTaskSemaphore semaphore = TaskSemaphoreMgr.getSemaphore(session, name, scope, discipline = discipline != null ? session.getData(Discipline.class, "id", discipline.getId(), DataProviderSessionIFace.CompareType.Equals) : null, collection = collection != null ? session.getData(Collection.class, "id", collection.getId(), DataProviderSessionIFace.CompareType.Equals) : null);
        if (semaphore != null) {
            boolean locked;
            boolean bl = locked = semaphore.getIsLocked() != false || checkUsage && semaphore.getUsageCount() != null && semaphore.getUsageCount() > 0;
            if (doLock) {
                if (locked && !doOverride) {
                    previouslyLocked = true;
                    prevLockedBy = semaphore.getOwner() != null && semaphore.getOwner().getAgents() != null && semaphore.getOwner().getAgents().size() > 0 ? semaphore.getOwner().getAgents().iterator().next().getIdentityTitle() : null;
                    return semaphore;
                }
            } else if (!semaphore.getIsLocked().booleanValue()) {
                log.error((Object)"Trying to unlock when already unlocked!");
            }
            previouslyLocked = locked;
        } else if (doLock) {
            semaphore = new SpTaskSemaphore();
            semaphore.initialize();
            semaphore.setTaskName(name);
            semaphore.setTimestampCreated(now);
            semaphore.setOwner(user);
            previouslyLocked = false;
        } else {
            log.error((Object)"Try to unlock when there is no lock.");
            return null;
        }
        semaphore.setIsLocked(doLock);
        semaphore.setContext(context);
        String machineName = "";
        try {
            machineName = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        machineName = StringUtils.isNotEmpty((String)machineName) ? machineName.substring(0, Math.min(64, machineName.length())) : null;
        semaphore.setMachineName(doLock ? machineName : null);
        semaphore.setScope(new Byte((byte)scope.ordinal()));
        semaphore.setLockedTime(now);
        semaphore.setUsageCount(null);
        semaphore.setTimestampModified(now);
        semaphore.setDiscipline(discipline);
        semaphore.setCollection(collection);
        semaphore.setOwner(user);
        session.beginTransaction();
        session.saveOrUpdate(semaphore);
        session.commit();
        return semaphore;
    }

    public static enum SCOPE {
        Global,
        Discipline,
        Collection;

    }

    public static enum USER_ACTION {
        OK,
        Error,
        Cancel,
        ViewMode,
        Override;

    }
}

