/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.SchemaUpdateService;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEventAttribute;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.FieldNotebookPage;
import edu.ku.brc.specify.datamodel.GeoCoordDetail;
import edu.ku.brc.specify.datamodel.LocalityDetail;
import edu.ku.brc.specify.datamodel.PaleoContext;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpTaskSemaphore;
import edu.ku.brc.specify.datamodel.SpVersion;
import edu.ku.brc.specify.dbsupport.BuildFromGeonames;
import edu.ku.brc.specify.dbsupport.HibernateDataProviderSession;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.tasks.subpane.security.NavigationTreeMgr;
import edu.ku.brc.specify.tools.SpecifySchemaGenerator;
import edu.ku.brc.specify.tools.export.ExportToMySQLDB;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.LatLonConverter;
import edu.ku.brc.util.Pair;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SpecifySchemaUpdateService
extends SchemaUpdateService {
    protected static final Logger log = Logger.getLogger(SpecifySchemaUpdateService.class);
    private final int OVERALL_TOTAL = 34;
    private static final String TINYINT4 = "TINYINT(4)";
    private static final String APP = "App";
    private static final String APP_REQ_EXIT = "AppReqExit";
    private static final String SCHEMA_VERSION_FILENAME = "schema_version.xml";
    private static final String UPD_CNT_NO_MATCH = "Update count didn't match for update to table: %s";
    private static final String COL_TYP_NO_DET = "Column type couldn't be determined for update to table %s";
    private static final String ERR_ADDING_FIELDS = "For table %s error adding fields %s";
    private Pair<String, String> itUserNamePassword = null;
    private ProgressFrame frame;
    private String errMsgStr = null;

    @Override
    public String getDBSchemaVersionFromXML() {
        String dbVersion = null;
        try {
            Element root = XMLHelper.readFileToDOM4J(new FileInputStream(XMLHelper.getConfigDirPath(SCHEMA_VERSION_FILENAME)));
            if (root != null) {
                dbVersion = root.getTextTrim();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbVersion;
    }

    protected boolean isInternalVerNum(String appVerNumArg) {
        if (appVerNumArg != null) {
            String[] pieces = StringUtils.split((String)appVerNumArg, (String)".");
            int p = 0;
            while (p < pieces.length) {
                try {
                    new Integer(pieces[p]);
                }
                catch (NumberFormatException ex) {
                    return true;
                }
                ++p;
            }
        }
        return false;
    }

    private static String mkKey(String shortKey) {
        return "SpecifySchemaUpdateService." + shortKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaUpdateService.SchemaUpdateType updateSchema(String appVerNumber, String username) {
        Integer recVerNum;
        Integer spverId;
        String schemaVerFromDB;
        String appVerFromDB;
        boolean doInsert;
        boolean doSchemaUpdate;
        boolean doUpdateAppVer;
        DBMSUserMgr dbMgr;
        DBConnection dbConn;
        boolean useSilentSuccess;
        String appVerNum;
        String dbVersion;
        block39: {
            block37: {
                block38: {
                    Vector<Object[]> data;
                    dbVersion = this.getDBSchemaVersionFromXML();
                    appVerNum = appVerNumber;
                    boolean internalVerNum = this.isInternalVerNum(appVerNum);
                    useSilentSuccess = false;
                    dbConn = DBConnection.getInstance();
                    if (dbConn == null) return SchemaUpdateService.SchemaUpdateType.Error;
                    SpVersion.fixSchemaNumber(dbConn);
                    dbMgr = DBMSUserMgr.getInstance();
                    if (!dbMgr.connect(dbConn.getUserName(), dbConn.getPassword(), dbConn.getServerName(), dbConn.getDatabaseName())) return SchemaUpdateService.SchemaUpdateType.Error;
                    if (dbMgr.doesFieldExistInTable("institution", "IsReleaseManagedGlobally") && (data = BasicSQLUtils.query(dbMgr.getConnection(), "SELECT IsReleaseManagedGlobally, CurrentManagedRelVersion FROM institution")) != null && data.size() > 0) {
                        String curRelease;
                        Object[] row = data.get(0);
                        Boolean isManagedByDB = (Boolean)row[0];
                        String managedRelNumber = (String)row[1];
                        boolean isReleaseManager = AppPreferences.getLocalPrefs().getBoolean("RELEASE_MANAGER", false);
                        boolean isManagedRelease = !isReleaseManager && isManagedByDB != null && isManagedByDB != false;
                        AppPreferences.getLocalPrefs().putBoolean("MANAGED_RELEASES", isManagedRelease);
                        if (isManagedRelease && StringUtils.isNotEmpty((String)(curRelease = UIHelper.getInstall4JInstallString())) && StringUtils.isNotEmpty((String)managedRelNumber) && !curRelease.equals(managedRelNumber)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CommandDispatcher.dispatch(new CommandAction(SpecifySchemaUpdateService.APP, "CheckForUpdates"));
                                }
                            });
                        }
                    }
                    doUpdateAppVer = false;
                    doSchemaUpdate = false;
                    doInsert = false;
                    appVerFromDB = null;
                    schemaVerFromDB = null;
                    spverId = null;
                    recVerNum = 1;
                    if (!dbMgr.doesDBHaveTable("spversion")) break block37;
                    Vector<Object[]> rows = BasicSQLUtils.query(dbConn.getConnection(), "SELECT AppVersion, SchemaVersion, SpVersionID, Version FROM spversion ORDER BY TimestampCreated DESC");
                    if (rows.size() <= 0) break block38;
                    Object[] row = rows.get(rows.size() - 1);
                    appVerFromDB = row[0].toString();
                    schemaVerFromDB = row[1].toString();
                    spverId = (Integer)row[2];
                    recVerNum = (Integer)row[3];
                    log.debug((Object)("appVerNumArg: [" + appVerNumber + "] dbVersion from XML[" + dbVersion + "] appVersion[" + appVerFromDB + "] schemaVersion[" + schemaVerFromDB + "]  spverId[" + spverId + "]  recVerNum[" + recVerNum + "] "));
                    if (appVerNum == null || internalVerNum) {
                        appVerNum = appVerFromDB;
                    }
                    if (appVerFromDB == null || schemaVerFromDB == null) {
                        doUpdateAppVer = true;
                    } else if (!appVerFromDB.equals(appVerNum)) {
                        if (!this.checkVersion(appVerFromDB, appVerNum, SpecifySchemaUpdateService.mkKey("APP_VER_ERR"), SpecifySchemaUpdateService.mkKey("APP_VER_NEQ_OLD"), SpecifySchemaUpdateService.mkKey("APP_VER_NEQ_NEW"), false)) {
                            CommandDispatcher.dispatch(new CommandAction(APP, APP_REQ_EXIT, null));
                            return SchemaUpdateService.SchemaUpdateType.Error;
                        }
                        doUpdateAppVer = true;
                    }
                    String schemaVers = AppPreferences.getLocalPrefs().get("UPDATE_SCHEMA", null);
                    if (schemaVers != null) {
                        AppPreferences.getLocalPrefs().remove("UPDATE_SCHEMA");
                        schemaVerFromDB = schemaVers;
                    }
                    if (dbVersion != null && schemaVerFromDB != null) {
                        Boolean isDBClosed = false;
                        String dbClosedBy = null;
                        if (schemaVerFromDB.compareTo("1.6") > -1 && (rows = BasicSQLUtils.query(dbConn.getConnection(), "SELECT IsDBClosed, DbClosedBy FROM spversion ORDER BY TimestampCreated DESC")).size() > 0) {
                            row = rows.get(rows.size() - 1);
                            isDBClosed = (Boolean)row[0];
                            dbClosedBy = (String)row[1];
                        }
                        if (isDBClosed != null && isDBClosed.booleanValue() && dbClosedBy != null && !dbClosedBy.equals(username)) {
                            UIRegistry.showLocalizedError("SYSSTP_CLSD_MSG", dbClosedBy);
                            return SchemaUpdateService.SchemaUpdateType.Error;
                        }
                        if (!schemaVerFromDB.equals(dbVersion)) {
                            String errKey = SpecifySchemaUpdateService.mkKey("DB_VER_NEQ");
                            if (!this.checkVersion(schemaVerFromDB, dbVersion, SpecifySchemaUpdateService.mkKey("DB_VER_ERR"), errKey, errKey, false)) {
                                CommandDispatcher.dispatch(new CommandAction(APP, APP_REQ_EXIT, null));
                                return SchemaUpdateService.SchemaUpdateType.Error;
                            }
                            doSchemaUpdate = true;
                        }
                    }
                    break block39;
                }
                doUpdateAppVer = true;
                if (appVerNumber != null && appVerNumber.length() > 2) {
                    doSchemaUpdate = true;
                    useSilentSuccess = true;
                }
                break block39;
            }
            doInsert = true;
        }
        try {
            if (doSchemaUpdate || doInsert || doUpdateAppVer) {
                boolean onlyAppVersion;
                this.fixDuplicatedPaleoContexts(dbConn.getConnection());
                if (doSchemaUpdate || doInsert) {
                    int permissions;
                    if (!SpecifySchemaUpdateService.askToUpdateSchema()) {
                        CommandDispatcher.dispatch(new CommandAction(APP, APP_REQ_EXIT, null));
                        SchemaUpdateService.SchemaUpdateType schemaUpdateType = SchemaUpdateService.SchemaUpdateType.Error;
                        return schemaUpdateType;
                    }
                    String msg = UIRegistry.getResourceString("UPDATE_SCH_BACKUP");
                    int opt = UIRegistry.askYesNoLocalized("EXIT", "CONTINUE", msg, "MySQLBackupService.BACKUP_NOW");
                    if (opt == 0) {
                        CommandDispatcher.dispatch(new CommandAction(APP, APP_REQ_EXIT, null));
                        SchemaUpdateService.SchemaUpdateType schemaUpdateType = SchemaUpdateService.SchemaUpdateType.Error;
                        return schemaUpdateType;
                    }
                    this.itUserNamePassword = DatabaseLoginPanel.getITUsernamePwd();
                    if (this.itUserNamePassword == null) {
                        CommandDispatcher.dispatch(new CommandAction(APP, APP_REQ_EXIT, null));
                        SchemaUpdateService.SchemaUpdateType schemaUpdateType = SchemaUpdateService.SchemaUpdateType.Error;
                        return schemaUpdateType;
                    }
                    DBConnection dbc = DBConnection.getInstance();
                    DBMSUserMgr dbmsMgr = DBMSUserMgr.getInstance();
                    if (dbmsMgr.connectToDBMS((String)this.itUserNamePassword.first, (String)this.itUserNamePassword.second, dbc.getServerName()) && ((permissions = dbmsMgr.getPermissionsForUpdate((String)this.itUserNamePassword.first, dbConn.getDatabaseName())) & 0x40) != 64) {
                        dbmsMgr.close();
                        this.errMsgList.add("You must have permissions to alter database tables.");
                        SchemaUpdateService.SchemaUpdateType schemaUpdateType = SchemaUpdateService.SchemaUpdateType.Error;
                        return schemaUpdateType;
                    }
                    dbmsMgr.close();
                    this.frame = new ProgressFrame(UIRegistry.getResourceString("UPDATE_SCHEMA_TITLE"));
                    this.frame.adjustProgressFrame();
                    this.frame.getCloseBtn().setVisible(false);
                    this.frame.getProcessProgress().setIndeterminate(true);
                    this.frame.setDesc(UIRegistry.getLocalizedMessage("UPDATE_SCHEMA", dbVersion));
                    this.frame.setOverall(0, 34);
                    UIHelper.centerAndShow(this.frame);
                    boolean ok = this.manuallyFixDB(DatabaseDriverInfo.getDriver(dbc.getDriver()), dbc.getServerName(), dbc.getDatabaseName(), (String)this.itUserNamePassword.first, (String)this.itUserNamePassword.second);
                    if (!ok) {
                        this.frame.setVisible(false);
                        SchemaUpdateService.SchemaUpdateType schemaUpdateType = SchemaUpdateService.SchemaUpdateType.Error;
                        return schemaUpdateType;
                    }
                    this.frame.setDesc("Updating Schema...");
                    ok = SpecifySchemaGenerator.updateSchema(DatabaseDriverInfo.getDriver(dbc.getDriver()), dbc.getServerName(), dbc.getDatabaseName(), (String)this.itUserNamePassword.first, (String)this.itUserNamePassword.second);
                    if (!ok) {
                        this.errMsgList.add("There was an error updating the schema.");
                        this.frame.setVisible(false);
                        SchemaUpdateService.SchemaUpdateType schemaUpdateType = SchemaUpdateService.SchemaUpdateType.Error;
                        return schemaUpdateType;
                    }
                    this.frame.setVisible(false);
                    this.fixSchemaMappingScope(dbConn.getConnection(), dbConn.getDatabaseName());
                    this.fixLocaleSchema();
                }
                if (doInsert || appVerFromDB == null && schemaVerFromDB == null) {
                    SpVersion.createInitialRecord(dbConn.getConnection(), appVerNum, dbVersion);
                } else if (doSchemaUpdate || doUpdateAppVer) {
                    this.fixDuplicatedPaleoContexts(dbConn.getConnection());
                    recVerNum = recVerNum + 1;
                    SpVersion.updateRecord(dbConn.getConnection(), appVerNum, dbVersion, recVerNum, spverId);
                }
                boolean bl = onlyAppVersion = !doSchemaUpdate && doUpdateAppVer;
                SchemaUpdateService.SchemaUpdateType schemaUpdateType = useSilentSuccess ? SchemaUpdateService.SchemaUpdateType.SuccessSilent : (onlyAppVersion ? SchemaUpdateService.SchemaUpdateType.SuccessAppVer : SchemaUpdateService.SchemaUpdateType.Success);
                return schemaUpdateType;
            }
            SchemaUpdateService.SchemaUpdateType schemaUpdateType = SchemaUpdateService.SchemaUpdateType.NotNeeded;
            return schemaUpdateType;
        }
        catch (Exception e) {
            e.printStackTrace();
            return SchemaUpdateService.SchemaUpdateType.Error;
        }
        finally {
            dbMgr.close();
        }
    }

    static void processUnhandledException(Throwable throwable) {
    }

    private static void attachUnhandledException() {
        log.debug((Object)("attachUnhandledException " + Thread.currentThread().getName() + " " + Thread.currentThread().hashCode()));
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                SpecifySchemaUpdateService.processUnhandledException(e);
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    log.debug((Object)("attachUnhandledException " + Thread.currentThread().getName() + " " + Thread.currentThread().hashCode()));
                    Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            SpecifySchemaUpdateService.processUnhandledException(e);
                        }
                    });
                }
            });
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                SpecifySchemaUpdateService.processUnhandledException(e);
            }
        });
    }

    private Integer getFieldLength(Connection conn, String databaseName, String tableName, String fieldName) {
        Vector<Object[]> rows = BasicSQLUtils.query(conn, "SELECT CHARACTER_MAXIMUM_LENGTH FROM `information_schema`.`COLUMNS` where TABLE_SCHEMA = '" + databaseName + "' and TABLE_NAME = '" + tableName + "' and COLUMN_NAME = '" + fieldName + "'");
        if (rows.size() == 0) {
            return null;
        }
        return ((Number)rows.get(0)[0]).intValue();
    }

    private String getFieldColumnType(Connection conn, String databaseName, String tableName, String fieldName) {
        Vector<Object[]> rows = BasicSQLUtils.query(conn, "SELECT COLUMN_TYPE FROM `information_schema`.`COLUMNS` where TABLE_SCHEMA = '" + databaseName + "' and TABLE_NAME = '" + tableName + "' and COLUMN_NAME = '" + fieldName + "'");
        if (rows.size() == 0) {
            return null;
        }
        return rows.get(0)[0].toString();
    }

    /*
     * Exception decompiling
     */
    private boolean manuallyFixDB(DatabaseDriverInfo dbdriverInfo, String hostname, String databaseName, String userName, String password) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 123[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void fixCollectorOrder(Connection conn) {
        try {
            String sql = "SELECT ID FROM (SELECT ce.CollectingEventID ID, COUNT(c.OrderNumber) CNT, MAX(c.OrderNumber) MX, MIN(c.OrderNumber) MN FROM collectingevent ce INNER JOIN collector c ON ce.CollectingEventID = c.CollectingEventID INNER JOIN agent a ON c.AgentID = a.AgentID GROUP BY ce.CollectingEventID) T1 WHERE MN <> 1 OR MX <> CNT ";
            PreparedStatement pStmt = conn.prepareStatement("SELECT CollectorID FROM collector WHERE CollectingEventID = ? ORDER BY OrderNumber");
            PreparedStatement pStmt2 = conn.prepareStatement("UPDATE collector SET OrderNumber = ? WHERE CollectorID = ?");
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int cnt = 0;
            while (rs.next()) {
                int order = 1;
                pStmt.setInt(1, rs.getInt(1));
                ResultSet rs2 = pStmt.executeQuery();
                while (rs2.next()) {
                    pStmt2.setInt(1, order++);
                    pStmt2.setInt(2, rs2.getInt(1));
                    if (pStmt2.executeUpdate() == 1) continue;
                    log.error((Object)("Error updating CollectorID " + rs2.getInt(1)));
                }
                rs2.close();
                if (++cnt % 10 != 0) continue;
                log.debug((Object)("Fixing Collector Ordering: " + cnt));
            }
            rs.close();
            stmt.close();
            pStmt.close();
            pStmt2.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean miscSchema16Updates(Connection conn, String databaseName) throws Exception {
        String[] instCols;
        String tblName = this.getTableTitleForFrame(SpVersion.getClassTableId());
        if (!this.doesColumnExist(databaseName, tblName, "IsDBClosed") && !this.checkAndAddColumns(conn, databaseName, tblName, instCols = new String[]{"IsDBClosed", "BIT(1)", "SchemaVersion", "DbClosedBy", "VARCHAR(32)", "IsDBClosed"})) {
            return false;
        }
        this.frame.incOverall();
        tblName = this.getTableTitleForFrame(GeoCoordDetail.getClassTableId());
        if (!this.doesColumnExist(databaseName, tblName, "UncertaintyPolygon") && !this.checkAndAddColumns(conn, databaseName, tblName, instCols = new String[]{"UncertaintyPolygon", "TEXT", "MaxUncertaintyEstUnit", "ErrorPolygon", "TEXT", "UncertaintyPolygon"})) {
            return false;
        }
        this.frame.incOverall();
        this.frame.setDesc("Fixing SrcLatLonUnit in Locality");
        this.fixSrcLatLongUnit(conn);
        this.frame.incOverall();
        this.frame.setDesc("Processing...");
        return true;
    }

    public static void createSGRTables(Connection conn, String databaseName) throws SQLException {
        String sql;
        if (!SpecifySchemaUpdateService.doesTableExist(databaseName, "sgrmatchconfiguration")) {
            sql = "CREATE TABLE `sgrmatchconfiguration` (`id`                       bigint(20)      NOT NULL AUTO_INCREMENT, `name`                     varchar(128)    NOT NULL, `similarityFields`         text            NOT NULL, `serverUrl`                text            NOT NULL, `filterQuery`              varchar(128)    NOT NULL, `queryFields`              text            NOT NULL, `remarks`                  text            NOT NULL, `boostInterestingTerms`    tinyint(1)      NOT NULL, `nRows`                    int(11)         NOT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            BasicSQLUtils.update(conn, sql);
        }
        if (!SpecifySchemaUpdateService.doesTableExist(databaseName, "sgrbatchmatchresultset")) {
            sql = "CREATE TABLE `sgrbatchmatchresultset` (`id`                       bigint(20)      NOT NULL AUTO_INCREMENT, `insertTime`               timestamp       NOT NULL, `name`                     varchar(128)    NOT NULL, `recordSetID`              bigint(20)      DEFAULT NULL, `matchConfigurationId`     bigint(20)      NOT NULL, `query`                    text            NOT NULL, `remarks`                  text            NOT NULL, `dbTableId`                int(11)         DEFAULT NULL, PRIMARY KEY (`id`), KEY `sgrbatchmatchresultsetfk2` (`matchConfigurationId`), CONSTRAINT `sgrbatchmatchresultsetfk2` FOREIGN KEY (`matchConfigurationId`) REFERENCES `sgrmatchconfiguration` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            BasicSQLUtils.update(conn, sql);
        }
        if (!SpecifySchemaUpdateService.doesTableExist(databaseName, "sgrbatchmatchresultitem")) {
            sql = "CREATE TABLE `sgrbatchmatchresultitem` ( `id`                       bigint(20)      NOT NULL AUTO_INCREMENT, `matchedId`                varchar(128)    NOT NULL, `maxScore`                 float           NOT NULL, `batchMatchResultSetId`    bigint(20)      NOT NULL, `qTime`                    int(11)         NOT NULL, PRIMARY KEY (`id`), KEY `sgrbatchmatchresultitemfk1` (`batchMatchResultSetId`), CONSTRAINT `sgrbatchmatchresultitemfk1` FOREIGN KEY (`batchMatchResultSetId`) REFERENCES `sgrbatchmatchresultset` (`id`) ON DELETE CASCADE ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            BasicSQLUtils.update(conn, sql);
        }
    }

    private LatLonConverter.FORMAT discoverUnitType(String latLonStr) {
        LatLonConverter.FORMAT fmt = LatLonConverter.FORMAT.None;
        if (StringUtils.isNotEmpty((String)latLonStr)) {
            int colonCnt = StringUtils.countMatches((String)latLonStr, (String)":");
            if (colonCnt == 0) {
                fmt = LatLonConverter.FORMAT.DDDDDD;
            } else if (colonCnt == 1) {
                fmt = LatLonConverter.FORMAT.DDMMMM;
            } else if (colonCnt == 2) {
                fmt = LatLonConverter.FORMAT.DDMMSS;
            }
        }
        return fmt;
    }

    public static boolean updateDNAAttachments(Connection conn) {
        boolean isInnoDB = true;
        Object[] createRow = BasicSQLUtils.queryForRow("SHOW CREATE TABLE collectionobject");
        if (createRow != null && createRow.length > 1) {
            isInnoDB = StringUtils.containsIgnoreCase((String)createRow[1].toString(), (String)"InnoDB");
        }
        String dbType = isInnoDB ? "InnoDB" : "MyISAM";
        String dnaSeqRunAttSQL = String.format("CREATE TABLE `dnasequencerunattachment` ( `DnaSequencingRunAttachmentId` int(11) NOT NULL AUTO_INCREMENT, `TimestampCreated` datetime NOT NULL, `TimestampModified` datetime DEFAULT NULL, `Version` int(11) DEFAULT NULL, `Ordinal` int(11) DEFAULT NULL, `Remarks` text, `ModifiedByAgentID` int(11) DEFAULT NULL, `AttachmentID` int(11) NOT NULL, `CreatedByAgentID` int(11) DEFAULT NULL, `DnaSequencingRunID` int(11) NOT NULL, PRIMARY KEY (`DnaSequencingRunAttachmentId`), KEY `FKD0DAEB167699B003` (`CreatedByAgentID`), KEY `FKD0DAEB1678F036AA` (`DnaSequencingRunID`), KEY `FKD0DAEB16C7E55084` (`AttachmentID`), KEY `FKD0DAEB165327F942` (`ModifiedByAgentID`), CONSTRAINT `FKD0DAEB165327F942` FOREIGN KEY (`ModifiedByAgentID`) REFERENCES `agent` (`AgentID`), CONSTRAINT `FKD0DAEB167699B003` FOREIGN KEY (`CreatedByAgentID`) REFERENCES `agent` (`AgentID`), CONSTRAINT `FKD0DAEB1678F036AA` FOREIGN KEY (`DnaSequencingRunID`) REFERENCES `dnasequencingrun` (`DNASequencingRunID`), CONSTRAINT `FKD0DAEB16C7E55084` FOREIGN KEY (`AttachmentID`) REFERENCES `attachment` (`AttachmentID`) ) ENGINE=%s DEFAULT CHARSET=utf8;", dbType);
        String dnaSeqAttSQL = String.format("CREATE TABLE `dnasequenceattachment` ( `DnaSequenceAttachmentId` int(11) NOT NULL AUTO_INCREMENT, `TimestampCreated` datetime NOT NULL, `TimestampModified` datetime DEFAULT NULL, `Version` int(11) DEFAULT NULL, `Ordinal` int(11) DEFAULT NULL, `Remarks` text, `AttachmentID` int(11) NOT NULL, `CreatedByAgentID` int(11) DEFAULT NULL, `DnaSequenceID` int(11) NOT NULL, `ModifiedByAgentID` int(11) DEFAULT NULL, PRIMARY KEY (`DnaSequenceAttachmentId`), KEY `FKFFC2E0FB265FB168` (`DnaSequenceID`), KEY `FKFFC2E0FB7699B003` (`CreatedByAgentID`), KEY `FKFFC2E0FBC7E55084` (`AttachmentID`), KEY `FKFFC2E0FB5327F942` (`ModifiedByAgentID`), CONSTRAINT `FKFFC2E0FB5327F942` FOREIGN KEY (`ModifiedByAgentID`) REFERENCES `agent` (`AgentID`), CONSTRAINT `FKFFC2E0FB265FB168` FOREIGN KEY (`DnaSequenceID`) REFERENCES `dnasequence` (`DnaSequenceID`), CONSTRAINT `FKFFC2E0FB7699B003` FOREIGN KEY (`CreatedByAgentID`) REFERENCES `agent` (`AgentID`), CONSTRAINT `FKFFC2E0FBC7E55084` FOREIGN KEY (`AttachmentID`) REFERENCES `attachment` (`AttachmentID`) ) ENGINE=%s DEFAULT CHARSET=utf8;", dbType);
        String insert = "INSERT INTO dnasequencerunattachment ( DnaSequencingRunAttachmentId, TimestampCreated, TimestampModified, Version, Ordinal, Remarks, AttachmentID, CreatedByAgentID, DnaSequencingRunID, ModifiedByAgentID) SELECT DnaSequencingRunAttachmentId, TimestampCreated, TimestampModified, Version, Ordinal, Remarks, AttachmentID, CreatedByAgentID, DnaSequencingRunID, ModifiedByAgentID FROM dnasequenceattachment ORDER BY DnaSequencingRunAttachmentId ASC";
        DBMSUserMgr dbMgr = DBMSUserMgr.getInstance();
        dbMgr.setConnection(conn);
        if (dbMgr.doesDBHaveTable("dnasequencerunattachment")) {
            log.error((Object)"dnasequencerunattachment already exists");
            return false;
        }
        int rv = BasicSQLUtils.update(conn, dnaSeqRunAttSQL);
        log.debug((Object)("Created dnasequencerunattachment: " + rv));
        if (rv != 0) {
            log.info((Object)("Failed creating dnasequencerunattachment: " + rv));
            return false;
        }
        int recCnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM dnasequenceattachment");
        log.debug((Object)("Number of dnasequenceattachment records: " + recCnt));
        if (recCnt > 0) {
            rv = BasicSQLUtils.update(conn, insert);
            log.debug((Object)("Moved Records dnasequencerunattachment: " + rv));
            if (rv != 0) {
                log.info((Object)("Failed moving records dnasequencerunattachment: " + rv));
                return false;
            }
        }
        rv = BasicSQLUtils.update(conn, "DROP TABLE dnasequenceattachment");
        log.debug((Object)("Dropped Old table dnasequenceattachment: " + rv));
        if (rv != 0) {
            log.info((Object)("Failed dropping dnasequenceattachment: " + rv));
            return false;
        }
        rv = BasicSQLUtils.update(conn, dnaSeqAttSQL);
        log.debug((Object)("Created New table dnasequenceattachment: " + rv));
        if (rv != 0) {
            log.info((Object)("Failed creating dnasequenceattachment: " + rv));
            return false;
        }
        return true;
    }

    private void fixSrcLatLongUnit(Connection conn) {
        String post = " FROM locality WHERE Lat1Text IS NOT NULL AND Long1Text IS NOT NULL AND OriginalLatLongUnit <> SrcLatLongUnit";
        String cntSQL = "SELECT COUNT(*)" + post;
        String sql = "SELECT LocalityID, OriginalLatLongUnit, SrcLatLongUnit, Lat1Text, Long1Text" + post;
        int total = BasicSQLUtils.getCountAsInt(conn, cntSQL);
        int cnt = 0;
        int updated = 0;
        this.frame.setProcess(0, total);
        PreparedStatement pStmt1 = null;
        try {
            try {
                pStmt1 = conn.prepareStatement("UPDATE locality SET SrcLatLongUnit=? WHERE LocalityID = ?");
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int locID = rs.getInt(1);
                    Integer srcUnit = rs.getInt(3);
                    String latStr = rs.getString(4);
                    String lonStr = rs.getString(5);
                    LatLonConverter.FORMAT latFmt = this.discoverUnitType(latStr);
                    LatLonConverter.FORMAT lonFmt = this.discoverUnitType(lonStr);
                    LatLonConverter.FORMAT fmt = latFmt == LatLonConverter.FORMAT.DDMMSS || lonFmt == LatLonConverter.FORMAT.DDMMSS ? LatLonConverter.FORMAT.DDMMSS : (latFmt.ordinal() > lonFmt.ordinal() ? latFmt : lonFmt);
                    int fmtUnit = fmt.ordinal();
                    if (fmtUnit != srcUnit) {
                        pStmt1.setInt(1, fmtUnit);
                        pStmt1.setInt(2, locID);
                        pStmt1.executeUpdate();
                        ++updated;
                    }
                    if (++cnt % 100 != 0) continue;
                    this.frame.setProcess(cnt);
                }
                this.frame.setProcess(total);
                rs.close();
                stmt.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (pStmt1 != null) {
                        pStmt1.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (pStmt1 != null) {
                    pStmt1.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String generateErrFieldsMsg(String tableName, String[] fieldNames) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String nm = stringArray[n2];
            sb.append(nm);
            sb.append(",\n");
            ++n2;
        }
        sb.setLength(sb.length() - 2);
        String msg = String.format(ERR_ADDING_FIELDS, tableName, sb.toString());
        this.errMsgList.add(msg);
        return msg;
    }

    private int getCount(String tableName) {
        return BasicSQLUtils.getCountAsInt(String.format("SELECT COUNT(*) FROM %s", tableName));
    }

    public void fixDuplicatedPaleoContexts(Connection conn) {
        boolean isErr;
        block23: {
            String sql = "SELECT PaleoContextID FROM (SELECT pc.PaleoContextID, COUNT(pc.PaleoContextID) cnt FROM paleocontext pc INNER JOIN collectionobject co ON pc.PaleoContextID = co.PaleoContextID GROUP BY pc.PaleoContextID) T1 WHERE cnt > 1 ";
            String coSQL = "SELECT CollectionObjectID FROM collectionobject WHERE PaleoContextID = ";
            List<String> pcFieldNames = BasicSQLUtils.getFieldNamesFromSchema(conn, "paleocontext");
            String fieldStr = BasicSQLUtils.buildSelectFieldList(pcFieldNames, null);
            fieldStr = StringUtils.remove((String)fieldStr, (String)"PaleoContextID, ");
            StringBuilder sb = new StringBuilder("INSERT INTO paleocontext (");
            sb.append(fieldStr);
            sb.append(") SELECT ");
            sb.append(fieldStr);
            sb.append(" FROM paleocontext WHERE PaleoContextID = ?");
            String updateSQL = sb.toString();
            isErr = false;
            PreparedStatement pStmt = null;
            PreparedStatement pStmt2 = null;
            try {
                try {
                    pStmt = conn.prepareStatement(updateSQL);
                    pStmt2 = conn.prepareStatement("UPDATE collectionobject SET PaleoContextID=? WHERE CollectionObjectID = ?");
                    for (Integer pcId : BasicSQLUtils.queryForInts(conn, sql)) {
                        Vector<Integer> colObjIds = BasicSQLUtils.queryForInts(conn, String.valueOf(coSQL) + pcId);
                        int i = 1;
                        while (i < colObjIds.size()) {
                            pStmt.setInt(1, pcId);
                            int rv = pStmt.executeUpdate();
                            if (rv == 1) {
                                Integer newPCId = BasicSQLUtils.getInsertedId(pStmt);
                                pStmt2.setInt(1, newPCId);
                                pStmt2.setInt(2, colObjIds.get(i));
                                rv = pStmt2.executeUpdate();
                                if (rv != 1) {
                                    log.error((Object)("Error updating co " + colObjIds.get(i)));
                                    isErr = true;
                                }
                            } else {
                                log.error((Object)("Error updating pc " + pcId));
                                isErr = true;
                            }
                            ++i;
                        }
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, ex);
                    try {
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        if (pStmt2 != null) {
                            pStmt2.close();
                        }
                        break block23;
                    }
                    catch (SQLException sQLException) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (pStmt2 != null) {
                        pStmt2.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (pStmt2 != null) {
                    pStmt2.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (isErr) {
            UIRegistry.showError("There was an error updating the duplicated PaleoContexts\nPlease contact support.");
        }
    }

    public void fixAgentsDivsDisps(Connection conn) {
        try {
            String sql = "SELECT T1.SpecifyUserID FROM (SELECT COUNT(su.SpecifyUserID) AS cnt, su.SpecifyUserID FROM specifyuser su INNER JOIN agent a ON su.SpecifyUserID = a.SpecifyUserID GROUP BY su.SpecifyUserID) T1 WHERE cnt > 1";
            log.debug((Object)sql);
            Vector<Integer> rows = BasicSQLUtils.queryForInts(conn, sql);
            if (rows.size() == 0) {
                return;
            }
            for (Integer spId : rows) {
                ArrayList<Integer> availAgents;
                HashMap<Integer, Integer> divToAgentToFixHash;
                Integer firstDivId;
                Integer firstAgentId;
                block47: {
                    ArrayList availDivs;
                    block45: {
                        log.debug((Object)("-------- For SpUser: " + spId + " --------------"));
                        HashSet<Integer> currAgentsDivHash = new HashSet<Integer>();
                        String fromClause = String.format(" FROM specifyuser su INNER JOIN agent a ON su.SpecifyUserID = a.SpecifyUserID WHERE su.SpecifyUserID = %d AND a.DivisionID IS NOT NULL ORDER BY a.TimestampModified ASC", spId);
                        sql = "SELECT a.AgentID, a.DivisionID" + fromClause;
                        firstAgentId = null;
                        firstDivId = null;
                        HashMap<Integer, Integer> agentIdsWithDupDivs = new HashMap<Integer, Integer>();
                        HashMap<Integer, Integer> divToAgentHash = new HashMap<Integer, Integer>();
                        divToAgentToFixHash = new HashMap<Integer, Integer>();
                        log.debug((Object)sql);
                        for (Object[] row : BasicSQLUtils.query(conn, sql)) {
                            Integer agtId = (Integer)row[0];
                            Integer divId = (Integer)row[1];
                            if (firstAgentId == null) {
                                firstAgentId = agtId;
                                firstDivId = divId;
                            }
                            divToAgentHash.put(divId, agtId);
                            log.debug((Object)String.format("Div: %d -> Agent: %d", divId, agtId));
                            if (currAgentsDivHash.contains(divId)) {
                                agentIdsWithDupDivs.put(agtId, divId);
                                log.debug((Object)String.format("Agent %d was a duplicate Agent for Div %d", agtId, divId));
                                continue;
                            }
                            currAgentsDivHash.add(divId);
                        }
                        ArrayList<Integer> divsForSpecifyUserList = new ArrayList<Integer>();
                        HashSet<Integer> divsForSpecifyUserHash = new HashSet<Integer>();
                        sql = "SELECT DISTINCT dv.UserGroupScopeId FROM collection cln INNER JOIN spprincipal p ON cln.UserGroupScopeId = p.userGroupScopeID INNER JOIN discipline ds ON cln.DisciplineID = ds.UserGroupScopeId INNER JOIN division dv ON ds.DivisionID = dv.UserGroupScopeId INNER JOIN specifyuser_spprincipal su_pr ON p.SpPrincipalID = su_pr.SpPrincipalID INNER JOIN specifyuser su ON su_pr.SpecifyUserID = su.SpecifyUserID  WHERE su.SpecifyUserID = " + spId + " ORDER BY dv.UserGroupScopeId";
                        log.debug((Object)sql);
                        ArrayList<Integer> divsForSpUserWithNoAgent = new ArrayList<Integer>();
                        for (Integer divId : BasicSQLUtils.queryForInts(conn, sql)) {
                            divsForSpecifyUserList.add(divId);
                            log.debug((Object)String.format("spId: %d  div: %d", spId, divId));
                            divsForSpecifyUserHash.add(divId);
                            if (divToAgentHash.get(divId) != null) continue;
                            divsForSpUserWithNoAgent.add(divId);
                            log.debug((Object)String.format("Div %d doesn't have an UserAgent", divId));
                        }
                        if (agentIdsWithDupDivs.size() == 0 && divsForSpUserWithNoAgent.size() == 0) continue;
                        availAgents = new ArrayList<Integer>(agentIdsWithDupDivs.keySet());
                        availDivs = new ArrayList(divsForSpUserWithNoAgent);
                        PreparedStatement pStmt = null;
                        try {
                            try {
                                pStmt = conn.prepareStatement("UPDATE agent SET DivisionID=? WHERE AgentID = ?");
                                for (Integer divId : divsForSpUserWithNoAgent) {
                                    if (availAgents.size() > 0) {
                                        Integer n = (Integer)availAgents.get(0);
                                        availAgents.remove(0);
                                        pStmt.setInt(1, divId);
                                        pStmt.setInt(2, n);
                                        pStmt.executeUpdate();
                                        log.debug((Object)String.format("Set Agent %d to Div %d", n, divId));
                                        divToAgentToFixHash.put(divId, n);
                                        availDivs.remove(divId);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                try {
                                    if (pStmt != null) {
                                        pStmt.close();
                                    }
                                    break block45;
                                }
                                catch (Exception exception) {}
                                break block45;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (pStmt != null) {
                                    pStmt.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            if (pStmt != null) {
                                pStmt.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (availDivs.size() > 0) {
                        DataProviderSessionIFace session = null;
                        try {
                            try {
                                session = DataProviderFactory.getInstance().createSession();
                                ArrayList<Agent> agentToBeAdded = new ArrayList<Agent>();
                                for (Integer n : availDivs) {
                                    Agent clonableAgent = session.get(Agent.class, firstAgentId);
                                    Division division = session.get(Division.class, n);
                                    Agent clonedAgent = (Agent)clonableAgent.clone();
                                    clonedAgent.setAgentId(null);
                                    clonedAgent.setVersion(0);
                                    clonedAgent.setDivision(division);
                                    log.debug((Object)String.format("Cloning Agent %d for Div %d", firstAgentId, n));
                                    agentToBeAdded.add(clonedAgent);
                                }
                                session.close();
                                session = DataProviderFactory.getInstance().createSession();
                                session.beginTransaction();
                                for (Agent agent : agentToBeAdded) {
                                    Agent newAgent = (Agent)agent.clone();
                                    session.save(newAgent);
                                    divToAgentToFixHash.put(newAgent.getDivision().getId(), newAgent.getId());
                                }
                                session.commit();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                try {
                                    if (session != null) {
                                        session.close();
                                    }
                                    break block47;
                                }
                                catch (Exception exception) {}
                                break block47;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (session != null) {
                                    session.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            if (session != null) {
                                session.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                StringBuilder sb = new StringBuilder();
                for (Integer agtId : availAgents) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(agtId);
                }
                String inClause = " WHERE %s in (" + sb.toString() + ") ";
                divToAgentToFixHash.put(firstDivId, firstAgentId);
                if (availAgents.size() <= 0) continue;
                sql = "SELECT aa.AccessionAgentID, aa.AgentID, a.DivisionID FROM accessionagent aa INNER JOIN accession a ON aa.AccessionID = a.AccessionID ORDER BY aa.AgentID";
                this.fixAgents(conn, sql, "accessionagent", "aa.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT aa.AddressOfRecordID, aa.AgentID, a.DivisionID FROM addressofrecord aa INNER JOIN accession a ON aa.AddressOfRecordID = a.AddressOfRecordID ORDER BY aa.AgentID";
                this.fixAgents(conn, sql, "addressofrecord", "aa.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT aa.AddressOfRecordID, aa.AgentID, ei.DivisionID FROM addressofrecord aa INNER JOIN exchangein ei ON aa.AddressOfRecordID = ei.AddressOfRecordID ORDER BY aa.AgentID";
                this.fixAgents(conn, sql, "addressofrecord", "aa.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT aa.AddressOfRecordID, aa.AgentID, eo.DivisionID FROM addressofrecord aa INNER JOIN exchangeout eo ON aa.AddressOfRecordID = eo.AddressOfRecordID ORDER BY aa.AgentID";
                this.fixAgents(conn, sql, "addressofrecord", "aa.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT aa.AddressOfRecordID, aa.AgentID, g.DivisionID FROM addressofrecord aa INNER JOIN gift g ON aa.AddressOfRecordID = g.AddressOfRecordID ORDER BY aa.AgentID";
                this.fixAgents(conn, sql, "addressofrecord", "aa.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT aa.AddressOfRecordID, aa.AgentID, l.DivisionID FROM addressofrecord aa INNER JOIN loan l ON aa.AddressOfRecordID = l.AddressOfRecordID ";
                this.fixAgents(conn, sql, "addressofrecord", "aa.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT aa.AddressOfRecordID, aa.AgentID, ra.DivisionID FROM addressofrecord aa INNER JOIN repositoryagreement ra ON aa.AddressOfRecordID = ra.AddressOfRecordID ";
                this.fixAgents(conn, sql, "addressofrecord", "aa.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ag.AgentGeographyID, ag.AgentID, dp.DivisionID FROM agentgeography ag INNER JOIN geography g ON ag.GeographyID = g.GeographyID INNER JOIN discipline dp ON g.GeographyTreeDefID = dp.GeographyTreeDefID ";
                this.fixAgents(conn, sql, "agentgeography", "ag.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ap.AppraisalID, ap.AgentID, a.DivisionID FROM appraisal ap INNER JOIN accession a ON ap.AccessionID = a.AccessionID ";
                this.fixAgents(conn, sql, "appraisal", "ap.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ap.AppraisalID, ap.AgentID, dp.DivisionID FROM appraisal ap INNER JOIN collectionobject co ON ap.AppraisalID = co.AppraisalID INNER JOIN collection c ON co.CollectionID = c.UserGroupScopeId INNER JOIN discipline dp ON c.DisciplineID = dp.UserGroupScopeId ";
                this.fixAgents(conn, sql, "appraisal", "ap.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ba.BorrowAgentID, ba.AgentID, dp.DivisionID FROM borrowagent ba INNER JOIN collection c ON ba.CollectionMemberID = c.UserGroupScopeId INNER JOIN discipline dp ON c.DisciplineID = dp.UserGroupScopeId ";
                this.fixAgents(conn, sql, "borrowagent", "ba.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT brm.BorrowReturnMaterialID, brm.ReturnedByID, dp.DivisionID FROM borrowreturnmaterial brm INNER JOIN borrowmaterial bm ON brm.BorrowMaterialID = bm.BorrowMaterialID INNER JOIN collection c ON bm.CollectionMemberID = c.UserGroupScopeId INNER JOIN discipline dp ON c.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "borrowreturnmaterial", "brm.ReturnedByID", divToAgentToFixHash, inClause);
                sql = "SELECT co.CollectionObjectID, co.CatalogerID, dp.DivisionID FROM collectionobject co INNER JOIN collection c ON co.CollectionID = c.UserGroupScopeId INNER JOIN discipline dp ON c.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "collectionobject", "co.CatalogerID", divToAgentToFixHash, inClause);
                sql = "SELECT CollectorID, AgentID, DivisionID FROM collector";
                this.fixAgents(conn, sql, "collector", "AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT d.DeterminationID, d.DeterminerID, dp.DivisionID FROM determination d INNER JOIN collection c ON d.CollectionMemberID = c.UserGroupScopeId INNER JOIN discipline dp ON c.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "determination", "d.DeterminerID", divToAgentToFixHash, inClause);
                sql = "SELECT DnaSequenceID, dna.AgentID, dp.DivisionID FROM collection c INNER JOIN discipline dp ON c.DisciplineID = dp.UserGroupScopeId INNER JOIN dnasequence dna ON dna.CollectionMemberID = c.UserGroupScopeId";
                this.fixAgents(conn, sql, "dnasequence", "dna.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ExchangeInID, CatalogedByID, DivisionID FROM exchangein";
                this.fixAgents(conn, sql, "exchangein", "CatalogedByID", divToAgentToFixHash, inClause);
                sql = "SELECT ExchangeOutID, CatalogedByID, DivisionID FROM exchangeout";
                this.fixAgents(conn, sql, "exchangeout", "CatalogedByID", divToAgentToFixHash, inClause);
                sql = "SELECT fn.FieldNotebookID, fn.AgentID, dp.DivisionID FROM fieldnotebook fn INNER JOIN discipline dp ON fn.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "fieldnotebook", "fn.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT FieldNotebookPageSetID, fnps.AgentID, dp.DivisionID FROM fieldnotebookpageset fnps INNER JOIN discipline dp ON fnps.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "fieldnotebookpageset", "fnps.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT gd.GeoCoordDetailID, gd.AgentID, dp.DivisionID FROM geocoorddetail gd INNER JOIN locality l ON gd.LocalityID = l.LocalityID INNER JOIN discipline dp ON l.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "geocoorddetail", "gd.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ga.GiftAgentID, ga.AgentID, g.DivisionID, dp.DivisionID FROM giftagent ga INNER JOIN gift g ON ga.GiftID = g.GiftID INNER JOIN discipline dp ON g.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "giftagent", "ga.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ir.InfoRequestID, ir.AgentID, dp.DivisionID FROM inforequest ir INNER JOIN collection c ON ir.CollectionMemberID = c.UserGroupScopeId INNER JOIN discipline dp ON c.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "inforequest", "ir.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT la.LoanAgentID, la.AgentID, l.DivisionID, dp.DivisionID FROM loanagent la INNER JOIN loan l ON la.LoanID = l.LoanID INNER JOIN discipline dp ON l.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "loanagent", "la.AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT lrp.LoanReturnPreparationID, lrp.ReceivedByID, dp.DivisionID FROM loanreturnpreparation lrp INNER JOIN discipline dp ON lrp.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "loanreturnpreparation", "lrp.ReceivedByID", divToAgentToFixHash, inClause);
                sql = "SELECT PreparationID, p.PreparedByID, dp.DivisionID FROM preparation p INNER JOIN collectionobject co ON p.CollectionObjectID = co.CollectionObjectID INNER JOIN collection c ON co.CollectionID = c.UserGroupScopeId INNER JOIN discipline dp ON c.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "preparation", "p.PreparedByID", divToAgentToFixHash, inClause);
                sql = "SELECT RepositoryAgreementID, AgentID, DivisionID FROM repositoryagreement";
                this.fixAgents(conn, sql, "repositoryagreement", "AgentID", divToAgentToFixHash, inClause);
                sql = "SELECT s.ShipmentID, s.ShipperID, dp.DivisionID FROM shipment s INNER JOIN discipline dp ON s.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "shipment", "s.ShipperID", divToAgentToFixHash, inClause);
                sql = "SELECT s.ShipmentID, s.ShippedToID, dp.DivisionID FROM shipment s INNER JOIN discipline dp ON s.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "shipment", "s.ShippedToID", divToAgentToFixHash, inClause);
                sql = "SELECT s.ShipmentID, s.ShippedByID, dp.DivisionID FROM shipment s INNER JOIN discipline dp ON s.DisciplineID = dp.UserGroupScopeId";
                this.fixAgents(conn, sql, "shipment", "s.ShippedByID", divToAgentToFixHash, inClause);
                sql = "SELECT ap.SpAppResourceDirID, ap.CreatedByAgentID, d.DivisionID FROM spappresourcedir AS ap Inner Join discipline AS d ON ap.DisciplineID = d.UserGroupScopeId ";
                this.fixAgents(conn, sql, "spappresourcedir", "ap.CreatedByAgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ap.SpAppResourceDirID, ap.ModifiedByAgentID, d.DivisionID FROM spappresourcedir AS ap Inner Join discipline AS d ON ap.DisciplineID = d.UserGroupScopeId ";
                this.fixAgents(conn, sql, "spappresourcedir", "ap.ModifiedByAgentID", divToAgentToFixHash, inClause);
                sql = "SELECT r.SpAppResourceID, r.CreatedByAgentID, d.DivisionID FROM spappresource AS r Inner Join spappresourcedir AS rd ON r.SpAppResourceDirID = rd.SpAppResourceDirID Inner Join discipline AS d ON rd.DisciplineID = d.UserGroupScopeId ";
                this.fixAgents(conn, sql, "spappresource", "r.CreatedByAgentID", divToAgentToFixHash, inClause);
                sql = "SELECT r.SpAppResourceID, r.ModifiedByAgentID, d.DivisionID FROM spappresource AS r Inner Join spappresourcedir AS rd ON r.SpAppResourceDirID = rd.SpAppResourceDirID Inner Join discipline AS d ON rd.DisciplineID = d.UserGroupScopeId ";
                this.fixAgents(conn, sql, "spappresource", "r.ModifiedByAgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ada.SpAppResourceDataID, ada.CreatedByAgentID, d.DivisionID FROM spappresourcedata AS ada Inner Join spappresource AS ar ON ada.SpAppResourceID = ar.SpAppResourceID Inner Join spappresourcedir AS ad ON ar.SpAppResourceDirID = ad.SpAppResourceDirID Inner Join discipline AS d ON ad.DisciplineID = d.UserGroupScopeId ";
                this.fixAgents(conn, sql, "spappresourcedata", "ada.CreatedByAgentID", divToAgentToFixHash, inClause);
                sql = "SELECT ada.SpAppResourceDataID, ada.ModifiedByAgentID, d.DivisionID FROM spappresourcedata AS ada Inner Join spappresource AS ar ON ada.SpAppResourceID = ar.SpAppResourceID Inner Join spappresourcedir AS ad ON ar.SpAppResourceDirID = ad.SpAppResourceDirID Inner Join discipline AS d ON ad.DisciplineID = d.UserGroupScopeId ";
                this.fixAgents(conn, sql, "spappresourcedata", "ada.ModifiedByAgentID", divToAgentToFixHash, inClause);
                this.fixAllTables(conn, firstAgentId, inClause, "CreatedByAgentID");
                this.fixAllTables(conn, firstAgentId, inClause, "ModifiedByAgentID");
                this.deleteAgentRelationships(conn, "address", availAgents);
                this.deleteAgentRelationships(conn, "agentvariant", availAgents);
                this.deleteAgentRelationships(conn, "agentgeography", availAgents);
                this.deleteAgentRelationships(conn, "agentspecialty", availAgents);
                this.deleteAgentAttachments(conn, availAgents);
                BasicSQLUtils.setSkipTrackExceptions(true);
                for (Integer n : availAgents) {
                    try {
                        System.out.println("Delete Agent: " + n);
                        BasicSQLUtils.update(conn, "DELETE FROM agent WHERE AgentID = " + n);
                    }
                    catch (Exception ex) {
                        UIRegistry.showError("There was error deleting Agent ID %d.\nPlease write this number down and report this error immediately to the Specify team.");
                    }
                }
                BasicSQLUtils.setSkipTrackExceptions(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void deleteAgentRelationships(Connection conn, String tableName, List<Integer> ids) {
        for (Integer id : ids) {
            String sql = String.format("DELETE FROM %s WHERE AgentID = %d", tableName, id);
            if (BasicSQLUtils.update(conn, sql) == 1) continue;
            this.errMsgList.add(String.format("Error deleting Agent %d Table %s\n", id, tableName));
        }
    }

    private void deleteAgentAttachments(Connection conn, List<Integer> ids) {
        for (Integer id : ids) {
            String sql = " SELECT aa.AgentAttachmentID, a.AttachmentID FROM agentattachment aa INNER JOIN attachment a ON aa.AttachmentID = a.AttachmentID WHERE aa.AgentID = " + id;
            for (Object[] row : BasicSQLUtils.query(sql)) {
                Integer agtAtchId = (Integer)row[1];
                Integer atchId = (Integer)row[2];
                sql = String.format("DELETE FROM attachment WHERE AttachmentID = %d", atchId);
                if (BasicSQLUtils.update(conn, sql) != 1) {
                    this.errMsgList.add(String.format("Error deleting Agent %d Table attachment\n", id));
                }
                if (BasicSQLUtils.update(conn, sql = String.format("DELETE FROM agentattachment WHERE AgentAttachmentID = %d", agtAtchId)) == 1) continue;
                this.errMsgList.add(String.format("Error deleting Agent %d Table agentattachment\n", id));
            }
        }
    }

    private void fixAllTables(Connection conn, Integer firstAgentId, String inClause, String fldName) {
        String fullInClause = String.format(inClause, fldName);
        for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
            String primaryKey = ti.getPrimaryKeyName();
            if (ti.getTableId() == SpTaskSemaphore.getClassTableId()) {
                primaryKey = "TaskSemaphoreID";
            } else if (ti.getPrimaryKeyName().equals("userGroupId")) {
                primaryKey = String.valueOf(ti.getClassObj().getSimpleName()) + "ID";
            }
            String relName = fldName.toLowerCase().substring(0, fldName.length() - 2);
            if (ti.getRelationshipByName(relName) == null) continue;
            String sql = String.format("SELECT COUNT(*) FROM %s %s", ti.getName(), fullInClause);
            log.debug((Object)sql);
            int total = BasicSQLUtils.getCountAsInt(sql);
            if (total <= 0) continue;
            int percentStep = (int)((double)total * 0.02);
            this.frame.setProcess(0, total);
            this.frame.setDesc("Fixing " + ti.getName());
            Statement ps = null;
            try {
                try {
                    sql = String.format("UPDATE %s SET %s = ? WHERE %s = ?", ti.getName(), fldName, primaryKey);
                    ps = conn.prepareStatement(sql);
                    sql = String.format("SELECT %s FROM %s %s", primaryKey, ti.getName(), fullInClause);
                    int cnt = 0;
                    for (Integer id : BasicSQLUtils.queryForInts(sql)) {
                        ps.setInt(1, firstAgentId);
                        ps.setInt(2, id);
                        if (ps.executeUpdate() != 1) {
                            this.errMsgList.add(String.format("Error updating Agent %d Table [%s] Field [%s] Primary [%s]\n", firstAgentId, ti.getName(), fldName, primaryKey));
                        }
                        if (percentStep <= 0 || ++cnt % percentStep != 0) continue;
                        this.frame.setProcess(cnt);
                    }
                    this.frame.setProcess(total);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.errMsgList.add(ex.getMessage());
                    if (ps == null) continue;
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (ps == null) continue;
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String addInClause(String sql, String inClause) {
        String ORDER_BY = "order by";
        int inx = sql.toLowerCase().indexOf("order by");
        if (inx == -1) {
            return String.valueOf(sql) + inClause;
        }
        String str = String.valueOf(sql.substring(0, inx - 1)) + inClause + sql.substring(inx);
        return str;
    }

    private void fixAgents(Connection conn, String sqlArg, String tableName, String fieldName, HashMap<Integer, Integer> divToAgentToFixHash, String inClause) {
        Statement pStmt = null;
        Statement stmt = null;
        try {
            try {
                String fullInClause = String.format(inClause, fieldName);
                String sql = this.addInClause(sqlArg, fullInClause);
                int inx = sql.indexOf("FROM");
                String tmpSQL = "SELECT COUNT(*) " + sql.substring(inx);
                int total = BasicSQLUtils.getCountAsInt(tmpSQL);
                int percentStep = (int)((double)total * 0.02);
                this.frame.setProcess(0, total);
                this.frame.setDesc("Fixing " + tableName);
                String fldName = fieldName;
                inx = fieldName.indexOf(46);
                if (inx > -1) {
                    fldName = fieldName.substring(inx + 1);
                }
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                String recIdColName = rs.getMetaData().getColumnName(1);
                String sqlStr = String.format("UPDATE %s SET %s=? WHERE %s = ?", tableName, fldName, recIdColName);
                pStmt = conn.prepareStatement(sqlStr);
                int cnt = 0;
                int itemsFixed = 0;
                while (rs.next()) {
                    Integer mappedAgentId;
                    Integer divId2;
                    Integer recID = rs.getInt(1);
                    Integer divId = rs.getObject(3) != null ? Integer.valueOf(rs.getInt(3)) : null;
                    Integer n = divId2 = rsmd.getColumnCount() == 4 ? Integer.valueOf(rs.getInt(4)) : null;
                    if (divId2 != null && divId == null) {
                        divId = divId2;
                    }
                    if ((mappedAgentId = divToAgentToFixHash.get(divId)) != null) {
                        pStmt.setInt(1, mappedAgentId);
                        pStmt.setInt(2, recID);
                        if (pStmt.executeUpdate() != 1) {
                            this.errMsgList.add(String.format("Error deleting Agent %d Table %s Field %s RecIdCol %s RecID %d", mappedAgentId, tableName, fldName, recIdColName, recID));
                        }
                        ++itemsFixed;
                    }
                    if (percentStep <= 0 || ++cnt % percentStep != 0) continue;
                    this.frame.setProcess(cnt);
                }
                this.frame.setProcess(total);
                log.debug((Object)String.format("%d Fixed ->%s.%s  (%s)", itemsFixed, tableName, fldName, sql));
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.errMsgList.add(ex.getMessage());
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean alterFieldLength(Connection conn, String databaseName, String tblName, String fldName, int origLen, int newLen) {
        Integer len = this.getFieldLength(conn, databaseName, tblName, fldName);
        if (len == origLen) {
            BasicSQLUtils.setSkipTrackExceptions(false);
            try {
                BasicSQLUtils.update(conn, String.format("ALTER TABLE %s MODIFY %s varchar(%d)", tblName, fldName, newLen));
            }
            catch (Exception ex) {
                this.errMsgList.add(String.format("Error - Updating %s %s.%s - %d -> %d  Excpt: %s", databaseName, tblName, fldName, origLen, newLen, ex.getMessage()));
            }
            BasicSQLUtils.setSkipTrackExceptions(false);
        }
        return true;
    }

    private boolean doFixesForDBSchemaVersions(Connection conn, String databaseName) throws Exception {
        boolean statusOK;
        block59: {
            int count;
            String sql;
            String tblName;
            DBConnection dbc;
            block53: {
                this.getTableTitleForFrame(PaleoContext.getClassTableId());
                Integer len = this.getFieldLength(conn, databaseName, "paleocontext", "Text1");
                this.alterFieldLength(conn, databaseName, "paleocontext", "Text1", 32, 64);
                this.alterFieldLength(conn, databaseName, "paleocontext", "Text2", 32, 64);
                len = this.getFieldLength(conn, databaseName, "paleocontext", "Remarks");
                if (len == null) {
                    int count2 = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM paleocontext");
                    int rv = BasicSQLUtils.update(conn, "ALTER TABLE paleocontext ADD Remarks VARCHAR(60)");
                    if (rv != count2) {
                        this.errMsgList.add("Error updating PaleoContext.Remarks");
                        return false;
                    }
                }
                this.frame.incOverall();
                dbc = DBConnection.getInstance();
                this.getTableTitleForFrame(FieldNotebookPage.getClassTableId());
                len = this.getFieldLength(conn, databaseName, "fieldnotebookpage", "PageNumber");
                if (len != null && len == 16) {
                    this.alterFieldLength(conn, databaseName, "fieldnotebookpage", "PageNumber", 16, 32);
                    BasicSQLUtils.update(conn, "ALTER TABLE fieldnotebookpage ALTER COLUMN ScanDate DROP DEFAULT");
                }
                this.frame.incOverall();
                this.alterFieldLength(conn, databaseName, "project", "projectname", 50, 128);
                this.frame.incOverall();
                if (SpecifySchemaUpdateService.doesTableExist(databaseName, "attachmentimageattribute")) {
                    this.alterFieldLength(conn, databaseName, "attachmentimageattribute", "CreativeCommons", 128, 500);
                    this.frame.incOverall();
                }
                tblName = this.getTableTitleForFrame(LocalityDetail.getClassTableId());
                statusOK = true;
                sql = String.format("SELECT COUNT(*) FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = 'localitydetail' AND COLUMN_NAME = 'UtmScale' AND DATA_TYPE = 'varchar'", dbc.getDatabaseName());
                count = BasicSQLUtils.getCountAsInt(sql);
                if (count > 0) {
                    Vector<Object[]> values = BasicSQLUtils.query("SELECT ld.LocalityDetailID, ld.UtmScale, l.LocalityName FROM localitydetail ld INNER JOIN locality l ON ld.LocalityID = l.LocalityID WHERE ld.UtmScale IS NOT NULL");
                    BasicSQLUtils.update(conn, "ALTER TABLE localitydetail DROP COLUMN UtmScale");
                    this.addColumn(conn, databaseName, tblName, "UtmScale", "FLOAT", "UtmOrigLongitude");
                    this.addColumn(conn, databaseName, tblName, "MgrsZone", "VARCHAR(4)", "UtmScale");
                    HashMap<String, String> badLocalitiesHash = new HashMap<String, String>();
                    try {
                        PreparedStatement pStmt = conn.prepareStatement("UPDATE localitydetail SET UtmScale=? WHERE LocalityDetailID=?");
                        for (Object[] row : values) {
                            Iterator<Object[]> locDetailId = (Integer)row[0];
                            String scale = (String)row[1];
                            String locName = (String)row[2];
                            String string = scale = StringUtils.contains((String)scale, (char)',') ? StringUtils.replace((String)scale, (String)",", (String)"") : scale;
                            if (!StringUtils.isNumeric((String)scale)) {
                                badLocalitiesHash.put(locName, scale);
                                continue;
                            }
                            float scaleFloat = 0.0f;
                            try {
                                scaleFloat = Float.parseFloat(scale);
                            }
                            catch (NumberFormatException ex) {
                                badLocalitiesHash.put(locName, scale);
                                continue;
                            }
                            pStmt.setFloat(1, scaleFloat);
                            pStmt.setInt(2, (Integer)((Object)locDetailId));
                            pStmt.execute();
                        }
                        pStmt.close();
                    }
                    catch (SQLException ex) {
                        statusOK = false;
                    }
                    if (badLocalitiesHash.size() > 0) {
                        try {
                            File file = new File(String.valueOf(UIRegistry.getUserHomeDir()) + File.separator + "localitydetailerrors.html");
                            TableWriter tblWriter = new TableWriter(file.getAbsolutePath(), "Locality Detail Errors");
                            tblWriter.startTable();
                            tblWriter.logHdr("Locality Name", "Scale");
                            for (String key : badLocalitiesHash.keySet()) {
                                tblWriter.log(key, (String)badLocalitiesHash.get(key));
                            }
                            tblWriter.endTable();
                            tblWriter.flush();
                            tblWriter.close();
                            UIRegistry.showLocalizedError("LOC_DETAIL_ERRORS", badLocalitiesHash.size(), file.getAbsoluteFile());
                            badLocalitiesHash.clear();
                            if (!file.exists()) break block53;
                            try {
                                AttachmentUtils.openURI(file.toURI());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                } else {
                    this.addColumn(conn, databaseName, tblName, "UtmScale", "FLOAT", "UtmOrigLongitude");
                }
            }
            this.frame.incOverall();
            DBMSUserMgr dbmsMgr = DBMSUserMgr.getInstance();
            if (dbmsMgr.connectToDBMS((String)this.itUserNamePassword.first, (String)this.itUserNamePassword.second, dbc.getServerName())) {
                boolean status;
                block56: {
                    status = true;
                    Connection connection = dbmsMgr.getConnection();
                    try {
                        try {
                            IdTableMapper mapper;
                            block58: {
                                Integer oldColId;
                                ResultSet rs;
                                PreparedStatement pStmt;
                                int percent;
                                Object stmt;
                                tblName = this.getTableTitleForFrame(Determination.getClassTableId());
                                this.addColumn(conn, databaseName, tblName, "VarQualifier", "ALTER TABLE %s ADD COLUMN %s VARCHAR(16) AFTER Qualifier");
                                this.addColumn(conn, databaseName, tblName, "SubSpQualifier", "ALTER TABLE %s ADD COLUMN %s VARCHAR(16) AFTER VarQualifier");
                                this.frame.incOverall();
                                sql = String.format("SELECT COUNT(*) FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = 'collectingeventattribute' AND COLUMN_NAME = 'CollectionMemberID'", dbc.getDatabaseName());
                                count = BasicSQLUtils.getCountAsInt(sql);
                                connection.setCatalog(dbc.getDatabaseName());
                                if (count > 0) {
                                    block55: {
                                        HashMap<Integer, Integer> collIdToDispIdHash = new HashMap<Integer, Integer>();
                                        sql = "SELECT UserGroupScopeId, DisciplineID FROM collection";
                                        for (Object[] cols : BasicSQLUtils.query(sql)) {
                                            Integer colId = (Integer)cols[0];
                                            Integer dspId = (Integer)cols[1];
                                            collIdToDispIdHash.put(colId, dspId);
                                        }
                                        count = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM collectingeventattribute");
                                        IdMapperMgr.getInstance().setDBs(connection, connection);
                                        mapper = new IdTableMapper("ceattrmapper", "id", "SELECT CollectingEventAttributeID, CollectionMemberID FROM collectingeventattribute", true, false);
                                        mapper.setFrame(this.frame);
                                        mapper.mapAllIdsNoIncrement(count > 0 ? Integer.valueOf(count) : null);
                                        stmt = null;
                                        try {
                                            try {
                                                this.getTableTitleForFrame(CollectingEventAttribute.getClassTableId());
                                                stmt = connection.createStatement(1004, 1007);
                                                BasicSQLUtils.update(conn, "DROP INDEX COLEVATSColMemIDX on collectingeventattribute");
                                                BasicSQLUtils.update(conn, "ALTER TABLE collectingeventattribute DROP COLUMN CollectionMemberID");
                                                BasicSQLUtils.update(conn, "ALTER TABLE collectingeventattribute ADD COLUMN DisciplineID int(11)");
                                                BasicSQLUtils.update(conn, "CREATE INDEX COLEVATSDispIDX ON collectingeventattribute(DisciplineID)");
                                                double inc = count > 0 ? 100.0 / (double)count : 0.0;
                                                double cnt = 0.0;
                                                percent = 0;
                                                this.frame.setProcess(0, 100);
                                                this.frame.setProcessPercent(true);
                                                pStmt = conn.prepareStatement("UPDATE collectingeventattribute SET DisciplineID=? WHERE CollectingEventAttributeID=?");
                                                rs = stmt.executeQuery("SELECT CollectingEventAttributeID FROM collectingeventattribute");
                                                while (rs.next()) {
                                                    Integer ceAttrId = rs.getInt(1);
                                                    oldColId = mapper.get(ceAttrId);
                                                    if (oldColId != null) {
                                                        Integer dispId = (Integer)collIdToDispIdHash.get(oldColId);
                                                        if (dispId != null) {
                                                            pStmt.setInt(1, dispId);
                                                            pStmt.setInt(2, ceAttrId);
                                                            pStmt.execute();
                                                        } else {
                                                            log.debug((Object)("Error getting hashed DisciplineID from Old Collection ID[" + oldColId + "]  ceAttrId[" + ceAttrId + "]"));
                                                        }
                                                    } else {
                                                        log.debug((Object)("Error getting mapped  Collection ID[" + oldColId + "]  ceAttrId[" + ceAttrId + "]"));
                                                    }
                                                    if ((int)(cnt += inc) <= percent) continue;
                                                    percent = (int)cnt;
                                                    this.frame.setProcess(percent);
                                                }
                                                rs.close();
                                                pStmt.close();
                                                this.frame.setProcess(100);
                                            }
                                            catch (SQLException ex) {
                                                ex.printStackTrace();
                                                if (stmt != null) {
                                                    stmt.close();
                                                }
                                                break block55;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (stmt != null) {
                                                stmt.close();
                                            }
                                            throw throwable;
                                        }
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                    }
                                    mapper.cleanup();
                                }
                                this.frame.incOverall();
                                sql = String.format("SELECT COUNT(*) FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = 'collector' AND COLUMN_NAME = 'CollectionMemberID'", dbc.getDatabaseName());
                                count = BasicSQLUtils.getCountAsInt(sql);
                                if (count <= 0) break block56;
                                HashMap<Integer, Integer> collIdToDivIdHash = new HashMap<Integer, Integer>();
                                sql = "SELECT c.UserGroupScopeId, d.DivisionID FROM collection c INNER JOIN discipline d ON c.DisciplineID = d.UserGroupScopeId";
                                for (Object[] cols : BasicSQLUtils.query(sql)) {
                                    Integer colId = (Integer)cols[0];
                                    Integer divId = (Integer)cols[1];
                                    collIdToDivIdHash.put(colId, divId);
                                }
                                count = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM collector");
                                IdMapperMgr.getInstance().setDBs(connection, connection);
                                mapper = new IdTableMapper("collectormap", "id", "SELECT CollectorID, CollectionMemberID FROM collector", true, false);
                                mapper.setFrame(this.frame);
                                mapper.mapAllIdsNoIncrement(count > 0 ? Integer.valueOf(count) : null);
                                this.getTableTitleForFrame(Collector.getClassTableId());
                                stmt = null;
                                try {
                                    try {
                                        stmt = connection.createStatement(1004, 1007);
                                        BasicSQLUtils.update(conn, "DROP INDEX COLTRColMemIDX on collector");
                                        BasicSQLUtils.update(conn, "ALTER TABLE collector DROP COLUMN CollectionMemberID");
                                        BasicSQLUtils.update(conn, "ALTER TABLE collector ADD COLUMN DivisionID INT(11)");
                                        BasicSQLUtils.update(conn, "CREATE INDEX COLTRDivIDX ON collector(DivisionID)");
                                        double inc = count > 0 ? 100.0 / (double)count : 0.0;
                                        double cnt = 0.0;
                                        percent = 0;
                                        this.frame.setProcess(0, 100);
                                        this.frame.setProcessPercent(true);
                                        pStmt = conn.prepareStatement("UPDATE collector SET DivisionID=? WHERE CollectorID=?");
                                        rs = stmt.executeQuery("SELECT CollectorID FROM collector");
                                        while (rs.next()) {
                                            Integer coltrId = rs.getInt(1);
                                            oldColId = mapper.get(coltrId);
                                            if (oldColId != null) {
                                                Integer divId = (Integer)collIdToDivIdHash.get(oldColId);
                                                if (divId != null) {
                                                    pStmt.setInt(1, divId);
                                                    pStmt.setInt(2, coltrId);
                                                    pStmt.execute();
                                                } else {
                                                    log.debug((Object)("Error getting hashed DisciplineID from Old Collection ID[" + oldColId + "]"));
                                                }
                                            } else {
                                                log.debug((Object)("Error getting mapped Collector ID[" + oldColId + "]"));
                                            }
                                            if ((int)(cnt += inc) <= percent) continue;
                                            percent = (int)cnt;
                                            this.frame.setProcess(percent);
                                        }
                                        rs.close();
                                        pStmt.close();
                                        this.frame.setProcess(100);
                                    }
                                    catch (SQLException ex) {
                                        ex.printStackTrace();
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                        break block58;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                    throw throwable;
                                }
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            mapper.cleanup();
                            this.frame.incOverall();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            this.frame.getProcessProgress().setIndeterminate(true);
                            this.frame.setDesc("Loading updated schema...");
                            if (!status) {
                                UIRegistry.showLocalizedError("SCHEMA_UPDATE_ERROR", this.errMsgStr);
                            }
                            dbmsMgr.close();
                            break block59;
                        }
                    }
                    catch (Throwable throwable) {
                        this.frame.getProcessProgress().setIndeterminate(true);
                        this.frame.setDesc("Loading updated schema...");
                        if (!status) {
                            UIRegistry.showLocalizedError("SCHEMA_UPDATE_ERROR", this.errMsgStr);
                        }
                        dbmsMgr.close();
                        throw throwable;
                    }
                }
                this.frame.getProcessProgress().setIndeterminate(true);
                this.frame.setDesc("Loading updated schema...");
                if (!status) {
                    UIRegistry.showLocalizedError("SCHEMA_UPDATE_ERROR", this.errMsgStr);
                }
                dbmsMgr.close();
            }
        }
        return statusOK;
    }

    private void fixSpUserAndAgents() {
        HashMap<Integer, HashSet<Integer>> spUserToDivHash = new HashMap<Integer, HashSet<Integer>>();
        HashMap<Integer, Integer> spUserToAgentHash = new HashMap<Integer, Integer>();
        String sql = "SELECT su.SpecifyUserID, a.AgentID, a.DivisionID FROM specifyuser AS su Inner Join agent AS a ON su.SpecifyUserID = a.SpecifyUserID ";
        log.debug((Object)sql);
        for (Object[] row : BasicSQLUtils.query(sql)) {
            int spUserID = (Integer)row[0];
            int agtId = (Integer)row[1];
            int divId = (Integer)row[2];
            spUserToAgentHash.put(spUserID, agtId);
            HashSet<Integer> usersHash = (HashSet<Integer>)spUserToDivHash.get(spUserID);
            if (usersHash == null) {
                usersHash = new HashSet<Integer>();
                spUserToDivHash.put(spUserID, usersHash);
            }
            usersHash.add(divId);
            log.debug((Object)String.format("Collecing User %d in Division %d", spUserID, divId));
        }
        sql = "SELECT dsp.DivisionID, su.SpecifyUserID, dsp.DisciplineID FROM collection AS cln Inner Join spprincipal AS p ON cln.UserGroupScopeId = p.userGroupScopeID Inner Join specifyuser_spprincipal AS su_pr ON p.SpPrincipalID = su_pr.SpPrincipalID Inner Join specifyuser AS su ON su_pr.SpecifyUserID = su.SpecifyUserID Inner Join discipline AS dsp ON cln.DisciplineID = dsp.UserGroupScopeId WHERE su_pr.SpecifyUserID IS NOT NULL";
        log.debug((Object)sql);
        for (Object[] row : BasicSQLUtils.query(sql)) {
            int colDiv = (Integer)row[0];
            int spUserID = (Integer)row[1];
            int dispID = (Integer)row[2];
            HashSet divs = (HashSet)spUserToDivHash.get(spUserID);
            if (divs != null && divs.contains(colDiv)) continue;
            String divName = (String)BasicSQLUtils.querySingleObj("SELECT Name FROM division WHERE DivisionID = " + colDiv);
            String userName = (String)BasicSQLUtils.querySingleObj("SELECT Name FROM specifyuser WHERE SpecifyUserID = " + spUserID);
            log.debug((Object)String.format("*********** No Agent for User %d (%s) in Division %d (%s) - (Going to Duplicate)", spUserID, userName, colDiv, divName));
            Integer agtId = (Integer)spUserToAgentHash.get(spUserID);
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    session.beginTransaction();
                    Agent agent = session.get(Agent.class, agtId);
                    Discipline dsp = session.get(Discipline.class, dispID);
                    Division div = session.get(Division.class, colDiv);
                    Agent dupAgent = (Agent)agent.clone();
                    dupAgent.setDivision(div);
                    session.save(dupAgent);
                    session.save(dsp);
                    session.commit();
                    log.debug((Object)String.format("Saved New Agent %s (%d) for Discipline %s (%d), Division %s (%d)", dupAgent.getLastName(), dupAgent.getId(), dsp.getName(), dsp.getId(), div.getName(), div.getId()));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(NavigationTreeMgr.class, e1);
                    if (session != null) {
                        session.rollback();
                    }
                    log.error((Object)("Exception caught: " + e1.toString()));
                    if (session == null) continue;
                    session.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session == null) continue;
            session.close();
        }
    }

    private String getTableTitleForFrame(int tableId) {
        DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(tableId);
        if (ti != null) {
            this.frame.setDesc(String.format("Updating %s Fields...", ti.getTitle()));
            return ti.getName();
        }
        throw new RuntimeException("Couldn't find table in Mgr for Table Id " + tableId);
    }

    protected boolean checkAndAddColumns(Connection conn, String dbName, String tableName, String[] columnInfo) {
        int inx = 0;
        while (inx < columnInfo.length) {
            if (!this.doesColumnExist(dbName, tableName, columnInfo[inx]) && !this.addColumn(conn, dbName, tableName, columnInfo[inx], columnInfo[inx + 1], columnInfo[inx + 2])) {
                String msg = String.format("Error adding DB: %s  TBL: %s  Col:%s  Typ:%s  After: %s", dbName, tableName, columnInfo[inx], columnInfo[inx + 1], columnInfo[inx + 2]);
                log.error((Object)msg);
                this.errMsgList.add(msg);
                msg = this.generateErrFieldsMsg(tableName, columnInfo);
                log.error((Object)msg);
                return false;
            }
            inx += 3;
        }
        return true;
    }

    protected boolean addColumn(Connection conn, String dbName, String tableName, String colName, String type, String afterField) {
        String updateSQL = "ALTER TABLE %s ADD COLUMN %s " + type + " AFTER " + afterField;
        return this.addColumn(conn, dbName, tableName, colName, updateSQL);
    }

    protected boolean addColumn(Connection conn, String dbName, String tableName, String colName, String updateSQL) {
        if (!this.doesColumnExist(dbName, tableName, colName)) {
            String fmtSQL = String.format(updateSQL, tableName, colName);
            int rv = BasicSQLUtils.update(conn, fmtSQL);
            boolean isAlterTbl = updateSQL.trim().toLowerCase().startsWith("alter table");
            if (rv == 0 && isAlterTbl) {
                return true;
            }
            if (rv != 1 && !isAlterTbl) {
                log.error((Object)fmtSQL);
                this.errMsgList.add(String.format("Error adding column '%s' to table '%s'", colName, tableName));
                return false;
            }
        }
        return true;
    }

    protected boolean doesColumnExist(String dbName, String tableName, String colName) {
        String sql = String.format("SELECT COUNT(*) FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' AND COLUMN_NAME = '%s'", dbName, tableName, colName);
        return BasicSQLUtils.getCountAsInt(sql) == 1;
    }

    protected boolean doesIndexExist(String tableName, String indexName) {
        String sql = String.format("SHOW INDEX IN %s WHERE Key_name = '%s'", tableName, indexName);
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        return rows != null && rows.size() > 0;
    }

    protected static boolean doesTableExist(String dbName, String tableName) {
        String sql = String.format("SELECT COUNT(*) FROM `INFORMATION_SCHEMA`.`TABLES` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s'", dbName, tableName);
        return BasicSQLUtils.getCountAsInt(sql) == 1;
    }

    protected void fixLocaleSchema() {
        PostInsertEventListener.setAuditOn(false);
        Window localFrame = null;
        DataProviderSessionIFace session = null;
        Session hbSession = null;
        Transaction trans = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                hbSession = ((HibernateDataProviderSession)session).getSession();
                trans = hbSession.beginTransaction();
                List<Discipline> disciplines = session.getDataList(Discipline.class);
                localFrame = new ProgressFrame(UIRegistry.getResourceString("UPDATE_SCHEMA_TITLE"));
                ((ProgressFrame)localFrame).adjustProgressFrame();
                ((ProgressFrame)localFrame).turnOffOverAll();
                ((ProgressFrame)localFrame).getCloseBtn().setVisible(false);
                ((ProgressFrame)localFrame).setDesc("Merging New Schema Fields...");
                if (disciplines.size() > 1) {
                    ((ProgressFrame)localFrame).getProcessProgress().setIndeterminate(false);
                    ((ProgressFrame)localFrame).setProcess(0, disciplines.size());
                } else {
                    ((ProgressFrame)localFrame).getProcessProgress().setIndeterminate(true);
                }
                localFrame.setVisible(true);
                UIHelper.centerAndShow(localFrame);
                int cnt = 1;
                for (Discipline discipline : disciplines) {
                    BuildSampleDatabase bsd = new BuildSampleDatabase();
                    bsd.setSession(hbSession);
                    bsd.loadSchemaLocalization(discipline, SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance(), null, null, BuildSampleDatabase.UpdateType.eMerge, session);
                    ((ProgressFrame)localFrame).setProcess(cnt++);
                }
                trans.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (trans != null) {
                        trans.rollback();
                    }
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
                if (localFrame != null) {
                    localFrame.setVisible(false);
                }
                PostInsertEventListener.setAuditOn(true);
            }
        }
        finally {
            if (localFrame != null) {
                localFrame.setVisible(false);
            }
            PostInsertEventListener.setAuditOn(true);
        }
    }

    protected void fixSchemaMappingScope(Connection conn, String databaseName) throws Exception {
        String[] instCols;
        String tblName = this.getTableTitleForFrame(SpExportSchemaMapping.getClassTableId());
        if (!this.doesColumnExist(databaseName, tblName, "CollectionMemberID") && !this.checkAndAddColumns(conn, databaseName, tblName, instCols = new String[]{"CollectionMemberID", "INT(11)", "TimestampExported"})) {
            return;
        }
        String checkSQL = "select SpExportSchemaMappingID, MappingName from spexportschemamapping where CollectionMemberID is null";
        Vector<Object[]> mappingsToFix = BasicSQLUtils.query(checkSQL);
        if (mappingsToFix != null && mappingsToFix.size() > 0) {
            Vector<Object> collectionIDs = BasicSQLUtils.querySingleCol("select UserGroupScopeID from collection");
            if (collectionIDs.size() == 1) {
                BasicSQLUtils.update("update spexportschemamapping set CollectionMemberID = " + collectionIDs.get(0));
            } else {
                for (Object[] row : mappingsToFix) {
                    log.info((Object)"fixing mappings in multiple collection database");
                    String cacheName = ExportToMySQLDB.fixTblNameForMySQL(row[1].toString());
                    if (BasicSQLUtils.doesTableExist(DBConnection.getInstance().getConnection(), cacheName)) {
                        String updateSQL;
                        String cacheID = String.valueOf(cacheName) + "ID";
                        String sql = "select distinct CollectionMemberID from collectionobject co inner join " + cacheName + " cn on cn." + cacheID + " = co.CollectionObjectID";
                        Vector<Object> collsInCache = BasicSQLUtils.querySingleCol(sql);
                        if (collsInCache != null && collsInCache.size() == 1) {
                            updateSQL = "update spexportschemamapping set CollectionMemberID = " + collsInCache.get(0) + " where SpExportSchemaMappingID = " + row[0];
                            log.info((Object)("Updating exportmapping with cache containing single collection: " + updateSQL));
                            BasicSQLUtils.update(updateSQL);
                            continue;
                        }
                        if (collsInCache == null || collsInCache.size() <= 1) continue;
                        updateSQL = "update spexportschemamapping set CollectionMemberID = " + collsInCache.get(0) + " where SpExportSchemaMappingID = " + row[0];
                        log.info((Object)("Updating exportmapping with cache containing multiple collections: " + updateSQL));
                        BasicSQLUtils.update(updateSQL);
                        continue;
                    }
                    log.info((Object)("updating export mapping that has no cache: " + row[1] + " - " + row[0]));
                    String discSQL = "select distinct DisciplineID from spexportschema es inner join spexportschemaitem esi on esi.SpExportSchemaID = es.SpExportSchemaID inner join spexportschemaitemmapping esim on esim.ExportSchemaItemID = esi.SpExportSchemaItemID where esim.SpExportSchemaMappingID = " + row[0];
                    Object disciplineID = BasicSQLUtils.querySingleObj(discSQL);
                    if (disciplineID != null) {
                        String updateSQL;
                        String discCollSql = "select UserGroupScopeID from collection where DisciplineID = " + disciplineID;
                        Vector<Object> collIDsInDisc = BasicSQLUtils.querySingleCol(discCollSql);
                        if (collIDsInDisc != null && collIDsInDisc.size() == 1) {
                            updateSQL = "update spexportschemamapping set CollectionMemberID = " + collIDsInDisc.get(0) + " where SpExportSchemaMappingID = " + row[0];
                            log.info((Object)("Updating exportmapping that has no cache and one collection in its discipline: " + updateSQL));
                            BasicSQLUtils.update(updateSQL);
                            continue;
                        }
                        if (collIDsInDisc == null || collIDsInDisc.size() <= 1) continue;
                        updateSQL = "update spexportschemamapping set CollectionMemberID = " + collIDsInDisc.get(0) + " where SpExportSchemaMappingID = " + row[0];
                        log.info((Object)("Updating exportmapping that has no cache and a discipline with multiple collections: " + updateSQL));
                        BasicSQLUtils.update(updateSQL);
                        continue;
                    }
                    throw new Exception("unable to find discipline for exportschemamapping " + row[0]);
                }
            }
        }
    }

    public static boolean askToUpdateSchema() {
        if (SubPaneMgr.getInstance().aboutToShutdown()) {
            Object[] options = new Object[]{UIRegistry.getResourceString("CONTINUE"), UIRegistry.getResourceString("CANCEL")};
            return JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage(SpecifySchemaUpdateService.mkKey("DB_SCH_UP"), new Object[0]), UIRegistry.getResourceString(SpecifySchemaUpdateService.mkKey("DB_SCH_UP_TITLE")), 0, 3, null, options, options[0]) == 0;
        }
        return false;
    }

    protected boolean checkVersion(String versionFromDB, String localVersionNum, String notNumericErrKey, String localVerTooOldKey, String localVerTooNewKey, boolean checkForTooNew) {
        Integer localVerNum;
        Integer verNumFromDB;
        block4: {
            try {
                log.debug((Object)("App - Prev[" + versionFromDB + "] New[" + localVersionNum + "]"));
                verNumFromDB = Integer.parseInt(StringUtils.replace((String)StringUtils.deleteWhitespace((String)versionFromDB), (String)".", (String)""));
                localVerNum = Integer.parseInt(StringUtils.replace((String)StringUtils.deleteWhitespace((String)localVersionNum), (String)".", (String)""));
                log.debug((Object)("App - Prev[" + verNumFromDB + "] New[" + localVerNum + "]"));
                if (verNumFromDB <= localVerNum) break block4;
                UIRegistry.showLocalizedError(localVerTooOldKey, localVersionNum, versionFromDB);
                return false;
            }
            catch (NumberFormatException ex) {
                UIRegistry.showLocalizedError(notNumericErrKey, localVersionNum, versionFromDB);
                return false;
            }
        }
        if (checkForTooNew && verNumFromDB < localVerNum) {
            UIRegistry.showLocalizedError(localVerTooNewKey, localVersionNum, versionFromDB);
            return false;
        }
        return true;
    }

    public void updateGeographyNames() {
        String FIXED_GEO = "FIXED.GEOGRAPHY";
        AppPreferences.getGlobalPrefs().getBoolean("FIXED.GEOGRAPHY", false).booleanValue();
        String sql = String.format("SELECT COUNT(*) FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = 'geoname'", DBConnection.getInstance().getDatabaseName());
        if (BasicSQLUtils.getCount(sql) == 0) {
            AppPreferences.getGlobalPrefs().putBoolean("FIXED.GEOGRAPHY", true);
            return;
        }
        final int numRecs = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM geoname ge INNER JOIN geography g ON ge.name = g.Name WHERE ge.Name <> ge.asciiname");
        if (BasicSQLUtils.getCount(sql) == 0) {
            AppPreferences.getGlobalPrefs().putBoolean("FIXED.GEOGRAPHY", true);
            return;
        }
        final ProgressFrame prefProgFrame = new ProgressFrame(UIRegistry.getResourceString("UPDATE_SCHEMA_TITLE"));
        prefProgFrame.adjustProgressFrame();
        prefProgFrame.getCloseBtn().setVisible(false);
        prefProgFrame.getProcessProgress().setIndeterminate(true);
        prefProgFrame.setDesc(UIRegistry.getLocalizedMessage("UPDATE_GEO", new Object[0]));
        UIHelper.centerAndShow(prefProgFrame);
        prefProgFrame.setProcess(0, 100);
        SwingWorker<Boolean, Boolean> worker = new SwingWorker<Boolean, Boolean>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                block19: {
                    Statement stmt = null;
                    PreparedStatement pStmt = null;
                    try {
                        try {
                            Connection currDBConn = DBConnection.getInstance().getConnection();
                            pStmt = currDBConn.prepareStatement("UPDATE geography SET Name=? WHERE GeographyID=?");
                            stmt = currDBConn.createStatement();
                            int cnt = 0;
                            String sqlStr = "SELECT ge.asciiname, g.GeographyID FROM geoname ge INNER JOIN geography g ON ge.name = g.Name WHERE ge.Name <> ge.asciiname";
                            ResultSet rs = stmt.executeQuery(sqlStr);
                            while (rs.next()) {
                                pStmt.setString(1, rs.getString(1));
                                pStmt.setInt(2, rs.getInt(2));
                                pStmt.executeUpdate();
                                if (prefProgFrame == null || ++cnt % 100 != 0) continue;
                                this.setProgress((int)((double)(cnt / numRecs) * 100.0));
                            }
                            rs.close();
                            if (prefProgFrame != null) {
                                prefProgFrame.setProcess(numRecs);
                            }
                            AppPreferences.getGlobalPrefs().putBoolean("FIXED.GEOGRAPHY", true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(BuildFromGeonames.class, ex);
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                                if (pStmt != null) {
                                    pStmt.close();
                                }
                                break block19;
                            }
                            catch (Exception ex2) {
                                ex2.printStackTrace();
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (pStmt != null) {
                                pStmt.close();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return true;
            }

            @Override
            protected void done() {
                super.done();
                prefProgFrame.setVisible(false);
                prefProgFrame.dispose();
            }
        };
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    prefProgFrame.setProcess((Integer)evt.getNewValue());
                }
            }
        });
        worker.execute();
    }

    private boolean fixSpQuerySQLLength(Connection conn, String databaseName) {
        BasicSQLUtils.setSkipTrackExceptions(false);
        try {
            BasicSQLUtils.update(conn, "ALTER TABLE spquery CHANGE COLUMN `SqlStr` `SqlStr` TEXT NULL DEFAULT NULL");
        }
        catch (Exception ex) {
            this.errMsgList.add(String.format("Error - Updating %s SpQuery.SqlStr - varchar(64) -> text  Excpt: %s", databaseName, "SpQuery", ex.getMessage()));
            return false;
        }
        BasicSQLUtils.setSkipTrackExceptions(false);
        return true;
    }
}

