/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.sql.Connection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SpecifySchemaUpdateScopeFixer {
    protected static final Logger log = Logger.getLogger(SpecifySchemaUpdateScopeFixer.class);
    protected HashMap<Integer, Integer> colToDspHash = new HashMap();
    protected HashMap<Integer, Integer> colToDivHash = new HashMap();
    protected final String databaseName;

    public SpecifySchemaUpdateScopeFixer(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean fix(Connection conn) {
        String sql = "SELECT c.UserGroupScopeId, d.UserGroupScopeId FROM collection c Inner Join discipline d ON c.DisciplineID = d.UserGroupScopeId";
        for (Object[] row : BasicSQLUtils.query(conn, sql)) {
            this.colToDspHash.put((Integer)row[0], (Integer)row[1]);
        }
        sql = "SELECT c.UserGroupScopeId, d.DivisionId FROM collection c Inner Join discipline d ON c.DisciplineID = d.UserGroupScopeId";
        for (Object[] row : BasicSQLUtils.query(conn, sql)) {
            this.colToDivHash.put((Integer)row[0], (Integer)row[1]);
        }
        String[] memberTableNames = new String[]{"GiftAgent", "GiftPreparation", "LoanAgent", "LoanPreparation", "LoanReturnPreparation", "LocalityCitation", "Shipment"};
        String[] memberIndexNames = new String[]{"GiftAgColMemIDX", "GiftPrepColMemIDX", "LoanAgColMemIDX", "LoanPrepColMemIDX", "LoanRetPrepColMemIDX", "LocCitColMemIDX", "ShipmentColMemIDX"};
        int i = 0;
        while (i < memberTableNames.length) {
            if (!this.fixCollectionMember(conn, memberTableNames[i].toLowerCase(), memberIndexNames[i])) {
                return false;
            }
            ++i;
        }
        return this.fixGroupPerson(conn);
    }

    protected boolean fieldExists(Connection conn, String tableName, String fieldName) {
        DBMSUserMgr dbUserMgr = DBMSUserMgr.getInstance();
        Connection connCache = dbUserMgr.getConnection();
        dbUserMgr.setConnection(conn);
        boolean fieldExists = dbUserMgr.doesFieldExistInTable(tableName, fieldName);
        dbUserMgr.setConnection(connCache);
        return fieldExists;
    }

    protected boolean fixCollectionMember(Connection conn, String tableName, String oldIndexName) {
        log.info((Object)(String.valueOf(tableName) + " - " + oldIndexName));
        if (!this.fieldExists(conn, tableName, "CollectionMemberID")) {
            return true;
        }
        boolean hasDisciplineID = this.fieldExists(conn, tableName, "DisciplineID");
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByShortClassName(tableName);
        if (tblInfo != null && tblInfo.getTableIndexMap() != null) {
            String newIndexName = null;
            for (String key : tblInfo.getTableIndexMap().keySet()) {
                if (!tblInfo.getTableIndexMap().get(key).equals("DisciplineID")) continue;
                newIndexName = key;
                break;
            }
            if (newIndexName != null) {
                String tblName = tableName.toLowerCase();
                int cnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM " + tblName);
                log.debug((Object)String.format("Fixing %d %s records", cnt, tblName));
                HashMap<Integer, Integer> hash = new HashMap<Integer, Integer>();
                String sql = "SELECT " + tblInfo.getIdFieldName() + ", CollectionMemberID FROM " + tblName;
                log.debug((Object)sql);
                for (Object[] row : BasicSQLUtils.query(conn, sql)) {
                    hash.put((Integer)row[0], (Integer)row[1]);
                }
                String dropOldInx = String.format("DROP INDEX %s on %s", oldIndexName, tblName);
                String dropOldCol = String.format("ALTER TABLE %s DROP COLUMN CollectionMemberID", tblName);
                String createNewCol = String.format("ALTER TABLE %s Add COLUMN DisciplineID int(11) ", tblName);
                int rv = BasicSQLUtils.update(conn, dropOldInx);
                rv = BasicSQLUtils.update(conn, dropOldCol);
                if (!hasDisciplineID) {
                    rv = BasicSQLUtils.update(conn, createNewCol);
                }
                sql = "SELECT " + tblInfo.getIdFieldName() + " FROM " + tblName;
                for (Object idObj : BasicSQLUtils.querySingleCol(conn, sql)) {
                    Integer id = (Integer)idObj;
                    Integer oldColMemId = (Integer)hash.get(id);
                    if (oldColMemId == null) continue;
                    sql = "UPDATE " + tblName + " SET DisciplineID=" + this.colToDspHash.get(oldColMemId) + " WHERE " + tblInfo.getIdFieldName() + " = " + id;
                    BasicSQLUtils.update(sql);
                }
                return true;
            }
            log.error((Object)("Couldn't find new Index name for table[" + tableName + "][" + oldIndexName + "]"));
        } else {
            log.error((Object)("Couldn't find new DBTableInfo or the TableIndex HashMap was null table[" + tableName + "][" + oldIndexName + "]"));
        }
        return false;
    }

    public boolean fixGroupPerson(Connection conn) {
        if (!this.fieldExists(conn, "groupperson", "CollectionMemberID")) {
            return true;
        }
        String dropOldInx = "DROP INDEX GPColMemIDX on groupperson";
        String dropOldCol = "ALTER TABLE groupperson DROP COLUMN CollectionMemberID";
        String createNewCol = "ALTER TABLE groupperson Add COLUMN DivisionID int(11)";
        String createNewInx = "CREATE INDEX GPDivMemIDX ON groupperson (DivisionID)";
        String createNewFK = "ALTER TABLE groupperson ADD CONSTRAINT `FK5DEB769497C961D8` FOREIGN KEY (`DivisionID`) REFERENCES `division` (`UserGroupScopeId`)";
        int cnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM groupperson");
        log.debug((Object)String.format("Fixing %d groupperson records", cnt));
        HashMap<Integer, Integer> hash = new HashMap<Integer, Integer>();
        String sql = "SELECT GroupPersonID, CollectionMemberID FROM groupperson";
        for (Object[] row : BasicSQLUtils.query(conn, sql)) {
            hash.put((Integer)row[0], (Integer)row[1]);
        }
        int rv = BasicSQLUtils.update(conn, dropOldInx);
        rv = BasicSQLUtils.update(conn, dropOldCol);
        rv = BasicSQLUtils.update(conn, createNewCol);
        rv = BasicSQLUtils.update(conn, createNewInx);
        rv = BasicSQLUtils.update(conn, createNewFK);
        sql = "SELECT GroupPersonID FROM groupperson";
        for (Object idObj : BasicSQLUtils.querySingleCol(conn, sql)) {
            Integer id = (Integer)idObj;
            Integer oldColMemId = (Integer)hash.get(id);
            if (oldColMemId == null) continue;
            sql = "UPDATE groupperson SET DivisionID=" + this.colToDivHash.get(oldColMemId) + " WHERE GroupPersonID = " + id;
            BasicSQLUtils.update(sql);
        }
        return true;
    }
}

