/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.BaseTreeDef;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.ExchangeIn;
import edu.ku.brc.specify.datamodel.ExchangeOut;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SpecifyQueryAdjusterForDomain
extends QueryAdjusterForDomain {
    protected static final Logger log = Logger.getLogger(SpecifyQueryAdjusterForDomain.class);
    private static final String SPECIFYUSERID = "SPECIFYUSERID";
    private static final String DIVID = "DIVID";
    private static final String DSPLNID = "DSPLNID";
    private static final String COLMEMID = "COLMEMID";
    private static final String COLLID = "COLLID";
    private static final String TAXTREEDEFID = "TAXTREEDEFID";
    private static final String STORTREEDEFID = "STORTREEDEFID";
    private static final String LITHOTREEDEFID = "LITHOTREEDEFID";
    private static final String GTPTREEDEFID = "GTPTREEDEFID";
    private static final String GEOTREEDEFID = "GEOTREEDEFID";
    private boolean permsOKForGlobalSearch = !AppContextMgr.isSecurityOn() || SpecifyUser.isCurrentUserType(SpecifyUserTypes.UserType.Manager);
    private int divisionCnt = 0;
    private int disciplineCnt = 0;
    private int collectionCnt = 0;

    @Override
    public String getSpecialColumns(DBTableInfo tableInfo, boolean isHQL, boolean isLeftJoin, String tblAlias) {
        if (tableInfo != null) {
            String prefix = tblAlias == null ? "" : String.valueOf(tblAlias) + ".";
            String criterion = null;
            String fld = null;
            boolean adjustFldToSQL = true;
            if (tableInfo.getFieldByName("collectionMemberId") != null) {
                fld = isHQL ? "collectionMemberId" : "CollectionMemberId";
                criterion = COLMEMID;
            } else if (tableInfo.getTableId() == Agent.getClassTableId() || tableInfo.getTableId() == Accession.getClassTableId() || tableInfo.getTableId() == RepositoryAgreement.getClassTableId() || tableInfo.getTableId() == ExchangeIn.getClassTableId() || tableInfo.getTableId() == ExchangeOut.getClassTableId()) {
                prefix = prefix.equals("") ? (isHQL ? "dv." : "") : (isHQL ? "dv" + prefix : prefix);
                fld = isHQL ? "divisionId" : "DivisionID";
                criterion = DIVID;
            } else if (tableInfo.getRelationshipByName("discipline") != null) {
                DBRelationshipInfo ri = tableInfo.getRelationshipByName("discipline");
                if (ri.getType() != DBRelationshipInfo.RelationshipType.OneToOne) {
                    prefix = prefix.equals("") ? (isHQL ? "dsp." : "") : (isHQL ? "dsp" + prefix : prefix);
                    fld = isHQL ? "disciplineId" : "DisciplineID";
                    criterion = DSPLNID;
                }
            } else if (tableInfo.getTableId() == Geography.getClassTableId()) {
                fld = isHQL ? "definition" : "GeographyTreeDefID";
                criterion = GEOTREEDEFID;
            } else if (tableInfo.getTableId() == GeologicTimePeriod.getClassTableId()) {
                fld = isHQL ? "definition" : "GeologicTimePeriodTreeDefID";
                criterion = GTPTREEDEFID;
            } else if (tableInfo.getTableId() == LithoStrat.getClassTableId()) {
                fld = isHQL ? "definition" : "LithoStratTreeDefID";
                criterion = LITHOTREEDEFID;
            } else if (tableInfo.getTableId() == Storage.getClassTableId()) {
                fld = isHQL ? "definition" : "StorageTreeDefID";
                criterion = STORTREEDEFID;
            } else if (tableInfo.getTableId() == PrepType.getClassTableId()) {
                fld = isHQL ? "collection" : "CollectionID";
                criterion = COLLID;
            } else if (tableInfo.getTableId() == Taxon.getClassTableId()) {
                fld = isHQL ? "definition" : "TaxonTreeDefID";
                criterion = TAXTREEDEFID;
            } else if (tableInfo.getTableId() == Locality.getClassTableId()) {
                fld = isHQL ? "discipline" : "DisciplineID";
                criterion = DSPLNID;
            } else if (tableInfo.getTableId() == Locality.getClassTableId()) {
                fld = isHQL ? "discipline" : "DisciplineID";
                criterion = DSPLNID;
            } else if (tableInfo.getTableId() == Locality.getClassTableId()) {
                fld = isHQL ? "discipline" : "DisciplineID";
                criterion = DSPLNID;
            }
            if (criterion != null && fld != null) {
                String sql = adjustFldToSQL ? "(" + prefix + fld + " = " + criterion + ")" : fld;
                if (isLeftJoin) {
                    if (isHQL) {
                        if (tblAlias != null) {
                            sql = "(" + sql + " or " + tblAlias + " is null)";
                        } else {
                            log.error((Object)"can't adjust hql for left join without a tblAlias.");
                        }
                    } else {
                        sql = "(" + sql + " or " + prefix + fld + " is null)";
                    }
                }
                return this.adjustSQL(sql);
            }
        }
        return null;
    }

    @Override
    public String getJoinClause(DBTableInfo tableInfo, boolean isHQL, String aliasArg, boolean useLeftJoin) {
        DBRelationshipInfo ri;
        String alias = aliasArg == null ? tableInfo.getAbbrev() : aliasArg;
        String join = useLeftJoin ? "left join " : (isHQL ? "join " : "inner join ");
        if (tableInfo.getTableId() == Agent.getClassTableId() || tableInfo.getTableId() == Accession.getClassTableId() || tableInfo.getTableId() == RepositoryAgreement.getClassTableId() || tableInfo.getTableId() == ExchangeIn.getClassTableId() || tableInfo.getTableId() == ExchangeOut.getClassTableId()) {
            if (isHQL) {
                return String.valueOf(join) + alias + ".division as dv" + (aliasArg == null ? "" : alias);
            }
            if (aliasArg != null) {
                return "";
            }
            return join;
        }
        if (tableInfo.getRelationshipByName("discipline") != null && (ri = tableInfo.getRelationshipByName("discipline")).getType() != DBRelationshipInfo.RelationshipType.OneToOne) {
            if (isHQL) {
                return String.valueOf(join) + alias + ".discipline as dsp" + (aliasArg == null ? "" : alias);
            }
            return String.valueOf(join) + "discipline as dsp ON " + aliasArg + ".DisciplineID = dsp.DisciplineID";
        }
        return super.getJoinClause(tableInfo, isHQL, alias, useLeftJoin);
    }

    private int checkAhead(String lowerSQL, int startInx, String key) {
        int bInx = lowerSQL.lastIndexOf(key, startInx);
        int diff = startInx - bInx;
        if (diff == key.length() + 1) {
            return diff;
        }
        return 0;
    }

    private int checkAfter(String lowerSQL, int endInx, String key) {
        int diff;
        int bInx = lowerSQL.indexOf(key, endInx);
        if (bInx > -1 && (diff = bInx - endInx) == 2) {
            return key.length() + 1;
        }
        return 0;
    }

    public static String itrim(String source) {
        return source.replaceAll("\\s+", " ");
    }

    private String removeSpecialFilter(String specialSQL, String key) {
        int startInx;
        int endInx;
        String lowerSQL = specialSQL.toLowerCase();
        String frontStr = "";
        String whereStr = "";
        int whereInx = lowerSQL.indexOf("where");
        if (whereInx == -1) {
            whereInx = 0;
            whereStr = specialSQL;
        } else {
            frontStr = specialSQL.substring(0, whereInx += 6);
            whereStr = SpecifyQueryAdjusterForDomain.itrim(specialSQL.substring(whereInx, specialSQL.length()));
            lowerSQL = SpecifyQueryAdjusterForDomain.itrim(lowerSQL.substring(whereInx, specialSQL.length()));
        }
        int inx = whereStr.indexOf(key);
        if (inx > -1 && (endInx = inx + key.length()) < whereStr.length() && lowerSQL.charAt(endInx) == ')' && (startInx = lowerSQL.lastIndexOf(40, inx)) > -1) {
            int bInx = this.checkAhead(lowerSQL, startInx, "and");
            if (bInx > 0) {
                startInx -= bInx;
            } else {
                bInx = this.checkAhead(lowerSQL, startInx, "or");
                if (bInx > 0) {
                    startInx -= bInx;
                } else {
                    int eInx = this.checkAfter(lowerSQL, endInx, "and");
                    endInx = eInx > 0 ? (endInx += eInx) : (endInx += this.checkAfter(lowerSQL, endInx, "or"));
                }
            }
            String segment = whereStr.substring(startInx, endInx + 1);
            String newStr = String.valueOf(frontStr) + StringUtils.remove((String)whereStr, (String)segment);
            return newStr;
        }
        return null;
    }

    @Override
    public String adjustSQL(String sql) {
        AppPreferences locPrefs = AppPreferences.getLocalPrefs();
        boolean doGlobalSearch = this.permsOKForGlobalSearch && locPrefs.getBoolean("GLOBAL_SEARCH_AVAIL", false) != false && locPrefs.getBoolean("GLOBAL_SEARCH", false) != false;
        SpecifyUser user = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        if (user != null) {
            Integer id = user.getId();
            if (id != null) {
                BaseTreeDef lithoTreeDef;
                StorageTreeDef locTreeDef;
                TaxonTreeDef taxonTreeDef;
                Collection collection;
                String adjustedSQL;
                String adjSQL = sql;
                if (StringUtils.contains((String)adjSQL, (String)SPECIFYUSERID)) {
                    adjSQL = StringUtils.replace((String)adjSQL, (String)SPECIFYUSERID, (String)Integer.toString(id));
                }
                if (StringUtils.contains((String)adjSQL, (String)DIVID)) {
                    adjustedSQL = null;
                    if (doGlobalSearch || this.divisionCnt == 1) {
                        adjustedSQL = this.removeSpecialFilter(adjSQL, DIVID);
                    }
                    if (adjustedSQL == null) {
                        Integer divId = null;
                        Division division = AppContextMgr.getInstance().getClassObject(Division.class);
                        if (division != null) {
                            divId = division.getId();
                        } else {
                            Integer n = divId = Agent.getUserAgent().getDivision() != null ? Agent.getUserAgent().getDivision().getDivisionId() : null;
                        }
                        if (divId != null) {
                            adjSQL = StringUtils.replace((String)adjSQL, (String)DIVID, (String)Integer.toString(divId));
                        }
                    } else {
                        adjSQL = adjustedSQL;
                    }
                }
                if (StringUtils.contains((String)adjSQL, (String)COLMEMID)) {
                    adjustedSQL = null;
                    if (doGlobalSearch || this.collectionCnt == 1) {
                        adjustedSQL = this.removeSpecialFilter(adjSQL, COLMEMID);
                    }
                    if (adjustedSQL == null) {
                        collection = AppContextMgr.getInstance().getClassObject(Collection.class);
                        if (collection != null) {
                            adjSQL = StringUtils.replace((String)adjSQL, (String)COLMEMID, (String)Integer.toString(collection.getCollectionId()));
                        }
                    } else {
                        adjSQL = adjustedSQL;
                    }
                }
                if (StringUtils.contains((String)adjSQL, (String)COLLID)) {
                    adjustedSQL = null;
                    if (doGlobalSearch || this.collectionCnt == 1) {
                        adjustedSQL = this.removeSpecialFilter(adjSQL, COLLID);
                    }
                    if (adjustedSQL == null) {
                        collection = AppContextMgr.getInstance().getClassObject(Collection.class);
                        if (collection != null) {
                            adjSQL = StringUtils.replace((String)adjSQL, (String)COLLID, (String)Integer.toString(collection.getCollectionId()));
                        }
                    } else {
                        adjSQL = adjustedSQL;
                    }
                }
                if (StringUtils.contains((String)adjSQL, (String)DSPLNID)) {
                    adjustedSQL = null;
                    if (doGlobalSearch || this.disciplineCnt == 1) {
                        adjustedSQL = this.removeSpecialFilter(adjSQL, DSPLNID);
                    }
                    if (adjustedSQL == null) {
                        Discipline discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
                        if (discipline != null) {
                            adjSQL = StringUtils.replace((String)adjSQL, (String)DSPLNID, (String)Integer.toString(discipline.getDisciplineId()));
                        }
                    } else {
                        adjSQL = adjustedSQL;
                    }
                }
                if (StringUtils.contains((String)adjSQL, (String)TAXTREEDEFID) && (taxonTreeDef = AppContextMgr.getInstance().getClassObject(TaxonTreeDef.class)) != null) {
                    adjSQL = StringUtils.replace((String)adjSQL, (String)TAXTREEDEFID, (String)Integer.toString(taxonTreeDef.getTaxonTreeDefId()));
                }
                if (StringUtils.contains((String)adjSQL, (String)GTPTREEDEFID)) {
                    GeologicTimePeriodTreeDef gtpTreeDef = AppContextMgr.getInstance().getClassObject(GeologicTimePeriodTreeDef.class);
                    if (gtpTreeDef != null) {
                        adjSQL = StringUtils.replace((String)adjSQL, (String)GTPTREEDEFID, (String)Integer.toString(gtpTreeDef.getGeologicTimePeriodTreeDefId()));
                    } else {
                        return null;
                    }
                }
                if (StringUtils.contains((String)adjSQL, (String)STORTREEDEFID) && (locTreeDef = AppContextMgr.getInstance().getClassObject(StorageTreeDef.class)) != null) {
                    adjSQL = StringUtils.replace((String)adjSQL, (String)STORTREEDEFID, (String)Integer.toString(locTreeDef.getStorageTreeDefId()));
                }
                if (StringUtils.contains((String)adjSQL, (String)LITHOTREEDEFID)) {
                    lithoTreeDef = AppContextMgr.getInstance().getClassObject(LithoStratTreeDef.class);
                    if (lithoTreeDef != null) {
                        adjSQL = StringUtils.replace((String)adjSQL, (String)LITHOTREEDEFID, (String)Integer.toString(((LithoStratTreeDef)lithoTreeDef).getLithoStratTreeDefId()));
                    } else {
                        return null;
                    }
                }
                if (StringUtils.contains((String)adjSQL, (String)GEOTREEDEFID) && (lithoTreeDef = AppContextMgr.getInstance().getClassObject(GeographyTreeDef.class)) != null) {
                    adjSQL = StringUtils.replace((String)adjSQL, (String)GEOTREEDEFID, (String)Integer.toString(((GeographyTreeDef)lithoTreeDef).getGeographyTreeDefId()));
                }
                return adjSQL;
            }
            throw new RuntimeException("The SpecifyUser ID cannot be null!");
        }
        throw new RuntimeException("The SpecifyUser cannot be null!");
    }

    public boolean isPermsOKForGlobalSearch() {
        return this.permsOKForGlobalSearch;
    }
}

