/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpAuditLog;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;

public class SpecifyDeleteHelper {
    private static String CNT = "CNT";
    private static String MSG = "MSG";
    private static String STR2PARM = "%s %s";
    private static String STR3PARM = "%s %s %s";
    protected static boolean debug = false;
    protected static boolean debugUpdate = false;
    protected String delMsgStr;
    protected DBTableIdMgr tblMgr;
    protected boolean doTrees = true;
    protected Integer totalCount = null;
    protected int counter = 0;
    protected SwingWorker<?, ?> worker = null;
    protected JProgressBar progressBar = null;
    protected JLabel titleLbl = null;
    protected Connection connection = null;
    protected HashSet<Class<?>> classHash = new HashSet();

    public SpecifyDeleteHelper() {
        this.delMsgStr = UIRegistry.getResourceString("DELETING");
        this.tblMgr = DBTableIdMgr.getInstance();
        DBConnection dbConn = DBConnection.getInstance();
        this.connection = dbConn.createConnection();
    }

    public JDialog initProgress(SwingWorker<?, ?> workerArg, String title) {
        this.worker = workerArg;
        if (workerArg != null) {
            JDialog dialog = new JDialog(null, true);
            this.titleLbl = new JLabel(title);
            this.progressBar = new JProgressBar(0, 100);
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,p,4px,p,f:p:g"));
            pb.add((Component)this.titleLbl, cc.xy(1, 2));
            pb.add((Component)this.progressBar, cc.xy(1, 4));
            pb.setDefaultDialogBorder();
            dialog.setContentPane(pb.getPanel());
            dialog.setDefaultCloseOperation(0);
            dialog.pack();
            dialog.setSize(500, 150);
            workerArg.addPropertyChangeListener(new SwingWorkerCompletionWaiter(dialog));
            return dialog;
        }
        return null;
    }

    private void fireMsg(String msgKey, Object ... vals) {
        if (this.worker != null) {
            this.worker.firePropertyChange(MSG, null, UIRegistry.getLocalizedMessage(msgKey, vals));
        }
    }

    public void rollback() {
        try {
            if (this.connection != null) {
                this.connection.rollback();
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyDeleteHelper.class, ex);
            ex.printStackTrace();
        }
    }

    public void done(boolean doClose) {
        if (this.worker != null) {
            this.worker.firePropertyChange(CNT, (Object)SwingWorker.StateValue.DONE, (Object)SwingWorker.StateValue.DONE);
        }
        if (doClose) {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyDeleteHelper.class, ex);
                ex.printStackTrace();
            }
        }
    }

    public boolean isRecordDeletable(Class<?> cls, int id) {
        boolean result;
        try {
            try {
                this.delRecordFromTable(cls, id, true);
                result = true;
            }
            catch (SQLException ex) {
                result = false;
            }
        }
        finally {
            this.rollback();
        }
        return result;
    }

    public boolean isRecordRequired(Class<?> cls, int id, Class<?> excludeCls, int[] excludeFromRequirement) throws SQLException {
        StackItem root = new StackItem(null, null, null);
        DBTableInfo tblInfo = this.tblMgr.getByShortClassName(cls.getSimpleName());
        String sqlStr = "SELECT " + tblInfo.getIdColumnName() + " FROM " + tblInfo.getName() + " WHERE " + tblInfo.getIdColumnName() + " = ";
        this.getSubTables(root, cls, id, sqlStr, null, 0, null, true);
        Statement stmt = this.connection.createStatement();
        try {
            if (stmt != null) {
                for (StackItem si : root.getStack()) {
                    if (!this.checkRequiredRecs(si, 0, id, excludeCls, excludeFromRequirement)) continue;
                    return true;
                }
            }
        }
        finally {
            stmt.close();
        }
        return false;
    }

    public boolean isRecordShared(Class<?> cls, Integer id) throws SQLException {
        StackItem root = new StackItem(null, null, null);
        this.getSubTables(root, cls, id, null, null, 0, null, true);
        StackItem s = root.getStack().peek();
        for (StackItem si : s.getStack()) {
            System.out.println(String.valueOf(si.getSql()) + id);
            Vector<Integer> ids = this.getIds(String.valueOf(si.getSql()) + id, -1);
            if (ids != null && ids.size() > 1) {
                return true;
            }
            if (ids == null || ids.size() != 1 || !this.isRecordShared(si.getTableInfo().getClassObj(), ids.get(0))) continue;
            return true;
        }
        return false;
    }

    public boolean checkRequiredRecs(StackItem si, int level, int id, Class<?> excludeCls, int[] excludeFromRequirement) throws SQLException {
        Vector<Integer> ids = this.getIds(String.valueOf(si.getSql()) + id, level);
        if (si.getTableInfo().getClassObj().equals(excludeCls)) {
            int[] nArray = excludeFromRequirement;
            int n = excludeFromRequirement.length;
            int n2 = 0;
            while (n2 < n) {
                int exid = nArray[n2];
                int idx = ids.indexOf(exid);
                if (idx != -1) {
                    ids.remove(idx);
                }
                ++n2;
            }
        }
        return ids.size() > 0;
    }

    public boolean delRecordFromTable(Class<?> cls, int id, boolean doDeleteId) throws SQLException {
        StackItem root = new StackItem(null, null, null);
        DBTableInfo tblInfo = this.tblMgr.getByShortClassName(cls.getSimpleName());
        String sqlStr = "SELECT " + tblInfo.getIdColumnName() + " FROM " + tblInfo.getName() + " WHERE " + tblInfo.getIdColumnName() + " = ";
        String delStr = doDeleteId ? "DELETE FROM " + tblInfo.getName() + " WHERE " + tblInfo.getIdColumnName() + " = " : null;
        this.fireMsg("INITIALIZING", new Object[0]);
        this.getSubTables(root, cls, id, sqlStr, delStr, 0, null, false);
        debug = false;
        if (debug) {
            System.out.println("\n------------------------------------------\n");
            this.dumpStack(root, 0);
        }
        boolean isAutoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        Statement stmt = this.connection.createStatement();
        if (stmt != null) {
            for (StackItem si : root.getStack()) {
                this.fireMsg(STR2PARM, this.delMsgStr, si.getTableInfo().getTitle());
                this.deleteRecords(si, 0, id, stmt, false);
            }
            if (debug) {
                System.out.println("Count: " + this.counter);
            }
            if (!debug) {
                this.totalCount = this.counter;
                this.counter = 0;
                if (this.worker != null && this.totalCount != null) {
                    this.worker.firePropertyChange(CNT, this.totalCount, (int)(100.0 * (double)this.counter / (double)this.totalCount.intValue()));
                }
                for (StackItem si : root.getStack()) {
                    this.deleteRecords(si, 0, id, stmt, true);
                }
            }
            stmt.close();
            this.connection.commit();
            this.connection.setAutoCommit(isAutoCommit);
            return true;
        }
        return false;
    }

    protected void printLevel(int level) {
        int i = 0;
        while (i < level) {
            System.out.print("  ");
            ++i;
        }
    }

    protected StackItem getSubTables(StackItem parent, Class<?> cls, int id, String sqlStr, String delSqlStr, int level, Hashtable<String, Boolean> inUseHashArg, boolean checkIfIsShared) {
        if (this.classHash.contains(cls)) {
            return null;
        }
        this.classHash.add(cls);
        if (debug) {
            this.printLevel(level);
            System.out.println(cls.getSimpleName());
        }
        DBTableInfo tblInfo = this.tblMgr.getByShortClassName(cls.getSimpleName());
        StackItem child = parent.push(tblInfo, sqlStr, delSqlStr);
        Hashtable<String, Boolean> inUseHash = inUseHashArg == null && level == 1 ? new Hashtable<String, Boolean>() : inUseHashArg;
        Method[] methodArray = cls.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block55: {
                Method method = methodArray[n2];
                String methodName = method.getName();
                if (methodName.startsWith("get") && !method.isAnnotationPresent(Transient.class)) {
                    if (methodName.endsWith("TreeDef")) {
                        if (this.doTrees) {
                            Class<?> treeClass;
                            Vector<Integer> ids;
                            String sql;
                            String itemTableNameTDI;
                            String primaryKeyTD;
                            String tableNameTD;
                            String className;
                            block56: {
                                className = methodName.substring(3, methodName.length() - 7);
                                tableNameTD = String.valueOf(className.toLowerCase()) + "treedef";
                                primaryKeyTD = String.valueOf(className) + "TreeDefID";
                                itemTableNameTDI = String.valueOf(className.toLowerCase()) + "treedefitem";
                                sql = "SELECT " + primaryKeyTD + " FROM " + tblInfo.getName() + " WHERE " + tblInfo.getIdColumnName() + " = " + id;
                                if (debugUpdate) {
                                    System.err.println(sql);
                                }
                                if ((ids = this.getIds(sql, level)) == null || ids.size() <= 0) break block55;
                                treeClass = null;
                                try {
                                    treeClass = Class.forName("edu.ku.brc.specify.datamodel." + className);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(SpecifyDeleteHelper.class, ex);
                                }
                                if (treeClass != cls) break block56;
                                this.classHash.remove(cls);
                                return null;
                            }
                            try {
                                String delSql;
                                if (treeClass == Taxon.class) {
                                    String tmpSql = "SELECT tc.TaxonCitationID FROM taxoncitation tc INNER JOIN taxon tx ON tc.TaxonID = tx.TaxonID INNER JOIN taxontreedef ttd ON tx.TaxonTreeDefID = ttd.TaxonTreeDefID = " + ids.get(0);
                                    delSql = "DELETE FROM taxoncitation WHERE TaxonCitationID = ";
                                    child.pushPPS(new StackItem(null, tmpSql, delSql, false, true));
                                }
                                delSql = "DELETE FROM " + className.toLowerCase() + " WHERE " + primaryKeyTD + " = " + ids.get(0) + " ORDER BY AcceptedID DESC, ParentID DESC";
                                child.pushPPS(new StackItem(null, sql, delSql, false, false));
                                delSql = "DELETE FROM " + itemTableNameTDI + " WHERE " + primaryKeyTD + " = " + ids.get(0) + " ORDER BY RankID DESC";
                                child.pushPPS(new StackItem(null, sql, delSql, false, false));
                                delSql = "DELETE FROM " + tableNameTD + " WHERE " + primaryKeyTD + " = " + ids.get(0);
                                child.pushPPS(new StackItem(null, sql, delSql, false, false));
                            }
                            catch (SQLException ex) {
                                UsageTracker.incrSQLUsageCount();
                                ExceptionTracker.getInstance().capture(SpecifyDeleteHelper.class, ex);
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        String relName;
                        DBRelationshipInfo relInfo;
                        JoinTable joinTable;
                        String colName = null;
                        boolean isOKToDel = false;
                        boolean includeSubTable = false;
                        if (method.isAnnotationPresent(OneToMany.class)) {
                            String nm = method.getName();
                            boolean isAttachment = nm.indexOf("Attachment") > -1;
                            boolean doDel = false;
                            OneToMany oneToMany2 = method.getAnnotation(OneToMany.class);
                            CascadeType[] cascadeTypeArray = oneToMany2.cascade();
                            int n3 = cascadeTypeArray.length;
                            int tmpSql = 0;
                            while (tmpSql < n3) {
                                CascadeType ct = cascadeTypeArray[tmpSql];
                                if (ct == CascadeType.ALL || ct == CascadeType.REMOVE) {
                                    doDel = true;
                                    break;
                                }
                                ++tmpSql;
                            }
                            if (!isAttachment && !doDel && method.isAnnotationPresent(Cascade.class)) {
                                Cascade cascade = method.getAnnotation(Cascade.class);
                                org.hibernate.annotations.CascadeType[] cascadeTypeArray2 = cascade.value();
                                int n4 = cascadeTypeArray2.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    org.hibernate.annotations.CascadeType ct = cascadeTypeArray2[n3];
                                    if (ct == org.hibernate.annotations.CascadeType.ALL || ct == org.hibernate.annotations.CascadeType.DELETE || ct == org.hibernate.annotations.CascadeType.REMOVE) {
                                        doDel = true;
                                        break;
                                    }
                                    ++n3;
                                }
                            }
                            boolean bl = isOKToDel = !doDel ? this.isOKToDel(method) : true;
                            if (checkIfIsShared && cls.equals(Geography.class) && method.getName().equals("getLocalities")) {
                                isOKToDel = false;
                            }
                            includeSubTable = !checkIfIsShared ? isOKToDel : !isOKToDel;
                            colName = tblInfo.getIdColumnName();
                        } else if (!checkIfIsShared && method.isAnnotationPresent(ManyToOne.class)) {
                            JoinColumn joinCol;
                            boolean doDel = false;
                            ManyToOne oneToMany = method.getAnnotation(ManyToOne.class);
                            CascadeType[] ct = oneToMany.cascade();
                            int cascade = ct.length;
                            int oneToMany2 = 0;
                            while (oneToMany2 < cascade) {
                                CascadeType ct2 = ct[oneToMany2];
                                if (ct2 == CascadeType.ALL || ct2 == CascadeType.REMOVE) {
                                    doDel = true;
                                }
                                ++oneToMany2;
                            }
                            boolean bl = isOKToDel = !doDel ? this.isOKToDel(method) : true;
                            boolean bl2 = !checkIfIsShared ? isOKToDel : (includeSubTable = !isOKToDel);
                            if (includeSubTable && (joinCol = method.getAnnotation(JoinColumn.class)) != null) {
                                colName = joinCol.name();
                            }
                        } else if (method.isAnnotationPresent(ManyToMany.class) && (joinTable = method.getAnnotation(JoinTable.class)) != null) {
                            String joinTableName = joinTable.name();
                            String joinColName = null;
                            JoinColumn[] cascade = joinTable.joinColumns();
                            if (cascade.length != 0) {
                                JoinColumn jc = cascade[0];
                                joinColName = jc.name();
                            }
                            DBRelationshipInfo relInfo2 = null;
                            for (DBRelationshipInfo ri : tblInfo.getRelationships()) {
                                if (ri.getJoinTable() == null || !ri.getJoinTable().equals(joinTableName)) continue;
                                relInfo2 = ri;
                                break;
                            }
                            System.out.println(joinColName);
                            if (cls != Agent.class) {
                                if (inUseHash != null) {
                                    inUseHash.put(relInfo2.getClassName(), true);
                                }
                                String sql = "SELECT " + joinColName + " FROM " + joinTableName + " WHERE " + joinColName + " = ";
                                String delSql = "DELETE FROM " + joinTableName + " WHERE " + joinColName + " = ";
                                if (debug) {
                                    this.printLevel(level);
                                    System.out.println(sql);
                                }
                                DBTableInfo ti = this.tblMgr.getByShortClassName(relInfo2.getDataClass().getSimpleName());
                                if (!checkIfIsShared) {
                                    child.push(ti, sql, delSql);
                                }
                            }
                        }
                        if (includeSubTable && (relInfo = tblInfo.getRelationshipByName(relName = method.getName().substring(3))) != null) {
                            DBTableInfo ti = this.tblMgr.getByClassName(relInfo.getClassName());
                            if (ti != null) {
                                String sql;
                                if (method.isAnnotationPresent(OneToMany.class)) {
                                    String otherColName = colName;
                                    DBRelationshipInfo ri = ti.getRelationshipByName(relInfo.getOtherSide());
                                    if (ri != null) {
                                        otherColName = ri.getColName();
                                    }
                                    sql = "SELECT " + ti.getAbbrev() + "." + ti.getIdColumnName() + " FROM " + ti.getName() + " " + ti.getAbbrev() + " INNER JOIN " + tblInfo.getName() + " " + tblInfo.getAbbrev() + " ON " + ti.getAbbrev() + "." + otherColName + " = " + tblInfo.getAbbrev() + "." + tblInfo.getIdColumnName() + "  WHERE " + tblInfo.getAbbrev() + "." + colName + " = ";
                                } else {
                                    sql = "SELECT " + ti.getAbbrev() + "." + ti.getIdColumnName() + " FROM " + ti.getName() + " " + ti.getAbbrev() + " INNER JOIN " + tblInfo.getName() + " " + tblInfo.getAbbrev() + " ON " + ti.getAbbrev() + "." + ti.getIdColumnName() + " = " + tblInfo.getAbbrev() + "." + colName + "  WHERE " + tblInfo.getAbbrev() + "." + tblInfo.getIdColumnName() + " = ";
                                }
                                String delSql = "DELETE FROM " + ti.getName() + " WHERE " + ti.getIdColumnName() + " = ";
                                if (debug) {
                                    this.printLevel(level);
                                    System.out.println(sql);
                                    this.printLevel(level);
                                    System.out.println(delSql);
                                }
                                if (relInfo.getDataClass() != Agent.class) {
                                    if (inUseHash != null) {
                                        inUseHash.put(relInfo.getClassName(), true);
                                    }
                                    if (ti.getClassObj() != cls || this.doTrees && !Treeable.class.isAssignableFrom(cls)) {
                                        if (!checkIfIsShared) {
                                            this.getSubTables(child, ti.getClassObj(), id, sql, delSql, level + 1, inUseHash, checkIfIsShared);
                                        } else {
                                            child.push(ti, sql, delSql);
                                        }
                                    } else if (debug) {
                                        System.err.println("Skipping " + ti.getClassObj().getSimpleName());
                                    }
                                }
                            } else {
                                String shortClassName = relInfo.getDataClass().getSimpleName();
                                String sql = "SELECT " + shortClassName + "ID FROM " + shortClassName.toLowerCase() + " WHERE " + tblInfo.getClassObj().getSimpleName() + "ID = ";
                                String delSql = "DELETE FROM " + shortClassName.toLowerCase() + " WHERE " + shortClassName + "ID = ";
                                if (debug) {
                                    this.printLevel(level);
                                    System.out.println(sql);
                                    this.printLevel(level);
                                    System.out.println(delSql);
                                }
                                child.push(tblInfo, sql, delSql);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        for (DBTableInfo ti : this.tblMgr.getTables()) {
            if (ti == tblInfo) continue;
            for (DBRelationshipInfo ri : ti.getRelationships()) {
                boolean hashOK;
                if (ri.getDataClass() == Agent.class) continue;
                boolean bl = hashOK = inUseHash == null || inUseHash.get(ti.getClassName()) == null;
                if (ri.getDataClass() == tblInfo.getClassObj() && hashOK && StringUtils.isEmpty((String)ri.getOtherSide())) {
                    String sql = "SELECT " + ti.getIdColumnName() + " FROM " + ti.getName() + "  WHERE " + ri.getColName() + " = ";
                    String delSql = "DELETE FROM " + ti.getName() + "  WHERE " + ti.getIdColumnName() + " = ";
                    if (debug) {
                        this.printLevel(level);
                        System.out.println("Missed " + ti.getClassName() + " for " + tblInfo.getClassObj());
                        this.printLevel(level);
                        System.out.println(sql);
                    }
                    if (inUseHash != null) {
                        inUseHash.put(ti.getClassName(), true);
                    }
                    this.getSubTables(child, ti.getClassObj(), id, sql, delSql, level + 1, inUseHash, checkIfIsShared);
                    continue;
                }
                if (ri.getDataClass() != tblInfo.getClassObj() || hashOK || !StringUtils.isEmpty((String)ri.getOtherSide()) || !debug) continue;
                System.out.println("Skipping " + ti.getClassObj().getSimpleName() + " for " + tblInfo.getClassObj().getSimpleName());
            }
        }
        if (debug) {
            System.out.println();
        }
        this.classHash.remove(cls);
        return child;
    }

    protected boolean isOKToDel(Method method) {
        Cascade hibCascade = method.getAnnotation(Cascade.class);
        if (hibCascade != null) {
            boolean isAllOrDel = false;
            org.hibernate.annotations.CascadeType[] cascadeTypeArray = hibCascade.value();
            int n = cascadeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.hibernate.annotations.CascadeType ct = cascadeTypeArray[n2];
                if (ct == org.hibernate.annotations.CascadeType.ALL || ct == org.hibernate.annotations.CascadeType.DELETE) {
                    isAllOrDel = true;
                } else if (isAllOrDel && ct == org.hibernate.annotations.CascadeType.DELETE_ORPHAN) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void dumpStack(StackItem si, int level) {
        this.printLevel(level);
        System.out.print(" -- ");
        System.out.println(si.getTableInfo() == null ? "Root" : String.valueOf(si.getTableInfo().getName()) + " -- ");
        for (StackItem s : si.getStack()) {
            this.dumpStack(s, level + 1);
        }
        if (si.getSql() != null) {
            this.printLevel(level);
            System.out.println(si.getSql());
        }
    }

    protected Vector<Integer> getIds(String sqlArg, int level) throws SQLException {
        int cnt = 0;
        Vector<Integer> ids = null;
        if (sqlArg != null) {
            ids = new Vector<Integer>();
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(sqlArg);
            while (rs.next()) {
                int rowId = rs.getInt(1);
                ids.add(rowId);
                ++cnt;
            }
            rs.close();
            stmt.close();
            this.counter += cnt;
        }
        return ids;
    }

    protected void deleteRecords(StackItem si, int level, int id, Statement stmt, boolean doDeletes) throws SQLException {
        if (!this.doTrees && (si.getTableInfo() == null || Treeable.class.isAssignableFrom(si.getTableInfo().getClassObj()))) {
            return;
        }
        if (debugUpdate) {
            this.printLevel(level);
            System.out.print(" -- ");
            System.out.println(si.getTableInfo() == null ? "Root" : String.valueOf(si.getTableInfo().getName()) + " -- ");
        }
        int cnt = 0;
        Vector<Integer> ids = null;
        if (si.getSql() != null && (si.isBuildingSQL() || si.isBuildingDelSQL())) {
            String sql;
            ids = new Vector<Integer>();
            String string = sql = si.isBuildingSQL() ? String.valueOf(si.getSql()) + Integer.toString(id) : si.getSql();
            if (debugUpdate) {
                System.err.println(sql);
            }
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int rowId = rs.getInt(1);
                ids.add(rowId);
                if (debugUpdate) {
                    this.printLevel(level);
                    System.out.println("Adding ID: " + rowId + "  " + (si.getTableInfo() != null ? si.getTableInfo().getName() : "N/A"));
                }
                Statement statement = this.connection.createStatement();
                for (StackItem s : si.getStack()) {
                    this.deleteRecords(s, level + 1, rowId, statement, doDeletes);
                }
                statement.close();
                ++cnt;
            }
            rs.close();
            this.counter += cnt;
            if (debugUpdate) {
                System.err.println("Items returned: " + cnt);
            }
        }
        if (doDeletes) {
            String delSql;
            if (si.isBuildingDelSQL()) {
                if (ids != null) {
                    if (cnt > 0) {
                        for (Integer itemId : ids) {
                            if (si.getDelSql() == null) continue;
                            String delSql2 = String.valueOf(si.getDelSql()) + itemId;
                            if (StringUtils.contains((String)si.getDelSql(), (String)"XXX")) {
                                delSql2 = StringUtils.replace((String)si.getDelSql(), (String)"XXX", (String)Integer.toString(itemId));
                            }
                            if (si.getTableInfo().getClassObj() == Discipline.class && StringUtils.contains((String)delSql2, (String)"FROM discipline")) {
                                this.deleteDiscipline(delSql2, itemId);
                                continue;
                            }
                            if (si.getTableInfo().getClassObj() == Division.class && StringUtils.contains((String)delSql2, (String)"FROM division")) {
                                this.cleanUpAgentsForDivision(id);
                            } else if (si.getTableInfo().getName().endsWith("attribute")) {
                                String preDelSql = "update " + si.getTableInfo().getName().replace("attribute", "") + " set " + si.getTableInfo().getPrimaryKeyName() + " = null where " + si.getTableInfo().getPrimaryKeyName() + " = " + itemId;
                                if (debugUpdate) {
                                    System.err.println(preDelSql);
                                }
                                int count = stmt.executeUpdate(preDelSql);
                                if (debugUpdate) {
                                    System.err.println("Count: " + count);
                                }
                            }
                            if (debugUpdate) {
                                System.err.println(delSql2);
                            }
                            int count = stmt.executeUpdate(delSql2);
                            if (!debugUpdate) continue;
                            System.err.println("Count: " + count);
                        }
                    }
                } else if (si.getDelSql() != null) {
                    delSql = String.valueOf(si.getDelSql()) + id;
                    if (debugUpdate) {
                        System.err.println(delSql);
                    }
                    int count = stmt.executeUpdate(delSql);
                    if (debugUpdate) {
                        System.err.println("Count: " + count);
                    }
                }
            } else if (si.getDelSql() != null) {
                delSql = si.getDelSql();
                if (debugUpdate) {
                    System.err.println("*****: " + delSql);
                }
                int count = stmt.executeUpdate(delSql);
                if (debugUpdate) {
                    System.err.println("Count: " + count);
                }
            }
            for (StackItem stckItm : si.getPostProcStack()) {
                this.deleteRecords(stckItm, level + 2, id, stmt, true);
            }
        }
        if (debugUpdate) {
            this.printLevel(level);
            System.out.println("Records to delete: " + cnt);
        }
        if (this.totalCount != null && debugUpdate) {
            System.err.println(String.valueOf(this.counter) + " / " + this.totalCount);
        }
        if (this.worker != null && this.totalCount != null) {
            this.worker.firePropertyChange(CNT, this.totalCount, (int)(100.0 * (double)this.counter / (double)this.totalCount.intValue()));
        }
    }

    protected void deleteDiscipline(String delSql, int id) throws SQLException {
        this.progressBar.setIndeterminate(true);
        String dispName = (String)BasicSQLUtils.querySingleObj("SELECT Name FROM discipline WHERE DisciplineID = " + id);
        this.fireMsg(STR3PARM, this.delMsgStr, dispName, this.tblMgr.getTitleForId(Discipline.getClassTableId()));
        Statement stmt = this.connection.createStatement();
        for (Integer collId : BasicSQLUtils.queryForInts("SELECT CollectionID FROM collection WHERE DisciplineID = " + id)) {
            String dSQL = "DELETE FROM sptasksemaphore WHERE CollectionID = " + collId;
            int count = stmt.executeUpdate(dSQL);
            if (debugUpdate) {
                System.err.println(String.valueOf(count) + " - " + dSQL);
            }
            String sql = "SELECT RecordSetID FROM recordset WHERE CollectionMemberID = " + collId;
            if (debugUpdate) {
                System.err.println(sql);
            }
            Vector<Integer> ids = this.getIds(sql, 0);
            for (Integer rsId : ids) {
                this.deleteRecordSet(rsId);
            }
        }
        String dSQL = "DELETE FROM sptasksemaphore WHERE DisciplineID = " + id;
        int count = stmt.executeUpdate(dSQL);
        if (debugUpdate) {
            System.err.println(String.valueOf(count) + " - " + dSQL);
        }
        Integer txTDId = null;
        Integer geoTTDId = null;
        Integer lsTDId = null;
        Integer gtpTDId = null;
        String tmpSql = "SELECT TaxonTreeDefID, GeographyTreeDefID, LithoStratTreeDefID, GeologicTimePeriodTreeDefID FROM discipline WHERE DisciplineID = " + id;
        ResultSet tmpRS = stmt.executeQuery(tmpSql);
        if (tmpRS.next()) {
            txTDId = tmpRS.getInt(1);
            geoTTDId = tmpRS.getInt(2);
            lsTDId = tmpRS.getInt(3);
            gtpTDId = tmpRS.getInt(4);
        }
        tmpRS.close();
        if (txTDId != null && txTDId != null && txTDId != null && txTDId != null) {
            count = stmt.executeUpdate(delSql);
            if (debugUpdate) {
                System.err.println(String.valueOf(count) + " - " + delSql);
            }
            this.cleanUpTree(TaxonTreeDef.class, txTDId, dispName);
            this.cleanUpTree(GeographyTreeDef.class, geoTTDId, dispName);
            this.cleanUpTree(LithoStratTreeDef.class, lsTDId, dispName);
            this.cleanUpTree(GeologicTimePeriodTreeDef.class, gtpTDId, dispName);
        } else {
            System.err.println("Error!");
        }
        stmt.close();
    }

    protected void checkTables() throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet rs = statement.executeQuery("show tables");
        while (rs.next()) {
            String tablename = rs.getString(1);
            int count = BasicSQLUtils.getNumRecords("select count(*) FROM " + tablename, this.connection);
            if (count <= 0 || !debug) continue;
            System.out.println(String.valueOf(tablename) + " " + count);
        }
        rs.close();
        statement.close();
    }

    protected void cleanUpTree(Class<?> treeDefClass, int treeDefId, String dispName) throws SQLException {
        String delSql;
        Statement stmt = this.connection.createStatement();
        DBTableInfo tblInfo = this.tblMgr.getByShortClassName(treeDefClass.getSimpleName());
        String className = treeDefClass.getSimpleName().substring(0, treeDefClass.getSimpleName().length() - 7);
        String tableNameTD = tblInfo.getName();
        String primaryKeyTD = tblInfo.getIdColumnName();
        String itemTableNameTDI = String.valueOf(tableNameTD) + "item";
        this.fireMsg(STR3PARM, this.delMsgStr, dispName, this.tblMgr.getByShortClassName(className).getTitle());
        if (treeDefClass == TaxonTreeDef.class) {
            String tmpSql = "SELECT tc.TaxonCitationID FROM taxoncitation tc INNER JOIN taxon tx ON tc.TaxonID = tx.TaxonID INNER JOIN taxontreedef ttd ON tx.TaxonTreeDefID = ttd.TaxonTreeDefID = " + treeDefId;
            if (debugUpdate) {
                System.err.println(tmpSql);
            }
            Vector<Integer> ids = this.getIds(tmpSql, 0);
            for (Integer id : ids) {
                delSql = "DELETE FROM taxoncitation WHERE TaxonCitationID = " + id;
                int count = stmt.executeUpdate(delSql);
                if (!debugUpdate) continue;
                System.err.println(String.valueOf(count) + " - " + delSql);
            }
        }
        delSql = "DELETE FROM " + className.toLowerCase() + " WHERE " + primaryKeyTD + " = " + treeDefId + " ORDER BY NodeNumber DESC";
        if (debugUpdate) {
            System.err.println(delSql);
        }
        stmt.executeUpdate(delSql);
        delSql = "DELETE FROM " + itemTableNameTDI + " WHERE " + primaryKeyTD + " = " + treeDefId + " ORDER BY RankID DESC";
        if (debugUpdate) {
            System.err.println(delSql);
        }
        stmt.executeUpdate(delSql);
        delSql = "DELETE FROM " + tableNameTD + " WHERE " + primaryKeyTD + " = " + treeDefId;
        if (debugUpdate) {
            System.err.println(delSql);
        }
        stmt.executeUpdate(delSql);
        stmt.close();
    }

    protected void cleanUpAgentsForDivision(int divisionId) throws SQLException {
        Statement stmt = this.connection.createStatement();
        this.fireMsg(STR2PARM, this.delMsgStr, this.tblMgr.getTitleForId(SpAuditLog.getClassTableId()));
        String sql = "SELECT au.SpAuditLogID FROM spauditlog AS au Inner Join agent AS a ON au.CreatedByAgentID = a.AgentID WHERE a.DivisionID = " + divisionId;
        if (debugUpdate) {
            System.err.println(sql);
        }
        Vector<Integer> ids = this.getIds(sql, 0);
        for (Integer id : ids) {
            stmt.executeUpdate("DELETE FROM spauditlog WHERE SpAuditLogID = " + id);
        }
        this.fireMsg(STR2PARM, this.delMsgStr, this.tblMgr.getTitleForId(Agent.getClassTableId()));
        sql = "SELECT AgentID FROM agent WHERE DivisionID = " + divisionId + " AND ParentOrganizationID IS NOT NULL";
        if (debugUpdate) {
            System.err.println(sql);
        }
        ids = this.getIds(sql, 0);
        this.cleanUpAgentsForDivision(stmt, divisionId, ids, true);
        sql = "SELECT a.AgentID FROM agent a INNER JOIN groupperson gp ON a.AgentID = gp.MemberID WHERE a.DivisionID = " + divisionId;
        if (debugUpdate) {
            System.err.println(sql);
        }
        ids = this.getIds(sql, 0);
        for (Integer id : ids) {
            stmt.executeUpdate("DELETE FROM groupperson WHERE MemberID = " + id);
        }
        this.cleanUpAgentsForDivision(stmt, divisionId, ids, true);
        sql = "SELECT AgentID FROM agent WHERE DivisionID = " + divisionId;
        ids = this.getIds(sql, 0);
        if (debugUpdate) {
            System.err.println(sql);
        }
        this.cleanUpAgentsForDivision(stmt, divisionId, ids, true);
        stmt.close();
    }

    protected void cleanUpAgentsForDivision(Statement stmt, int divisionId, Vector<Integer> ids, boolean doDelAgents) throws SQLException {
        SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        Division currDiv = AppContextMgr.getInstance().getClassObject(Division.class);
        Agent userAgent = null;
        for (Agent agt : spUser.getAgents()) {
            if (!agt.getDivision().getId().equals(currDiv.getId())) continue;
            userAgent = agt;
            break;
        }
        for (Integer agentId : ids) {
            if (debugUpdate) {
                System.err.println("Agent: " + agentId);
            }
            for (DBTableInfo ti : this.tblMgr.getTables()) {
                int modifiedByCount;
                DBRelationshipInfo ri = ti.getRelationshipByName("createdByAgent");
                if (ri == null) continue;
                int createdByCount = BasicSQLUtils.getCountAsInt("SELECT count(*) FROM " + ti.getName() + " WHERE CreatedByAgentID = " + agentId);
                if (createdByCount > 0) {
                    String sql = String.format("UPDATE %s SET CreatedByAgentID = %d WHERE CreatedByAgentID = %d", ti.getName(), userAgent.getId(), agentId);
                    if (debug) {
                        System.err.println(sql);
                    }
                    stmt.executeUpdate(sql);
                }
                if ((modifiedByCount = BasicSQLUtils.getCountAsInt("SELECT count(*) FROM " + ti.getName() + " WHERE ModifiedByAgentID = " + agentId)) <= 0) continue;
                String sql = String.format("UPDATE %s SET ModifiedByAgentID=%d WHERE ModifiedByAgentID = %d", ti.getName(), userAgent.getId(), agentId);
                if (debug) {
                    System.err.println(sql);
                }
                stmt.executeUpdate(sql);
            }
            stmt.executeUpdate("DELETE FROM accessionagent WHERE AgentID = " + agentId);
            stmt.executeUpdate("DELETE FROM permit WHERE IssuedToID = " + agentId + " OR IssuedByID = " + agentId);
            stmt.executeUpdate("DELETE FROM agentvariant WHERE AgentID = " + agentId);
            stmt.executeUpdate("DELETE FROM agentgeography WHERE AgentID = " + agentId);
            stmt.executeUpdate("DELETE FROM agentspecialty WHERE AgentID = " + agentId);
            stmt.executeUpdate("DELETE FROM address WHERE AgentID = " + agentId);
            if (!doDelAgents) continue;
            stmt.executeUpdate("DELETE FROM agent WHERE AgentID = " + agentId);
        }
    }

    protected void deleteRecordSet(int recordSetId) throws SQLException {
        this.fireMsg(STR2PARM, this.delMsgStr, this.tblMgr.getTitleForId(RecordSet.getClassTableId()));
        Statement stmt = this.connection.createStatement();
        stmt.executeUpdate("DELETE FROM recordsetitem WHERE RecordSetID = " + recordSetId);
        stmt.executeUpdate("DELETE FROM recordset WHERE RecordSetID = " + recordSetId);
        stmt.close();
    }

    protected void deleteReportsAndQueries(int specifyUserId) throws SQLException {
        Statement stmt = this.connection.createStatement();
        this.fireMsg(STR2PARM, this.delMsgStr, this.tblMgr.getTitleForId(SpReport.getClassTableId()));
        String sql = "SELECT r.SpReportID FROM spreport r INNER JOIN spquery q ON r.SpQueryID = q.SpQueryID WHERE r.SpecifyUserID  = " + specifyUserId;
        if (debugUpdate) {
            System.err.println(sql);
        }
        Vector<Integer> reportIds = this.getIds(sql, 0);
        for (Integer id : reportIds) {
            stmt.executeUpdate("DELETE FROM spreoprts WHERE SpReportID " + id);
        }
        this.fireMsg(STR2PARM, this.delMsgStr, this.tblMgr.getTitleForId(SpQuery.getClassTableId()));
        sql = "SELECT SpQueryID FROM spquery WHERE SpecifyUserID = " + specifyUserId;
        if (debugUpdate) {
            System.err.println(sql);
        }
        Vector<Integer> queryIds = this.getIds(sql, 0);
        for (Integer id : queryIds) {
            stmt.executeUpdate("DELETE FROM spqueryfield WHERE SpQueryID = " + id);
            stmt.executeUpdate("DELETE FROM spquery WHERE SpQueryID = " + id);
        }
    }

    protected void deleteAppResourceDir(int appResDirId) throws SQLException {
        this.fireMsg(STR2PARM, this.delMsgStr, this.tblMgr.getTitleForId(SpAppResource.getClassTableId()));
        Statement stmt = this.connection.createStatement();
        String sql = "SELECT SpAppResourceDataID FROM spappresourcedata sd INNER JOIN spappresource sr ON sd.SpAppResourceID = sr.SpAppResourceID WHERE sr.SpAppResourceDirID = " + appResDirId;
        if (debugUpdate) {
            System.err.println(sql);
        }
        Vector<Integer> ids = this.getIds(sql, 0);
        for (Integer id : ids) {
            sql = "DELETE FROM spappresourcedata WHERE SpAppResourceDataID = " + id;
            stmt.executeUpdate(sql);
            if (!debugUpdate) continue;
            System.err.println(sql);
        }
        sql = "DELETE FROM spappresource WHERE SpAppResourceDirID = " + appResDirId;
        if (debugUpdate) {
            System.err.println(sql);
        }
        stmt.executeUpdate(sql);
        sql = "SELECT ard.SpAppResourceDataID FROM spappresourcedata ard INNER JOIN spviewsetobj v ON ard.SpViewSetObjID = v.SpViewSetObjID";
        if (debugUpdate) {
            System.err.println(sql);
        }
        ids = this.getIds(sql, 0);
        for (Integer id : ids) {
            sql = "DELETE FROM spappresourcedata WHERE SpAppResourceDataID " + id;
            if (debugUpdate) {
                System.err.println(sql);
            }
            stmt.executeUpdate(sql);
        }
        sql = "DELETE FROM spviewsetobj WHERE SpAppResourceDirID = " + appResDirId;
        if (debugUpdate) {
            System.err.println(sql);
        }
        stmt.executeUpdate(sql);
        sql = "DELETE FROM spappresourcedir WHERE SpAppResourceDirID = " + appResDirId;
        if (debugUpdate) {
            System.err.println(sql);
        }
        stmt.executeUpdate(sql);
        stmt.close();
    }

    protected void deleteWorkBench(int wbId) throws SQLException {
        this.fireMsg(STR2PARM, this.delMsgStr, this.tblMgr.getTitleForId(Workbench.getClassTableId()));
        Statement stmt = this.connection.createStatement();
        Vector<Integer> templateIds = this.getIds("SELECT workbench.WorkbenchTemplateID FROM workbench WHERE WorkbenchID = " + wbId, 0);
        String sql = "SELECT wdi.WorkbenchDataItemID FROM workbench wb INNER JOIN workbenchrow wbr ON wb.WorkbenchID = wbr.WorkbenchID INNER JOIN workbenchdataitem wdi ON wbr.WorkbenchRowID = wdi.WorkbenchRowID WHERE wb.WorkbenchID = " + wbId;
        Vector<Integer> ids = this.getIds(sql, 0);
        for (Integer id : ids) {
            sql = "DELETE FROM workbenchdataitem WHERE WorkbenchDataItemID = " + id;
            if (debugUpdate) {
                System.err.println(sql);
            }
            stmt.executeUpdate(sql);
        }
        sql = "SELECT wri.WorkbenchRowImageID FROM workbench wb INNER JOIN workbenchrow wbr ON wb.WorkbenchID = wbr.WorkbenchID INNER JOIN workbenchrowimage wri ON wbr.WorkbenchRowID = wri.WorkbenchRowID WHERE wb.WorkbenchID = " + wbId;
        ids = this.getIds(sql, 0);
        for (Integer id : ids) {
            stmt.executeUpdate("DELETE FROM workbenchrowimage WHERE WorkbenchRowImageID = " + id);
        }
        sql = "SELECT wbr.WorkbenchRowID FROM workbench wb INNER JOIN workbenchrow wbr ON wb.WorkbenchID = wbr.WorkbenchID WHERE wbr.WorkbenchID = " + wbId;
        ids = this.getIds(sql, 0);
        for (Integer id : ids) {
            stmt.executeUpdate("DELETE FROM workbenchrow WHERE WorkbenchRowID = " + id);
        }
        stmt.executeUpdate("DELETE FROM workbench WHERE WorkbenchID = " + wbId);
        for (Integer id : templateIds) {
            stmt.executeUpdate("DELETE FROM workbenchtemplatemappingitem WHERE WorkbenchTemplateID = " + id);
            stmt.executeUpdate("DELETE FROM workbenchtemplate WHERE WorkbenchTemplateID = " + id);
        }
        stmt.close();
    }

    public static void showTableCounts(String fileName, boolean filterEmpty) {
        try {
            PrintWriter pw = new PrintWriter(new File(fileName));
            ArrayList<String> tblNames = new ArrayList<String>(DBTableIdMgr.getInstance().getTables().size());
            for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                tblNames.add(ti.getName());
            }
            Collections.sort(tblNames);
            int total = 0;
            int tblCount = 0;
            for (String name : tblNames) {
                int cnt;
                Integer count = BasicSQLUtils.getCount("SELECT count(*) FROM " + name);
                if (count == null || filterEmpty && count <= 0) continue;
                int n = cnt = count == 0 ? 0 : count;
                if (debug) {
                    System.out.println(String.format("%5d - %s", cnt, name));
                }
                pw.println(String.format("%5d - %s", cnt, name));
                total += cnt;
                ++tblCount;
            }
            if (debug) {
                System.out.println(String.format("%5d - %s", total, "Total"));
            }
            pw.println(String.format("%5d - %s", total, "Total"));
            if (debug) {
                System.out.println(String.format("%5d - %s", tblCount, "Total Tables"));
            }
            pw.println(String.format("%5d - %s", tblCount, "Total Tables"));
            pw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DBTableIdMgr.getInstance().getByShortClassName(CollectingEvent.class.getSimpleName());
        SpecifyDeleteHelper sdh = new SpecifyDeleteHelper();
        try {
            if (sdh.isRecordShared(Geography.class, 54907)) {
                System.out.println("Geography 54907 is shared");
            } else {
                System.out.println("Geography 54907 is NOT shared");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    class StackItem {
        protected DBTableInfo tableInfo;
        protected Stack<StackItem> stack = new Stack();
        protected Stack<StackItem> postProcStack = new Stack();
        protected String sql;
        protected String delSql;
        protected boolean isBuildingSQL;
        protected boolean isBuildingDelSQL;

        public StackItem(DBTableInfo tableInfo, String sql, String delSql, boolean isBuildingSQL, boolean isBuildingDelSQL) {
            this.tableInfo = tableInfo;
            this.sql = sql;
            this.delSql = delSql;
            this.isBuildingSQL = isBuildingSQL;
            this.isBuildingDelSQL = isBuildingDelSQL;
        }

        public StackItem(DBTableInfo tableInfo, String sql, String delSql, boolean isBuildingAllSQL) {
            this(tableInfo, sql, delSql, isBuildingAllSQL, isBuildingAllSQL);
        }

        public StackItem(DBTableInfo tableInfo, String sql, String delSql) {
            this(tableInfo, sql, delSql, true);
        }

        public StackItem push(DBTableInfo ti, String sqlArg, String delSqlArg) {
            StackItem si = new StackItem(ti, sqlArg, delSqlArg);
            this.stack.push(si);
            return si;
        }

        public void removeChild(StackItem child) {
            this.stack.remove(child);
        }

        public StackItem pushPPS(StackItem si) {
            this.postProcStack.push(si);
            return si;
        }

        public Stack<StackItem> getStack() {
            return this.stack;
        }

        public DBTableInfo getTableInfo() {
            return this.tableInfo;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDelSql() {
            return this.delSql;
        }

        public Stack<StackItem> getPostProcStack() {
            return this.postProcStack;
        }

        public boolean isBuildingSQL() {
            return this.isBuildingSQL;
        }

        public boolean isBuildingDelSQL() {
            return this.isBuildingDelSQL;
        }

        public void setBuildingSQL(boolean isBuildingSQL) {
            this.isBuildingSQL = isBuildingSQL;
        }

        public void setBuildingDelSQL(boolean isBuildingDelSQL) {
            this.isBuildingDelSQL = isBuildingDelSQL;
        }
    }

    class SwingWorkerCompletionWaiter
    implements PropertyChangeListener {
        private JDialog dialog;

        public SwingWorkerCompletionWaiter(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (CNT.equals(event.getPropertyName())) {
                int value = (Integer)event.getNewValue();
                if (value < 100) {
                    SpecifyDeleteHelper.this.progressBar.setValue(value);
                } else {
                    SpecifyDeleteHelper.this.progressBar.setValue(100);
                }
            } else if (MSG.equals(event.getPropertyName())) {
                SpecifyDeleteHelper.this.titleLbl.setText((String)event.getNewValue());
            } else if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
    }
}

