/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.dbsupport.TypeCode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.log4j.Logger;

public class RecordTypeCodeBuilder {
    protected static final Logger log = Logger.getLogger(RecordTypeCodeBuilder.class);

    public static List<PickListDBAdapterIFace> getTypeCodes(Class<?> tblClass) {
        block6: {
            Method codeGetter = tblClass.getMethod("getSpSystemTypeCodes", null);
            if (!Modifier.isStatic(codeGetter.getModifiers()) || !codeGetter.getReturnType().equals(List.class)) break block6;
            log.debug((Object)("building TypeCodes for " + tblClass.getName()));
            try {
                return (List)codeGetter.invoke(null, null);
            }
            catch (InvocationTargetException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordTypeCodeBuilder.class, ex);
                log.error((Object)ex);
                return null;
            }
            catch (IllegalAccessException ex) {
                try {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(RecordTypeCodeBuilder.class, ex);
                    log.error((Object)ex);
                    return null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        log.debug((Object)("returning null TypeCodes for " + tblClass.getName()));
        return null;
    }

    public static PickListDBAdapterIFace getTypeCode(DBFieldInfo fi) {
        List<PickListDBAdapterIFace> picks;
        if (RecordTypeCodeBuilder.isTypeCodeField(fi) && (picks = RecordTypeCodeBuilder.getTypeCodes(fi.getTableInfo().getClassObj())) != null) {
            int p = 0;
            while (p < picks.size()) {
                if (((TypeCode)picks.get(p)).getFldName().equalsIgnoreCase(fi.getName())) {
                    return picks.get(p);
                }
                ++p;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTypeCodeField(DBFieldInfo field) {
        Class<?> tblClass = field.getTableInfo().getClassObj();
        try {
            Method codeGetter = tblClass.getMethod("getSpSystemTypeCodeFlds", null);
            if (!Modifier.isStatic(codeGetter.getModifiers())) return false;
            if (!codeGetter.getReturnType().equals(String[].class)) return false;
            log.debug((Object)("retrieving TypeCode Fields for " + tblClass.getName()));
            try {
                String[] flds = (String[])codeGetter.invoke(null, null);
                int f = 0;
                while (true) {
                    if (f >= flds.length) {
                        return false;
                    }
                    if (flds[f].equals(field.getName())) {
                        return true;
                    }
                    ++f;
                }
            }
            catch (InvocationTargetException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordTypeCodeBuilder.class, ex);
                log.error((Object)ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordTypeCodeBuilder.class, ex);
                log.error((Object)ex);
                return false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }
}

