/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderIFace;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Locality;
import java.util.List;
import java.util.Vector;

public class RecordSetLoader {
    public static List<Object> loadRecordSet(RecordSetIFace recordSet) {
        Vector<Object> records = new Vector<Object>();
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(recordSet.getDbTableId());
        Class<?> recordClass = tableInfo.getClassObj();
        DataProviderIFace dataProvider = DataProviderFactory.getInstance();
        DataProviderSessionIFace session = null;
        try {
            try {
                session = dataProvider.createSession();
                for (RecordSetItemIFace rsItem : recordSet.getOrderedItems()) {
                    Object record = session.get(recordClass, rsItem.getRecordId());
                    records.add(record);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return records;
    }

    public static List<Object> loadCollectionObjectsRecordSet(RecordSetIFace recordSet) {
        Vector<Object> colObjList = new Vector<Object>();
        if (recordSet.getDbTableId().equals(CollectionObject.getClassTableId())) {
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(recordSet.getDbTableId());
            Class<?> recordClass = tableInfo.getClassObj();
            DataProviderIFace dataProvider = DataProviderFactory.getInstance();
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = dataProvider.createSession();
                    for (RecordSetItemIFace rsItem : recordSet.getOrderedItems()) {
                        Locality loc;
                        CollectionObject colObj = (CollectionObject)session.get(recordClass, rsItem.getRecordId());
                        for (Determination det : colObj.getDeterminations()) {
                            det.getTaxon().getId();
                        }
                        CollectingEvent ce = colObj.getCollectingEvent();
                        if (ce != null && (loc = ce.getLocality()) != null) {
                            loc.getGeography();
                        }
                        colObjList.add(colObj);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return colObjList;
    }
}

