/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.hibernate.event.PostInsertEvent;

public class PostInsertEventListener
implements org.hibernate.event.PostInsertEventListener {
    private static final Logger log = Logger.getLogger(PostInsertEventListener.class);
    private static final String APP_SHUTDOWN_ACT = "Shutdown";
    private static final String APP = "App";
    private static boolean isAuditOn = true;
    private static PreparedStatement pStmt = null;
    private static byte gAction = (byte)127;
    private static int gRecordId = Integer.MAX_VALUE;
    private static long gTSCreated = Long.MAX_VALUE;
    private static CommandListener cmdListener = null;
    public static final String DB_CMD_TYPE = "Database";
    public static final String SAVE_CMD_ACT = "Save";
    public static final String INSERT_CMD_ACT = "Insert";
    public static final String DELETE_CMD_ACT = "Delete";
    public static final String UPDATE_CMD_ACT = "Update";

    static {
        cmdListener = new CommandListener(){

            @Override
            public void doCommand(CommandAction cmdAction) {
                if (cmdAction.isType(PostInsertEventListener.APP) && (cmdAction.isAction(PostInsertEventListener.APP_SHUTDOWN_ACT) || cmdAction.isAction("STATS_SEND_DONE"))) {
                    try {
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        pStmt = null;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        CommandDispatcher.register(APP, cmdListener);
    }

    public void onPostInsert(final PostInsertEvent obj) {
        if (obj.getEntity() instanceof FormDataObjIFace) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommandDispatcher.dispatch(new CommandAction(PostInsertEventListener.DB_CMD_TYPE, PostInsertEventListener.INSERT_CMD_ACT, obj.getEntity()));
                }
            });
            if (PostInsertEventListener.isAuditOn() && ((FormDataObjIFace)obj.getEntity()).isChangeNotifier()) {
                PostInsertEventListener.saveOnAuditTrail((byte)0, obj.getEntity());
            }
        }
    }

    public static void saveOnAuditTrail(Byte action, Object dObjArg) {
        if (dObjArg instanceof FormDataObjIFace) {
            FormDataObjIFace dObj = (FormDataObjIFace)dObjArg;
            if (dObj.getId() != null) {
                try {
                    if (pStmt == null) {
                        String sql = "INSERT INTO spauditlog (TimestampCreated, TimestampModified, Version, Action, ParentRecordId, ParentTableNum, RecordId,  RecordVersion,  TableNum,  ModifiedByAgentID, CreatedByAgentID)  VALUES(?,?,?,?,?,?,?,?,?,?,?)";
                        pStmt = DBConnection.getInstance().getConnection().prepareStatement(sql);
                    }
                    if (pStmt == null) {
                        return;
                    }
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    if (gRecordId == dObj.getId() && gAction == 0 && action == 1 && now.getTime() - gTSCreated < 1001L) {
                        return;
                    }
                    gAction = action;
                    gRecordId = dObj.getId();
                    gTSCreated = now.getTime();
                    Agent createdByAgent = AppContextMgr.getInstance() == null ? null : (AppContextMgr.getInstance().hasContext() ? Agent.getUserAgent() : null);
                    pStmt.setTimestamp(1, now);
                    pStmt.setTimestamp(2, now);
                    pStmt.setInt(3, 0);
                    pStmt.setInt(4, action.byteValue());
                    Integer pId = dObj.getParentId();
                    if (pId != null) {
                        pStmt.setInt(5, pId);
                        Integer parentTableId = dObj.getParentTableId();
                        if (parentTableId != null) {
                            pStmt.setInt(6, parentTableId);
                        } else {
                            pStmt.setObject(6, null);
                        }
                    } else {
                        pStmt.setObject(5, null);
                        pStmt.setObject(6, null);
                    }
                    pStmt.setInt(7, dObj.getId());
                    if (dObj.getVersion() != null) {
                        pStmt.setInt(8, dObj.getVersion());
                    } else {
                        pStmt.setObject(8, null);
                    }
                    pStmt.setInt(9, dObj.getTableId());
                    if (createdByAgent != null) {
                        pStmt.setInt(10, createdByAgent.getId());
                        pStmt.setInt(11, createdByAgent.getId());
                    } else {
                        pStmt.setObject(10, null);
                        pStmt.setObject(11, null);
                    }
                    pStmt.execute();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    log.error((Object)ex);
                }
            }
        } else {
            log.error((Object)("Can't audit data object, not instanceof FormDataObjIFace: " + (dObjArg != null ? dObjArg.getClass().getSimpleName() : "null")));
        }
    }

    public static boolean isAuditOn() {
        return isAuditOn;
    }

    public static void setAuditOn(boolean isAuditOn) {
        PostInsertEventListener.isAuditOn = isAuditOn;
    }
}

