/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.StaleObjectException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.JDBCConnectionException;

public class HibernateDataProviderSession
implements DataProviderSessionIFace {
    protected static final Logger log = Logger.getLogger(HibernateDataProviderSession.class);
    protected static int createsCounts = 0;
    protected static int closesCounts = 0;
    protected static boolean SHOW_COUNTS = AppPreferences.getLocalPrefs().getBoolean("CONN_COUNTS", false);
    protected Session session = null;
    protected Exception recentException = null;
    protected Transaction transaction = null;
    protected List<Object> deleteList = new Vector<Object>();
    private static HashSet<Session> sessions = new HashSet();

    public HibernateDataProviderSession() {
        this.session = HibernateUtil.getNewSession();
        if (SHOW_COUNTS) {
            System.err.println("Create - Creates: " + ++createsCounts + "  Closes: " + closesCounts + " Dif: " + (createsCounts - closesCounts) + "  " + this.session.hashCode());
            sessions.add(this.session);
            if (sessions.size() < 4) {
                int cn = 0;
                for (Session ses : sessions) {
                    if (cn > 0) {
                        System.err.print(",");
                    }
                    System.err.print(ses.hashCode());
                    if (++cn % 20 != 0) continue;
                    System.err.println();
                }
                System.err.println();
            }
        }
    }

    public HibernateDataProviderSession(Session session) {
        if (session != null) {
            this.session = session;
            return;
        }
        this.session = HibernateUtil.getNewSession();
        if (SHOW_COUNTS) {
            ++createsCounts;
            sessions.add(this.session);
        }
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean isOpen() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public boolean refresh(Object dataObj) {
        if (this.session != null) {
            log.debug((Object)this.session.hashCode());
            this.session.refresh(dataObj);
            return true;
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return false;
    }

    @Override
    public boolean delete(Object dataObj) throws Exception {
        if (this.session != null) {
            this.session.delete(dataObj);
            return true;
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return false;
    }

    @Override
    public boolean deleteHQL(String hql) throws Exception {
        if (this.session != null) {
            Query query = this.session.createQuery(hql);
            int row = query.executeUpdate();
            if (row == 0) {
                log.info((Object)"no rows deleted");
                return false;
            }
            log.info((Object)("Deleted Rows: " + row));
            return true;
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return false;
    }

    @Override
    public void deleteOnSaveOrUpdate(Object dataObj) {
        this.deleteList.add(dataObj);
    }

    @Override
    public <T> T merge(T dataObj) throws StaleObjectException {
        if (this.session != null) {
            Object mergedObj = null;
            try {
                mergedObj = this.session.merge(dataObj);
            }
            catch (StaleStateException sse) {
                throw new StaleObjectException(sse);
            }
            return (T)mergedObj;
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public List<?> getDataList(String sqlStr) {
        if (this.session != null) {
            Query query = this.session.createQuery(sqlStr);
            return query.list();
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public <T> List<T> getDataList(Class<T> clazz) {
        if (this.session != null) {
            Query q = this.session.createQuery("FROM " + clazz.getName());
            return q.list();
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public <T> List<T> getDataList(Class<T> clsObject, String fieldName, boolean isDistinct) {
        Query query = this.session.createQuery("SELECT DISTINCT " + fieldName + " FROM " + clsObject.getName() + " WHERE " + fieldName + " <> NULL");
        return query.list();
    }

    @Override
    public <T> List<T> getDataList(Class<T> clsObject, String fieldName, Object value, DataProviderSessionIFace.CompareType compareType) {
        if (this.session != null) {
            Criteria criteria = this.session.createCriteria(clsObject);
            criteria.add((Criterion)(compareType == DataProviderSessionIFace.CompareType.Equals ? Restrictions.eq((String)fieldName, (Object)value) : Restrictions.eq((String)fieldName, (Object)value)));
            return criteria.list();
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public <T> T getData(Class<T> clsObject, String fieldName, Object value, DataProviderSessionIFace.CompareType compareType) {
        if (this.session != null) {
            Criteria criteria = this.session.createCriteria(clsObject);
            criteria.add((Criterion)(compareType == DataProviderSessionIFace.CompareType.Equals ? Restrictions.eq((String)fieldName, (Object)value) : Restrictions.eq((String)fieldName, (Object)value)));
            List list = criteria.list();
            return list == null || list.size() == 0 ? null : (T)list.get(0);
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public <T> List<T> getDataList(Class<T> clsObject, String fieldName, Object value) {
        if (this.session != null) {
            return this.getDataList(clsObject, fieldName, value, DataProviderSessionIFace.CompareType.Equals);
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    protected void checkAndReconnect() {
        boolean reconnect;
        block24: {
            reconnect = false;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                Connection conn = this.session.connection();
                stmt = conn.createStatement();
                if (stmt != null && (rs = stmt.executeQuery("select * from specifyuser")) != null) {
                    rs.next();
                }
            }
            catch (SQLException ex) {
                reconnect = true;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block24;
                }
                catch (Exception exception) {}
                break block24;
            }
            catch (JDBCConnectionException ex) {
                try {
                    reconnect = true;
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (reconnect) {
            log.debug((Object)"Reconnecting and rebuilding session factory....");
            if (this.session != null && this.session.isOpen()) {
                this.session.close();
            }
            HibernateUtil.rebuildSessionFactory();
            this.session = HibernateUtil.getNewSession();
        }
    }

    @Override
    public <T> T get(Class<T> clsObj, Integer id) {
        if (this.session != null) {
            return (T)this.session.get(clsObj, (Serializable)id);
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public <T> Integer getDataCount(Class<T> clsObject, String fieldName, Object value, DataProviderSessionIFace.CompareType compareType) {
        if (this.session != null) {
            Criteria criteria = this.session.createCriteria(clsObject);
            criteria.add((Criterion)(compareType == DataProviderSessionIFace.CompareType.Equals ? Restrictions.eq((String)fieldName, (Object)value) : Restrictions.eq((String)fieldName, (Object)value)));
            criteria.setProjection(Projections.rowCount());
            List countList = criteria.list();
            if (countList == null || countList.size() == 0) {
                return 0;
            }
            Object countObj = countList.get(0);
            if (countObj instanceof Integer) {
                return (Integer)countObj;
            }
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return 0;
    }

    @Override
    public <T> T load(Class<T> clsObj, Integer id) {
        if (this.session != null) {
            return (T)this.session.load(clsObj, (Serializable)id);
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public Object getData(String sqlStr) {
        if (this.session != null) {
            List<?> list = this.getDataList(sqlStr);
            return list != null && list.size() > 0 ? list.get(0) : null;
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public boolean contains(Object obj) {
        return this.session.contains(obj);
    }

    @Override
    public void evict(Class<?> clsObject) {
        if (this.session != null) {
            this.session.evict(clsObject);
            HibernateUtil.getSessionFactory().evict(clsObject);
        } else {
            log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        }
    }

    @Override
    public void evict(Object dataObj) {
        if (this.session != null) {
            this.session.evict(dataObj);
        } else {
            log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        }
    }

    @Override
    public void attach(Object dataObj) {
        if (this.session != null) {
            this.session.lock(dataObj, LockMode.NONE);
        } else {
            log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        }
    }

    @Override
    public boolean save(Object dataObj) throws Exception {
        if (this.session != null) {
            this.deleteObjectFromList();
            this.session.save(dataObj);
            return true;
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return false;
    }

    @Override
    public boolean saveOrUpdate(Object dataObj) throws Exception {
        if (this.session != null) {
            this.deleteObjectFromList();
            this.session.saveOrUpdate(dataObj);
            return true;
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return false;
    }

    @Override
    public boolean update(Object dataObj) throws Exception {
        if (this.session != null) {
            this.deleteObjectFromList();
            this.session.update(dataObj);
            return true;
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return false;
    }

    @Override
    public DataProviderSessionIFace.QueryIFace createQuery(String query, boolean isSql) {
        if (isSql) {
            return new HibernateSQLQuery(query);
        }
        return new HibernateQuery(query);
    }

    @Override
    public DataProviderSessionIFace.CriteriaIFace createCriteria(Class<?> cls) {
        if (this.session != null) {
            return new HibernateCriteria(cls);
        }
        log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        return null;
    }

    @Override
    public void beginTransaction() throws Exception {
        if (this.session != null) {
            this.transaction = this.session.beginTransaction();
            if (this.transaction == null) {
                log.error((Object)"Transaction was null!");
            }
        } else {
            log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.transaction != null) {
            try {
                this.transaction.commit();
                this.transaction = null;
            }
            catch (StaleObjectStateException soe) {
                throw new StaleObjectException(soe);
            }
        } else {
            throw new RuntimeException("Transaction was null and shouldn't been.");
        }
    }

    @Override
    public void rollback() {
        if (this.transaction == null) {
            throw new RuntimeException("Transaction was null and shouldn't been.");
        }
        this.transaction.rollback();
        this.transaction = null;
    }

    @Override
    public void flush() {
        if (this.session != null) {
            this.session.flush();
        } else {
            log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        }
    }

    @Override
    public void clear() {
        if (this.session != null) {
            this.session.clear();
        } else {
            log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        }
    }

    @Override
    public void close() {
        if (SHOW_COUNTS) {
            System.err.println("Close - Creates: " + createsCounts + "  Closes: " + ++closesCounts + " Dif: " + (createsCounts - closesCounts) + "  " + this.session.hashCode());
            sessions.remove(this.session);
            if (sessions.size() == 1) {
                int cn = 0;
                for (Session ses : sessions) {
                    if (cn > 0) {
                        System.err.print(",");
                    }
                    System.err.print(ses.hashCode());
                    if (++cn % 20 != 0) continue;
                    System.err.println();
                }
                System.err.println();
            }
        }
        if (this.session != null) {
            if (this.transaction != null) {
                this.transaction.rollback();
                this.transaction = null;
                throw new RuntimeException("Closing Session with open transaction - rolling it back");
            }
            this.session.close();
            this.session = null;
        } else {
            log.error((Object)"Session was null.", (Throwable)new NullPointerException("Session was null"));
        }
    }

    protected void deleteObjectFromList() {
        for (Object obj : this.deleteList) {
            if (!this.session.contains(obj)) continue;
            this.session.delete(obj);
        }
        this.deleteList.clear();
    }

    public class HibernateCriteria
    implements DataProviderSessionIFace.CriteriaIFace {
        protected Criteria criteriaDelegate;

        public HibernateCriteria(Class<?> cls) {
            this.criteriaDelegate = HibernateDataProviderSession.this.session.createCriteria(cls);
        }

        @Override
        public void add(Object criterion) {
            if (criterion instanceof Criterion) {
                this.criteriaDelegate.add((Criterion)criterion);
            } else {
                log.error((Object)"invalid criterion.");
            }
        }

        @Override
        public Object uniqueResult() {
            return this.criteriaDelegate.uniqueResult();
        }

        @Override
        public List<?> list() {
            return this.criteriaDelegate.list();
        }

        @Override
        public void addSubCriterion(String name, Object criterion) {
            if (criterion instanceof Criterion) {
                this.criteriaDelegate.createCriteria(name).add((Criterion)criterion);
            } else {
                log.error((Object)"invalid criterion.");
            }
        }
    }

    public class HibernateQuery
    implements DataProviderSessionIFace.QueryIFace {
        protected Query queryDelegate;

        protected HibernateQuery() {
        }

        public HibernateQuery(String hql) {
            this.queryDelegate = HibernateDataProviderSession.this.session.createQuery(hql);
            if (this.queryDelegate == null) {
                log.error((Object)("queryDelegate is null for query for hql[" + hql + "]"));
            }
        }

        @Override
        public int executeUpdate() {
            return this.queryDelegate != null ? this.queryDelegate.executeUpdate() : 0;
        }

        @Override
        public List<?> list() {
            return this.queryDelegate != null ? this.queryDelegate.list() : null;
        }

        @Override
        public void setParameter(String name, Object value) {
            if (this.queryDelegate != null) {
                this.queryDelegate.setParameter(name, value);
            }
        }

        @Override
        public Object uniqueResult() {
            return this.queryDelegate != null ? this.queryDelegate.uniqueResult() : null;
        }
    }

    public class HibernateSQLQuery
    extends HibernateQuery {
        public HibernateSQLQuery(String sql) {
            this.queryDelegate = HibernateDataProviderSession.this.session.createSQLQuery(sql);
            if (this.queryDelegate == null) {
                log.error((Object)("queryDelegate is null for query for sql[" + sql + "]"));
            }
        }
    }
}

