/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.AutoNumberGeneric;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.util.Pair;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class CollectionAutoNumberAlphaNum
extends AutoNumberGeneric {
    public CollectionAutoNumberAlphaNum() {
        this.classObj = CollectionObject.class;
        this.fieldName = "catalogNumber";
    }

    public CollectionAutoNumberAlphaNum(Properties properties) {
        super(properties);
    }

    @Override
    protected String getHighestObject(UIFieldFormatterIFace formatter, Session session, String value, Pair<Integer, Integer> yearPos, Pair<Integer, Integer> pos) throws Exception {
        Collection currCollection = AppContextMgr.getInstance().getClassObject(Collection.class);
        Integer yearVal = null;
        if (yearPos != null && StringUtils.isNotEmpty((String)value) && value.length() >= (Integer)yearPos.second) {
            yearVal = this.extractIntegerValue(yearPos, value);
        }
        StringBuilder sb = new StringBuilder("SELECT c.catalogNumber From CollectionObject c Join c.collection col Join col.numberingSchemes cns WHERE cns.autoNumberingSchemeId = ");
        sb.append(currCollection.getNumberingSchemesByType(CollectionObject.getClassTableId()).getAutoNumberingSchemeId());
        if (yearVal != null) {
            sb.append(" AND ");
            sb.append(yearVal);
            sb.append(" = substring(" + this.fieldName + "," + ((Integer)yearPos.first + 1) + "," + yearPos.second + ")");
        }
        sb.append(" AND c.collectionMemberId = COLMEMID ORDER BY");
        try {
            String sql;
            List list;
            if (yearPos != null) {
                sb.append(" substring(" + this.fieldName + "," + ((Integer)yearPos.first + 1) + "," + yearPos.second + ") desc");
            }
            if (pos != null) {
                if (yearPos != null) {
                    sb.append(", ");
                }
                sb.append(" substring(" + this.fieldName + "," + ((Integer)pos.first + 1) + "," + pos.second + ") desc");
            }
            if ((list = session.createQuery(sql = QueryAdjusterForDomain.getInstance().adjustSQL(sb.toString())).setMaxResults(1).list()).size() == 1) {
                return list.get(0).toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(CollectionAutoNumberAlphaNum.class, ex);
        }
        return null;
    }
}

