/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.AutoNumberGeneric;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.util.Pair;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class CollectionAutoNumber
extends AutoNumberGeneric {
    protected static final Logger log = Logger.getLogger(CollectionAutoNumber.class);

    public CollectionAutoNumber() {
        this.classObj = CollectionObject.class;
        this.fieldName = "catalogNumber";
    }

    public CollectionAutoNumber(Properties properties) {
        super(properties);
    }

    @Override
    protected String getHighestObject(UIFieldFormatterIFace formatter, Session session, String value, Pair<Integer, Integer> yearPos, Pair<Integer, Integer> pos) throws Exception {
        boolean doDebug = false;
        Collection currCol = AppContextMgr.getInstance().getClassObject(Collection.class);
        AutoNumberingScheme catNumScheme = currCol.getNumberingSchemesByType(CollectionObject.getClassTableId());
        if (catNumScheme == null) {
            throw new RuntimeException("The Catalog Numbering Scheme cannot be null! Collection Table ID: " + CollectionObject.getClassTableId());
        }
        catNumScheme = (AutoNumberingScheme)session.merge((Object)catNumScheme);
        if (doDebug) {
            System.out.println("CatNumScheme: " + catNumScheme.getSchemeName());
        }
        Vector<Integer> ids = new Vector<Integer>();
        for (Collection collection : catNumScheme.getCollections()) {
            if (doDebug) {
                System.out.println("adding ID: " + collection.getCollectionId() + "  " + collection.getCollectionName());
            }
            ids.add(collection.getCollectionId());
        }
        StringBuilder sb = new StringBuilder("SELECT CatalogNumber FROM collectionobject WHERE CollectionMemberID IN (");
        Connection conn = null;
        Statement stmt = null;
        int i = 0;
        while (i < ids.size()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ids.get(i));
            ++i;
        }
        sb.append(") ORDER BY CatalogNumber DESC");
        log.debug((Object)sb.toString());
        try {
            conn = DBConnection.getInstance().getConnection();
            stmt = conn.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(sb.toString());
            String catNum = null;
            if (rs.next()) {
                catNum = rs.getString(1);
            }
            rs.close();
            String string = catNum;
            return string;
        }
        catch (SQLException e) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(CollectionAutoNumber.class, e);
            log.error((Object)("Exception caught: " + e));
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(CollectionAutoNumber.class, e);
                log.error((Object)("Exception caught: " + e.toString()));
                e.printStackTrace();
            }
        }
        return null;
    }
}

