/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.BackupServiceFactory;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class BuildFromGeonames {
    private static final Logger log = Logger.getLogger(BuildFromGeonames.class);
    protected GeographyTreeDef geoDef;
    protected Timestamp now;
    protected String insertSQL = null;
    protected Agent createdByAgent;
    protected ProgressFrame frame;
    protected String itUsername;
    protected String itPassword;
    protected Connection readConn = null;
    protected Connection updateConn;
    protected PreparedStatement pStmt = null;
    protected ArrayList<Object> rowData = new ArrayList();
    protected Hashtable<String, String> countryToContHash = new Hashtable();
    protected Hashtable<String, Integer> contToIdHash = new Hashtable();
    protected Hashtable<String, String> continentNameFromCode = new Hashtable();
    protected Hashtable<String, Hashtable<String, Integer>> countryStateCodeToIdHash = new Hashtable();
    protected Hashtable<String, String> stateToCountryHash = new Hashtable();
    protected Hashtable<String, Integer> countryCodeToIdHash = new Hashtable();

    public BuildFromGeonames(GeographyTreeDef geoDef, Timestamp now, Agent createdByAgent, String itUsername, String itPassword, ProgressFrame frame) {
        this.geoDef = geoDef;
        this.now = now;
        this.createdByAgent = createdByAgent;
        this.itUsername = itUsername;
        this.itPassword = itPassword;
        this.frame = frame;
        this.insertSQL = "INSERT INTO geography (Name, RankID, ParentID, IsAccepted, IsCurrent, GeographyTreeDefID, GeographyTreeDefItemID, CreatedByAgentID, CentroidLat, CentroidLon, Abbrev, TimestampCreated, TimestampModified, Version) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    public Geography buildEarth(Session session) {
        try {
            Geography earth = new Geography();
            earth.initialize();
            earth.setName("Earth");
            earth.setFullName("Earth");
            earth.setNodeNumber(1);
            earth.setHighestChildNodeNumber(1);
            earth.setRankId(0);
            earth.setDefinition(this.geoDef);
            GeographyTreeDefItem defItem = this.geoDef.getDefItemByRank(0);
            earth.setDefinitionItem(defItem);
            defItem.getTreeEntries().add(earth);
            session.saveOrUpdate((Object)earth);
            return earth;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean build(int earthId) {
        Statement stmt = null;
        try {
            Integer newId;
            String continentCode;
            String countryCode;
            DBConnection currDBConn = DBConnection.getInstance();
            if (this.updateConn == null) {
                this.updateConn = currDBConn.createConnection();
            }
            this.pStmt = this.updateConn.prepareStatement(this.insertSQL);
            this.readConn = currDBConn.createConnection();
            stmt = this.readConn.createStatement();
            Integer count = BasicSQLUtils.getCount(this.readConn, "SELECT COUNT(*) FROM geoname");
            if (this.frame != null) {
                this.frame.setProcess(0, count);
                this.frame.setDesc("Creating Geography...");
            }
            Hashtable<String, String> continentCodeFromName = new Hashtable<String, String>();
            ResultSet rs = stmt.executeQuery("SELECT code, name from continentCodes");
            while (rs.next()) {
                this.continentNameFromCode.put(rs.getString(1), rs.getString(2));
                continentCodeFromName.put(rs.getString(2), rs.getString(1));
            }
            rs.close();
            if (this.frame != null) {
                this.frame.setDesc("Creating Continents...");
            }
            int cnt = 0;
            String sqlStr = "SELECT continentCodes.name, geoname.latitude, geoname.longitude, continentCodes.code FROM geoname Inner Join continentCodes ON geoname.name = continentCodes.name";
            rs = stmt.executeQuery(sqlStr);
            while (rs.next()) {
                if (this.frame != null) {
                    this.frame.setProcess(cnt);
                }
                if (this.buildInsert(rs, 100, earthId)) {
                    this.pStmt.executeUpdate();
                    Integer newId2 = BasicSQLUtils.getInsertedId(this.pStmt);
                    this.contToIdHash.put(rs.getString(4), newId2);
                }
                if (this.frame == null || ++cnt % 100 != 0) continue;
                this.frame.setProcess(cnt);
            }
            rs.close();
            HashSet<String> countryCodes = new HashSet<String>();
            rs = stmt.executeQuery("SELECT DISTINCT country FROM geoname WHERE fcode = 'PCLI'");
            while (rs.next()) {
                countryCodes.add(rs.getString(1));
            }
            rs.close();
            if (this.frame != null) {
                this.frame.setDesc("Creating Countries...");
            }
            rs = stmt.executeQuery("SELECT name, iso_alpha2 AS CountryCode, continent FROM countryinfo ORDER BY continent, iso_alpha2");
            while (rs.next()) {
                countryCode = rs.getString(2);
                continentCode = rs.getString(3);
                this.countryStateCodeToIdHash.put(countryCode, new Hashtable());
                this.countryToContHash.put(countryCode, continentCode);
            }
            rs.close();
            sqlStr = "SELECT asciiname, latitude, longitude, country FROM geoname WHERE fcode = 'PCLI' ORDER BY name";
            rs = stmt.executeQuery(sqlStr);
            while (rs.next()) {
                if (this.buildInsert(rs, 200, earthId)) {
                    this.pStmt.executeUpdate();
                    Integer newId3 = BasicSQLUtils.getInsertedId(this.pStmt);
                    this.countryCodeToIdHash.put(rs.getString(4), newId3);
                }
                if (this.frame == null || ++cnt % 100 != 0) continue;
                this.frame.setProcess(cnt);
            }
            rs.close();
            rs = stmt.executeQuery("SELECT name, iso_alpha2 AS CountryCode, continent FROM countryinfo ORDER BY continent, iso_alpha2");
            while (rs.next()) {
                countryCode = rs.getString(2);
                continentCode = rs.getString(3);
                if (BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM geography WHERE RankID = 200 AND Abbrev = '" + countryCode + "'") != 0) continue;
                String countryName = rs.getString(1);
                log.error((Object)("Adding country[" + countryName + "]"));
                this.createCountry(countryName, countryCode, continentCode, 200);
                this.pStmt.executeUpdate();
                newId = BasicSQLUtils.getInsertedId(this.pStmt);
                this.countryCodeToIdHash.put(countryCode, newId);
            }
            rs.close();
            if (this.frame != null) {
                this.frame.setDesc("Creating States...");
            }
            sqlStr = "SELECT asciiname, latitude, longitude, country, admin1 as StateCode FROM geoname WHERE fcode = 'ADM1' ORDER BY name";
            rs = stmt.executeQuery(sqlStr);
            while (rs.next()) {
                if (this.buildInsert(rs, 300, earthId)) {
                    String nameStr = rs.getString(1);
                    String countryCode2 = rs.getString(4);
                    String stateCode = rs.getString(5);
                    this.stateToCountryHash.put(nameStr, countryCode2);
                    this.pStmt.executeUpdate();
                    newId = BasicSQLUtils.getInsertedId(this.pStmt);
                    Hashtable<String, Integer> stateToIdHash = this.countryStateCodeToIdHash.get(countryCode2);
                    if (stateToIdHash != null) {
                        stateToIdHash.put(stateCode, newId);
                    } else {
                        log.error((Object)("****** Error - No State for code [" + stateCode + "]  Country: " + countryCode2 + "   Name: " + nameStr));
                    }
                }
                if (this.frame == null || ++cnt % 100 != 0) continue;
                this.frame.setProcess(cnt);
            }
            rs.close();
            sqlStr = "SELECT asciiname AS CountyName, latitude, longitude, country, admin1 as StateCode FROM geoname WHERE fcode = 'ADM2' ORDER BY name";
            rs = stmt.executeQuery(sqlStr);
            while (rs.next()) {
                countryCode = rs.getString(4);
                String stateCode = rs.getString(5);
                Hashtable<String, Integer> stateToIdHash = this.countryStateCodeToIdHash.get(countryCode);
                if (stateToIdHash == null || stateToIdHash.get(stateCode) != null) continue;
                this.rowData.clear();
                this.rowData.add(rs.getString(1));
                this.rowData.add(new BigDecimal(-1000));
                this.rowData.add(new BigDecimal(-1000));
                this.rowData.add(countryCode);
                this.rowData.add(stateCode);
                if (!this.buildInsert(this.rowData, 300, earthId)) continue;
                this.stateToCountryHash.put(stateCode, countryCode);
                log.debug((Object)("Adding State [" + rs.getString(1) + "][" + stateCode + "] for Country [" + countryCode + "]"));
                this.pStmt.executeUpdate();
                newId = BasicSQLUtils.getInsertedId(this.pStmt);
                stateToIdHash.put(stateCode, newId);
            }
            rs.close();
            if (this.frame != null) {
                this.frame.setDesc("Creating Counties...");
            }
            sqlStr = "SELECT asciiname, latitude, longitude, country, admin1 as StateCode FROM geoname WHERE fcode = 'ADM2' ORDER BY name";
            rs = stmt.executeQuery(sqlStr);
            while (rs.next()) {
                if (this.buildInsert(rs, 400, earthId)) {
                    this.pStmt.executeUpdate();
                }
                if (this.frame == null || ++cnt % 100 != 0) continue;
                this.frame.setProcess(cnt);
            }
            rs.close();
            if (this.frame != null) {
                this.frame.setProcess(count);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BuildFromGeonames.class, ex);
            try {
                this.updateConn.rollback();
            }
            catch (Exception exr) {
                exr.printStackTrace();
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (this.readConn != null) {
                    this.readConn.close();
                }
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                if (this.updateConn != DBConnection.getInstance()) {
                    this.updateConn.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean buildInsert(ResultSet rs, int rankId, int earthId) throws SQLException {
        this.rowData.clear();
        int i = 0;
        while (i < rs.getMetaData().getColumnCount()) {
            this.rowData.add(rs.getObject(i + 1));
            ++i;
        }
        return this.buildInsert(this.rowData, rankId, earthId);
    }

    private boolean buildInsert(List<Object> row, int rankId, int earthId) throws SQLException {
        String countryCode;
        GeographyTreeDefItem item = this.geoDef.getDefItemByRank(rankId);
        int geoDefItemId = item.getId();
        String nameStr = row.get(0).toString().trim();
        Integer parentId = null;
        String abbrev = null;
        if (rankId == 100) {
            parentId = earthId;
            abbrev = row.get(3).toString();
        } else if (rankId == 200) {
            countryCode = row.get(3).toString();
            String continentCode = this.countryToContHash.get(countryCode);
            abbrev = countryCode;
            if (continentCode != null) {
                parentId = this.contToIdHash.get(continentCode);
                if (parentId == null) {
                    log.error((Object)("No Continent Id for Name  continentCode[" + continentCode + "]   Country[" + nameStr + "]"));
                }
            } else {
                StringBuilder sb = new StringBuilder("No Continent Code [" + continentCode + "]:\n");
                int i = 0;
                while (i < row.size()) {
                    sb.append(String.valueOf(i) + " - " + row.get(i) + "\n");
                    ++i;
                }
                log.error((Object)sb.toString());
            }
        } else if (rankId == 300) {
            countryCode = row.get(3).toString();
            abbrev = row.get(4).toString();
            parentId = this.countryCodeToIdHash.get(countryCode);
            if (parentId == null) {
                log.error((Object)("No Country Code Id for [" + countryCode + "][" + nameStr + "]"));
            }
        } else if (rankId == 400) {
            String stateCode = row.get(4).toString();
            String countryCode2 = row.get(3).toString();
            abbrev = row.get(3).toString();
            Hashtable<String, Integer> stateToIdHash = this.countryStateCodeToIdHash.get(countryCode2);
            if (stateToIdHash != null) {
                parentId = stateToIdHash.get(stateCode);
                if (parentId == null) {
                    log.error((Object)("No State Id for CC[" + countryCode2 + "]  stateCode[" + stateCode + "] County[" + nameStr + "]"));
                }
            } else {
                log.error((Object)("No State Hash for CC[" + countryCode2 + "]  State[" + stateCode + "] Name: " + row.get(1)));
            }
        }
        if (nameStr.length() > 64) {
            log.error((Object)("Name[" + nameStr + " is too long " + nameStr.length() + "truncating."));
            nameStr = nameStr.substring(0, 64);
        }
        if (parentId != null) {
            Double lat = row.get(1) != null ? Double.valueOf(((BigDecimal)row.get(1)).doubleValue()) : null;
            Double lon = row.get(2) != null ? Double.valueOf(((BigDecimal)row.get(2)).doubleValue()) : null;
            this.pStmt.setString(1, nameStr);
            this.pStmt.setInt(2, rankId);
            this.pStmt.setInt(3, parentId);
            this.pStmt.setBoolean(4, true);
            this.pStmt.setBoolean(5, true);
            this.pStmt.setInt(6, this.geoDef.getId());
            this.pStmt.setInt(7, geoDefItemId);
            this.pStmt.setInt(8, this.createdByAgent == null ? 1 : this.createdByAgent.getId());
            this.pStmt.setBigDecimal(9, lat > -181.0 ? new BigDecimal(lat) : null);
            this.pStmt.setBigDecimal(10, lon > -181.0 ? new BigDecimal(lon) : null);
            this.pStmt.setString(11, StringUtils.isNotEmpty((String)abbrev) ? abbrev : null);
            this.pStmt.setTimestamp(12, this.now);
            this.pStmt.setTimestamp(13, this.now);
            this.pStmt.setInt(14, 0);
            return true;
        }
        return false;
    }

    private void createCountry(String nameStr, String countryCode, String continentCode, int rankId) throws SQLException {
        GeographyTreeDefItem item = this.geoDef.getDefItemByRank(rankId);
        int geoDefItemId = item.getId();
        Integer parentId = null;
        parentId = this.contToIdHash.get(continentCode);
        if (parentId == null) {
            log.error((Object)("No Continent Id for continentCode[" + continentCode + "]   Country[" + nameStr + "]"));
        }
        if (parentId != null || rankId == 100) {
            this.pStmt.setString(1, nameStr);
            this.pStmt.setInt(2, rankId);
            this.pStmt.setInt(3, parentId);
            this.pStmt.setBoolean(4, true);
            this.pStmt.setBoolean(5, true);
            this.pStmt.setInt(6, this.geoDef.getId());
            this.pStmt.setInt(7, geoDefItemId);
            this.pStmt.setInt(8, this.createdByAgent == null ? 1 : this.createdByAgent.getId());
            this.pStmt.setBigDecimal(9, null);
            this.pStmt.setBigDecimal(10, null);
            this.pStmt.setString(11, countryCode);
            this.pStmt.setTimestamp(12, this.now);
            this.pStmt.setTimestamp(13, this.now);
            this.pStmt.setInt(14, 0);
        } else {
            log.error((Object)("parentId is NULL [" + continentCode + "]"));
        }
    }

    public boolean loadGeoNamesDB() {
        File file;
        try {
            DBConnection currDBConn = DBConnection.getInstance();
            String dbName = currDBConn.getDatabaseName();
            DBMSUserMgr.DBSTATUS status = DBMSUserMgr.checkForDB(dbName, currDBConn.getServerName(), this.itUsername, this.itPassword);
            if (status == DBMSUserMgr.DBSTATUS.missingDB) {
                DBMSUserMgr dbMgr = DBMSUserMgr.getInstance();
                if (dbMgr != null) {
                    if (dbMgr.connectToDBMS(this.itUsername, this.itPassword, currDBConn.getServerName())) {
                        if (!dbMgr.createDatabase(dbName)) {
                            UIRegistry.showLocalizedError("ERROR_CRE_GEODB", dbName);
                        }
                    } else {
                        UIRegistry.showLocalizedError("ERROR_LOGIN_GEODB", dbName);
                    }
                } else {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(BuildFromGeonames.class, new Exception("Couldn't create DBMSMgr"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BuildFromGeonames.class, ex);
        }
        if ((file = new File(XMLHelper.getConfigDirPath("geonames.sql.zip"))).exists()) {
            BackupServiceFactory bsf = BackupServiceFactory.getInstance();
            bsf.setUsernamePassword(this.itUsername, this.itPassword);
            String dbName = DBConnection.getInstance().getDatabaseName();
            boolean status = bsf.doRestoreBulkDataInBackground(dbName, null, file.getAbsolutePath(), null, null, null, true, false);
            bsf.setUsernamePassword(null, null);
            return status;
        }
        return false;
    }
}

