/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.dbsupport;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.AutoNumberGeneric;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class AccessionAutoNumberAlphaNum
extends AutoNumberGeneric {
    private static final Logger log = Logger.getLogger(AccessionAutoNumberAlphaNum.class);

    public AccessionAutoNumberAlphaNum() {
        this.classObj = Accession.class;
        this.fieldName = "accessionNumber";
    }

    public AccessionAutoNumberAlphaNum(Properties properties) {
        super(properties);
    }

    @Override
    protected String getHighestObject(UIFieldFormatterIFace formatter, Session session, String value, Pair<Integer, Integer> yearPos, Pair<Integer, Integer> pos) throws Exception {
        Division currDivision = AppContextMgr.getInstance().getClassObject(Division.class);
        String ansSQL = "SELECT ans.AutonumberingSchemeID, ans.FormatName, ans.IsNumericOnly, ans.SchemeName, dv.Name, dv.DivisionID FROM autonumberingscheme ans Inner Join autonumsch_div ad ON ans.AutoNumberingSchemeID = ad.AutoNumberingSchemeID Inner Join division dv ON ad.DivisionID = dv.UserGroupScopeId WHERE dv.UserGroupScopeId = %d AND FormatName = '%s'";
        String sql = String.format(ansSQL, currDivision.getId(), formatter.getName());
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        Integer ansID = null;
        if (rows.size() == 1) {
            ansID = (Integer)rows.get(0)[0];
        } else {
            log.debug((Object)("Too many Formatters named [" + formatter.getName() + "]"));
        }
        String ansToDivSQL = "SELECT dv.UserGroupScopeId DivID FROM autonumberingscheme ans Inner Join autonumsch_div ad ON ans.AutoNumberingSchemeID = ad.AutoNumberingSchemeID Inner Join division dv ON ad.DivisionID = dv.UserGroupScopeId WHERE ans.AutoNumberingSchemeID = %d";
        Vector<Integer> divIds = new Vector<Integer>();
        for (Object[] row : BasicSQLUtils.query(String.format(ansToDivSQL, ansID))) {
            divIds.add((Integer)row[0]);
        }
        Integer yearVal = null;
        if (yearPos != null && StringUtils.isNotEmpty((String)value) && value.length() >= (Integer)yearPos.second) {
            yearVal = this.extractIntegerValue(yearPos, value);
        }
        StringBuilder sb = new StringBuilder("SELECT a.accessionNumber FROM Accession a Join a.division dv Join dv.numberingSchemes ans WHERE ans.id = ");
        AutoNumberingScheme accessionAutoNumScheme = currDivision.getNumberingSchemesByType(Accession.getClassTableId());
        if (accessionAutoNumScheme != null && accessionAutoNumScheme.getAutoNumberingSchemeId() != null) {
            sb.append(accessionAutoNumScheme.getAutoNumberingSchemeId());
            sb.append(" AND dv.id in (");
            for (Integer dvId : divIds) {
                sb.append(dvId);
                sb.append(',');
            }
        } else {
            UIRegistry.showError("There is no AutonumberingScheme for the Accession formatter!");
            return "";
        }
        sb.setLength(sb.length() - 1);
        sb.append(')');
        if (yearVal != null) {
            sb.append(" AND ");
            sb.append(yearVal);
            sb.append(" = substring(" + this.fieldName + "," + ((Integer)yearPos.first + 1) + "," + yearPos.second + ")");
        }
        sb.append(" ORDER BY");
        try {
            if (yearPos != null) {
                sb.append(" substring(" + this.fieldName + "," + ((Integer)yearPos.first + 1) + "," + yearPos.second + ") desc");
            }
            if (pos != null) {
                if (yearPos != null) {
                    sb.append(", ");
                }
                sb.append(" substring(" + this.fieldName + "," + ((Integer)pos.first + 1) + "," + pos.second + ") desc");
            }
            System.out.println("AccessionAutoNumberAlphaNum - " + sb.toString());
            List list = session.createQuery(sb.toString()).setMaxResults(1).list();
            if (list.size() == 1) {
                return list.get(0).toString();
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(AccessionAutoNumberAlphaNum.class, ex);
            ex.printStackTrace();
        }
        return null;
    }
}

