/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.ESTermParser;
import edu.ku.brc.af.ui.SearchTermField;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchQueryBuilderIFace;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.busrules.TableSearchResults;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class TreeableSearchQueryBuilder
implements ViewBasedSearchQueryBuilderIFace {
    public static final int PARENT = 0;
    public static final int ACCEPTED_PARENT = 1;
    public static final int HYBRID_PARENT = 2;
    protected Treeable<?, ?, ?> nodeInForm;
    protected ValComboBox rankCombo;
    protected boolean accepted;
    protected int lookupType;
    protected List<ERTICaptionInfo> cols = new Vector<ERTICaptionInfo>();

    public TreeableSearchQueryBuilder(Treeable<?, ?, ?> nodeInForm, ValComboBox rankCombo, int lookupType) {
        this.nodeInForm = nodeInForm;
        this.rankCombo = rankCombo;
        this.lookupType = lookupType;
        this.accepted = lookupType != 2;
    }

    @Override
    public String buildSQL(String searchText, boolean isForCount) {
        if (!QueryAdjusterForDomain.getInstance().isUserInputNotInjectable(searchText)) {
            return "";
        }
        String queryStr = "";
        TreeDefIface<?, ?, ?> treeDef = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefForClass(this.nodeInForm.getClass());
        Integer treeDefId = treeDef.getTreeDefId();
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(this.nodeInForm.getClass().getName());
        DBTableInfo defTableInfo = DBTableIdMgr.getInstance().getByClassName(tableInfo.getRelationshipByName("definition").getClassName());
        String defMemberName = defTableInfo.getShortClassName();
        defMemberName = defMemberName.substring(0, 1).toLowerCase().concat(defMemberName.substring(1));
        String queryFormatStr = isForCount ? "Select count(n.id) " : "SELECT n.fullName, n.id ";
        queryFormatStr = String.valueOf(queryFormatStr) + "from %s n INNER JOIN n.definition d WHERE lower(n.fullName) LIKE '%s' AND d.id = %d";
        queryStr = String.format(queryFormatStr, tableInfo.getShortClassName(), String.valueOf(searchText.toLowerCase()) + "%", treeDefId);
        Integer nodeId = this.nodeInForm == null ? null : this.nodeInForm.getTreeId();
        Integer nodeNumber = null;
        Integer highestChildNodeNumber = null;
        if (this.nodeInForm != null) {
            if (this.lookupType == 1 && nodeId == null) {
                Object parentNode = this.nodeInForm.getParent();
                nodeNumber = parentNode == null ? null : parentNode.getNodeNumber();
                highestChildNodeNumber = parentNode == null ? null : parentNode.getHighestChildNodeNumber();
            } else {
                nodeNumber = this.nodeInForm.getNodeNumber();
                highestChildNodeNumber = this.nodeInForm.getHighestChildNodeNumber();
            }
        }
        if (nodeId != null) {
            queryStr = String.valueOf(queryStr) + " and n.id != " + nodeId;
        }
        if (this.rankCombo != null && this.rankCombo.getComboBox() != null) {
            TreeDefItemIface rank = (TreeDefItemIface)this.rankCombo.getValue();
            if (rank != null) {
                if (this.lookupType == 1) {
                    queryStr = String.valueOf(queryStr) + " and (n.rankId = " + rank.getRankId() + " or n.rankId >= " + treeDef.getSynonymizedLevel() + ") ";
                } else {
                    queryStr = String.valueOf(queryStr) + " and n.rankId < " + rank.getRankId();
                    int minRank = 0;
                    for (TreeDefItemIface defItem : treeDef.getTreeDefItems()) {
                        if (defItem.getRankId().intValue() == ((Number)((Object)rank)).intValue()) break;
                        if (!defItem.getIsEnforced().booleanValue()) continue;
                        minRank = defItem.getRankId();
                    }
                    if (minRank > 0) {
                        queryStr = String.valueOf(queryStr) + " and n.rankId >= " + minRank;
                    }
                }
            } else if (this.lookupType == 1) {
                queryStr = String.valueOf(queryStr) + " and n.rankId >= " + treeDef.getSynonymizedLevel();
            } else {
                int maxRank = 0;
                for (TreeDefItemIface defItem : treeDef.getTreeDefItems()) {
                    if (defItem.getRankId() <= maxRank) continue;
                    maxRank = defItem.getRankId();
                }
                queryStr = String.valueOf(queryStr) + " and n.rankId < " + maxRank;
            }
        }
        if (nodeNumber != null && highestChildNodeNumber != null) {
            if (this.lookupType != 1 || nodeId != null) {
                queryStr = String.valueOf(queryStr) + " and (n.nodeNumber not between " + nodeNumber + " and " + highestChildNodeNumber + ")";
            }
            if (this.lookupType == 1) {
                queryStr = String.valueOf(queryStr) + " and (" + nodeNumber + " not between n.nodeNumber and n.highestChildNodeNumber)";
            }
        }
        if (this.accepted) {
            queryStr = String.valueOf(queryStr) + " and n." + this.getAcceptedBooleanFldName() + " = true";
        }
        if (!isForCount) {
            queryStr = String.valueOf(queryStr) + " ORDER BY n.fullName asc";
        }
        return queryStr;
    }

    protected String getAcceptedBooleanFldName() {
        return "isAccepted";
    }

    @Override
    public String buildSQL(Map<String, Object> dataMap, List<String> fieldNames) {
        Integer highestChildNodeNumber;
        String queryStr = "";
        TreeDefIface<?, ?, ?> treeDef = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefForClass(this.nodeInForm.getClass());
        Integer treeDefId = treeDef.getTreeDefId();
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(this.nodeInForm.getClass().getName());
        String tableName = tableInfo.getName();
        DBTableInfo defTableInfo = DBTableIdMgr.getInstance().getByClassName(tableInfo.getRelationshipByName("definition").getClassName());
        String defMemberName = defTableInfo.getShortClassName();
        defMemberName = defMemberName.substring(0, 1).toLowerCase().concat(defMemberName.substring(1));
        this.cols.clear();
        StringBuilder colNames = new StringBuilder();
        int dspCnt = 0;
        for (String colName : fieldNames) {
            DBFieldInfo fi;
            String fieldName;
            if (dspCnt > 0) {
                colNames.append(',');
            }
            String columnName = colName;
            if (!colName.startsWith(String.valueOf(tableName) + ".")) {
                fieldName = "n." + columnName.substring(0, 1).toLowerCase().concat(columnName.substring(1));
            } else {
                String fld = StringUtils.substringAfter((String)colName, (String)".");
                fieldName = "n." + fld.substring(0, 1).toLowerCase().concat(fld.substring(1));
            }
            colNames.append(fieldName);
            Object baseName = StringUtils.substringAfter((String)colName, (String)".");
            if (StringUtils.isEmpty((String)baseName)) {
                baseName = colName;
            }
            Object colTitle = (fi = tableInfo.getFieldByColumnName((String)baseName)) != null ? fi.getTitle() : baseName;
            ERTICaptionInfo col = new ERTICaptionInfo(columnName, (String)colTitle, true, null, dspCnt + 1);
            this.cols.add(col);
            ++dspCnt;
        }
        StringBuilder orderBy = new StringBuilder();
        StringBuilder criteria = new StringBuilder();
        int criCnt = 0;
        for (String colName : dataMap.keySet()) {
            String data = (String)dataMap.get(colName);
            if (!ESTermParser.getInstance().parse(data.toLowerCase(), true) || !StringUtils.isNotEmpty((String)data)) continue;
            List<SearchTermField> fields = ESTermParser.getInstance().getFields();
            SearchTermField firstTerm = fields.get(0);
            String fieldName = colName;
            if (!colName.startsWith(String.valueOf(tableName) + ".")) {
                fieldName = "n." + colName.substring(0, 1).toLowerCase().concat(colName.substring(1));
            } else {
                String fld = StringUtils.substringAfter((String)colName, (String)".");
                fieldName = "n." + fld.substring(0, 1).toLowerCase().concat(fld.substring(1));
            }
            if (criCnt > 0) {
                criteria.append(" OR ");
            }
            String clause = ESTermParser.getInstance().createWhereClause(firstTerm, null, fieldName);
            criteria.append(clause);
            if (criCnt > 0) {
                orderBy.append(',');
            }
            orderBy.append(fieldName);
            ++criCnt;
        }
        if (criteria.length() == 0) {
            return null;
        }
        queryStr = "SELECT n.id, " + colNames;
        queryStr = String.valueOf(queryStr) + " from " + tableInfo.getShortClassName() + " n INNER JOIN n.definition d WHERE " + criteria.toString() + " AND d.id = " + treeDefId;
        Integer nodeId = this.nodeInForm == null ? null : this.nodeInForm.getTreeId();
        Integer nodeNumber = this.nodeInForm == null ? null : this.nodeInForm.getNodeNumber();
        Integer n = highestChildNodeNumber = this.nodeInForm == null ? null : this.nodeInForm.getHighestChildNodeNumber();
        if (nodeId != null) {
            queryStr = String.valueOf(queryStr) + " and n.id != " + nodeId;
        }
        if (this.rankCombo != null) {
            Object rank = this.rankCombo.getValue();
            if (rank != null) {
                queryStr = String.valueOf(queryStr) + " and n.rankId < " + ((TreeDefItemIface)rank).getRankId();
            } else {
                int maxRank = 0;
                for (TreeDefItemIface defItem : treeDef.getTreeDefItems()) {
                    if (defItem.getRankId() <= maxRank) continue;
                    maxRank = defItem.getRankId();
                }
                queryStr = String.valueOf(queryStr) + " and n.rankId < " + maxRank;
            }
        } else if (nodeNumber != null && highestChildNodeNumber != null) {
            queryStr = String.valueOf(queryStr) + " and (n.nodeNumber not between " + nodeNumber + " and " + highestChildNodeNumber + ")";
        }
        if (this.accepted) {
            queryStr = String.valueOf(queryStr) + " and n." + this.getAcceptedBooleanFldName() + " = true";
        }
        if (!StringUtils.isBlank((String)orderBy.toString())) {
            queryStr = String.valueOf(queryStr) + " ORDER BY " + orderBy.toString();
        }
        return queryStr;
    }

    @Override
    public QueryForIdResultsIFace createQueryForIdResults() {
        return new TableSearchResults(DBTableIdMgr.getInstance().getByClassName(this.nodeInForm.getClass().getName()), this.cols, true);
    }
}

