/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.specify.datamodel.busrules.BaseTreeBusRules;
import edu.ku.brc.specify.datamodel.busrules.TreeableSearchQueryBuilder;
import edu.ku.brc.specify.tasks.TreeTaskMgr;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class TaxonBusRules
extends BaseTreeBusRules<Taxon, TaxonTreeDef, TaxonTreeDefItem> {
    protected static final String PARENT = "parent";
    protected static final String RANK = "definitionItem";
    protected static final String HYBRIDPARENT1 = "hybridParent1";
    protected static final String HYBRIDPARENT2 = "hybridParent2";
    protected static final String IS_HYBRID = "isHybrid";
    protected AttachmentOwnerBaseBusRules attachOwnerRules = new AttachmentOwnerBaseBusRules(new Class[0]){

        @Override
        public boolean okToEnableDelete(Object dataObj) {
            return false;
        }
    };

    public TaxonBusRules() {
        super(Taxon.class, TaxonTreeDefItem.class);
    }

    @Override
    protected Class<?> getNodeClass() {
        return Taxon.class;
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        Component fishBaseWL = this.formViewObj.getControlById("WebLink");
        if (fishBaseWL != null && !Discipline.isCurrentDiscipline(DisciplineType.STD_DISCIPLINES.fish)) {
            fishBaseWL.setVisible(false);
        }
        final JCheckBox hybridCheckBox = (JCheckBox)this.formViewObj.getControlByName(IS_HYBRID);
        final GetSetValueIFace hybrid1Widget = (GetSetValueIFace)((Object)this.formViewObj.getControlByName(HYBRIDPARENT1));
        final GetSetValueIFace hybrid2Widget = (GetSetValueIFace)((Object)this.formViewObj.getControlByName(HYBRIDPARENT2));
        if (hybridCheckBox != null) {
            hybridCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!hybridCheckBox.isSelected()) {
                        hybrid1Widget.setValue(null, null);
                        hybrid2Widget.setValue(null, null);
                    }
                }
            });
        }
        TreeTaskMgr.checkLocks();
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        return UIRegistry.getLocalizedMessage("TAXON_DELETE", ((Taxon)dataObj).getName());
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        if (dataObj instanceof Taxon) {
            Taxon taxon = (Taxon)dataObj;
            int citCnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM taxoncitation WHERE TaxonID = " + taxon.getId());
            if (citCnt < 1) {
                return super.okToDeleteNode(taxon);
            }
        } else if (dataObj instanceof TaxonTreeDefItem) {
            return this.okToDeleteDefItem((TaxonTreeDefItem)dataObj);
        }
        return false;
    }

    public boolean okToDeleteDefItem(TaxonTreeDefItem defItem) {
        this.reasonList.clear();
        if (defItem.getRankId() == 0) {
            return false;
        }
        return this.okToDelete("taxon", "TaxonTreeDefItemID", defItem.getId());
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        this.setLSID((FormDataObjIFace)dataObj);
        return super.afterSaveCommit(dataObj, session);
    }

    @Override
    protected String getExtraWhereColumns(DBTableInfo tableInfo) {
        return null;
    }

    @Override
    public String[] getRelatedTableAndColumnNames() {
        String[] relationships = new String[]{"determination", "TaxonID", "collectingeventattribute", "HostTaxonID", "taxon", "HybridParent1ID", "taxon", "HybridParent2ID", "taxon", "AcceptedID"};
        return relationships;
    }

    @Override
    public String[] getAllRelatedTableAndColumnNames() {
        String[] relationships = new String[]{"determination", "TaxonID", "determination", "PreferredTaxonID", "collectingeventattribute", "HostTaxonID", "taxoncitation", "TaxonID", "taxon", "HybridParent1ID", "taxon", "HybridParent2ID", "taxon", "AcceptedID"};
        return relationships;
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        this.attachOwnerRules.beforeSave(dataObj, session);
        super.beforeSave(dataObj, session);
        if (dataObj instanceof Taxon) {
            Taxon taxon = (Taxon)dataObj;
            this.beforeSaveTaxon(taxon, session);
            super.updateFullNamesIfNecessary(taxon, session);
            return;
        }
    }

    protected void beforeSaveTaxon(Taxon taxon, DataProviderSessionIFace session) {
        if (taxon.getIsAccepted() == null || taxon.getIsAccepted().booleanValue()) {
            taxon.setAcceptedTaxon(null);
        }
        if (taxon.getIsHybrid() == null || !taxon.getIsHybrid().booleanValue()) {
            taxon.setHybridParent1(null);
            taxon.setHybridParent2(null);
        }
    }

    @Override
    public boolean beforeDeleteCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        boolean retVal = this.attachOwnerRules.beforeDeleteCommit(dataObj, session);
        if (!retVal) {
            return retVal;
        }
        retVal = super.beforeDeleteCommit(dataObj, session);
        return retVal;
    }

    @Override
    public boolean beforeSaveCommit(Object dataObj, DataProviderSessionIFace session) throws Exception {
        boolean retVal = this.attachOwnerRules.beforeSaveCommit(dataObj, session);
        if (!retVal) {
            return retVal;
        }
        retVal = super.beforeSaveCommit(dataObj, session);
        return retVal;
    }

    @Override
    protected boolean canAccessSynonymy(Taxon dataObj) {
        return false;
    }

    @Override
    protected boolean canAccessSynonymy(Taxon dataObj, int rank) {
        return false;
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (this.formViewObj.getAltView().getMode() == AltViewIFace.CreationMode.EDIT && this.formViewObj.getDataObj() instanceof Taxon) {
            Taxon nodeInForm = (Taxon)this.formViewObj.getDataObj();
            JCheckBox hybridCheckBox = (JCheckBox)this.formViewObj.getControlByName(IS_HYBRID);
            Component hybridParent1Comp = this.formViewObj.getControlByName(HYBRIDPARENT1);
            if (hybridParent1Comp instanceof ValComboBoxFromQuery) {
                ValComboBoxFromQuery hybrid1Widget = (ValComboBoxFromQuery)hybridParent1Comp;
                ValComboBoxFromQuery hybrid2Widget = (ValComboBoxFromQuery)this.formViewObj.getControlByName(HYBRIDPARENT2);
                if (hybridCheckBox != null && nodeInForm != null) {
                    hybrid1Widget.registerQueryBuilder(new TreeableSearchQueryBuilder(nodeInForm, null, 2));
                    hybrid2Widget.registerQueryBuilder(new TreeableSearchQueryBuilder(nodeInForm, null, 2));
                }
            }
        }
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        TreeTaskMgr.checkLocks();
    }
}

