/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.datamodel.busrules.BaseTreeBusRules;
import edu.ku.brc.specify.tasks.TreeTaskMgr;
import edu.ku.brc.ui.UIRegistry;

public class StorageBusRules
extends BaseTreeBusRules<Storage, StorageTreeDef, StorageTreeDefItem> {
    public StorageBusRules() {
        super(Storage.class, StorageTreeDefItem.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        TreeTaskMgr.checkLocks();
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        if (dataObj instanceof Storage) {
            return UIRegistry.getLocalizedMessage("STORAGE_DELETED", ((Storage)dataObj).getName());
        }
        return super.getDeleteMsg(dataObj);
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        if (dataObj instanceof Storage) {
            Storage stor = (Storage)dataObj;
            this.beforeSaveStorage(stor);
            super.updateFullNamesIfNecessary(stor, session);
            return;
        }
    }

    protected void beforeSaveStorage(Storage stor) {
    }

    @Override
    public String[] getRelatedTableAndColumnNames() {
        String[] relationships = new String[]{"preparation", "StorageID", "container", "StorageID", "storage", "AcceptedID"};
        return relationships;
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        this.reasonList.clear();
        if (dataObj instanceof Storage) {
            return super.okToDeleteNode((Storage)dataObj);
        }
        if (dataObj instanceof StorageTreeDefItem) {
            return this.okToDeleteDefItem((StorageTreeDefItem)dataObj);
        }
        return false;
    }

    public boolean okToDeleteDefItem(StorageTreeDefItem defItem) {
        if (defItem.getRankId() == 0) {
            return false;
        }
        return this.okToDelete("storage", "StorageTreeDefItemID", defItem.getId());
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        TreeTaskMgr.checkLocks();
    }

    @Override
    protected Class<?> getNodeClass() {
        return Storage.class;
    }
}

