/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.ui.PasswordStrengthUI;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.EditViewCompSwitcherPanel;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.af.ui.forms.validation.ValPasswordField;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;

public class SpecifyUserBusRules
extends BaseBusRules {
    private static final int PWD_LEN_THRESHOLD = 25;
    private char currEcho;
    private String currentPlainTextPWD = null;
    private Integer spUserId = null;
    private ValPasswordField pwdTxt = null;
    private JTextField keyTxt = null;
    private JButton showPwdBtn = null;
    private PasswordStrengthUI pwdStrenthUI = null;
    private JButton genBtn = null;
    private JButton copyBtn = null;
    private int minPwdLen;

    public SpecifyUserBusRules() {
        super(SpecifyUser.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        char echoChar;
        if (viewableArg == null || this.pwdTxt != null) {
            return;
        }
        super.initialize(viewableArg);
        this.pwdTxt = (ValPasswordField)this.formViewObj.getCompById("3");
        this.keyTxt = (JTextField)this.formViewObj.getCompById("key");
        this.showPwdBtn = (JButton)this.formViewObj.getCompById("ShowPwd");
        this.pwdStrenthUI = (PasswordStrengthUI)this.formViewObj.getCompById("6");
        this.genBtn = (JButton)this.formViewObj.getCompById("GenerateKey");
        this.copyBtn = (JButton)this.formViewObj.getCompById("CopyToCB");
        if (this.pwdTxt == null) {
            return;
        }
        Institution institution = AppContextMgr.getInstance().getClassObject(Institution.class);
        this.minPwdLen = institution.getMinimumPwdLength().byteValue();
        this.pwdTxt.setMinLen(this.minPwdLen);
        this.pwdStrenthUI.setMinPwdLen(this.minPwdLen);
        this.currEcho = echoChar = this.pwdTxt.getEchoChar();
        this.pwdTxt.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String pwdStr = new String(SpecifyUserBusRules.this.pwdTxt.getPassword());
                if (StringUtils.isNotEmpty((String)pwdStr) && pwdStr.length() < 25 && (SpecifyUserBusRules.this.currentPlainTextPWD == null || !SpecifyUserBusRules.this.currentPlainTextPWD.equals(pwdStr))) {
                    SpecifyUserBusRules.this.currentPlainTextPWD = pwdStr;
                }
            }
        });
        if (this.showPwdBtn != null) {
            this.showPwdBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpecifyUserBusRules.this.currEcho = SpecifyUserBusRules.this.currEcho == echoChar ? (char)'\u0000' : echoChar;
                    SpecifyUserBusRules.this.pwdTxt.setEchoChar(SpecifyUserBusRules.this.currEcho);
                    SpecifyUserBusRules.this.showPwdBtn.setText(UIRegistry.getResourceString(SpecifyUserBusRules.this.currEcho == echoChar ? "SHOW_PASSWORD" : "HIDE_PASSWORD"));
                }
            });
        }
        if (this.copyBtn != null) {
            this.copyBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UIHelper.setTextToClipboard(new String(SpecifyUserBusRules.this.pwdTxt.getPassword()));
                }
            });
        }
        if (this.genBtn != null) {
            this.genBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key;
                    if (StringUtils.isNotEmpty((String)SpecifyUserBusRules.this.currentPlainTextPWD) && SpecifyUserBusRules.this.currentPlainTextPWD.length() >= SpecifyUserBusRules.this.minPwdLen && (key = SpecifyUserBusRules.this.createEncryptMasterKey(SpecifyUserBusRules.this.currentPlainTextPWD)) != null) {
                        if (SpecifyUserBusRules.this.keyTxt != null) {
                            SpecifyUserBusRules.this.keyTxt.setText(key);
                        }
                        UIHelper.setTextToClipboard(key);
                        UIRegistry.showLocalizedMsg("SPUSR_KEYGEN");
                    }
                }
            });
            this.genBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
            this.pwdTxt.getDocument().addDocumentListener(new DocumentAdaptor(){

                @Override
                protected void changed(DocumentEvent e) {
                    super.changed(e);
                    char[] chars = SpecifyUserBusRules.this.pwdTxt.getPassword();
                    boolean enable = chars != null && chars.length >= SpecifyUserBusRules.this.minPwdLen;
                    SpecifyUserBusRules.this.genBtn.setEnabled(enable);
                    SpecifyUserBusRules.this.copyBtn.setEnabled(enable);
                }
            });
        }
        if (this.pwdStrenthUI == null) {
            return;
        }
        this.pwdStrenthUI.setPasswordField(this.pwdTxt, null);
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        return super.isOkToSave(dataObj, session);
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object parentDataObj, Object dataObj, boolean isExistingObject) {
        return super.processBusinessRules(parentDataObj, dataObj, isExistingObject);
    }

    protected ValComboBoxFromQuery getAgentCBX() {
        Component agentCBX;
        if (this.formViewObj != null && (agentCBX = this.formViewObj.getControlByName("agent")) != null && agentCBX instanceof ValComboBoxFromQuery) {
            return (ValComboBoxFromQuery)agentCBX;
        }
        return null;
    }

    @Override
    public void afterFillForm(Object dataObj) {
        Iterator<Agent> iterator;
        ValComboBoxFromQuery cbx;
        super.afterFillForm(dataObj);
        SpecifyUser spUser = (SpecifyUser)dataObj;
        boolean doReset = true;
        if (spUser != null && spUser.getId() != null) {
            if (this.spUserId != null) {
                doReset = !this.spUserId.equals(spUser.getId());
            }
            this.spUserId = spUser.getId();
        }
        if (spUser != null && doReset) {
            this.currentPlainTextPWD = null;
            if (this.genBtn != null) {
                this.genBtn.setEnabled(false);
                this.copyBtn.setEnabled(false);
            }
        }
        if (this.formViewObj != null && this.formViewObj.getDataObj() instanceof SpecifyUser && (cbx = this.getAgentCBX()) != null && spUser != null && (iterator = spUser.getAgents().iterator()).hasNext()) {
            Agent agent = iterator.next();
            cbx.setValue(agent, null);
        }
    }

    protected String createEncryptMasterKey(String pwdStr) {
        String key = null;
        if (!pwdStr.isEmpty()) {
            String oldPwd = Encryption.getEncryptDecryptPassword();
            try {
                Pair<String, String> usrPwd = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
                Encryption.setEncryptDecryptPassword(pwdStr);
                key = Encryption.encrypt(String.valueOf((String)usrPwd.first) + "," + (String)usrPwd.second, pwdStr);
            }
            finally {
                Encryption.setEncryptDecryptPassword(oldPwd);
            }
            return key;
        }
        return null;
    }

    private boolean isFieldOK(String id, String keyName, boolean isPwd) {
        JTextField tf = null;
        Component comp = (Component)this.formViewObj.getCompById(id);
        tf = comp instanceof EditViewCompSwitcherPanel ? (JTextField)((EditViewCompSwitcherPanel)comp).getCurrentComp() : (JTextField)comp;
        String value = tf.getText().trim();
        if (StringUtils.contains((String)value, (char)' ') || !isPwd && StringUtils.contains((String)value, (char)',')) {
            UIRegistry.showLocalizedError(keyName);
            return false;
        }
        return false;
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (!(dataObj instanceof SpecifyUser)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS nameStatus = this.isCheckDuplicateNumberOK("name", (FormDataObjIFace)dataObj, SpecifyUser.class, "specifyUserId");
        if (this.isFieldOK("1", "NO_SPC_USRNAME", false)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        if (this.isFieldOK("3", "NO_SPC_PWDNAME", true)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        return nameStatus != BusinessRulesIFace.STATUS.OK ? BusinessRulesIFace.STATUS.Error : BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        SpecifyUser spUser;
        String pwd;
        super.beforeMerge(dataObj, session);
        if (this.formViewObj != null && (pwd = (spUser = (SpecifyUser)this.formViewObj.getDataObj()).getPassword()).length() < 25) {
            spUser.setPassword(Encryption.encrypt(pwd, pwd));
        }
    }
}

