/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.Shipment;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.Set;
import javax.swing.JTextField;

public class ShipmentBusRules
extends BaseBusRules {
    public ShipmentBusRules() {
        super(Shipment.class);
    }

    @Override
    public void afterFillForm(Object dataObj) {
        MultiView mvParent;
        boolean isNewObj;
        if (this.formViewObj != null && this.formViewObj.getDataObj() instanceof Shipment && (isNewObj = MultiView.isOptionOn((mvParent = this.formViewObj.getMVParent()).getOptions(), 4))) {
            Loan loan = (Loan)mvParent.getMultiViewParent().getData();
            Component shipComp = this.formViewObj.getControlByName("shipmentNumber");
            if (shipComp instanceof JTextField) {
                JTextField shipTxt = (JTextField)shipComp;
                shipTxt.setText(loan.getLoanNumber());
            }
        }
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (dataObj == null || !(dataObj instanceof Shipment)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        Shipment shipment = (Shipment)dataObj;
        Agent agent = shipment.getShippedTo();
        if (agent != null) {
            Set<Address> addr = agent.getAddresses();
            if (addr.size() == 0) {
                this.reasonList.add(UIRegistry.getLocalizedMessage("LOAN_MISSING_AGENT_ADDR", new Object[0]));
                return BusinessRulesIFace.STATUS.Error;
            }
        } else {
            this.reasonList.add(UIRegistry.getLocalizedMessage("Loan Agent is missing an Agent", new Object[0]));
            return BusinessRulesIFace.STATUS.Error;
        }
        return BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        if (dataObj instanceof Accession) {
            return UIRegistry.getLocalizedMessage("SHIPMENT_DELETED", ((Shipment)dataObj).getShipmentNumber());
        }
        return super.getDeleteMsg(dataObj);
    }

    @Override
    public void setObjectIdentity(Object dataObj, DraggableRecordIdentifier draggableIcon) {
        if (dataObj == null) {
            draggableIcon.setLabel("");
        }
        if (dataObj instanceof Shipment) {
            Shipment shipment = (Shipment)dataObj;
            draggableIcon.setLabel(shipment.getShipmentNumber());
            Object data = draggableIcon.getData();
            if (data == null) {
                RecordSet rs = new RecordSet();
                rs.initialize();
                rs.addItem(shipment.getId());
                data = rs;
                draggableIcon.setData(data);
            } else if (data instanceof RecordSetIFace) {
                RecordSetIFace rs = (RecordSetIFace)data;
                rs.clearItems();
                rs.addItem(shipment.getId());
            }
        }
    }
}

