/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.ui.UIRegistry;
import java.util.Hashtable;

public class RepositoryAgreementBusRules
extends AttachmentOwnerBaseBusRules {
    public RepositoryAgreementBusRules() {
        super(RepositoryAgreement.class);
    }

    @Override
    public void addChildrenToNewDataObjects(Object newDataObj) {
        super.addChildrenToNewDataObjects(newDataObj);
        ((RepositoryAgreement)newDataObj).setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
    }

    @Override
    public boolean shouldCreateSubViewData(String fieldName) {
        return false;
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (!(this.viewable instanceof FormViewObj)) {
            return;
        }
        FormViewObj fvo = (FormViewObj)this.viewable;
        fvo.isFieldAutoNumberedByName("repositoryAgreementNumber");
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (!(dataObj instanceof RepositoryAgreement)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        RepositoryAgreement repositoryAgreement = (RepositoryAgreement)dataObj;
        Hashtable<String, Boolean> agentRoleHash = new Hashtable<String, Boolean>();
        for (AccessionAgent aa : repositoryAgreement.getRepositoryAgreementAgents()) {
            Agent agent = aa.getAgent();
            if (agent == null) continue;
            String key = agent.getId() + " _ " + aa.getRole();
            if (agentRoleHash.get(key) == null) {
                agentRoleHash.put(key, true);
                continue;
            }
            this.reasonList.add(UIRegistry.getLocalizedMessage("REPAGR_DUP_AGENTROLE", agent.toString(), aa.getRole()));
            return BusinessRulesIFace.STATUS.Error;
        }
        BusinessRulesIFace.STATUS duplicateNumberStatus = this.isCheckDuplicateNumberOK("repositoryAgreementNumber", (FormDataObjIFace)dataObj, RepositoryAgreement.class, "repositoryAgreementId");
        return duplicateNumberStatus;
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        this.reasonList.clear();
        if (dataObj != null) {
            if (dataObj instanceof RepositoryAgreement) {
                RepositoryAgreement repositoryAgreement = (RepositoryAgreement)dataObj;
                if (repositoryAgreement.getRepositoryAgreementId() != null) {
                    int count = BasicSQLUtils.getCount("select count(*) from accession where RepositoryAgreementID = " + repositoryAgreement.getRepositoryAgreementId());
                    return count == 0;
                }
                return true;
            }
        } else {
            return false;
        }
        throw new RuntimeException("Data Obj is not an RepositoryAgreement [" + dataObj.getClass().getSimpleName() + "]");
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        if (dataObj instanceof RepositoryAgreement) {
            return UIRegistry.getLocalizedMessage("REPAGR_DELETED", ((RepositoryAgreement)dataObj).getRepositoryAgreementNumber());
        }
        return super.getDeleteMsg(dataObj);
    }

    @Override
    public void setObjectIdentity(Object dataObj, DraggableRecordIdentifier draggableIcon) {
        if (dataObj == null) {
            draggableIcon.setLabel("");
        }
        if (dataObj instanceof RepositoryAgreement) {
            RepositoryAgreement repositoryAgreement = (RepositoryAgreement)dataObj;
            draggableIcon.setLabel(repositoryAgreement.getRepositoryAgreementNumber());
            Object data = draggableIcon.getData();
            if (data == null) {
                RecordSet rs = new RecordSet();
                rs.initialize();
                rs.addItem(repositoryAgreement.getRepositoryAgreementId());
                data = rs;
                draggableIcon.setData(data);
            } else if (data instanceof RecordSetIFace) {
                RecordSetIFace rs = (RecordSetIFace)data;
                rs.clearItems();
                rs.addItem(repositoryAgreement.getRepositoryAgreementId());
            }
        }
    }
}

