/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public class PrepTypeBusRules
extends BaseBusRules {
    public PrepTypeBusRules() {
        super(PrepType.class);
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        if (dataObj instanceof PrepType) {
            return UIRegistry.getLocalizedMessage("PREPTYPE_DELETED", ((PrepType)dataObj).getName());
        }
        return super.getDeleteMsg(dataObj);
    }

    @Override
    public List<String> getWarningsAndErrors() {
        return this.reasonList;
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        this.reasonList.clear();
        PrepType prepType = (PrepType)dataObj;
        if (prepType.getId() == null) {
            return true;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DBConnection.getInstance().createConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select count(*) from preparation where preparation.PrepTypeID = " + prepType.getId());
            boolean bl = rs.next() && rs.getInt(1) == 0;
            return bl;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PrepTypeBusRules.class, ex);
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PrepTypeBusRules.class, ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        PrepType prepType;
        this.reasonList.clear();
        if (dataObj == null || !(dataObj instanceof PrepType)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        if (dataObj instanceof PrepType && (prepType = (PrepType)dataObj).getId() == null) {
            return this.isCheckDuplicateNumberOK("name", (FormDataObjIFace)dataObj, PrepType.class, "prepTypeId");
        }
        return BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public void setObjectIdentity(Object dataObj, DraggableRecordIdentifier draggableIcon) {
    }

    @Override
    public void addChildrenToNewDataObjects(Object newDataObj) {
        super.addChildrenToNewDataObjects(newDataObj);
        PrepType prepType = (PrepType)newDataObj;
        Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                collection = session.getData(Collection.class, "collectionId", collection.getId(), DataProviderSessionIFace.CompareType.Equals);
                collection.addReference(prepType, "prepTypes");
                prepType.setCollection(collection);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PrepTypeBusRules.class, ex);
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void dispatchChangeNotification(String pickListName) {
        CommandDispatcher.dispatch(new CommandAction("PICKLIST", "CLEAR", pickListName));
    }

    @Override
    public void afterDeleteCommit(Object dataObj) {
        super.afterDeleteCommit(dataObj);
        this.dispatchChangeNotification(dataObj.getClass().getSimpleName());
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        this.dispatchChangeNotification(dataObj.getClass().getSimpleName());
        return super.afterSaveCommit(dataObj, session);
    }
}

