/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.PickListIFace;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpViewSetObj;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.commons.lang.StringUtils;

public class PickListBusRules
extends BaseBusRules
implements FormPane.FormPaneAdjusterIFace {
    public PickListBusRules() {
        super(new Class[0]);
    }

    @Override
    public void adjustForm(final FormViewObj fvo) {
        String[] types;
        ValComboBox formatterCBX = (ValComboBox)fvo.getControlByName("formatterCBX");
        ValComboBox tablesCBX = (ValComboBox)fvo.getControlByName("tablesCBX");
        ValComboBox fieldsCBX = (ValComboBox)fvo.getControlByName("fieldsCBX");
        ValComboBox typesCBX = (ValComboBox)fvo.getControlByName("typesCBX");
        final ValCheckBox readOnlyChk = (ValCheckBox)fvo.getControlByName("readOnly");
        tablesCBX.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PickListBusRules.this.tableSelected(fvo);
            }
        });
        typesCBX.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PickListBusRules.typeSelected(fvo);
            }
        });
        readOnlyChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!readOnlyChk.isSelected() && PickListBusRules.this.formViewObj.getDataObj() != null) {
                    PickListBusRules.this.adjustSizeSpinner();
                }
            }
        });
        fieldsCBX.setEnabled(false);
        formatterCBX.setEnabled(false);
        this.fillTableNameCBX(tablesCBX);
        DefaultComboBoxModel model = (DefaultComboBoxModel)typesCBX.getComboBox().getModel();
        model.removeAllElements();
        String[] stringArray = types = new String[]{UIRegistry.getResourceString("PL_ITEMS"), UIRegistry.getResourceString("PL_TABLE"), UIRegistry.getResourceString("PLTABLEFIELD")};
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            model.addElement(title);
            ++n2;
        }
    }

    protected void adjustSizeSpinner() {
        ValSpinner sizeLimitSp = (ValSpinner)this.formViewObj.getControlByName("sizeLimit");
        if (sizeLimitSp != null) {
            PickListIFace pickList = (PickListIFace)this.formViewObj.getDataObj();
            if (pickList.getReadOnly().booleanValue()) {
                sizeLimitSp.setRange(0, 0, 0);
            } else if (this.formViewObj != null && pickList.getType() == 0) {
                int min = Math.max(pickList.getNumItems(), 0);
                int max = AppPreferences.getRemote().getInt("PL_MAX_ITEMS", 500);
                Integer val = pickList.getSizeLimit();
                this.formViewObj.getValidator().setHasChanged(true);
                if (min > max) {
                    max = min;
                }
                if (val == null || val == -1 || val < min) {
                    val = min;
                }
                sizeLimitSp.setRange(min, max, val);
            }
        }
    }

    private void tableSelected(FormViewObj fvo) {
        ValComboBox formatterCBX = (ValComboBox)fvo.getControlByName("formatterCBX");
        ValComboBox tablesCBX = (ValComboBox)fvo.getControlByName("tablesCBX");
        ValComboBox fieldsCBX = (ValComboBox)fvo.getControlByName("fieldsCBX");
        fvo.getValidator().setHasChanged(true);
        tablesCBX.setChanged(true);
        String noneStr = UIRegistry.getResourceString("NONE");
        PickList pickList = (PickList)fvo.getDataObj();
        if (pickList == null) {
            return;
        }
        JComboBox tableCbx = tablesCBX.getComboBox();
        DBTableInfo tblInfo = (DBTableInfo)tableCbx.getSelectedItem();
        if (tblInfo != null) {
            if (tblInfo.getName().equals(noneStr)) {
                pickList.setTableName(null);
                pickList.setFieldName(null);
                pickList.setFormatter(null);
            } else {
                pickList.setTableName(tblInfo.getName());
                DefaultComboBoxModel fldModel = (DefaultComboBoxModel)fieldsCBX.getComboBox().getModel();
                fldModel.removeAllElements();
                for (DBFieldInfo fi : tblInfo.getFields()) {
                    if (fi.getDataClass() != String.class) continue;
                    fldModel.addElement(fi);
                }
                Vector<DataObjSwitchFormatter> list = new Vector<DataObjSwitchFormatter>();
                for (DataObjSwitchFormatter fmt : DataObjFieldFormatMgr.getInstance().getFormatters()) {
                    if (fmt.getDataClass() != tblInfo.getClassObj()) continue;
                    list.add(fmt);
                }
                DefaultComboBoxModel fmtModel = (DefaultComboBoxModel)formatterCBX.getComboBox().getModel();
                fmtModel.removeAllElements();
                if (list.size() > 0) {
                    Collections.sort(list);
                    for (DataObjSwitchFormatter fmt : list) {
                        fmtModel.addElement(fmt);
                    }
                    formatterCBX.setEnabled(true);
                } else {
                    formatterCBX.setEnabled(false);
                }
            }
        } else {
            fieldsCBX.setEnabled(false);
        }
    }

    private void fillTableNameCBX(ValComboBox tablesCBX) {
        if (tablesCBX.getComboBox().getModel().getSize() == 0) {
            DefaultComboBoxModel tblModel = (DefaultComboBoxModel)tablesCBX.getComboBox().getModel();
            String noneStr = UIRegistry.getResourceString("NONE");
            DBTableInfo none = new DBTableInfo(-1, PickList.class.getName(), "none", "", "");
            none.setTitle(noneStr);
            tblModel.addElement(none);
            for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                if (!DataModelObjBase.class.isAssignableFrom(ti.getClassObj()) || ti.getName().startsWith("sp") || ti.getName().startsWith("workbench") || ti.getName().startsWith("user") || ti.getName().startsWith("appres")) continue;
                tblModel.addElement(ti);
            }
        }
    }

    private int getIndexInModel(ValComboBox vcbx, String value) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)vcbx.getComboBox().getModel();
        int i = 0;
        while (i < model.getSize()) {
            DataObjSwitchFormatter fmt;
            DBFieldInfo fi;
            DBTableInfo ti;
            Object obj = model.getElementAt(i);
            if (obj instanceof DBTableInfo ? (ti = (DBTableInfo)obj).getName().equals(value) : (obj instanceof DBFieldInfo ? (fi = (DBFieldInfo)obj).getName().equals(value) : (obj instanceof DataObjSwitchFormatter ? (fmt = (DataObjSwitchFormatter)obj).getName().equals(value) : obj.toString().equals(value)))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void typeSelected(FormViewObj fvo) {
        fvo.getValidator().setHasChanged(true);
        ValComboBox formatterCBX = (ValComboBox)fvo.getControlByName("formatterCBX");
        ValComboBox tablesCBX = (ValComboBox)fvo.getControlByName("tablesCBX");
        ValComboBox fieldsCBX = (ValComboBox)fvo.getControlByName("fieldsCBX");
        ValComboBox typesCBX = (ValComboBox)fvo.getControlByName("typesCBX");
        ValSpinner sizeLimitSp = (ValSpinner)fvo.getControlByName("sizeLimit");
        ValCheckBox readOnlyChk = (ValCheckBox)fvo.getControlByName("readOnly");
        MultiView pickListItemsMV = (MultiView)fvo.getControlByName("pickListItems");
        typesCBX.setChanged(true);
        FormDataObjIFace dataObj = (FormDataObjIFace)fvo.getDataObj();
        boolean isEditing = dataObj != null && dataObj.getId() != null;
        PickListIFace pickList = (PickListIFace)fvo.getDataObj();
        boolean fullEditIsOK = !isEditing || !pickList.isSystem();
        int typeIndex = typesCBX.getComboBox().getSelectedIndex();
        switch (typeIndex) {
            case 0: {
                tablesCBX.setEnabled(false);
                fieldsCBX.setEnabled(false);
                formatterCBX.setEnabled(false);
                sizeLimitSp.setEnabled(true);
                pickListItemsMV.setVisible(true);
                readOnlyChk.setEnabled(true);
                Object val = sizeLimitSp.getValue();
                if (val == null || !(val instanceof Integer) || (Integer)val != -1) break;
                sizeLimitSp.setValue(50);
                break;
            }
            case 1: {
                tablesCBX.setEnabled(fullEditIsOK);
                fieldsCBX.setEnabled(false);
                formatterCBX.setEnabled(true);
                pickListItemsMV.setVisible(false);
                readOnlyChk.setEnabled(false);
                sizeLimitSp.setEnabled(false);
                sizeLimitSp.setValue(-1);
                fieldsCBX.getComboBox().setSelectedIndex(-1);
                break;
            }
            case 2: {
                tablesCBX.setEnabled(true);
                fieldsCBX.setEnabled(true);
                formatterCBX.setEnabled(true);
                pickListItemsMV.setVisible(false);
                readOnlyChk.setEnabled(false);
                sizeLimitSp.setEnabled(false);
                fieldsCBX.getComboBox().setSelectedIndex(-1);
                break;
            }
        }
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        PickList pickList = (PickList)dataObj;
        if (pickList != null) {
            ValComboBox typesCBX = (ValComboBox)this.formViewObj.getControlByName("typesCBX");
            ValComboBox tablesCBX = (ValComboBox)this.formViewObj.getControlByName("tablesCBX");
            ValComboBox formatterCBX = (ValComboBox)this.formViewObj.getControlByName("formatterCBX");
            ValComboBox fieldsCBX = (ValComboBox)this.formViewObj.getControlByName("fieldsCBX");
            ValSpinner sizeLimitSp = (ValSpinner)this.formViewObj.getControlByName("sizeLimit");
            int fieldsSelectedIndex = -1;
            int fmtsSelectedIndex = -1;
            byte typeIndex = pickList.getType();
            if (typesCBX != null && typesCBX.getComboBox() != null) {
                String tableName;
                if (typesCBX.getComboBox().getModel().getSize() > 0) {
                    typesCBX.getComboBox().setSelectedIndex(typeIndex);
                }
                if (StringUtils.isNotEmpty((String)(tableName = pickList.getTableName()))) {
                    String formatter;
                    tablesCBX.getComboBox().setSelectedIndex(this.getIndexInModel(tablesCBX, tableName));
                    String fieldName = pickList.getFieldName();
                    if (StringUtils.isNotEmpty((String)fieldName)) {
                        fieldsSelectedIndex = this.getIndexInModel(fieldsCBX, fieldName);
                    }
                    if (StringUtils.isNotEmpty((String)(formatter = pickList.getFormatter()))) {
                        fmtsSelectedIndex = this.getIndexInModel(formatterCBX, formatter);
                    }
                }
                if (pickList.getSizeLimit() == -1) {
                    sizeLimitSp.setEnabled(false);
                    sizeLimitSp.setValue(sizeLimitSp.getMinValue());
                } else {
                    boolean plWithItems = typeIndex == 0;
                    sizeLimitSp.setEnabled(plWithItems);
                    if (plWithItems) {
                        this.adjustSizeSpinner();
                    }
                }
                PickListBusRules.typeSelected(this.formViewObj);
                typesCBX.setEnabled(pickList.getIsSystem() == false);
            }
            fieldsCBX.getComboBox().setSelectedIndex(fieldsSelectedIndex);
            formatterCBX.getComboBox().setSelectedIndex(fmtsSelectedIndex);
        }
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        PickList pl = (PickList)dataObj;
        ValComboBox typesCBX = (ValComboBox)this.formViewObj.getControlByName("typesCBX");
        ValComboBox formatterCBX = (ValComboBox)this.formViewObj.getControlByName("formatterCBX");
        ValComboBox tablesCBX = (ValComboBox)this.formViewObj.getControlByName("tablesCBX");
        ValComboBox fieldsCBX = (ValComboBox)this.formViewObj.getControlByName("fieldsCBX");
        ValSpinner sizeLimitSp = (ValSpinner)this.formViewObj.getControlByName("sizeLimit");
        Integer val = (Integer)sizeLimitSp.getValue();
        pl.setSizeLimit(val);
        int index = typesCBX.getComboBox().getSelectedIndex();
        pl.setType((byte)index);
        DBTableInfo ti = (DBTableInfo)tablesCBX.getValue();
        DBFieldInfo fi = (DBFieldInfo)fieldsCBX.getValue();
        DataObjSwitchFormatter dofw = (DataObjSwitchFormatter)formatterCBX.getValue();
        pl.setTableName(ti != null ? ti.getName() : null);
        pl.setFieldName(fi != null ? fi.getName() : null);
        pl.setFormatter(dofw != null ? dofw.getName() : null);
        super.beforeSave(dataObj, session);
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        return ((PickList)dataObj).getIsSystem();
    }

    @Override
    public void okToDelete(Object dataObj, DataProviderSessionIFace session, BusinessRulesOkDeleteIFace deletable) {
        this.reasonList.clear();
        PickList pickList = (PickList)dataObj;
        if (!pickList.getIsSystem().booleanValue()) {
            String searchText = "picklist=\"" + pickList.getName() + "\"";
            for (SpAppResourceDir appDir : ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getSpAppResourceList()) {
                for (SpViewSetObj viewSet : appDir.getSpViewSets()) {
                    String xml = viewSet.getDataAsString();
                    if (!StringUtils.contains((String)xml, (String)searchText)) continue;
                    if (deletable != null) {
                        deletable.doDeleteDataObj(dataObj, session, false);
                    }
                    return;
                }
            }
            super.okToDelete(dataObj, session, deletable);
        }
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        PickList pickList = (PickList)dataObj;
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            this.reasonList.clear();
            String sql = QueryAdjusterForDomain.getInstance().adjustSQL("FROM PickList WHERE name = '" + pickList.getName() + "' AND collectionId = COLLID");
            PickList dbPL = (PickList)session.getData(sql);
            if (!(dbPL == null || pickList.getId() != null && dbPL.getId().equals(pickList.getId()))) {
                this.reasonList.add(UIRegistry.getLocalizedMessage("PL_DUPLICATE_NAME", pickList.getName()));
                BusinessRulesIFace.STATUS sTATUS = BusinessRulesIFace.STATUS.Error;
                return sTATUS;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PickListBusRules.class, ex);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return super.processBusinessRules(dataObj);
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        PickListIFace rs = (PickListIFace)dataObj;
        if (rs.getType() == 0) {
            this.adjustSizeSpinner();
        }
        return super.afterSaveCommit(dataObj, session);
    }
}

