/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.LoanReturnPreparation;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LoanReturnPreparationBusRules
extends BaseBusRules {
    private boolean isFillingForm = false;
    private FormViewObj loanPrepFVO = null;
    private FormViewObj loanFVO = null;
    private LoanReturnPreparation prevLoanRetPrep = null;

    public LoanReturnPreparationBusRules() {
        super(LoanReturnPreparation.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        if (this.formViewObj != null && this.formViewObj.getRsController() != null) {
            this.formViewObj.setSkippingAttach(true);
            this.loanPrepFVO = this.formViewObj.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
            this.loanFVO = this.loanPrepFVO.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
            Component comp = this.formViewObj.getControlByName("quantityReturned");
            if (comp instanceof ValSpinner) {
                ValSpinner quantityReturned = (ValSpinner)comp;
                ValSpinner quantityResolved = (ValSpinner)this.formViewObj.getControlByName("quantityResolved");
                ChangeListener cl = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (!LoanReturnPreparationBusRules.this.isFillingForm) {
                            LoanReturnPreparationBusRules.this.updateLoanPrepQuantities(null, e);
                        }
                    }
                };
                quantityReturned.addChangeListener(cl);
                quantityResolved.addChangeListener(cl);
            }
        }
    }

    public static int getInt(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    @Override
    public void beforeFormFill() {
        this.isFillingForm = true;
        if (this.prevLoanRetPrep != null) {
            this.updateLoanPrepQuantities(this.prevLoanRetPrep, null);
            this.prevLoanRetPrep = null;
        }
    }

    @Override
    public Object beforeDelete(Object dataObj, DataProviderSessionIFace session) {
        this.updateLoanPrepQuantities(null, null);
        return super.beforeDelete(dataObj, session);
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (dataObj != null && this.formViewObj != null && this.formViewObj.getMVParent() != null && this.formViewObj.getMVParent().getMultiViewParent() != null) {
            this.loanPrepFVO = this.formViewObj.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
            this.loanFVO = this.loanPrepFVO.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
            LoanReturnPreparation loanRetPrep = (LoanReturnPreparation)dataObj;
            LoanPreparation loanPrep = (LoanPreparation)this.loanPrepFVO.getDataObj();
            this.prevLoanRetPrep = loanRetPrep;
            Component comp = this.formViewObj.getControlByName("quantityReturned");
            if (comp instanceof ValSpinner && loanPrep != null && loanPrep.getLoanPreparationId() != null) {
                int qQnt = LoanReturnPreparationBusRules.getInt(loanPrep.getQuantity());
                int qQntRes = LoanReturnPreparationBusRules.getInt(loanPrep.getQuantityResolved());
                int qQntRet = LoanReturnPreparationBusRules.getInt(loanPrep.getQuantityReturned());
                int qtyToBeReturned = Math.max(0, qQnt - qQntRet);
                int qtyToBeResolved = Math.max(0, qQnt - qQntRes);
                int qtyRetLPR = LoanReturnPreparationBusRules.getInt(loanRetPrep.getQuantityReturned());
                int qtyResLPR = LoanReturnPreparationBusRules.getInt(loanRetPrep.getQuantityResolved());
                JButton newBtn = this.formViewObj.getRsController().getNewRecBtn();
                newBtn.setEnabled(qtyToBeReturned > 0);
                ValSpinner quantityReturned = (ValSpinner)comp;
                quantityReturned.setRange(0, qtyRetLPR + qtyToBeReturned, qtyRetLPR);
                ValSpinner quantityResolved = (ValSpinner)this.formViewObj.getControlByName("quantityResolved");
                quantityResolved.setRange(0, qtyResLPR + qtyToBeResolved, qtyResLPR);
            }
        }
        this.isFillingForm = false;
    }

    protected void updateLoanPrepQuantities(LoanReturnPreparation loanRetPrepArg, ChangeEvent e) {
        if (this.formViewObj != null && this.formViewObj.getValidator() != null) {
            if (this.formViewObj.getValidator().hasChanged()) {
                this.loanPrepFVO = this.formViewObj.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
                this.loanFVO = this.loanPrepFVO.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj();
                Component comp = this.formViewObj.getControlByName("quantityResolved");
                if (comp instanceof ValSpinner) {
                    LoanPreparation lrpLoanPrep;
                    LoanReturnPreparation loanRetPrep = loanRetPrepArg != null ? loanRetPrepArg : (LoanReturnPreparation)this.formViewObj.getDataObj();
                    LoanPreparation loanPrep = (LoanPreparation)this.loanPrepFVO.getDataObj();
                    Loan loan = (Loan)this.loanFVO.getDataObj();
                    if (loanRetPrep != null) {
                        final ValSpinner lrpResolvedVS = (ValSpinner)comp;
                        int lrpResolvedQty = (Integer)lrpResolvedVS.getValue();
                        final ValSpinner lrpReturnedVS = (ValSpinner)this.formViewObj.getControlByName("quantityReturned");
                        int lrpReturnedQty = (Integer)lrpReturnedVS.getValue();
                        if (e != null) {
                            int qty;
                            if (e.getSource() == lrpResolvedVS) {
                                if (lrpResolvedQty < lrpReturnedQty) {
                                    qty = lrpReturnedQty = lrpResolvedQty;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            lrpReturnedVS.setValue(qty);
                                        }
                                    });
                                }
                            } else if (e.getSource() == lrpReturnedVS && lrpReturnedQty > lrpResolvedQty) {
                                lrpResolvedQty = lrpReturnedQty;
                                qty = lrpReturnedQty;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        lrpResolvedVS.setValue(qty);
                                    }
                                });
                            }
                        }
                        loanRetPrep.setQuantityResolved(lrpResolvedQty);
                        loanRetPrep.setQuantityReturned(lrpReturnedQty);
                    }
                    int qtyRes = 0;
                    int qtyRet = 0;
                    int i = 0;
                    if (loanRetPrep != null && (lrpLoanPrep = loanRetPrep.getLoanPreparation()) != null && lrpLoanPrep.getLoanReturnPreparations().size() > 0) {
                        for (LoanReturnPreparation lrp : loanRetPrep.getLoanPreparation().getLoanReturnPreparations()) {
                            qtyRes += LoanReturnPreparationBusRules.getInt(lrp.getQuantityResolved());
                            qtyRet += LoanReturnPreparationBusRules.getInt(lrp.getQuantityReturned());
                            ++i;
                        }
                    }
                    ValCheckBox isResolved = (ValCheckBox)this.loanPrepFVO.getControlByName("isResolved");
                    if (qtyRes == loanPrep.getQuantity() != isResolved.isSelected()) {
                        isResolved.doClick();
                    }
                    if ((comp = this.loanPrepFVO.getControlByName("quantityResolved")) instanceof JTextField) {
                        JTextField qtyReturnedVS = (JTextField)this.loanPrepFVO.getControlByName("quantityReturned");
                        JTextField qtyResolvedVS = (JTextField)comp;
                        qtyReturnedVS.setText(Integer.toString(qtyRet));
                        qtyResolvedVS.setText(Integer.toString(qtyRes));
                        loanPrep.setQuantityReturned(qtyRet);
                        loanPrep.setQuantityResolved(qtyRes);
                    }
                    int qQnt = 0;
                    int qQntRes = 0;
                    for (LoanPreparation lp : loan.getLoanPreparations()) {
                        qQnt += LoanReturnPreparationBusRules.getInt(lp.getQuantity());
                        qQntRes += LoanReturnPreparationBusRules.getInt(lp.getQuantityResolved());
                    }
                    isResolved = (ValCheckBox)this.loanPrepFVO.getControlByName("isResolved");
                    isResolved.setSelected(qQnt == qQntRes);
                    qQnt = 0;
                    qtyRes = 0;
                    for (LoanPreparation lp : loan.getLoanPreparations()) {
                        qQnt += LoanReturnPreparationBusRules.getInt(lp.getQuantity());
                        qtyRes += LoanReturnPreparationBusRules.getInt(lp.getQuantityResolved());
                    }
                    isResolved = (ValCheckBox)this.loanFVO.getControlByName("isClosed");
                    isResolved.setSelected(qQnt == qQntRes);
                    loan.setIsClosed(qQnt == qQntRes);
                }
            }
        } else {
            UIRegistry.showError("The formViewObj or or the formViewObj's validator was null and shouldn't been!");
        }
    }

    @Override
    public void aboutToShutdown() {
        this.updateLoanPrepQuantities(null, null);
        super.aboutToShutdown();
    }
}

