/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.SubViewBtn;
import edu.ku.brc.af.ui.forms.TableViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.LoanReturnPreparation;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Triple;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class LoanPreparationBusRules
extends BaseBusRules
implements CommandListener {
    private static final Logger log = Logger.getLogger(LoanPreparationBusRules.class);
    private final String LOAN_QTY_RANGE_ERR = "LOAN_QTY_RANGE_ERR";
    private boolean isFillingForm = false;
    private SubViewBtn loanRetBtn = null;

    public LoanPreparationBusRules() {
        super(LoanPreparation.class);
        CommandDispatcher.register("Interactions", this);
        CommandDispatcher.register("Data_Entry", this);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        TableViewObj tvo;
        JButton newBtn;
        super.initialize(viewableArg);
        if (this.formViewObj != null) {
            Component comp;
            JButton newBtn2;
            this.formViewObj.setSkippingAttach(true);
            if (this.formViewObj.getRsController() != null && (newBtn2 = this.formViewObj.getRsController().getNewRecBtn()) != null) {
                ActionListener[] actionListenerArray = newBtn2.getActionListeners();
                int n = actionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionListener al = actionListenerArray[n2];
                    newBtn2.removeActionListener(al);
                    ++n2;
                }
                newBtn2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MultiView loanMV = null;
                        if (LoanPreparationBusRules.this.viewable instanceof FormViewObj) {
                            loanMV = LoanPreparationBusRules.this.formViewObj.getMVParent().getMultiViewParent();
                            LoanPreparationBusRules.this.formViewObj.getDataFromUI();
                        } else if (LoanPreparationBusRules.this.viewable instanceof TableViewObj) {
                            TableViewObj tblViewObj = (TableViewObj)LoanPreparationBusRules.this.viewable;
                            loanMV = tblViewObj.getMVParent().getMultiViewParent();
                        }
                        if (loanMV != null) {
                            LoanPreparationBusRules.this.formViewObj.getDataFromUI();
                            CommandDispatcher.dispatch(new CommandAction("Interactions", "AddToLoan", loanMV.getCurrentViewAsFormViewObj().getCurrentDataObj()));
                        }
                    }
                });
            }
            if ((comp = this.formViewObj.getControlByName("quantityResolved")) instanceof ValSpinner) {
                final JTextField quantityResolved = (JTextField)this.formViewObj.getControlByName("quantityReturned");
                final ValSpinner quantity = (ValSpinner)this.formViewObj.getControlByName("quantity");
                final ValSpinner qtyResolved = (ValSpinner)comp;
                final ValCheckBox isResolved = (ValCheckBox)this.formViewObj.getControlByName("isResolved");
                ChangeListener cl = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (!UIValidator.isIgnoreAllValidation()) {
                            if (LoanPreparationBusRules.this.formViewObj != null) {
                                LoanPreparation loanPrep = (LoanPreparation)LoanPreparationBusRules.this.formViewObj.getDataObj();
                                Integer qty = quantity.getIntValue();
                                if (qty != null && qty >= quantity.getMinValue() && qty <= quantity.getMaxValue()) {
                                    loanPrep.setQuantity(qty);
                                } else {
                                    UIRegistry.showLocalizedError("LOAN_QTY_RANGE_ERR", qty, quantity.getMinValue(), quantity.getMaxValue());
                                }
                            }
                            if (!LoanPreparationBusRules.this.isFillingForm) {
                                Integer qtyResVal = Integer.parseInt(quantityResolved.getText());
                                if (qtyResVal != null && qtyResVal >= quantity.getMinValue() && qtyResVal <= quantity.getMaxValue()) {
                                    LoanPreparationBusRules.this.quantitiesChanged(quantity, qtyResVal, qtyResolved, isResolved);
                                } else {
                                    UIRegistry.showLocalizedError("LOAN_QTY_RANGE_ERR", qtyResVal, quantity.getMinValue(), quantity.getMaxValue());
                                }
                            }
                        }
                    }
                };
                quantity.addChangeListener(cl);
                qtyResolved.addChangeListener(cl);
            }
            if ((comp = this.formViewObj.getControlById("loanReturnPreparations")) instanceof SubViewBtn) {
                this.loanRetBtn = (SubViewBtn)comp;
                this.loanRetBtn.getBtn().setIcon(null);
                this.loanRetBtn.getBtn().setText(UIRegistry.getResourceString("LOAN_RET_PREP"));
                this.loanRetBtn.getBtn().setEnabled(this.formViewObj.isEditing());
            }
        } else if (viewableArg instanceof TableViewObj && (newBtn = (tvo = (TableViewObj)viewableArg).getNewButton()) != null) {
            ActionListener[] actionListenerArray = newBtn.getActionListeners();
            int n = actionListenerArray.length;
            int n3 = 0;
            while (n3 < n) {
                ActionListener al = actionListenerArray[n3];
                newBtn.removeActionListener(al);
                ++n3;
            }
            newBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultiView loanMV = tvo.getMVParent().getMultiViewParent();
                    if (loanMV != null) {
                        CommandDispatcher.dispatch(new CommandAction("Interactions", "AddToLoan", loanMV.getCurrentViewAsFormViewObj().getCurrentDataObj()));
                    }
                }
            });
        }
    }

    private int getInt(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    @Override
    public void beforeFormFill() {
        this.isFillingForm = true;
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (dataObj != null && this.formViewObj != null) {
            LoanPreparation loanPrep = (LoanPreparation)dataObj;
            Preparation prep = loanPrep.getPreparation();
            if (this.loanRetBtn != null) {
                this.loanRetBtn.setEnabled(loanPrep.getId() != null && loanPrep.getIsResolved() == false);
            }
            Component comp = this.formViewObj.getControlByName("quantityResolved");
            Component qtyComp = this.formViewObj.getControlByName("quantity");
            if (comp instanceof JTextField && qtyComp instanceof ValSpinner && prep != null && prep.getPreparationId() != null) {
                int availableQnt;
                ValSpinner quantity = (ValSpinner)qtyComp;
                JTextField qtyResolved = (JTextField)comp;
                JTextField qtyReturned = (JTextField)this.formViewObj.getControlByName("quantityReturned");
                String sql = "SELECT gf.Quantity FROM  giftpreparation AS gf INNER JOIN giftpreparation AS gfp ON gfp.GiftPreparationID = gf.GiftPreparationID INNER JOIN preparation AS p ON gf.PreparationID = p.PreparationID WHERE p.PreparationID = " + prep.getPreparationId();
                int qGiftQnt = 0;
                Vector<Object[]> rows = BasicSQLUtils.query(sql);
                for (Object[] cols : rows) {
                    qGiftQnt += this.getInt(cols[0]);
                }
                int qQnt = 0;
                int qQntRes = 0;
                int qQntRet = 0;
                int qPrepCnt = 0;
                Integer pCnt = BasicSQLUtils.getCount("SELECT CountAmt FROM preparation WHERE PreparationID = " + prep.getPreparationId());
                int n = qPrepCnt = pCnt != null ? pCnt : 0;
                if (loanPrep.getId() != null) {
                    sql = "SELECT lp.Quantity, lp.QuantityResolved, lrp.QuantityReturned FROM  loanpreparation AS lp LEFT JOIN loanreturnpreparation AS lrp ON lrp.LoanPreparationID = lp.LoanPreparationID INNER JOIN preparation AS p ON lp.PreparationID = p.PreparationID WHERE p.PreparationID = " + prep.getPreparationId();
                    rows = BasicSQLUtils.query(sql);
                    for (Object[] cols : rows) {
                        qQnt += this.getInt(cols[0]);
                        qQntRes += this.getInt(cols[1]);
                        qQntRet += this.getInt(cols[2]);
                    }
                }
                if ((availableQnt = Math.max(0, qPrepCnt - (qQnt - qQntRes) - qGiftQnt)) == 0) {
                    quantity.setRange(0, loanPrep.getQuantity(), loanPrep.getQuantity());
                    quantity.setEnabled(false);
                } else {
                    quantity.setRange(0, loanPrep.getQuantity() + availableQnt, loanPrep.getQuantity());
                    quantity.setEnabled(true);
                }
                qtyResolved.setText(Integer.toString(loanPrep.getQuantityResolved()));
                qtyReturned.setText(Integer.toString(loanPrep.getQuantityReturned()));
            }
        }
        this.isFillingForm = false;
    }

    private void quantitiesChanged(ValSpinner quantity, int quantityReturned, ValSpinner qtyResolved, final ValCheckBox resolvedChkBx) {
        int qty = (Integer)quantity.getValue();
        int qtyRes = (Integer)qtyResolved.getValue();
        quantity.setState(UIValidatable.ErrorType.Valid);
        qtyResolved.setState(UIValidatable.ErrorType.Valid);
        qtyResolved.setState(qtyRes > qty || qtyRes > qty ? UIValidatable.ErrorType.Error : UIValidatable.ErrorType.Valid);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoanPreparationBusRules.this.formViewObj.getValidator().wasValidated(null);
                LoanPreparationBusRules.this.formViewObj.getMVParent().getMultiViewParent().getCurrentValidator().setHasChanged(true);
                LoanPreparationBusRules.this.formViewObj.getMVParent().getMultiViewParent().getCurrentValidator().wasValidated(null);
            }
        });
        final Boolean allRet = qty == qtyRes;
        LoanPreparation loanPrep = (LoanPreparation)this.formViewObj.getDataObj();
        Loan loan = loanPrep.getLoan();
        loanPrep.setIsResolved(allRet);
        boolean allPrepsReturned = true;
        if (allRet.booleanValue()) {
            for (LoanPreparation lp : loan.getLoanPreparations()) {
                if (lp.getIsResolved().booleanValue()) continue;
                allPrepsReturned = false;
                break;
            }
        } else {
            allPrepsReturned = false;
        }
        final boolean allRetP = allPrepsReturned;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                resolvedChkBx.setSelected(allRet);
                Component comp = (Component)LoanPreparationBusRules.this.formViewObj.getMVParent().getMultiViewParent().getCurrentViewAsFormViewObj().getCompById("2");
                if (comp instanceof ValCheckBox) {
                    ValCheckBox chk = (ValCheckBox)comp;
                    chk.setSelected(allRetP);
                    chk.repaint();
                }
            }
        });
    }

    protected LoanReturnPreparation getNewLRP(LoanPreparation lp) {
        for (LoanReturnPreparation lrp : lp.getLoanReturnPreparations()) {
            if (lrp.getId() != null) continue;
            return lrp;
        }
        return null;
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        CommandDispatcher.unregister("Interactions", this);
        CommandDispatcher.unregister("Data_Entry", this);
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType("Interactions") && cmdAction.isAction("REFRESH_LOAN_PREPS")) {
            if (this.formViewObj != null) {
                MultiView loanMV = this.formViewObj.getMVParent().getMultiViewParent();
                if (loanMV != null && this.formViewObj.getValidator() != null) {
                    Loan loan = (Loan)loanMV.getData();
                    this.formViewObj.setDataObj(loan.getLoanPreparations());
                    this.formViewObj.getValidator().setHasChanged(true);
                    this.formViewObj.getValidator().validateRoot();
                }
            } else if (this.viewable instanceof TableViewObj) {
                TableViewObj tvo = (TableViewObj)this.viewable;
                MultiView loanMV = tvo.getMVParent().getMultiViewParent();
                if (loanMV != null && loanMV.getCurrentValidator() != null) {
                    loanMV.getCurrentValidator().setHasChanged(true);
                    loanMV.getCurrentValidator().validateRoot();
                } else {
                    log.error((Object)"The Loan's Multiview should not be null!");
                }
                tvo.refreshDataList();
            }
        } else if (cmdAction.isType("Data_Entry") && cmdAction.isAction("CLOSE_SUBVIEW")) {
            Triple dataTriple = (Triple)cmdAction.getData();
            if (dataTriple.first == this.formViewObj && dataTriple.second instanceof LoanPreparation && this.viewable.getValidator() != null) {
                LoanPreparation loanPrep = (LoanPreparation)dataTriple.second;
                Set lrps = (Set)dataTriple.third;
                if (loanPrep != null && lrps != null) {
                    Component comp;
                    int quantityResolved = 0;
                    int quantityReturned = 0;
                    for (LoanReturnPreparation lrp : lrps) {
                        quantityResolved += lrp.getQuantityResolved().intValue();
                        quantityReturned += lrp.getQuantityReturned().intValue();
                    }
                    loanPrep.setQuantityResolved(quantityResolved);
                    loanPrep.setQuantityReturned(quantityReturned);
                    if (this.formViewObj != null && (comp = this.formViewObj.getControlByName("quantityResolved")) instanceof JTextField) {
                        ((JTextField)comp).setText(Integer.toString(quantityResolved));
                    }
                } else {
                    log.error((Object)"The loanPrep or lrps should not be null!");
                }
            }
        }
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        LoanPreparation loanPrep = (LoanPreparation)dataObj;
        if (loanPrep.getQuantityResolved() > loanPrep.getQuantity()) {
            this.reasonList.add(UIRegistry.getResourceString("LOAN_RET_LWR_QNT"));
            return BusinessRulesIFace.STATUS.Error;
        }
        return super.processBusinessRules(dataObj);
    }
}

