/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Shipment;

public class LoanGiftShipmentBusRules
extends BaseBusRules {
    public static final String SHIPMETHOD = "loans.shipmeth";
    public static final String SHIPPEDBY = "loans.shippedby";

    public LoanGiftShipmentBusRules() {
        super(Shipment.class);
    }

    @Override
    public void beforeFormFill() {
        Shipment shipment = (Shipment)this.formViewObj.getDataObj();
        if (this.formViewObj != null && shipment != null && shipment.getId() == null) {
            AppPreferences prefs = AppPreferences.getRemote();
            shipment.setShipmentMethod(prefs.get(SHIPMETHOD, null));
            Integer shippedByAgentId = prefs.getInt(SHIPPEDBY, null);
            if (shippedByAgentId != null) {
                DataProviderSessionIFace session = this.formViewObj.getSession();
                try {
                    try {
                        if (session == null) {
                            session = DataProviderFactory.getInstance().createSession();
                        }
                        Agent shippingAgent = session.get(Agent.class, shippedByAgentId);
                        shipment.setShippedBy(shippingAgent);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (session != null && this.formViewObj.getSession() == null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (session != null && this.formViewObj.getSession() == null) {
                        session.close();
                    }
                }
            }
        }
    }

    @Override
    public void afterFillForm(Object dataObj) {
        if (this.viewable instanceof FormViewObj && this.formViewObj.getDataObj() instanceof Shipment) {
            MultiView multiView = this.formViewObj.getMVParent().getMultiViewParent();
        }
    }
}

