/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldSingle;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class LoanBusRules
extends AttachmentOwnerBaseBusRules {
    public static final String CMDTYPE = "Interactions";
    public static final String DE_CMDS = "Data_Entry";
    public static final String ADD_TO_LOAN = "AddToLoan";
    public static final String NEW_LOAN = "NEW_LOAN";
    public static final String DUEINMONTHS = "loans.dueinmons";
    protected boolean doCreateLoanNoPreps = false;

    public LoanBusRules() {
        super(Loan.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        Component closedComp;
        super.initialize(viewableArg);
        this.formViewObj.setSkippingAttach(true);
        if (this.isEditMode() && (closedComp = this.formViewObj.getControlByName("isClosed")) instanceof JCheckBox) {
            ((JCheckBox)closedComp).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValFormattedTextFieldSingle loanDateComp;
                    Component dateComp;
                    if (((JCheckBox)e.getSource()).isSelected() && (dateComp = LoanBusRules.this.formViewObj.getControlByName("dateClosed")) != null && dateComp instanceof ValFormattedTextFieldSingle && StringUtils.isEmpty((String)(loanDateComp = (ValFormattedTextFieldSingle)dateComp).getText())) {
                        DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
                        loanDateComp.setText(scrDateFormat.format(Calendar.getInstance()));
                    }
                }
            });
        }
    }

    public void setDoCreateLoanNoPreps(boolean doCreateLoanNoPreps) {
        Component loanPreparations;
        this.doCreateLoanNoPreps = doCreateLoanNoPreps;
        if (doCreateLoanNoPreps && (loanPreparations = this.formViewObj.getControlByName("loanPreparations")) != null) {
            loanPreparations.setVisible(false);
        }
    }

    @Override
    public boolean canCreateNewDataObject() {
        return true;
    }

    @Override
    public void createNewObj(boolean doSetIntoAndValidateArg, Object oldDataObj) {
        CommandAction cmdAction = new CommandAction(CMDTYPE, this.doCreateLoanNoPreps ? "LN_NO_PRP" : NEW_LOAN, this.viewable);
        CommandDispatcher.dispatch(cmdAction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beforeFormFill() {
        Loan loan = (Loan)this.formViewObj.getDataObj();
        if (this.formViewObj == null || loan == null) return;
        if (loan.getId() != null) {
            DataProviderSessionIFace session = this.formViewObj.getSession();
            try {
                try {
                    if (session == null) {
                        session = DataProviderFactory.getInstance().createSession();
                    }
                    session.attach(loan);
                    loan.forceLoad();
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (session == null || this.formViewObj.getSession() != null) return;
                    session.close();
                }
                return;
            }
            finally {
                if (session != null && this.formViewObj.getSession() == null) {
                    session.close();
                }
            }
        } else {
            Integer dueInMonths = AppPreferences.getRemote().getInt(DUEINMONTHS, 6);
            if (dueInMonths == null) return;
            Calendar date = Calendar.getInstance();
            date.add(2, dueInMonths);
            loan.setCurrentDueDate(date);
        }
    }

    @Override
    public void afterFillForm(Object dataObj) {
        if (this.formViewObj != null && this.formViewObj.getDataObj() instanceof Loan) {
            this.formViewObj.setSkippingAttach(true);
            MultiView mvParent = this.formViewObj.getMVParent();
            Loan loan = (Loan)this.formViewObj.getDataObj();
            boolean isNewObj = loan.getId() == null;
            boolean isEdit = mvParent.isEditable();
            Component comp = this.formViewObj.getControlByName("generateInvoice");
            if (comp instanceof JCheckBox) {
                ((JCheckBox)comp).setVisible(isEdit);
            }
            boolean allResolved = true;
            for (LoanPreparation loanPrep : loan.getLoanPreparations()) {
                Boolean isResolved = loanPrep.getIsResolved();
                if (isResolved != null && (isResolved == null || isResolved.booleanValue())) continue;
                allResolved = false;
                break;
            }
            comp = this.formViewObj.getControlByName("ReturnLoan");
            if (comp instanceof JButton) {
                comp.setVisible(isEdit);
                Boolean isClosed = loan.getIsClosed();
                comp.setEnabled(!isNewObj && isClosed != null && loan.getIsClosed() == false && !allResolved);
                if (allResolved) {
                    ((JButton)comp).setText(UIRegistry.getResourceString("LOAN_ALL_PREPS_RETURNED"));
                }
            }
            if (isNewObj) {
                Component shipComp = this.formViewObj.getControlByName("shipmentNumber");
                comp = this.formViewObj.getControlByName("loanNumber");
                if (comp instanceof JTextField && shipComp instanceof JTextField) {
                    JTextField loanTxt = (JTextField)comp;
                    if (shipComp instanceof GetSetValueIFace) {
                        GetSetValueIFace gsv = (GetSetValueIFace)((Object)shipComp);
                        gsv.setValue(loanTxt.getText(), loanTxt.getText());
                    } else if (shipComp instanceof JTextField) {
                        ((JTextField)shipComp).setText(loanTxt.getText());
                    }
                    if (shipComp instanceof UIValidatable) {
                        UIValidatable uiv = (UIValidatable)((Object)shipComp);
                        uiv.setChanged(true);
                    }
                }
            }
        }
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        return true;
    }

    @Override
    public void beforeMerge(Object dataObj, DataProviderSessionIFace session) {
        super.beforeMerge(dataObj, session);
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        this.reasonList.clear();
        if (dataObj == null || !(dataObj instanceof Loan)) {
            return BusinessRulesIFace.STATUS.Error;
        }
        Loan loan = (Loan)dataObj;
        if (loan.getId() == null) {
            BusinessRulesIFace.STATUS duplicateNumberStatus = this.isCheckDuplicateNumberOK("loanNumber", (FormDataObjIFace)dataObj, Loan.class, "loanId");
            return duplicateNumberStatus;
        }
        return BusinessRulesIFace.STATUS.OK;
    }

    @Override
    public String getDeleteMsg(Object dataObj) {
        if (dataObj instanceof Accession) {
            return UIRegistry.getLocalizedMessage("LOAN_DELETED", ((Loan)dataObj).getLoanNumber());
        }
        return super.getDeleteMsg(dataObj);
    }

    @Override
    public void setObjectIdentity(Object dataObj, DraggableRecordIdentifier draggableIcon) {
        if (dataObj == null) {
            draggableIcon.setLabel("");
        }
        if (dataObj instanceof Loan) {
            Loan loan = (Loan)dataObj;
            draggableIcon.setLabel(loan.getLoanNumber());
            Object data = draggableIcon.getData();
            if (data == null) {
                RecordSet rs = new RecordSet();
                rs.initialize();
                rs.addItem(loan.getLoanId());
                data = rs;
                draggableIcon.setData(data);
            } else if (data instanceof RecordSetIFace) {
                RecordSetIFace rs = (RecordSetIFace)data;
                rs.clearItems();
                rs.addItem(loan.getLoanId());
            }
        }
    }
}

