/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.busrules.BaseTreeBusRules;
import edu.ku.brc.specify.tasks.TreeTaskMgr;

public class LithoStratBusRules
extends BaseTreeBusRules<LithoStrat, LithoStratTreeDef, LithoStratTreeDefItem> {
    public LithoStratBusRules() {
        super(LithoStrat.class, LithoStratTreeDefItem.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        TreeTaskMgr.checkLocks();
    }

    @Override
    public String[] getRelatedTableAndColumnNames() {
        String[] relationships = new String[]{"paleocontext", "LithoStratID", "lithostrat", "AcceptedID"};
        return relationships;
    }

    @Override
    public boolean okToEnableDelete(Object dataObj) {
        this.reasonList.clear();
        if (dataObj instanceof LithoStrat) {
            return super.okToDeleteNode((LithoStrat)dataObj);
        }
        if (dataObj instanceof LithoStratTreeDefItem) {
            return this.okToDeleteDefItem((LithoStratTreeDefItem)dataObj);
        }
        return false;
    }

    public boolean okToDeleteDefItem(LithoStratTreeDefItem defItem) {
        if (defItem.getRankId() == 0) {
            return false;
        }
        return this.okToDelete("lithostrat", "LithoStratTreeDefItemID", defItem.getId());
    }

    @Override
    public void beforeSave(Object dataObj, DataProviderSessionIFace session) {
        super.beforeSave(dataObj, session);
        if (dataObj instanceof LithoStrat) {
            LithoStrat ls = (LithoStrat)dataObj;
            this.beforeSaveLithoStrat(ls);
            super.updateFullNamesIfNecessary(ls, session);
            return;
        }
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        this.setLSID((FormDataObjIFace)dataObj);
        return super.afterSaveCommit(dataObj, session);
    }

    protected void beforeSaveLithoStrat(LithoStrat geo) {
    }

    @Override
    public void formShutdown() {
        super.formShutdown();
        TreeTaskMgr.checkLocks();
    }

    @Override
    protected Class<?> getNodeClass() {
        return LithoStrat.class;
    }
}

