/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class InstitutionBusRules
extends BaseBusRules {
    private static final String RELEASES = "RELEASES";
    private ValCheckBox checkbox = null;
    private ValComboBox relCombobox = null;

    public InstitutionBusRules() {
        super(Institution.class);
    }

    @Override
    public void initialize(Viewable viewableArg) {
        super.initialize(viewableArg);
        if (this.formViewObj != null && this.formViewObj.getMVParent().isTopLevel()) {
            ValSpinner minPwdLenSpinner;
            ResultSetController rsc = this.formViewObj.getRsController();
            if (rsc != null) {
                if (rsc.getNewRecBtn() != null) {
                    rsc.getNewRecBtn().setVisible(false);
                }
                if (rsc.getDelRecBtn() != null) {
                    rsc.getDelRecBtn().setVisible(false);
                }
            }
            if ((minPwdLenSpinner = (ValSpinner)this.formViewObj.getControlById("minimumPwdLength")) != null) {
                minPwdLenSpinner.setRange(8, 30, 8);
            }
            if (!AppPreferences.getLocalPrefs().getBoolean("RELEASE_MANAGER", false).booleanValue()) {
                Component comp = this.formViewObj.getControlById("relmgrsep");
                if (comp != null) {
                    comp.setVisible(false);
                }
                if ((comp = this.formViewObj.getControlById("relmgrlabel")) != null) {
                    comp.setVisible(false);
                }
                if ((comp = this.formViewObj.getControlById("relmgrpanel")) != null) {
                    comp.setVisible(false);
                }
            }
        }
    }

    private int getNameCount(String name) {
        return BasicSQLUtils.getCountAsInt(String.format("SELECT COUNT(*) FROM institution WHERE Name = '%s'", name));
    }

    @Override
    public boolean isOkToSave(Object dataObj, DataProviderSessionIFace session) {
        Component comp;
        if (this.formViewObj != null && (comp = this.formViewObj.getControlByName("name")) instanceof ValTextField) {
            Institution inst = (Institution)dataObj;
            Integer instId = inst.getId();
            String name = ((ValTextField)comp).getText();
            int cnt = this.getNameCount(name);
            if (cnt == 0 || cnt == 1 && instId != null) {
                return true;
            }
            this.reasonList.add(UIRegistry.getLocalizedMessage("DIVNAME_DUP", name));
        }
        return false;
    }

    @Override
    public void afterFillForm(Object dataObj) {
        super.afterFillForm(dataObj);
        if (this.checkbox == null && dataObj != null) {
            Component comp = this.formViewObj.getControlById("curMgrRelVer");
            if (comp instanceof ValComboBox) {
                this.relCombobox = (ValComboBox)comp;
            }
            comp = this.formViewObj.getControlById("isRelMgrGlb");
            if (this.relCombobox != null && comp instanceof ValCheckBox) {
                this.checkbox = (ValCheckBox)comp;
                this.checkbox.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        InstitutionBusRules.this.relCombobox.setEnabled(InstitutionBusRules.this.checkbox.isSelected());
                        InstitutionBusRules.this.formViewObj.getLabelById("curMgrRelVerLbl").setEnabled(InstitutionBusRules.this.checkbox.isSelected());
                    }
                });
                final Institution inst = (Institution)this.viewable.getDataObj();
                if (inst != null) {
                    boolean releaseNumMismatch;
                    Vector<String> releases = new Vector<String>();
                    String curRelease = AppPreferences.getGlobalPrefs().get(RELEASES, null);
                    if (curRelease == null) {
                        curRelease = UIHelper.getInstall4JInstallString();
                        AppPreferences.getGlobalPrefs().put(RELEASES, curRelease);
                    }
                    releases.add(curRelease);
                    String managedRelease = inst.getCurrentManagedRelVersion();
                    if (managedRelease == null) {
                        managedRelease = curRelease;
                        inst.setCurrentManagedRelVersion(managedRelease);
                    }
                    boolean bl = releaseNumMismatch = !managedRelease.equals(curRelease);
                    if (releaseNumMismatch) {
                        releases.insertElementAt(managedRelease, 0);
                    }
                    this.relCombobox.getComboBox().setModel(new DefaultComboBoxModel(releases));
                    this.relCombobox.getComboBox().setSelectedIndex(releaseNumMismatch ? 1 : 0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIValidator.setIgnoreAllValidation(this, true);
                            try {
                                try {
                                    InstitutionBusRules.this.checkbox.setSelected(inst.getIsReleaseManagedGlobally() == false);
                                    InstitutionBusRules.this.checkbox.setSelected(inst.getIsReleaseManagedGlobally());
                                }
                                catch (Exception exception) {
                                    UIValidator.setIgnoreAllValidation(this, false);
                                }
                            }
                            finally {
                                UIValidator.setIgnoreAllValidation(this, false);
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public boolean afterSaveCommit(Object dataObj, DataProviderSessionIFace session) {
        AppContextMgr.getInstance().setClassObject(Institution.class, dataObj);
        Institution inst = (Institution)dataObj;
        AppPreferences.getLocalPrefs().putBoolean("MANAGED_RELEASES", inst.getIsReleaseManagedGlobally());
        String managedRel = inst.getCurrentManagedRelVersion();
        if (StringUtils.isNotEmpty((String)managedRel)) {
            AppPreferences.getGlobalPrefs().put(RELEASES, managedRel);
        } else {
            AppPreferences.getGlobalPrefs().remove(RELEASES);
        }
        return super.afterSaveCommit(dataObj, session);
    }
}

