/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel.busrules;

import edu.ku.brc.af.ui.forms.BaseBusRules;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.GroupPerson;
import edu.ku.brc.ui.UIRegistry;

public class GroupPersonBusRules
extends BaseBusRules {
    public GroupPersonBusRules() {
        super(GroupPerson.class);
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object dataObj) {
        return super.processBusinessRules(dataObj);
    }

    @Override
    public BusinessRulesIFace.STATUS processBusinessRules(Object parentDataObj, Object dataObj, boolean isExistingObject) {
        this.reasonList.clear();
        if (isExistingObject && parentDataObj instanceof Agent && dataObj instanceof GroupPerson) {
            Agent agentContainer = (Agent)parentDataObj;
            GroupPerson groupPerson = (GroupPerson)dataObj;
            Agent agentBeingAdded = groupPerson.getMember();
            if (agentContainer.getId() != null && agentBeingAdded != null && agentBeingAdded.getId() != null && agentContainer.getId().equals(agentBeingAdded.getId())) {
                this.reasonList.add(String.format(UIRegistry.getResourceString("GP_SELF_GRPPER"), groupPerson.getIdentityTitle()));
                return BusinessRulesIFace.STATUS.Error;
            }
            int cnt = 0;
            for (GroupPerson gp : agentContainer.getGroups()) {
                Agent agentInGroup = gp.getMember();
                if (agentInGroup == null || agentBeingAdded == null || !gp.getMember().getAgentId().equals(agentBeingAdded.getAgentId())) continue;
                if (cnt == 1) {
                    this.reasonList.add(String.format(UIRegistry.getResourceString("GP_DUPLICATE_GRPPER"), groupPerson.getIdentityTitle()));
                    return BusinessRulesIFace.STATUS.Error;
                }
                ++cnt;
            }
        }
        return super.processBusinessRules(parentDataObj, dataObj, isExistingObject);
    }
}

